/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.columnar.client.java.SecurityOptions;
import com.couchbase.columnar.client.java.TimeoutOptions;
import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.internal.DefaultJacksonDeserializerHolder;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public final class ClusterOptions {
    boolean srv = true;
    @Nullable
    Deserializer deserializer;
    final SecurityOptions security = new SecurityOptions();
    final TimeoutOptions timeout = new TimeoutOptions();

    ClusterOptions() {
    }

    Unmodifiable build() {
        return new Unmodifiable(this);
    }

    public ClusterOptions srv(boolean useDnsSrv) {
        this.srv = useDnsSrv;
        return this;
    }

    public ClusterOptions deserializer(@Nullable Deserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public ClusterOptions security(Consumer<SecurityOptions> optionsCustomizer) {
        optionsCustomizer.accept(this.security);
        return this;
    }

    public ClusterOptions timeout(Consumer<TimeoutOptions> optionsCustomizer) {
        optionsCustomizer.accept(this.timeout);
        return this;
    }

    static class Unmodifiable {
        private final TimeoutOptions.Unmodifiable timeout;
        private final SecurityOptions.Unmodifiable security;
        private final Deserializer deserializer;
        private final boolean srv;

        Unmodifiable(ClusterOptions builder) {
            this.timeout = builder.timeout.build();
            this.security = builder.security.build();
            this.srv = builder.srv;
            this.deserializer = builder.deserializer != null ? builder.deserializer : DefaultJacksonDeserializerHolder.DESERIALIZER;
        }

        public TimeoutOptions.Unmodifiable timeout() {
            return this.timeout;
        }

        public SecurityOptions.Unmodifiable security() {
            return this.security;
        }

        public Deserializer deserializer() {
            return this.deserializer;
        }

        public boolean srv() {
            return this.srv;
        }

        public String toString() {
            return "ClusterOptions{timeout=" + String.valueOf(this.timeout) + ", security=" + String.valueOf(this.security) + ", deserializer=" + String.valueOf(this.deserializer) + ", srv=" + this.srv + "}";
        }
    }
}

