/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import java.util.Arrays;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public final class ComplexKey {
    private final List<Object> components;
    private static final Object EMPTY_OBJECT = new Object();
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private boolean forceArray = false;

    private ComplexKey(Object[] components) {
        this.components = Arrays.asList(components);
    }

    public static ComplexKey of(Object ... components) {
        return new ComplexKey(components);
    }

    public static Object emptyObject() {
        return EMPTY_OBJECT;
    }

    public static Object[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public ComplexKey forceArray(boolean force) {
        this.forceArray = force;
        return this;
    }

    public String toJson() {
        if (this.components.size() == 1 && !this.forceArray) {
            Object component = this.components.get(0);
            if (component == EMPTY_OBJECT) {
                return new JSONObject().toString();
            }
            if (component instanceof String) {
                return "\"" + component + "\"";
            }
            if (component == null) {
                return "null";
            }
            return component.toString();
        }
        JSONArray key = new JSONArray();
        for (Object component : this.components) {
            if (component == EMPTY_OBJECT) {
                key.put((Object)new JSONObject());
                continue;
            }
            key.put(component);
        }
        return key.toString();
    }
}

