/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.ClusterManager;
import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseMemcachedConnection;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.ViewConnection;
import com.couchbase.client.vbucket.CouchbaseNodeOrder;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigType;
import com.couchbase.client.vbucket.provider.BucketConfigurationProvider;
import com.couchbase.client.vbucket.provider.ConfigurationProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;

public class CouchbaseConnectionFactory
extends BinaryConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Redistribute;
    public static final HashAlgorithm DEFAULT_HASH = DefaultHashAlgorithm.NATIVE_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_MIN_RECONNECT_INTERVAL = 1100L;
    public static final int DEFAULT_VIEW_TIMEOUT = 75000;
    public static final int DEFAULT_VIEW_WORKER_SIZE = 1;
    public static final int DEFAULT_VIEW_CONNS_PER_NODE = 10;
    public static final long DEFAULT_OBS_TIMEOUT = 5000L;
    public static final long DEFAULT_OBS_POLL_INTERVAL = 10L;
    @Deprecated
    public static final int DEFAULT_OBS_POLL_MAX = 500;
    public static final long DEFAULT_AUTH_WAIT_TIME = 2500L;
    public static final CouchbaseNodeOrder DEFAULT_STREAMING_NODE_ORDER = CouchbaseNodeOrder.RANDOM;
    protected volatile ConfigurationProvider configurationProvider;
    private volatile String bucket;
    private volatile String pass;
    private volatile List<URI> storedBaseList;
    private static final Logger LOGGER = Logger.getLogger(CouchbaseConnectionFactory.class.getName());
    private volatile boolean needsReconnect;
    private volatile long thresholdLastCheck = System.nanoTime();
    private final AtomicInteger configThresholdCount = new AtomicInteger(0);
    private final int maxConfigCheck = 10;
    private volatile long configProviderLastUpdateTimestamp;
    private long minReconnectInterval = 1100L;
    private final ExecutorService resubExec = Executors.newSingleThreadExecutor();
    private final CouchbaseNodeOrder nodeOrder = DEFAULT_STREAMING_NODE_ORDER;
    private ClusterManager clusterManager;

    public CouchbaseConnectionFactory() {
        String[] nodeList;
        String nodes = CouchbaseProperties.getProperty("nodes");
        String bucket = CouchbaseProperties.getProperty("bucket");
        String password = CouchbaseProperties.getProperty("password");
        if (nodes == null) {
            throw new IllegalArgumentException("System property cbclient.nodes not set or empty");
        }
        if (bucket == null) {
            throw new IllegalArgumentException("System property cbclient.bucket not set or empty");
        }
        if (password == null) {
            throw new IllegalArgumentException("System property cbclient.password not set or empty");
        }
        ArrayList<URI> baseList = new ArrayList<URI>();
        for (String node : nodeList = nodes.split(";")) {
            try {
                baseList.add(new URI(node));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not parse node list into  URI format.");
            }
        }
        this.initialize(baseList, bucket, password);
    }

    public CouchbaseConnectionFactory(List<URI> baseList, String bucketName, String password) throws IOException {
        this.initialize(baseList, bucketName, password);
    }

    private void initialize(List<URI> baseList, String bucket, String password) {
        this.storedBaseList = new ArrayList<URI>();
        for (URI bu : baseList) {
            if (!bu.isAbsolute()) {
                throw new IllegalArgumentException("The base URI must be absolute");
            }
            this.storedBaseList.add(bu);
        }
        if (bucket == null || bucket.isEmpty()) {
            throw new IllegalArgumentException("The bucket name must not be null or empty.");
        }
        if (password == null) {
            throw new IllegalArgumentException("The bucket password must not be  null.");
        }
        this.bucket = bucket;
        this.pass = password;
        this.configurationProvider = new BucketConfigurationProvider(baseList, bucket, password, this);
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        Config config = this.getVBucketConfig();
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new CouchbaseMemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new CouchbaseConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        throw new IOException("No ConnectionFactory for bucket type " + (Object)((Object)config.getConfigType()));
    }

    public ViewConnection createViewConnection(List<InetSocketAddress> addrs) throws IOException {
        return new ViewConnection(this, addrs, this.bucket, this.pass);
    }

    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        Config config = this.getVBucketConfig();
        if (config == null) {
            throw new IllegalStateException("Couldn't get config");
        }
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new KetamaNodeLocator(nodes, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new VBucketNodeLocator(nodes, this.getVBucketConfig());
        }
        throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)config.getConfigType()));
    }

    public boolean shouldOptimize() {
        return false;
    }

    public AuthDescriptor getAuthDescriptor() {
        if (!this.configurationProvider.getAnonymousAuthBucket().equals(this.bucket) && this.bucket != null) {
            return new AuthDescriptor(new String[0], (CallbackHandler)new PlainCallbackHandler(this.bucket, this.pass));
        }
        return null;
    }

    public String getBucketName() {
        return this.bucket;
    }

    public int getViewTimeout() {
        return 75000;
    }

    public int getViewWorkerSize() {
        return 1;
    }

    public int getViewConnsPerNode() {
        return 10;
    }

    public CouchbaseNodeOrder getStreamingNodeOrder() {
        return this.nodeOrder;
    }

    public Config getVBucketConfig() {
        return this.configurationProvider.getConfig().getConfig();
    }

    public synchronized ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected void requestConfigReconnect(String bucketName, Reconfigurable rec) {
        this.configurationProvider.signalOutdated();
        this.needsReconnect = true;
    }

    synchronized void setConfigurationProvider(ConfigurationProvider configProvider) {
        this.configProviderLastUpdateTimestamp = System.currentTimeMillis();
        this.configurationProvider = configProvider;
    }

    void setMinReconnectInterval(long reconnIntervalMsecs) {
        this.minReconnectInterval = reconnIntervalMsecs;
    }

    void checkConfigUpdate() {
        if (this.needsReconnect || this.pastReconnThreshold()) {
            long now = System.currentTimeMillis();
            long intervalWaited = now - this.configProviderLastUpdateTimestamp;
            if (intervalWaited < this.getMinReconnectInterval()) {
                LOGGER.log(Level.FINE, "Ignoring config update check. Only {0}ms out of a threshold of {1}ms since last update.", new Object[]{intervalWaited, this.getMinReconnectInterval()});
                return;
            }
            this.getConfigurationProvider().signalOutdated();
        } else {
            LOGGER.log(Level.FINE, "No reconnect required, though check requested. Current config check is {0} out of a threshold of {1}.", new Object[]{this.configThresholdCount, 10});
        }
    }

    protected boolean pastReconnThreshold() {
        long currentTime = System.nanoTime();
        if (currentTime - this.thresholdLastCheck >= TimeUnit.SECONDS.toNanos(10L)) {
            this.configThresholdCount.set(0);
            this.thresholdLastCheck = currentTime;
        }
        return this.configThresholdCount.incrementAndGet() >= 10;
    }

    public long getMinReconnectInterval() {
        return this.minReconnectInterval;
    }

    public long getObsPollInterval() {
        return 10L;
    }

    public long getObsTimeout() {
        return 5000L;
    }

    public long getAuthWaitTime() {
        return 2500L;
    }

    public int getObsPollMax() {
        return new Double(Math.ceil((double)this.getObsTimeout() / (double)this.getObsPollInterval())).intValue();
    }

    int getMaxConfigCheck() {
        return 10;
    }

    public ClusterManager getClusterManager() {
        if (this.clusterManager == null) {
            this.clusterManager = new ClusterManager(this.storedBaseList, this.bucket, this.pass);
        }
        return this.clusterManager;
    }

    List<URI> getStoredBaseList() {
        return this.storedBaseList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CouchbaseConnectionFactory{");
        sb.append("bucket='").append(this.getBucketName()).append('\'');
        sb.append(", nodes=").append(this.getStoredBaseList());
        sb.append(", order=").append((Object)this.getStreamingNodeOrder());
        sb.append(", opTimeout=").append(this.getOperationTimeout());
        sb.append(", opQueue=").append(this.getOpQueueLen());
        sb.append(", opQueueBlockTime=").append(this.getOpQueueMaxBlockTime());
        sb.append(", obsPollInt=").append(this.getObsPollInterval());
        sb.append(", obsPollMax=").append(this.getObsPollMax());
        sb.append(", obsTimeout=").append(this.getObsTimeout());
        sb.append(", viewConns=").append(this.getViewConnsPerNode());
        sb.append(", viewTimeout=").append(this.getViewTimeout());
        sb.append(", viewWorkers=").append(this.getViewWorkerSize());
        sb.append(", configCheck=").append(this.getMaxConfigCheck());
        sb.append(", reconnectInt=").append(this.getMinReconnectInterval());
        sb.append(", failureMode=").append(this.getFailureMode());
        sb.append(", hashAlgo=").append(this.getHashAlg());
        sb.append(", authWaitTime=").append(this.getAuthWaitTime());
        sb.append('}');
        return sb.toString();
    }
}

