/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.ClusterManager;
import java.net.URI;
import java.util.List;

public class ClusterManagerBuilder {
    private int connectionTimeout = ClusterManager.DEFAULT_CONN_TIMEOUT;
    private int socketTimeout = ClusterManager.DEFAULT_SOCKET_TIMEOUT;
    private boolean tcpNoDelay = true;
    private int ioThreadCount = 1;
    private int connectionsPerNode = 5;

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public int getConnectionsPerNode() {
        return this.connectionsPerNode;
    }

    public ClusterManagerBuilder setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ClusterManagerBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public ClusterManagerBuilder setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public ClusterManagerBuilder setIoThreadCount(int ioThreadCount) {
        this.ioThreadCount = ioThreadCount;
        return this;
    }

    public ClusterManagerBuilder setConnectionsPerNode(int connectionsPerNode) {
        this.connectionsPerNode = connectionsPerNode;
        return this;
    }

    public ClusterManager build(List<URI> nodes, String username, String password) {
        return new ClusterManager(nodes, username, password, this.connectionTimeout, this.socketTimeout, this.tcpNoDelay, this.ioThreadCount, this.connectionsPerNode);
    }
}

