// generated by src/scripts/write-version-info.sh

package com.couchbase.client;

import java.net.URL;
import java.util.Properties;

import java.io.InputStream;
import java.io.FileNotFoundException;

public final class BuildInfo extends Properties {
  public static final String VERSION="1.4.13";
  public static final String GIT_HASH="e2358f8221f22a5b9db9c535edc6ac071657c533";
  public static final String TREE_VERSION="1.4.13";
  public static final String COMPILE_USER="daschl";
  public static final String COMPILE_HOST="mbp";
  public static final String COMPILE_DATE="Tue May  2 18:11:16 CEST 2017";

  /**
   * Get an instance of BuildInfo that describes the spy.jar build.
   */
  public BuildInfo() {
  }

  public String toString() {
    StringBuilder sb = new StringBuilder(256);
    sb.append("Couchbase Java Client ");
    sb.append(VERSION);
    sb.append("\n\nTree Version: ");
    sb.append(TREE_VERSION);
    sb.append("\nLast Commit ID: ");
    sb.append(GIT_HASH);
    sb.append("\n\nCompiled by ");
    sb.append(COMPILE_USER);
    sb.append("@");
    sb.append(COMPILE_HOST);
    sb.append(" on ");
    sb.append(COMPILE_DATE);
    return sb.toString();
  }

  public URL getFile(String rel) throws FileNotFoundException {
    ClassLoader cl=getClass().getClassLoader();
    URL u=cl.getResource(rel);
    if(u == null) {
      throw new FileNotFoundException("Can't find " + rel);
    }
    return(u);
  }

  public static void main(String args[]) throws Exception {
    BuildInfo bi=new BuildInfo();
    String cl="%" + "CHANGELOG" + "%";

    System.out.println(bi);

    // If there was a changelog, let it be shown.
    if(!cl.equals("com/couchbase/client/changelog.txt")) {
      if(args.length > 0 && args[0].equals("-c")) {
        System.out.println(" -- Changelog:\n");

        URL u=bi.getFile("com/couchbase/client/changelog.txt");
        InputStream is=u.openStream();
        try {
          byte data[]=new byte[8192];
          int bread=0;
          do {
            bread=is.read(data);
            if(bread > 0) {
              System.out.write(data, 0, bread);
            }
          } while(bread != -1);
        } finally {
          is.close();
        }
      } else {
        System.out.println("(add -c to see the recent changelog)");
      }
    }
  }
}
