/*
 * Decompiled with CFR 0.152.
 */
package com.imomo.momo.mediaencoder;

import android.util.Log;
import com.imomo.momo.mediaencoder.FFMediaUtils;

public class FFAudioMixer
extends FFMediaUtils {
    private long mHandler;
    private final int CALL_BACK_PROGRESS_TAG = -1;
    private final int CALL_BACK_ERROR_TAG = -2;
    private OnAudioMixerListener mListener;

    private native long nativeCreateAudioMixer(Object var1);

    private native void nativeInit(long var1, int var3, int var4, int var5, String var6);

    private native int nativeAddSource(long var1, String var3, int var4, int var5);

    private native int nativeAddMainSource(long var1, String var3, int var4);

    private native int nativeAddMusicSource(long var1, String var3, int var4, int var5);

    private native int nativeStart(long var1);

    private native void nativeRelease(long var1);

    public boolean initAudioMixer(int n, int n2, int n3, String string) {
        this.mHandler = this.nativeCreateAudioMixer(this);
        if (this.mHandler == 0L) {
            return false;
        }
        this.nativeInit(this.mHandler, n, n2, n3, string);
        return true;
    }

    public void addSource(String string, int n, int n2) {
        this.nativeAddSource(this.mHandler, string, n, n2);
    }

    public void addMusicSource(String string, int n, int n2) {
        this.nativeAddMusicSource(this.mHandler, string, n, n2);
    }

    public void addMainSource(String string, int n) {
        this.nativeAddMainSource(this.mHandler, string, n);
    }

    public void start() {
        this.nativeStart(this.mHandler);
    }

    public void release() {
        this.nativeRelease(this.mHandler);
    }

    public void setOnAudioMixerListener(OnAudioMixerListener onAudioMixerListener) {
        this.mListener = onAudioMixerListener;
    }

    public void onObtainMessage(int n, int n2, Object object) {
        if (n == -1 && this.mListener != null) {
            this.mListener.onProgress(n2);
        }
        if (n == -2 && this.mListener != null) {
            this.mListener.onError(n2);
        }
    }

    private static void postEventFromNative(FFAudioMixer fFAudioMixer, int n, int n2, int n3) {
        if (fFAudioMixer == null) {
            Log.e((String)"FFAudioMixer", (String)"audioMixer_ref is null");
            return;
        }
        fFAudioMixer.onObtainMessage(n, n2, n3);
    }

    public static interface OnAudioMixerListener {
        public void onProgress(int var1);

        public void onError(int var1);
    }
}

