/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.util.fft;

public abstract class FourierTransform {
    protected static final int LINAVG = 1;
    protected static final int LOGAVG = 2;
    protected static final int NOAVG = 3;
    protected static final float TWO_PI = (float)Math.PI * 2;
    protected int timeSize;
    protected int sampleRate;
    protected float bandWidth;
    protected float[] real;
    protected float[] imag;
    protected float[] spectrum;
    protected float[] averages;
    protected int whichAverage;
    protected int octaves;
    protected int avgPerOctave;

    /*
     * WARNING - void declaration
     */
    FourierTransform(int ts, float sr) {
        void var2_2;
        void var1_1;
        this.timeSize = var1_1;
        this.sampleRate = (int)var2_2;
        this.bandWidth = 2.0f / (float)this.timeSize * ((float)this.sampleRate / 2.0f);
        this.noAverages();
        this.allocateArrays();
    }

    protected abstract void allocateArrays();

    /*
     * WARNING - void declaration
     */
    protected void setComplex(float[] r, float[] i) {
        if (this.real.length == r.length || this.imag.length == i.length) {
            void var2_2;
            void var1_1;
            System.arraycopy(r, 0, this.real, 0, ((void)var1_1).length);
            System.arraycopy(i, 0, this.imag, 0, ((void)var2_2).length);
        }
    }

    protected void fillSpectrum() {
        int n;
        for (n = 0; n < this.spectrum.length; ++n) {
            this.spectrum[n] = (float)Math.sqrt(this.real[n] * this.real[n] + this.imag[n] * this.imag[n]);
        }
        if (this.whichAverage == 1) {
            n = this.spectrum.length / this.averages.length;
            for (int i = 0; i < this.averages.length; ++i) {
                int n2;
                int n3;
                float f = 0.0f;
                for (n3 = 0; n3 < n && (n2 = n3 + i * n) < this.spectrum.length; ++n3) {
                    f += this.spectrum[n2];
                }
                this.averages[i] = f /= (float)(n3 + 1);
            }
            return;
        }
        if (this.whichAverage == 2) {
            for (n = 0; n < this.octaves; ++n) {
                float f = n == 0 ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n);
                float f2 = ((float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - n - 1) - f) / (float)this.avgPerOctave;
                float f3 = f;
                for (int i = 0; i < this.avgPerOctave; ++i) {
                    int n4 = i + n * this.avgPerOctave;
                    float f4 = f3;
                    this.averages[n4] = this.calcAvg(f4, f4 + f2);
                    f3 += f2;
                }
            }
        }
    }

    public void noAverages() {
        this.averages = new float[0];
        this.whichAverage = 3;
    }

    /*
     * WARNING - void declaration
     */
    public void linAverages(int numAvg) {
        void var1_1;
        if (numAvg > this.spectrum.length / 2) {
            return;
        }
        this.averages = new float[var1_1];
        this.whichAverage = 1;
    }

    /*
     * WARNING - void declaration
     */
    public void logAverages(int minBandwidth, int bandsPerOctave) {
        void var2_2;
        float f = (float)this.sampleRate / 2.0f;
        this.octaves = 1;
        while (true) {
            float f2;
            f /= 2.0f;
            if (!(f2 > (float)minBandwidth)) break;
            ++this.octaves;
        }
        this.avgPerOctave = bandsPerOctave;
        this.averages = new float[this.octaves * var2_2];
        this.whichAverage = 2;
    }

    public int timeSize() {
        return this.timeSize;
    }

    public int specSize() {
        return this.spectrum.length;
    }

    /*
     * WARNING - void declaration
     */
    public float getBand(int i) {
        void var1_1;
        if (i < 0) {
            i = 0;
        }
        if (i > this.spectrum.length - 1) {
            i = this.spectrum.length - 1;
        }
        return this.spectrum[var1_1];
    }

    public float getBandWidth() {
        return this.bandWidth;
    }

    /*
     * WARNING - void declaration
     */
    public float getAverageBandWidth(int averageIndex) {
        if (this.whichAverage == 1) {
            return (float)(this.spectrum.length / this.averages.length) * this.getBandWidth();
        }
        if (this.whichAverage == 2) {
            void var1_1;
            float f = (var1_1 /= this.avgPerOctave) == false ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - var1_1);
            return ((float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - var1_1 - 1) - f) / (float)this.avgPerOctave;
        }
        return 0.0f;
    }

    public abstract void setBand(int var1, float var2);

    public abstract void scaleBand(int var1, float var2);

    public int freqToIndex(float freq) {
        if (freq < this.getBandWidth() / 2.0f) {
            return 0;
        }
        if (freq > (float)(this.sampleRate / 2) - this.getBandWidth() / 2.0f) {
            return this.spectrum.length - 1;
        }
        return Math.round((float)this.timeSize * (var1_1 /= (float)this.sampleRate));
    }

    /*
     * WARNING - void declaration
     */
    public float indexToFreq(int i) {
        void var1_1;
        float f = this.getBandWidth();
        if (i == 0) {
            return f * 0.25f;
        }
        if (i == this.spectrum.length - 1) {
            float f2 = (float)(this.sampleRate / 2) - f / 2.0f;
            return f2 + (f *= 0.25f);
        }
        return (float)var1_1 * f;
    }

    /*
     * WARNING - void declaration
     */
    public float getAverageCenterFrequency(int i) {
        void var1_1;
        if (this.whichAverage == 1) {
            int n = this.spectrum.length / this.averages.length;
            var1_1 = var1_1 * n + n / 2;
            return this.indexToFreq((int)var1_1);
        }
        if (this.whichAverage == 2) {
            void var2_3 = var1_1 / this.avgPerOctave;
            float f = var2_3 == false ? 0.0f : (float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - var2_3);
            float f2 = ((float)(this.sampleRate / 2) / (float)Math.pow(2.0, this.octaves - var2_3 - 1) - f) / (float)this.avgPerOctave;
            return f + (float)(var1_1 %= this.avgPerOctave) * f2 + f2 / 2.0f;
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public float getFreq(float freq) {
        void var1_1;
        FourierTransform fourierTransform = this;
        return fourierTransform.getBand(fourierTransform.freqToIndex((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setFreq(float freq, float a2) {
        void var2_2;
        void var1_1;
        FourierTransform fourierTransform = this;
        fourierTransform.setBand(fourierTransform.freqToIndex((float)var1_1), (float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void scaleFreq(float freq, float s) {
        void var2_2;
        void var1_1;
        FourierTransform fourierTransform = this;
        fourierTransform.scaleBand(fourierTransform.freqToIndex((float)var1_1), (float)var2_2);
    }

    public int avgSize() {
        return this.averages.length;
    }

    /*
     * WARNING - void declaration
     */
    public float getAvg(int i) {
        void var1_1;
        float f = this.averages.length > 0 ? this.averages[var1_1] : 0.0f;
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public float calcAvg(float lowFreq, float hiFreq) {
        void var2_3;
        void var1_1;
        int n = this.freqToIndex((float)var1_1);
        int n2 = this.freqToIndex((float)var2_3);
        float f = 0.0f;
        for (int i = n; i <= n2; ++i) {
            f += this.spectrum[i];
        }
        return f / (float)(n2 - n + 1);
    }

    public float[] getSpectrumReal() {
        return this.real;
    }

    public float[] getSpectrumImaginary() {
        return this.imag;
    }

    public abstract void forward(float[] var1);

    /*
     * WARNING - void declaration
     */
    public void forward(float[] buffer, int startAt) {
        void var2_2;
        void var1_1;
        if (buffer.length - startAt < this.timeSize) {
            return;
        }
        float[] fArray = new float[this.timeSize];
        System.arraycopy(var1_1, (int)var2_2, fArray, 0, fArray.length);
        this.forward(fArray);
    }

    public abstract void inverse(float[] var1);

    /*
     * WARNING - void declaration
     */
    public void inverse(float[] freqReal, float[] freqImag, float[] buffer) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setComplex((float[])var1_1, (float[])var2_2);
        this.inverse((float[])var3_3);
    }
}

