/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.lightskin;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLES20;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.filter.processing.LookUpIntensityInterface;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class LookupFilter64
extends MultiInputFilter
implements LookUpIntensityInterface {
    private int lookup_texture;
    private Bitmap lookupBitmap;
    private float intensity = 1.0f;
    private int intensityHandler;
    private Context context;
    private int resId;
    private String filePath;
    private boolean assetRes = false;

    public LookupFilter64() {
        super(2);
    }

    /*
     * WARNING - void declaration
     */
    public LookupFilter64(Context context, int id) {
        super(2);
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.resId = var2_2;
        this.lookupBitmap = this.decodeLookupBitmapResource();
    }

    /*
     * WARNING - void declaration
     */
    public LookupFilter64(Context context, String filePath) {
        super(2);
        void var2_2;
        this.filePath = var2_2;
        this.lookupBitmap = this.decodeLookupBitmapFile();
    }

    private Bitmap decodeLookupBitmapResource() {
        if (this.context == null || this.resId <= 0) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inScaled = false;
        return BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.resId, (BitmapFactory.Options)options);
    }

    private Bitmap decodeLookupBitmapFile() {
        if (TextUtils.isEmpty((CharSequence)this.filePath)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inScaled = false;
        return BitmapFactory.decodeFile((String)this.filePath, (BitmapFactory.Options)options);
    }

    /*
     * Loose catch block
     */
    private Bitmap decodeLookupAssetsRes() {
        Bitmap bitmap;
        block10: {
            InputStream inputStream = null;
            bitmap = null;
            inputStream = this.context.getResources().getAssets().open(this.filePath);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block10;
            catch (IOException iOException) {
                try {
                    iOException.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public void setLookupBitmap(Bitmap lookupBitmap) {
        void var1_1;
        this.lookupBitmap = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setLookUpPath(String path) {
        void var1_1;
        this.filePath = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAssetResourcesId(Context context, String path) {
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.filePath = var2_2;
        this.assetRes = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setIntensity(float intensity) {
        void var1_1;
        this.intensity = var1_1;
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    public void destroy() {
        super.destroy();
        if (this.lookup_texture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.lookup_texture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.lookup_texture = 0;
        }
        if (this.lookupBitmap != null && !this.lookupBitmap.isRecycled()) {
            this.lookupBitmap.recycle();
            this.lookupBitmap = null;
        }
    }

    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float intensity;\nvoid main(){\n  vec4 texColour = texture2D(inputImageTexture0,textureCoordinate);\n  float blueColor = texColour.b * 15.0;\n  vec2 quad1;\n  quad1.y = floor(floor(blueColor) / 4.0);\n  quad1.x = floor(blueColor) - (quad1.y * 4.0);\n  vec2 quad2;\n  quad2.y = floor(ceil(blueColor) / 4.0);\n  quad2.x = ceil(blueColor) - (quad2.y * 4.0);\n  vec2 texPos1;\n  texPos1.x = (quad1.x * 0.25) + 0.5/64.0 + ((0.25 - 1.0/64.0) * texColour.r);\n  texPos1.y = (quad1.y * 0.25) + 0.5/64.0 + ((0.25 - 1.0/64.0) * texColour.g);\n  vec2 texPos2;\n  texPos2.x = (quad2.x * 0.25) + 0.5/64.0 + ((0.25 - 1.0/64.0) * texColour.r);\n  texPos2.y = (quad2.y * 0.25) + 0.5/64.0 + ((0.25 - 1.0/64.0) * texColour.g);\n  vec4 newColor1 = texture2D(inputImageTexture1, texPos1);\n  vec4 newColor2 = texture2D(inputImageTexture1, texPos2);\n  vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n  gl_FragColor = mix(texColour, vec4(newColor.rgb, texColour.a), intensity);\n}\n";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.intensityHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"intensity");
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.intensityHandler, (float)this.intensity);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.filterLocations.size() < 2 || !source.equals(this.filterLocations.get(0))) {
            this.clearRegisteredFilterLocations();
            this.registerFilterLocation(source, 0);
            LookupFilter64 lookupFilter64 = this;
            lookupFilter64.registerFilterLocation((GLTextureOutputRenderer)lookupFilter64, 1);
        }
        if (this.lookup_texture == 0) {
            if (this.lookupBitmap == null || this.lookupBitmap.isRecycled()) {
                this.lookupBitmap = this.resId > 0 ? this.decodeLookupBitmapResource() : (this.assetRes ? this.decodeLookupAssetsRes() : this.decodeLookupBitmapFile());
            }
            this.lookup_texture = ImageHelper.bitmapToTexture((Bitmap)this.lookupBitmap);
        }
        LookupFilter64 lookupFilter64 = this;
        super.newTextureReady(lookupFilter64.lookup_texture, (GLTextureOutputRenderer)this, newData);
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.lookup_texture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.lookup_texture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.lookup_texture = 0;
        }
    }
}

