/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.gesture;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.ObjectDetector;
import com.core.glcore.util.CVObjectHelper;
import com.core.glcore.yuvutil.YuvTools;
import com.immomo.medialog.MediaStatisticModel;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momocv.MMBox;
import com.momocv.objectdetect.ObjectDetectInfo;
import com.momocv.objectdetect.ObjectDetectParams;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class GestureDetector
extends CVDetector {
    private ByteBuffer curByteBuffer;
    private Object waitSignal;
    private Object startSync;
    private boolean running;
    private AtomicBoolean isDetecting;
    private int width;
    private int height;
    private boolean isFrontCamera;
    private int cameraDegree;
    private int detectInterval = 300;
    private RenderHandler mCallbackRenderHandler;
    GestureDetectThread detectThread;
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private ObjectDetectParams detectParams = new ObjectDetectParams();
    private ObjectDetectInfo objectDetectInfo;
    private int dataFormatType = 17;

    /*
     * WARNING - void declaration
     */
    public GestureDetector(CVDetector.GestureDetectorListener listener) {
        void var1_1;
        this.waitSignal = new Object();
        this.startSync = new Object();
        this.isDetecting = new AtomicBoolean(false);
        this.gestureDetectorListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDetect() {
        ObjectDetector.getInstance().create();
        Object object = this.startSync;
        synchronized (object) {
            if (this.detectThread == null) {
                this.running = true;
                this.detectThread = new GestureDetectThread();
                this.detectThread.setPriority(1);
                this.detectThread.start();
                if (this.mCallbackRenderHandler == null) {
                    this.mCallbackRenderHandler = new RenderHandler(this, Looper.myLooper());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object;
        if (this.isDetecting.get()) {
            return;
        }
        this.width = mmcvInfo.width;
        this.height = mmcvInfo.height;
        this.isFrontCamera = mmcvInfo.isFrontCamera;
        this.cameraDegree = mmcvInfo.cameraDegree;
        this.dataFormatType = mmcvInfo.getDataFormatType();
        this.curByteBuffer = ByteBuffer.wrap(((MMCVInfo)object).frameData);
        object = this.waitSignal;
        synchronized (object) {
            this.waitSignal.notify();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setGestureDetectorListener(CVDetector.GestureDetectorListener listener) {
        void var1_1;
        this.gestureDetectorListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDetectInterval(int interval) {
        void var1_1;
        this.detectInterval = var1_1;
    }

    private void detectGesture() {
        this.isDetecting.set(true);
        long l = SystemClock.elapsedRealtime();
        MMCVBoxes mMCVBoxes = new MMCVBoxes();
        byte[] byArray = this.curByteBuffer.array();
        if (this.dataFormatType == 4) {
            byArray = YuvTools.ConvertRGBAToNV21((byte[])this.curByteBuffer.array(), (int)this.width, (int)this.height, null);
            this.dataFormatType = 17;
        }
        this.mmFrame.setFormat(this.dataFormatType);
        this.mmFrame.setStep_(this.width);
        this.mmFrame.setWidth(this.width);
        this.mmFrame.setHeight(this.height);
        this.mmFrame.setDataPtr(byArray);
        this.mmFrame.setDataLen(byArray.length);
        this.detectParams.rotate_degree_ = this.cameraDegree;
        this.detectParams.fliped_show_ = this.isFrontCamera;
        this.objectDetectInfo = new ObjectDetectInfo();
        ObjectDetector.getInstance().objectDetect(this.mmFrame.getFrame(), this.detectParams, this.objectDetectInfo);
        mMCVBoxes.setDetectResult(this.objectDetectInfo.detect_results_);
        long l2 = SystemClock.elapsedRealtime() - l;
        GestureDetector gestureDetector = this;
        gestureDetector.uploadGestureInfo(gestureDetector.objectDetectInfo.detect_results_, l2);
        MediaStatisticModel.getInstance().setGestureDetect(l2);
        if (MediaModuleGlobalConfig.hasXE()) {
            CVObjectHelper.transObjectInfos((MMBox[])this.objectDetectInfo.detect_results_);
        }
        if (this.detectInterval > 0) {
            SystemClock.sleep((long)this.detectInterval);
        }
        this.isDetecting.set(false);
        this.curByteBuffer.clear();
        Message message = new Message();
        new Message().obj = mMCVBoxes;
        if (this.mCallbackRenderHandler != null) {
            this.mCallbackRenderHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void uploadGestureInfo(MMBox[] info, long cost) {
        void var1_1;
        if (info == null || info.length <= 0) {
            return;
        }
        for (void var6_5 : var1_1) {
            String string = var6_5.class_name_;
            if (var6_5.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)string)) continue;
            MediaStatisticModel.getInstance().setGestureInfo(string, cost, System.currentTimeMillis());
        }
    }

    @Override
    public void stopDetect() {
        this.cancel();
        this.detectThread = null;
        ObjectDetector.getInstance().release();
    }

    @Override
    public void cancel() {
        this.gestureDetectorListener = null;
        this.running = false;
        if (this.curByteBuffer != null) {
            this.curByteBuffer.clear();
        }
        if (this.detectThread != null) {
            try {
                this.detectThread.interrupt();
            }
            catch (Exception exception) {}
        }
        this.detectThread = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(GestureDetector x0, boolean x1) {
        void var1_1;
        x0.running = var1_1;
        return x0.running;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ByteBuffer access$302(GestureDetector x0, ByteBuffer x1) {
        void var1_1;
        x0.curByteBuffer = var1_1;
        return x0.curByteBuffer;
    }

    class RenderHandler
    extends Handler {
        final /* synthetic */ GestureDetector this$0;

        /*
         * WARNING - void declaration
         */
        public RenderHandler(GestureDetector this$0, Looper looper) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Looper)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void handleMessage(Message msg) {
            if (null != this.this$0.gestureDetectorListener) {
                void var1_1;
                this.this$0.gestureDetectorListener.gestureDetect((MMCVBoxes)var1_1.obj);
            }
        }
    }

    final class GestureDetectThread
    extends Thread {
        public GestureDetectThread() {
            super("GestureDetect");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            GestureDetector.access$002(GestureDetector.this, true);
            try {
                Object object = GestureDetector.this.waitSignal;
                synchronized (object) {
                    while (GestureDetector.this.running) {
                        GestureDetector.this.waitSignal.wait();
                        GestureDetector.this.detectGesture();
                    }
                }
                GestureDetector.this.curByteBuffer.clear();
                GestureDetector.access$302(GestureDetector.this, null);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

