/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import com.core.glcore.util.FileUtil;
import com.momo.mcamera.mask.Etc1Batch;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.batchbean.BatchFrame;
import com.momo.mcamera.mask.batchbean.BatchSize;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StickerETC1Item
extends StickerItem {
    private String texturePath;
    public ETC1Util.ETC1Texture texture = this.getETC1Texture();
    private Etc1Batch etc1Batch;
    private long lastFrameTime = -1L;
    private int curIndex = 0;
    public int etc1_texture_sticker = 0;

    /*
     * WARNING - void declaration
     */
    public StickerETC1Item(Sticker inSticker, Context context) {
        super((Sticker)var1_1, (Context)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public void initCoordinate() {
        String string = null;
        String string2 = this.sticker.getETC1JsonPath();
        try {
            string = FileUtil.readString((File)new File(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            return;
        }
        this.etc1Batch = Etc1Batch.getEffectModel(string);
        this.updateETC1Coordinate();
        this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
    }

    public void updateETC1Coordinate() {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = System.currentTimeMillis();
            this.curIndex = this.sticker.getETC1ImageIndex();
        }
        if (System.currentTimeMillis() - this.lastFrameTime > 50L) {
            this.curIndex = this.sticker.getETC1ImageIndex();
            this.lastFrameTime = System.currentTimeMillis();
        }
        Object object = this.etc1Batch.getBatchStickers().get(this.curIndex).getFrame();
        BatchSize batchSize = this.etc1Batch.getBatchMeta().getSize();
        float f = (float)((BatchFrame)object).getImageX() / (float)batchSize.getImageBatchWidth();
        float f2 = (float)((BatchFrame)object).getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        float f3 = (float)((BatchFrame)object).getImageX() / (float)batchSize.getImageBatchWidth();
        float f4 = (float)(((BatchFrame)object).getImageY() + ((BatchFrame)object).getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float f5 = (float)(((BatchFrame)object).getImageX() + ((BatchFrame)object).getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float f6 = (float)(((BatchFrame)object).getImageY() + ((BatchFrame)object).getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float f7 = (float)(((BatchFrame)object).getImageX() + ((BatchFrame)object).getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float f8 = (float)((BatchFrame)object).getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        this.stickerScale = (float)((BatchFrame)object).getImageHeight() / (float)((BatchFrame)object).getImageWidth();
        object = new float[]{f + -0.5f, 0.5f - f2, f3 + -0.5f, 0.5f - f4, f5 + -0.5f, 0.5f - f6, f7 + -0.5f, 0.5f - f8};
        float[] fArray = new float[]{f + -0.5f, -f2, f3 + -0.5f, -f4, f5 + -0.5f, -f6, f7 + -0.5f, -f8};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put((float[])object);
        this.vertexBuffer.position(0);
        object = ByteBuffer.allocateDirect(32);
        ((ByteBuffer)object).order(ByteOrder.nativeOrder());
        this.vertexBuffer2 = ((ByteBuffer)object).asFloatBuffer();
        this.vertexBuffer2.put(fArray);
        this.vertexBuffer2.position(0);
    }

    private ETC1Util.ETC1Texture loadPkmFile(String path) {
        ETC1Util.ETC1Texture eTC1Texture = null;
        try {
            Object object;
            object = new File((String)object);
            object = new FileInputStream((File)object);
            eTC1Texture = ETC1Util.createTexture((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {}
        return eTC1Texture;
    }

    private ETC1Util.ETC1Texture getETC1Texture() {
        if (this.texturePath == null) {
            this.texturePath = this.sticker.getETC1Path();
            this.texture = this.loadPkmFile(this.texturePath);
        }
        return this.texture;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.etc1_texture_sticker != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.etc1_texture_sticker;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.etc1_texture_sticker = 0;
        }
    }
}

