/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.config.Size;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.datadot.DataDotUtils;
import com.core.glcore.datadot.RecoderDotUtil;
import com.core.glcore.util.BodyLandHelper;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.core.glcore.util.XEEngineHelper;
import com.cosmos.mdlog.MDLog;
import com.google.ar.core.Frame;
import com.google.ar.core.Plane;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingState;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.mask.ARCoreFrameListener;
import com.momo.mcamera.mask.BeautyFace;
import com.momo.mcamera.mask.Capture3DImageListener;
import com.momo.mcamera.mask.EffectGroupFilter;
import com.momo.mcamera.mask.Face3DMaskFilter;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FaceMaskFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.MultiStickerCutFaceMaskFilter;
import com.momo.mcamera.mask.MultiStickerGameMaskFilter;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.SoundInputFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.StickerEtc1MaskFilter;
import com.momo.mcamera.mask.StickerGestureMaskFilter;
import com.momo.mcamera.mask.StickerGestureTrackingFilter;
import com.momo.mcamera.mask.StickerGroupFilter;
import com.momo.mcamera.mask.StickerMaskFilter;
import com.momo.mcamera.mask.WeexStickerMaskFilter;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.bean.ViewPortProportion;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import com.momo.mcamera.mask.express.ExpressDetector;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momo.mcamera.mask.gesture.GestureDetector;
import com.momo.mcamera.mask.gesture.NewHandGestureDetector;
import com.momo.mcamera.util.ArCoreHelper;
import com.momo.mcamera.util.PointHelper;
import com.momocv.MMBox;
import com.momocv.MMRect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import project.android.imageprocessing.EffectTimeBean;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.filter.processing.LookUpIntensityInterface;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.ARCoreInterface;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.MStickerActions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class StickerAdjustFilter
extends StickerGroupFilter
implements LookUpIntensityInterface,
ARCoreInterface,
IVideoTrackTime {
    public static final int POINTS_LENGTH = 68;
    public static final long DEFAULT_LONG_DURATION = 99999999999L;
    private static final int SOUND_PULL_SIZE = 5;
    private static final long DEFAULT_DURATION = 30000000L;
    private final String TAG = "StickerAdjustFilter";
    public SoundInputFilter mSoundInput;
    public boolean enableSelfRender = false;
    ConcurrentHashMap<String, StickerBlendFilter> mStickerFilterMap;
    ConcurrentHashMap<String, MaskModel> mGestureTriggerModels;
    int lastFacesCnt = 0;
    PointF lastFacePosition = new PointF(0.0f, 0.0f);
    private List<GLRenderer> filtersToDestroy;
    private NormalFilter mNormalFilter;
    private Context mContext;
    private BasicFilter mTerminalFilter;
    private StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener;
    private FilterTriggerManager filterTriggerManager;
    private float mBigEye;
    private float mThinFace;
    private CVDetector gestureDetector;
    private MMCVBoxes mmcvBoxes;
    private SoundPool soundPool;
    private MediaPlayer soundPlayer;
    private boolean enableSoundPool;
    private ArrayList<Integer> soundIds = new ArrayList();
    private GestureDetectedListener gestureDetectedListener;
    private StickerMaskFinishListener finishListener;
    private MMRect mmcvRect;
    private StickerGestureTrackingFilter mGestureTrackingFilter;
    private List<Face3DMaskFilter> face3DMaskFilters;
    private boolean isCameraFront = false;
    private CVDetector.GestureDetectorListener gestureDetectorListener;
    private MMCVInfo mCurCVInfo;
    private long startTime = 0L;
    private long time = System.currentTimeMillis();
    private MultiStickerMaskFilter mMultiStickerMaskFilter;
    private int scaleWidth = 0;
    private int scaleHeight = 0;
    private float scaleWidthRatio = 1.0f;
    private float scaleHeightRatio = 1.0f;
    private int groupNumber = 0;
    private boolean useBlendFilter = false;
    private boolean hasExpressionModel = false;
    private boolean isplayStatusTriggered = false;
    private MStickerActions.onPlayStatusListener playStatusListener;
    private boolean multiSwitchEnable = false;
    private ExpressDetector expressDetector;
    private ARCoreFrameListener mArCoreFrameListener;
    private List<Sticker> mSwapFacialMaskSticker;
    private FaceMaskFilter mFaceMaskFilter;
    EffectGroupFilter mEffectGroupFilter;
    private int mCount = 0;
    private Mask mDistorationMask = null;
    private BeautyFace mBeautyFace = null;
    private boolean mFaceBeauty = false;
    private boolean mFaceStateChange = false;
    private float mFaceThinValue = 0.0f;
    private float mBigEyeValue = 0.0f;
    private boolean mFaceBeautyHaveFinish = false;
    private int mPollGroupNum = 0;
    private long mLastRenderTime = 0L;
    private SingleLineGroupFilter mLookupFilter = null;
    private Map<Integer, SoundPoolInfo> soundInfoMap = new HashMap<Integer, SoundPoolInfo>();

    /*
     * WARNING - void declaration
     */
    public StickerAdjustFilter(Context context) {
        void var1_1;
        this.mContext = var1_1;
        this.filterTriggerManager = new FilterTriggerManager();
        this.mNormalFilter = new NormalFilter();
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
        this.mStickerFilterMap = new ConcurrentHashMap();
        this.mGestureTriggerModels = new ConcurrentHashMap();
        StickerAdjustFilter stickerAdjustFilter = this;
        stickerAdjustFilter.registerInitialFilter(stickerAdjustFilter.mNormalFilter);
        StickerAdjustFilter stickerAdjustFilter2 = this;
        stickerAdjustFilter2.registerTerminalFilter(stickerAdjustFilter2.mNormalFilter);
        this.mTerminalFilter = this.mNormalFilter;
        this.filtersToDestroy = new ArrayList<GLRenderer>();
        this.soundPool = new SoundPool(5, 3, 5);
    }

    public StickerBlendFilter.StickerStateChangeListener getStickerStateChangeListener() {
        return this.stickerStateChangeListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setStickerStateChangeListener(StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        void var1_1;
        this.stickerStateChangeListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableSound(boolean enableSound) {
        void var1_1;
        this.enableSoundPool = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setVoiceBytes(byte[] bytes) {
        Object object = this.listLock;
        synchronized (object) {
            if (this.mSoundInput != null) {
                void var1_1;
                this.mSoundInput.setSoundBytes((byte[])var1_1);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startExpressDetect(String modelPath) {
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter startExpressDetect");
        if (this.expressDetector == null) {
            this.expressDetector = new ExpressDetector();
        }
        this.expressDetector.setModelPath((String)var1_1);
        this.expressDetector.startDetect();
    }

    public void stopExpressDetect() {
        if (this.expressDetector != null) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopExpressDetect");
            this.expressDetector.stopDetect();
        }
    }

    public void startGestureDetect() {
        this.startGestureDetect(false, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void startGestureDetect(boolean useNewVersion, int handGestureType) {
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)("StickerAdjustFilter startGestureDetect useNewVersion " + useNewVersion + " handGestureType = " + handGestureType));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraUseHandGesture(true);
        if (this.gestureDetectorListener == null) {
            this.gestureDetectorListener = new CVDetector.GestureDetectorListener(this){
                final /* synthetic */ StickerAdjustFilter this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void gestureDetect(MMCVBoxes boxes) {
                    if (boxes != null && boxes.getDetectResult() != null && boxes.getDetectResult().length > 0) {
                        MMBox[] mMBoxArray;
                        StickerAdjustFilter.access$002(this.this$0, boxes);
                        for (MMBox mMBox : mMBoxArray.getDetectResult()) {
                            String string = mMBox.class_name_;
                            if (mMBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)string)) continue;
                            StickerAdjustFilter.access$100(this.this$0, string);
                            if (this.this$0.gestureDetectedListener == null) continue;
                            this.this$0.gestureDetectedListener.gestureDetected(string);
                        }
                        return;
                    }
                    StickerAdjustFilter.access$002(this.this$0, null);
                    if (this.this$0.mGestureTrackingFilter != null) {
                        this.this$0.mGestureTrackingFilter.gestureMiss();
                    }
                }
            };
        }
        if (this.gestureDetector == null) {
            if (var1_1 == false) {
                this.gestureDetector = new GestureDetector(this.gestureDetectorListener);
            } else {
                NewHandGestureDetector newHandGestureDetector = new NewHandGestureDetector();
                newHandGestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
                this.gestureDetector = newHandGestureDetector;
            }
        } else if (this.gestureDetector instanceof GestureDetector && var1_1 != false) {
            NewHandGestureDetector newHandGestureDetector = new NewHandGestureDetector();
            newHandGestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
            this.gestureDetector = newHandGestureDetector;
        } else if (this.gestureDetector instanceof NewHandGestureDetector && var1_1 == false) {
            this.gestureDetector = new GestureDetector(this.gestureDetectorListener);
        }
        if (this.gestureDetector instanceof NewHandGestureDetector) {
            void var2_4;
            ((NewHandGestureDetector)this.gestureDetector).setHandGestureType((int)var2_4);
        }
        this.gestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
        this.gestureDetector.startDetect();
    }

    /*
     * WARNING - void declaration
     */
    public void setGestureDetectInterval(int interval) {
        if (this.gestureDetector != null) {
            void var1_1;
            this.gestureDetector.setDetectInterval((int)var1_1);
        }
    }

    public void switchCamera(boolean isFront) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter switchCamera ");
        this.isCameraFront = isFront;
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            Iterator<Face3DMaskFilter> iterator = this.face3DMaskFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next().setCamera(isFront);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultCameraDirection(boolean cameraFront) {
        void var1_1;
        this.isCameraFront = var1_1;
    }

    public void stopGestureDetect() {
        if (this.gestureDetector != null) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopGestureDetect ");
            this.mmcvBoxes = null;
            this.gestureDetector.stopDetect();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeGestureModel(String gestureTriggerType) {
        void var1_1;
        this.mGestureTriggerModels.remove(var1_1);
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter removeGestureModel ");
    }

    /*
     * WARNING - void declaration
     */
    public void addGestureModel(String gestureTriggerType, MaskModel maskModel) {
        void var2_2;
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureModel ");
        maskModel.setModelType(4);
        this.mGestureTriggerModels.put((String)var1_1, (MaskModel)var2_2);
        if (this.gestureDetector != null) {
            this.gestureDetector.setGestureDetectorListener(this.gestureDetectorListener);
            this.gestureDetector.startDetect();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addGestureMaskModel(String gestureTriggerType) {
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureMaskModel ");
        MaskModel maskModel = this.mGestureTriggerModels.get(gestureTriggerType);
        this.addGestureMaskModel((String)var1_1, maskModel);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addGestureMaskModel(String gestureTriggerType, MaskModel model) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureMaskModel gestureTriggerType = ".concat(String.valueOf(gestureTriggerType)));
        if (model == null) {
            return false;
        }
        if (!FilterTriggerManager.isTriggerRegionMatches(this.mmcvBoxes, gestureTriggerType, model, this.getWidth(), this.getHeight())) {
            return false;
        }
        if (this.gestureDetectedListener != null) {
            void var1_1;
            this.gestureDetectedListener.onPreGestureAdded((String)var1_1);
        }
        if (model.addTime == 0L || System.currentTimeMillis() - model.addTime > model.getDuration() + 1000L) {
            model.addTime = System.currentTimeMillis();
            MaskModel maskModel = model;
            maskModel.setDuration(maskModel.getDuration());
            if (model != null) {
                void var2_2;
                this.addMaskModel((MaskModel)var2_2);
                this.startTime = 0L;
                return true;
            }
        }
        return false;
    }

    public void addHaniSticker(MaskModel model, int haniId) {
        if (this.mMultiStickerMaskFilter == null) {
            this.mMultiStickerMaskFilter = new MultiStickerMaskFilter(this.mContext);
            this.mMultiStickerMaskFilter.setPollGroupNumber(model.getPollGroupNum());
            StickerAdjustFilter stickerAdjustFilter = this;
            stickerAdjustFilter.addTerminalMultiStickerFilter(stickerAdjustFilter.mMultiStickerMaskFilter);
        }
        if (model == null) {
            return;
        }
        for (Sticker sticker : model.getStickers()) {
            String string = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
            sticker.setStickerType(model.getModelType() + "_" + string + haniId);
            sticker.setModelType(haniId);
            sticker.setDuration(99999999999L);
            sticker.setFrameRate(model.getFrameRate());
            sticker.isHaniSticker = true;
            this.addSticker(sticker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeHaniSticker(int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.removeHaniSticker(haniId);
            }
            this.clearMaskWithModelType((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addMaskModel(MaskModel model) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addMaskModel ");
        if (model == null) {
            RecoderDotUtil.getInstance().setUseSticker(false);
            return;
        }
        RecoderDotUtil.getInstance().setUseSticker(true);
        this.useBlendFilter = false;
        if (model.getModelType() == 0 || model.getModelType() == 7) {
            void object5;
            void var4_19;
            if (model.getModelType() == 0) {
                this.clearMaskWithModelType(0);
            }
            if (model.getAdditionalInfo() != null) {
                BodyLandHelper.setUseBodyLand((boolean)model.getAdditionalInfo().isBodyDetectEnable());
            }
            int n = 0;
            boolean n2 = false;
            this.mPollGroupNum = model.getPollGroupNum();
            if (model.getModelType() == 0) {
                this.hasExpressionModel = false;
                this.multiSwitchEnable = false;
            } else if (model.getModelType() == 7) {
                if (this.hasExpressionModel) {
                    return;
                }
                this.hasExpressionModel = true;
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isMultiFaceSwitchEnable()) {
                this.multiSwitchEnable = true;
                DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraEnableMultiFaces(this.multiSwitchEnable);
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isAnimojiDetectEnable()) {
                FacerigHelper.setUseAnimojiFaceRig((boolean)true);
            } else {
                FacerigHelper.setUseAnimojiFaceRig((boolean)false);
            }
            boolean bl = false;
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                List<Sticker> list = model.getStickers();
                ArrayList<Sticker> arrayList = new ArrayList<Sticker>();
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).getStickerType().equals("FACE_MASK_TYPE")) continue;
                    arrayList.add(list.get(i));
                    list.remove(i);
                }
                for (Sticker sticker : arrayList) {
                    list.add(sticker);
                }
                model.setStickers(list);
            }
            for (Sticker sticker : model.getStickers()) {
                if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                    sticker.setComic(true);
                }
                if (TextUtils.isEmpty((CharSequence)sticker.getStickerType()) || !sticker.getStickerType().equals("STICKER_TYPE_VOICE") && !sticker.getStickerType().equals("FACE_MASK_TYPE") && !sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    int n3 = n;
                    if (this.mMultiStickerMaskFilter != null) {
                        n3 += this.mMultiStickerMaskFilter.getStickerItemListSize();
                    }
                    if (this.mStickerFilterMap != null) {
                        n3 += this.mStickerFilterMap.size();
                    }
                    sticker.setStickerType(model.getModelType() + "_" + n3);
                    sticker.setDuration(99999999999L);
                }
                if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    for (LookUpModel lookUpModel : model.getLookUpFilters()) {
                        lookUpModel.setPresetFilter(MMPresetFilterStore.getPresetFilterByFolder(this.mContext, sticker.getImageFolderPath() + "/" + lookUpModel.getFolder()));
                        sticker.setStickerType("FACE_LOOK_UP_TYPE");
                        sticker.setTriggerType(lookUpModel.getTriggerType());
                        sticker.setLookUpModel(lookUpModel);
                        sticker.setHiddenTriggerType(lookUpModel.getHiddenTriggerType());
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d")) {
                    sticker.setXengineEsPath(model.getXengineEsPath());
                    this.useBlendFilter = true;
                }
                if (sticker.isClearsBodyArea()) {
                    this.useBlendFilter = true;
                    this.enableSelfRender = false;
                    ++var4_19;
                }
                if (this.isBlendSticker(sticker)) {
                    this.useBlendFilter = true;
                }
                if (sticker.getAdditionalInfo() != null && sticker.getAdditionalInfo().getFacePositions() != null) {
                    sticker.isCutFaceSticker = true;
                }
                sticker.setModelType(model.getModelType());
                if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                    void n5;
                    ++n5;
                }
                this.addSticker(sticker);
                ++n;
            }
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.addStickerList(this.mSwapFacialMaskSticker);
            }
            if (var4_19 > 0) {
                SegmentHelper.setSegmentCount((int)var4_19);
            }
            if (!TextUtils.isEmpty((CharSequence)model.getSoundPath())) {
                ++object5;
            }
            if (this.enableSoundPool) {
                if (!TextUtils.isEmpty((CharSequence)model.getSound()) && this.soundPlayer == null) {
                    this.soundPlayer = new MediaPlayer();
                    this.soundPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(this){
                        final /* synthetic */ StickerAdjustFilter this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public boolean onError(MediaPlayer mp, int what, int extra) {
                            void var3_3;
                            void var2_2;
                            MDLog.e((String)"FilterProcess", (String)("Audio Player Error what = " + (int)var2_2 + " extra = " + (int)var3_3));
                            return false;
                        }
                    });
                    this.soundPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(this){
                        final /* synthetic */ StickerAdjustFilter this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onPrepared(MediaPlayer player) {
                            void var1_1;
                            MDLog.d((String)"FilterProcess", (String)"Audio Player onPrepared");
                            player.setLooping(true);
                            var1_1.start();
                        }
                    });
                    this.soundPlayer.setAudioStreamType(3);
                    try {
                        this.soundPlayer.setDataSource(model.getSoundPath());
                        this.soundPlayer.prepareAsync();
                    }
                    catch (Exception exception) {
                        MDLog.e((String)"FilterProcess", (String)"MediaPlayerDataSourceHelper.setMediaPlayerDataSource Error");
                        this.soundPlayer.release();
                        this.soundPlayer = null;
                    }
                }
                this.tryLoadSound(model, (int)object5);
            }
        } else if (model.getModelType() == 4) {
            void var3_12;
            if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.isTrackingInit()) {
                return;
            }
            if (model.getStickers() == null) {
                return;
            }
            this.clearMaskWithModelType(model.getModelType());
            this.mPollGroupNum = model.getPollGroupNum();
            int n = 0;
            boolean mask = false;
            for (Sticker sticker : model.getStickers()) {
                String string = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + string + n);
                sticker.setTriggerRegion(model.getTriggerRegion());
                sticker.setModelType(model.getModelType());
                sticker.setFrameRate(model.getFrameRate());
                if ("object_follower".equals(sticker.getLayerType()) && !sticker.isDonotTrack()) {
                    sticker.setDuration(99999999999L);
                } else {
                    sticker.setDuration(model.getDuration());
                }
                if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                    void face3DMaskFilter;
                    ++face3DMaskFilter;
                }
                this.addSticker(sticker);
                ++n;
            }
            if (!TextUtils.isEmpty((CharSequence)model.getSoundPath())) {
                ++var3_12;
            }
            if (this.enableSoundPool) {
                this.tryLoadSound(model, (int)var3_12);
            }
        } else if (model.getModelType() == 6) {
            this.mPollGroupNum = model.getPollGroupNum();
            if (this.mMultiStickerMaskFilter == null) {
                this.mMultiStickerMaskFilter = new MultiStickerGameMaskFilter(this.mContext);
                StickerAdjustFilter stickerAdjustFilter = this;
                stickerAdjustFilter.addTerminalMultiStickerFilter(stickerAdjustFilter.mMultiStickerMaskFilter);
            }
            for (Sticker sticker : model.getStickers()) {
                sticker.setDuration(99999999999L);
                sticker.setFrameRate(model.getFrameRate());
                String string = sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + string);
                if (string != null && string.equals("game_over")) {
                    sticker.setType(5);
                    sticker.setAlwaysShow(true);
                    AbsolutePosition absolutePosition = new AbsolutePosition();
                    ObjectRegion objectRegion = new ObjectRegion();
                    new ObjectRegion().x = 0.5f;
                    objectRegion.y = 0.25f;
                    objectRegion.w = sticker.getImageWidth();
                    objectRegion.h = sticker.getImageHeight();
                    ViewPortProportion viewPortProportion = new ViewPortProportion();
                    new ViewPortProportion().height = 1920;
                    viewPortProportion.width = 1080;
                    absolutePosition.setCenter(objectRegion);
                    absolutePosition.setViewport(viewPortProportion);
                    sticker.setAbsolutePos(absolutePosition);
                } else {
                    sticker.isGameSticker = true;
                    sticker.setLayerType("face");
                    sticker.setGroupNumber(this.groupNumber);
                    sticker.setAlwaysShow(true);
                }
                this.addSticker(sticker);
            }
            ++this.groupNumber;
            if (this.enableSoundPool) {
                if (this.soundPool == null) {
                    this.soundPool = new SoundPool(5, 3, 5);
                }
                if (this.soundPool != null) {
                    if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
                        model.setSoundId(this.soundPool.load(model.getSoundPath(), 999));
                        this.soundPool.play(model.getSoundId(), 1.0f, 1.0f, 1, 1, 1.0f);
                        this.soundIds.add(model.getSoundId());
                    }
                    this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(this){
                        final /* synthetic */ StickerAdjustFilter this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            StickerAdjustFilter.access$400(this.this$0, (SoundPool)var1_1, (int)var2_2, (int)var3_3);
                        }
                    });
                    for (Sticker sticker : model.getStickers()) {
                        if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                        sticker.setSoundId(this.soundPool.load(sticker.getSoundPath(), 999));
                        this.soundIds.add(sticker.getSoundId());
                    }
                }
            }
        } else {
            this.addCommonModel(model);
        }
        if (model.getEffectList() != null) {
            this.addEffectProcessFilter(model);
        }
        if (model.getDistortionList() != null) {
            for (Mask mask : model.getDistortionList()) {
                if (mask.getHidingObjectTriggerType() == null) continue;
                this.mDistorationMask = mask;
                this.mFaceThinValue = this.mDistorationMask.getStrength();
                this.mBigEyeValue = this.mDistorationMask.getStrengthB();
                break;
            }
        }
        if (model.getBeautyFace() != null && this.mDistorationMask != null) {
            this.mBeautyFace = model.getBeautyFace();
        }
        if (model.getAdditionalInfo() != null) {
            void var1_1;
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                    if (model.getStickers() == null || face3DMaskFilter.getSticker() == null || !model.getStickers().contains(face3DMaskFilter.getSticker())) continue;
                    face3DMaskFilter.setAdditionalInfo(model.getAdditionalInfo());
                }
            }
            if (var1_1.getAdditionalInfo().isObjectDetectEnable()) {
                this.startGestureDetect();
            }
        }
        this.useBlendFilter = false;
    }

    private void addEffectProcessFilter(MaskModel model) {
        if (this.mEffectGroupFilter == null) {
            this.mEffectGroupFilter = new EffectGroupFilter();
            this.mEffectGroupFilter.setRenderFinishListener(new EffectGroupFilter.EffectRenderFinishListener(this){
                final /* synthetic */ StickerAdjustFilter this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void onRenderFinish() {
                    StickerAdjustFilter.access$500(this.this$0, (BasicFilter)this.this$0.mEffectGroupFilter);
                    this.this$0.filtersToDestroy.add(this.this$0.mEffectGroupFilter);
                    this.this$0.mEffectGroupFilter = null;
                }
            });
            StickerAdjustFilter stickerAdjustFilter = this;
            stickerAdjustFilter.addTerminalFilter((BasicFilter)stickerAdjustFilter.mEffectGroupFilter);
        }
        for (EffectFilterItem effectFilterItem : model.getEffectList()) {
            effectFilterItem.setModelType(model.getModelType());
            if (effectFilterItem.getDuration() == 0L) {
                effectFilterItem.setDuration(model.getDuration());
            }
            this.mEffectGroupFilter.addEffectFilterItem(effectFilterItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addCommonModel(MaskModel model) {
        if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
            List<Sticker> list = model.getStickers();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<Sticker> iterator = list.iterator();
            while (iterator.hasNext()) {
                Sticker sticker = iterator.next();
                if (!"FACE_MASK_TYPE".equals(sticker.getStickerType())) continue;
                arrayList.add(sticker);
                iterator.remove();
            }
            list.addAll(arrayList);
            model.setStickers(list);
        }
        this.mPollGroupNum = model.getPollGroupNum();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Sticker sticker : model.getStickers()) {
            if ("audio_visualizer".equals(sticker.getResourceType())) continue;
            if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                sticker.setStickerType("FACE_MASK_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                sticker.setStickerType("FACE_LOOK_UP_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                sticker.setStickerType("STICKER_TYPE_VOICE");
            } else if (TextUtils.isEmpty((CharSequence)sticker.getStickerType())) {
                sticker.setStickerType(model.getModelType() + "_" + n);
            }
            sticker.setModelType(model.getModelType());
            sticker.setFrameRate(model.getFrameRate());
            if (sticker.getDuration() == 0L) {
                sticker.setDuration(model.getDuration() > 0L ? model.getDuration() : 99999999999L);
            }
            if ("3d".equals(sticker.getLayerType())) {
                this.useBlendFilter = true;
                sticker.setXengineEsPath(model.getXengineEsPath());
            }
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
                ++n2;
            }
            if (this.isBlendSticker(sticker)) {
                this.useBlendFilter = true;
            }
            if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                ++n3;
            }
            this.addSticker(sticker);
            ++n;
        }
        if (n2 > 0) {
            SegmentHelper.setSegmentCount((int)n2);
        }
        if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
            ++n3;
        }
        if (this.enableSoundPool) {
            void var1_1;
            this.tryLoadSound((MaskModel)var1_1, n3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateSoundPoolLoadedStatus(SoundPool pool, int sampleId, int status) {
        void var3_3;
        SoundPoolInfo soundPoolInfo;
        MDLog.d((String)"media", (String)"update loadedStatus cur id=".concat(String.valueOf(sampleId)));
        if (soundPoolInfo != null && sampleId > 0 && var3_3 == false) {
            void var2_2;
            soundPoolInfo = this.soundInfoMap.get(sampleId);
            if (soundPoolInfo == null) {
                soundPoolInfo = new SoundPoolInfo();
                new SoundPoolInfo().soundId = sampleId;
                soundPoolInfo.isLoaded = true;
                this.soundInfoMap.put(sampleId, soundPoolInfo);
                MDLog.d((String)"media", (String)"[SoundPool]sticker is not playing, so put info to map id=".concat(String.valueOf(sampleId)));
                return;
            }
            MDLog.d((String)"media", (String)"[SoundPool]sticker is playing now , so execute runable id=".concat(String.valueOf((int)var2_2)));
            soundPoolInfo.isLoaded = true;
            if (soundPoolInfo.runnable != null) {
                soundPoolInfo.runnable.run();
                soundPoolInfo.runnable = null;
            }
        }
    }

    private synchronized void clearAllSoundPoolInfo() {
        MDLog.d((String)"media", (String)"[SoundPool]clear all soundInfo ");
        this.soundInfoMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setRunableCalledWhenLoaded(int sampleId, Runnable runable) {
        MDLog.d((String)"media", (String)"[SoundPool] set runable info id = ".concat(String.valueOf(sampleId)));
        if (sampleId > 0 && runable != null) {
            void var1_1;
            void var2_2;
            SoundPoolInfo soundPoolInfo = this.soundInfoMap.get(sampleId);
            if (soundPoolInfo != null && soundPoolInfo.isLoaded) {
                MDLog.d((String)"media", (String)"[SoundPool] sample is is loaded , execute runable   + sampleid=", (Object[])new Object[]{sampleId});
                runable.run();
                return;
            }
            MDLog.d((String)"media", (String)"[SoundPool] sample is not loaded, just update it ");
            if (soundPoolInfo == null) {
                soundPoolInfo = new SoundPoolInfo();
            }
            soundPoolInfo.soundId = sampleId;
            soundPoolInfo.runnable = var2_2;
            this.soundInfoMap.put((int)var1_1, soundPoolInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryLoadSound(MaskModel model, int soundSize) {
        this.clearAllSoundPoolInfo();
        if (this.soundPool != null) {
            void var1_1;
            void var2_3;
            for (Integer object : this.soundIds) {
                this.soundPool.unload(object.intValue());
            }
            this.soundPool.release();
            this.soundPool = new SoundPool((int)var2_3, 3, 5);
            this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(this){
                final /* synthetic */ StickerAdjustFilter this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    StickerAdjustFilter.access$400(this.this$0, (SoundPool)var1_1, (int)var2_2, (int)var3_3);
                }
            });
            for (Sticker sticker : var1_1.getStickers()) {
                if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                int n = this.soundPool.load(sticker.getSoundPath(), 999);
                MDLog.e((String)"media", (String)"[SoundPool]load tag is ".concat(String.valueOf(n)));
                sticker.setSoundId(n);
                this.soundIds.add(sticker.getSoundId());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBlendSticker(Sticker sticker) {
        void var1_1;
        return sticker.getBlendMode() != null && !TextUtils.isEmpty((CharSequence)var1_1.getBlendMode().name);
    }

    public float getThinFace() {
        return this.mThinFace;
    }

    /*
     * WARNING - void declaration
     */
    public void setThinFace(float thinFace) {
        void var1_1;
        this.mThinFace = var1_1;
    }

    public float getBigEye() {
        return this.mBigEye;
    }

    /*
     * WARNING - void declaration
     */
    public void setBigEye(float bigEye) {
        void var1_1;
        this.mBigEye = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFaceDetectFilter(FaceDetectFilter filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFinishListener(StickerMaskFinishListener finishListener) {
        void var1_1;
        this.finishListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void addSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2;
            sticker.curIndex = 0;
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
            }
            if (sticker.getTriggerType() > 0) {
                this.filterTriggerManager.setTriggerType(sticker.getTriggerType());
            }
            if (sticker.getHiddenTriggerType() > 0) {
                this.filterTriggerManager.setHiddenTriggerType(sticker.getHiddenTriggerType());
            }
            if ((object2 = this.mStickerFilterMap.get(sticker.getStickerType())) == null) {
                if (sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                    object2 = new SoundInputFilter();
                    this.mSoundInput = (SoundInputFilter)((Object)object2);
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type STICKER_TYPE_VOICE SoundInputFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("object_follower") && !sticker.isHaniSticker) {
                    object2 = new StickerGestureMaskFilter(this.mContext, sticker);
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type LAYER_TYPE_GESTURE StickerGestureMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                    if (this.mSwapFacialMaskSticker == null) {
                        this.mSwapFacialMaskSticker = new ArrayList<Sticker>();
                    }
                    this.mFaceMaskFilter = new FaceMaskFilter(sticker);
                    object2 = this.mFaceMaskFilter;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_MASK_TYPE FaceMaskFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d") && MediaModuleGlobalConfig.hasXE()) {
                    if (this.face3DMaskFilters == null) {
                        this.face3DMaskFilters = new ArrayList<Face3DMaskFilter>();
                    }
                    object2 = new Face3DMaskFilter(sticker, this.isCameraFront, this.mContext);
                    this.face3DMaskFilters.add((Face3DMaskFilter)((Object)object2));
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_3D_MASK_TYPE Face3DMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    if (null != sticker.getLookUpModel() && null != sticker.getLookUpModel().getPresetFilter()) {
                        object2 = sticker.getLookUpModel().getPresetFilter().getFilterGroup();
                        this.mLookupFilter = (SingleLineGroupFilter)object2;
                    } else {
                        object2 = new NormalFilter();
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_LOOK_UP_TYPE !!!");
                } else if (this.useBlendFilter && (sticker.getStickerType() == null || !sticker.getStickerType().startsWith("weex")) || sticker.isComic()) {
                    if (sticker.getEtcTextureBatch() != null) {
                        object2 = new StickerEtc1MaskFilter(this.mContext, sticker);
                    } else {
                        Sticker sticker2 = sticker;
                        object2 = new StickerMaskFilter(this.mContext, sticker2, sticker2.getImageProvider());
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                } else {
                    if (this.mMultiStickerMaskFilter == null) {
                        MDLog.e((String)"FilterProcess", (String)"optimization");
                        this.mMultiStickerMaskFilter = sticker.isCutFaceSticker ? new MultiStickerCutFaceMaskFilter(this.mContext) : new MultiStickerMaskFilter(this.mContext);
                        this.mMultiStickerMaskFilter.setPollGroupNumber(this.mPollGroupNum);
                        StickerAdjustFilter stickerAdjustFilter = this;
                        stickerAdjustFilter.addTerminalMultiStickerFilter(stickerAdjustFilter.mMultiStickerMaskFilter);
                    }
                    if (this.mMultiStickerMaskFilter != null) {
                        if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("native")) {
                            return;
                        }
                        if (this.mMultiStickerMaskFilter.isHaveSameSticker(sticker)) {
                            return;
                        }
                        this.mMultiStickerMaskFilter.addSticker(sticker, new StickerBlendFilter.StickerStateChangeListener(this, sticker){
                            final /* synthetic */ Sticker val$sticker;
                            final /* synthetic */ StickerAdjustFilter this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                this.val$sticker = sticker;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void stickerStateChanged(int trigerType, int state) {
                                StickerAdjustFilter.access$700(this.this$0, this.val$sticker, trigerType, state);
                                if (this.this$0.stickerStateChangeListener != null) {
                                    void var2_2;
                                    void var1_1;
                                    this.this$0.stickerStateChangeListener.stickerStateChanged((int)var1_1, (int)var2_2);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void stickerGestureTypeChanged(String trigerType, boolean isDraw) {
                                if (this.this$0.stickerStateChangeListener != null) {
                                    void var2_2;
                                    void var1_1;
                                    this.this$0.stickerStateChangeListener.stickerGestureTypeChanged((String)var1_1, (boolean)var2_2);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void faceDetected(boolean hasFace) {
                                if (this.this$0.stickerStateChangeListener != null) {
                                    void var1_1;
                                    this.this$0.stickerStateChangeListener.faceDetected((boolean)var1_1);
                                }
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void playStateChanged(int soundId, boolean play) {
                                void var2_2;
                                void var1_1;
                                if (null != this.this$0.soundPool) {
                                    if (play) {
                                        StickerAdjustFilter.access$1000(this.this$0, soundId, new Runnable(this, soundId){
                                            final /* synthetic */ int val$soundId;
                                            final /* synthetic */ 7 this$1;
                                            {
                                                void var1_1;
                                                this.this$1 = var1_1;
                                                this.val$soundId = n;
                                            }

                                            @Override
                                            public void run() {
                                                MDLog.d((String)"media", (String)"[SoundPool] Start play sounds !");
                                                int n = this.this$1.this$0.soundPool.play(this.val$soundId, 1.0f, 1.0f, 0, this.this$1.val$sticker.isLoopSound() ? -1 : 0, 1.0f);
                                                this.this$1.val$sticker.setPlayingSoundId(n);
                                            }
                                        });
                                    } else if (this.val$sticker.getPlayingSoundId() > 0) {
                                        this.this$0.soundPool.pause(this.val$sticker.getPlayingSoundId());
                                    }
                                }
                                this.this$0.stickerStateChangeListener.playStateChanged((int)var1_1, (boolean)var2_2);
                            }

                            @Override
                            public void distortionStateChanged(boolean faceBeauty, float faceValue, float eyeValue, float skinValue, float skinWhitevalue) {
                            }
                        });
                        this.mMultiStickerMaskFilter.setStickerFinishListener(new MultiStickerMaskFilter.StickerFinishListener(this){
                            final /* synthetic */ StickerAdjustFilter this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            public void stickerRenderFinished(int stickerNum, Sticker removeSticker) {
                                if (this.this$0.finishListener != null) {
                                    void var2_2;
                                    void var1_1;
                                    var1_1 = var1_1 + this.this$0.mStickerFilterMap.size() + Math.round(this.this$0.mBigEye) + Math.round(this.this$0.mThinFace);
                                    this.this$0.finishListener.stickerRenderFinished((int)var1_1, (Sticker)var2_2);
                                }
                            }
                        });
                        object2 = null;
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type MultiStickerMaskFilter !!!");
                    } else if (sticker.getStickerType().startsWith("weex")) {
                        object2 = new WeexStickerMaskFilter(sticker);
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type WeexStickerMaskFilter !!!");
                    } else {
                        if (sticker.getEtcTextureBatch() != null) {
                            object2 = new StickerEtc1MaskFilter(this.mContext, sticker);
                        } else {
                            Sticker sticker3 = sticker;
                            object2 = new StickerMaskFilter(this.mContext, sticker3, sticker3.getImageProvider());
                        }
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                    }
                }
                if (object2 != null) {
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerBlendFilter !!!");
                    object2 = new StickerBlendFilter((BasicFilter)object2, sticker);
                    ((StickerBlendFilter)((Object)object2)).setSegmentBody(sticker.isClearsBodyArea());
                    ((StickerBlendFilter)((Object)object2)).setSegmentStrokeColor(sticker.getStrokeColor());
                    ((StickerBlendFilter)((Object)object2)).setSegmentStrokeRadius(sticker.getStrokeRadius());
                    ((StickerBlendFilter)((Object)object2)).stickerStateChangeListener = new StickerBlendFilter.StickerStateChangeListener(this, sticker){
                        final /* synthetic */ Sticker val$sticker;
                        final /* synthetic */ StickerAdjustFilter this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$sticker = sticker;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void stickerStateChanged(int trigerType, int state) {
                            StickerAdjustFilter.access$700(this.this$0, this.val$sticker, trigerType, state);
                            if (this.this$0.stickerStateChangeListener != null) {
                                void var2_2;
                                void var1_1;
                                this.this$0.stickerStateChangeListener.stickerStateChanged((int)var1_1, (int)var2_2);
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void faceDetected(boolean hasFace) {
                            if (this.this$0.stickerStateChangeListener != null) {
                                void var1_1;
                                this.this$0.stickerStateChangeListener.faceDetected((boolean)var1_1);
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void stickerGestureTypeChanged(String trigerType, boolean isDraw) {
                            if (this.this$0.stickerStateChangeListener != null) {
                                void var2_2;
                                void var1_1;
                                this.this$0.stickerStateChangeListener.stickerGestureTypeChanged((String)var1_1, (boolean)var2_2);
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void playStateChanged(int soundId, boolean play) {
                            if (null != this.this$0.soundPool) {
                                if (play) {
                                    StickerAdjustFilter.access$1000(this.this$0, soundId, new Runnable(this, soundId){
                                        final /* synthetic */ int val$soundId;
                                        final /* synthetic */ 9 this$1;
                                        {
                                            void var1_1;
                                            this.this$1 = var1_1;
                                            this.val$soundId = n;
                                        }

                                        @Override
                                        public void run() {
                                            MDLog.d((String)"media", (String)"[SoundPool] Start play sounds !");
                                            int n = this.this$1.this$0.soundPool.play(this.val$soundId, 1.0f, 1.0f, 0, this.this$1.val$sticker.isLoopSound() ? -1 : 0, 1.0f);
                                            this.this$1.val$sticker.setPlayingSoundId(n);
                                        }
                                    });
                                } else if (this.val$sticker.getPlayingSoundId() > 0) {
                                    this.this$0.soundPool.pause(this.val$sticker.getPlayingSoundId());
                                }
                            }
                            if (this.this$0.stickerStateChangeListener != null) {
                                void var2_2;
                                void var1_1;
                                this.this$0.stickerStateChangeListener.playStateChanged((int)var1_1, (boolean)var2_2);
                            }
                        }

                        @Override
                        public void distortionStateChanged(boolean faceBeauty, float faceValue, float eyeValue, float skinValue, float skinWhitevalue) {
                        }
                    };
                    this.mStickerFilterMap.put(sticker.getStickerType(), (StickerBlendFilter)((Object)object2));
                    this.addTerminalBlendFilter((StickerBlendFilter)((Object)object2));
                    ((StickerBlendFilter)((Object)object2)).sticker = sticker;
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
                    ((StickerBlendFilter)((Object)object2)).setFinishListener(new StickerBlendFilter.StickerMaskFinishListener(this, sticker){
                        final /* synthetic */ Sticker val$sticker;
                        final /* synthetic */ StickerAdjustFilter this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$sticker = sticker;
                        }

                        @Override
                        public void stickerRenderFinished() {
                            StickerAdjustFilter.access$1400(this.this$0, this.val$sticker);
                        }
                    });
                }
            } else if (null != sticker.getImageFolderPath() && sticker.getImageFolderPath().equals(((StickerBlendFilter)((Object)object2)).sticker.getImageFolderPath())) {
                if (sticker.getStickerType().equals("FACE_MASK_TYPE") && sticker.getMask().swapFacialMask) {
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = 30000000L;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                } else {
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = ((StickerBlendFilter)((Object)object2)).mStickerDuration - ((StickerBlendFilter)((Object)object2)).getEscapedTime() + sticker.getDuration();
                }
            } else {
                void var1_1;
                ((StickerBlendFilter)((Object)object2)).sticker = sticker;
                ((StickerBlendFilter)((Object)object2)).resetSticker(sticker);
                ((StickerBlendFilter)((Object)object2)).mStickerDuration = sticker.getDuration() > 0L ? var1_1.getDuration() : 30000000L;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void removeStickerFilter(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            StickerBlendFilter stickerBlendFilter = this.mStickerFilterMap.get(sticker.getStickerType());
            stickerBlendFilter.setFinishListener(null);
            if (stickerBlendFilter == null) {
                return;
            }
            this.removeStickerBlendFilter(stickerBlendFilter);
            this.mStickerFilterMap.remove(sticker.getStickerType());
            this.filtersToDestroy.add((GLRenderer)stickerBlendFilter);
            if (this.finishListener != null) {
                void var1_1;
                int n = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n, (Sticker)var1_1);
            }
            return;
        }
    }

    private void removeStickerBlendFilter(StickerBlendFilter filter) {
        StickerBlendFilter stickerBlendFilter;
        BasicFilter basicFilter = filter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter((BasicFilter)filter);
            this.registerTerminalFilter(basicFilter);
            basicFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = basicFilter;
            return;
        }
        this.removeFilter((BasicFilter)filter);
        if (filter.getTargets().get(0) instanceof StickerBlendFilter) {
            stickerBlendFilter = (StickerBlendFilter)((Object)stickerBlendFilter.getTargets().get(0));
            v0.parentFilter = basicFilter;
            basicFilter.addTarget((GLTextureInputRenderer)stickerBlendFilter);
            return;
        }
        stickerBlendFilter = (BasicFilter)stickerBlendFilter.getTargets().get(0);
        v1.parentFilter = basicFilter;
        basicFilter.addTarget((GLTextureInputRenderer)stickerBlendFilter);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalFilter(BasicFilter filter) {
        void var1_1;
        this.mTerminalFilter.removeTarget((GLTextureInputRenderer)this);
        this.mTerminalFilter.addTarget((GLTextureInputRenderer)filter);
        filter.parentFilter = this.mTerminalFilter;
        StickerAdjustFilter stickerAdjustFilter = this;
        stickerAdjustFilter.removeTerminalFilter(stickerAdjustFilter.mTerminalFilter);
        StickerAdjustFilter stickerAdjustFilter2 = this;
        stickerAdjustFilter2.registerFilter(stickerAdjustFilter2.mTerminalFilter);
        this.mTerminalFilter = filter;
        var1_1.addTarget((GLTextureInputRenderer)this);
        StickerAdjustFilter stickerAdjustFilter3 = this;
        stickerAdjustFilter3.registerTerminalFilter(stickerAdjustFilter3.mTerminalFilter);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalMultiStickerFilter(BasicFilter filter) {
        void var1_1;
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            StickerAdjustFilter stickerAdjustFilter = this;
            stickerAdjustFilter.insertSpecifiedPosition(stickerAdjustFilter.mTerminalFilter, filter);
            return;
        }
        this.addTerminalFilter((BasicFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void insertSpecifiedPosition(BasicFilter destFilter, BasicFilter filter) {
        void var1_1;
        void var2_2;
        BasicFilter basicFilter = destFilter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)destFilter);
        basicFilter.addTarget((GLTextureInputRenderer)filter);
        this.registerFilter(filter);
        filter.parentFilter = basicFilter;
        destFilter.parentFilter = filter;
        var2_2.addTarget((GLTextureInputRenderer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalBlendFilter(StickerBlendFilter blendFilter) {
        void var1_1;
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            if (this.mMultiStickerMaskFilter != null) {
                StickerAdjustFilter stickerAdjustFilter = this;
                stickerAdjustFilter.insertSpecifiedPosition(stickerAdjustFilter.mMultiStickerMaskFilter, (BasicFilter)blendFilter);
                return;
            }
            StickerAdjustFilter stickerAdjustFilter = this;
            stickerAdjustFilter.insertSpecifiedPosition(stickerAdjustFilter.mTerminalFilter, (BasicFilter)blendFilter);
            return;
        }
        if (this.mTerminalFilter == this.mMultiStickerMaskFilter && blendFilter.segmentFilter != null) {
            StickerAdjustFilter stickerAdjustFilter = this;
            stickerAdjustFilter.insertSpecifiedPosition(stickerAdjustFilter.mTerminalFilter, (BasicFilter)blendFilter);
            return;
        }
        this.addTerminalFilter((BasicFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void drawTrackerSticker(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        filter.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawFixedSticker(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f;
        Sticker sticker = filter.sticker;
        float f2 = (float)this.getWidth() / 2.0f;
        float f3 = sticker.isShowTop() ? (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f : (float)this.getHeight() - (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        param.scaleW = f3 = (f = (float)sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f));
        param.scaleH = f;
        param.centerPoint = pointF;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawFullScreenFixed(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f;
        float f2 = (float)this.getWidth() / 2.0f;
        float f3 = ((float)this.getHeight() - (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        if (filter.sticker.getImageWidth() > 360) {
            f3 = 2.0f;
            f = 2.0f;
        } else if (this.getWidth() == 720) {
            f3 = 2.0f;
            f = 2.0f;
        } else {
            f3 = 1.5f;
            f = 1.5f;
        }
        param.scaleW = f3;
        param.scaleH = f;
        param.centerPoint = pointF;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawPositionSetFixed(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        param.scaleH = (float)this.getHeight() / (float)filter.sticker.getImageHeight() * f;
        param.scaleW = (float)this.getWidth() / (float)filter.sticker.getImageWidth() * f;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostion(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        float f = (float)filter.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        if (absolutePosition != null && absolutePosition.getCenter() != null) {
            float f2 = (float)this.getWidth() * absolutePosition.getCenter().x;
            float f3 = (float)this.getHeight() * absolutePosition.getCenter().y;
            param.centerPoint = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        } else {
            param.centerPoint = new PointF(0.5f, 0.5f);
        }
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostionUseStcikerDim(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        float f = (float)filter.sticker.getImageWidth() * ((float)this.getHeight() / (float)filter.sticker.getBaseDemensionHeight()) / ((float)this.getWidth() / 2.0f);
        if (absolutePosition != null && absolutePosition.getCenter() != null) {
            float f2 = (float)this.getWidth() * absolutePosition.getCenter().x;
            float f3 = (float)this.getHeight() * absolutePosition.getCenter().y;
            param.centerPoint = new PointF(f2 / (float)this.getWidth(), f3 / (float)this.getHeight());
        } else {
            param.centerPoint = new PointF(0.5f, 0.5f);
        }
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsPostionAdjustResolution(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = (float)this.getWidth() > 480.0f ? (float)this.getWidth() / 352.0f : 1.0f;
        f = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f) * f;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        param.centerPoint = absolutePosition != null && absolutePosition.getCenter() != null ? new PointF(absolutePosition.getCenter().x, absolutePosition.getCenter().y) : new PointF(0.5f, 0.5f);
        param.scaleW = f;
        param.scaleH = f;
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawScaleCenterCrop(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        float f = filter.sticker.getImageWidth();
        float f2 = filter.sticker.getImageHeight();
        f = f * (float)this.getHeight() > (float)this.getWidth() * f2 ? (float)this.getHeight() / f2 : (float)this.getWidth() / f;
        param.scaleW = f * 2.0f;
        param.scaleH = f * 2.0f;
        param.centerPoint = new PointF(0.5f, 0.5f);
        param.angle = 0.0f;
        param.filterTrigerManager = this.filterTriggerManager;
        var1_1.setDetectParam((FaceDetectFilter.FaceDetectParam)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawGestureFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        void var2_2;
        void var1_1;
        if (filter.sticker.isDonotTrack()) {
            this.drawGestureFixedFilter(filter, param);
            return;
        }
        this.drawGestureTrackingFilter((StickerBlendFilter)var1_1, (FaceDetectFilter.FaceDetectParam)var2_2);
    }

    private void drawGestureFixedFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (this.mmcvBoxes == null || this.mmcvBoxes.getDetectResult() == null || this.mmcvBoxes.getDetectResult().length == 0) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.triggerType = filter.sticker.getObjectTriggerType();
        for (MMBox mMBox : this.mmcvBoxes.getDetectResult()) {
            if (mMBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)mMBox.class_name_) || !mMBox.class_name_.equals(param.triggerType)) continue;
            param.gestureRect = new RectF((float)mMBox.x_, (float)mMBox.y_, (float)(mMBox.x_ + mMBox.width_), (float)(mMBox.y_ + mMBox.height_));
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updateRectForTrigger(PointF center, float angle, float scale, boolean forceUpdate, int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                void var3_4;
                void var1_1;
                void var2_3;
                FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
                new FaceDetectFilter.FaceDetectParam().angle = var2_3;
                faceDetectParam.centerPoint = new PointF(center.x, var1_1.y);
                faceDetectParam.triggerType = "tracking_rect";
                faceDetectParam.scaleH = 0.5f * scale;
                faceDetectParam.scaleW = 0.5f * var3_4;
                this.mMultiStickerMaskFilter.setHaniStickerParam(faceDetectParam, haniId);
                return;
            }
            return;
        }
    }

    private void drawGestureTrackingFilter(StickerBlendFilter filter, FaceDetectFilter.FaceDetectParam param) {
        if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.isTrackingInit()) {
            return;
        }
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (this.mmcvBoxes == null || null == this.mmcvBoxes.getDetectResult() || this.mmcvBoxes.getDetectResult().length == 0) {
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.triggerType = filter.sticker.getObjectTriggerType();
        for (MMBox mMBox : this.mmcvBoxes.getDetectResult()) {
            if (mMBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)mMBox.class_name_) || !mMBox.class_name_.equals(param.triggerType)) continue;
            mMBox = new RectF((float)mMBox.x_, (float)mMBox.y_, (float)(mMBox.x_ + mMBox.width_), (float)(mMBox.y_ + mMBox.height_));
            param.gestureRect = mMBox;
            this.mmcvRect = new MMRect();
            if (filter.sticker.getTrackingRegion() != null) {
                ObjectRegion objectRegion = filter.sticker.getTrackingRegion();
                mMBox = new RectF((RectF)mMBox);
                this.mmcvRect.x_ = (int)(mMBox.left + mMBox.width() * objectRegion.x);
                this.mmcvRect.y_ = (int)(mMBox.top + mMBox.height() * objectRegion.y);
                this.mmcvRect.width_ = (int)((float)this.mmcvRect.x_ + mMBox.width() * objectRegion.w);
                this.mmcvRect.height_ = (int)((float)this.mmcvRect.y_ + mMBox.height() * objectRegion.h);
            } else {
                this.mmcvRect.x_ = (int)mMBox.left;
                this.mmcvRect.y_ = (int)mMBox.top;
                this.mmcvRect.width_ = (int)(mMBox.right - mMBox.left);
                this.mmcvRect.height_ = (int)(mMBox.bottom - mMBox.top);
            }
            if (this.mGestureTrackingFilter != null) {
                this.mGestureTrackingFilter.setMMCVRect(this.mmcvRect);
            }
            param.filterTrigerManager = this.filterTriggerManager;
            param.centerPoint = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            if (this.mGestureTrackingFilter == null) continue;
            this.mGestureTrackingFilter.startTracking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        this.mCurCVInfo = mmcvInfo;
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2;
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.mStickerFilterMap != null && this.mStickerFilterMap.size() > 0) {
                for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                    if (stickerBlendFilter.segmentFilter == null) continue;
                    stickerBlendFilter.setMMCVInfo(mmcvInfo);
                }
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.expressDetector != null) {
                this.expressDetector.setMMCVInfo(mmcvInfo);
            }
            if (this.gestureDetector != null) {
                this.gestureDetector.setMMCVInfo(mmcvInfo);
            }
            if (this.mGestureTrackingFilter != null) {
                this.mGestureTrackingFilter.setMMCVInfo(mmcvInfo);
            }
            this.processDistortionState();
            boolean bl = true;
            int n = 0;
            if (mmcvInfo.getMaxFaceCnt() <= 0) {
                bl = false;
                this.lastFacesCnt = 0;
            } else if (this.multiSwitchEnable) {
                n = this.calculateFaceIndex(mmcvInfo);
                object2 = mmcvInfo.getFaceAttributeInfo(n).getLandmarks68();
                this.lastFacePosition.set(object2[0], object2[68]);
                this.lastFacesCnt = mmcvInfo.getMaxFaceCnt();
            }
            this.filterTriggerManager.setTriggerFaceIndex(n);
            this.filterTriggerManager.adjustStateBy(mmcvInfo);
            if (this.mMultiStickerMaskFilter != null) {
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(bl);
                }
                this.mMultiStickerMaskFilter.setMainFaceIndex(n);
                this.mMultiStickerMaskFilter.setFilterTriggerManager(this.filterTriggerManager);
                this.mMultiStickerMaskFilter.setMmcvBoxes(this.mmcvBoxes);
                this.mMultiStickerMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                object2 = this.face3DMaskFilters.iterator();
                while (object2.hasNext()) {
                    Face3DMaskFilter face3DMaskFilter = (Face3DMaskFilter)((Object)object2.next());
                    if (!face3DMaskFilter.needFaceDetect()) continue;
                    face3DMaskFilter.setMMCVInfo(mmcvInfo);
                }
            }
            if (mmcvInfo.getMaxFaceCnt() == 0) {
                for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                    FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
                    if (!TextUtils.isEmpty((CharSequence)stickerBlendFilter.sticker.getLayerType()) && stickerBlendFilter.sticker.getLayerType().equals("object_follower")) {
                        stickerBlendFilter.clearPoints();
                        this.drawGestureFilter(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (!stickerBlendFilter.sticker.isAlwaysShow()) {
                        stickerBlendFilter.clearPoints();
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 1) {
                        stickerBlendFilter.clearPoints();
                        this.drawFixedSticker(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 2) {
                        stickerBlendFilter.clearPoints();
                        this.drawFullScreenFixed(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 3) {
                        stickerBlendFilter.clearPoints();
                        this.drawPositionSetFixed(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 99) {
                        stickerBlendFilter.clearPoints();
                        this.drawScaleCenterCrop(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 5) {
                        stickerBlendFilter.clearPoints();
                        this.drawAbsolutePostion(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 6) {
                        stickerBlendFilter.clearPoints();
                        this.drawAbsolutePostionUseStcikerDim(stickerBlendFilter, faceDetectParam);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() != 7) continue;
                    stickerBlendFilter.clearPoints();
                    this.drawAbsPostionAdjustResolution(stickerBlendFilter, faceDetectParam);
                }
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(false);
                }
            } else {
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(true);
                }
                for (int i = mmcvInfo.getMaxFaceCnt() - 1; i >= 0; --i) {
                    for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                        float f;
                        float f2;
                        float f3;
                        Sticker sticker = stickerBlendFilter.sticker;
                        FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
                        new FaceDetectFilter.FaceDetectParam().mmcvBoxes = this.mmcvBoxes;
                        if (!TextUtils.isEmpty((CharSequence)stickerBlendFilter.sticker.getLayerType()) && stickerBlendFilter.sticker.getLayerType().equals("object_follower")) {
                            stickerBlendFilter.clearPoints();
                            this.drawGestureFilter(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (sticker.getType() == 1) {
                            stickerBlendFilter.clearPoints();
                            this.drawFixedSticker(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (sticker.getType() == 2) {
                            stickerBlendFilter.clearPoints();
                            this.drawFullScreenFixed(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (sticker.getType() == 3) {
                            stickerBlendFilter.clearPoints();
                            this.drawPositionSetFixed(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 99) {
                            stickerBlendFilter.clearPoints();
                            this.drawScaleCenterCrop(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 5) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsolutePostion(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 6) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsolutePostionUseStcikerDim(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 7) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsPostionAdjustResolution(stickerBlendFilter, faceDetectParam);
                            continue;
                        }
                        if (sticker.getType() != 0) continue;
                        stickerBlendFilter.clearPoints();
                        FaceAttributeInfo faceAttributeInfo = mmcvInfo.getFaceAttributeInfo(i);
                        float[] fArray = faceAttributeInfo.getLandmarks68();
                        float f4 = fArray[sticker.getFacePositionLeft()];
                        float f5 = fArray[sticker.getFacePositionLeft() + 68];
                        float f6 = fArray[sticker.getFacePositionRight()];
                        float f7 = fArray[sticker.getFacePositionRight() + 68];
                        PointF pointF = new PointF(f4, f5);
                        PointF pointF2 = new PointF(f6, f7);
                        f6 = faceAttributeInfo.getFaceRotateDegree_2d();
                        PointF pointF3 = new PointF((float)sticker.getOffsetX() * this.getAdjustWidthScale(), (float)sticker.getOffsetY() * this.getAdjustWidthScale());
                        this.rotatePoint(pointF3, f6);
                        if (sticker.hasCenterPoint()) {
                            faceAttributeInfo = new PointF(fArray[sticker.getCenterIndex()], fArray[sticker.getCenterIndex() + 68]);
                        } else if (sticker.getPointIndexes().length == 1) {
                            int n2 = sticker.getPointIndexes()[0];
                            f3 = fArray[n2];
                            f2 = fArray[n2 + 68];
                            faceAttributeInfo = new PointF(f3, f2);
                        } else {
                            int n3 = sticker.getPointIndexes()[0];
                            int n4 = sticker.getPointIndexes()[1];
                            f2 = fArray[n3];
                            f = fArray[n3 + 68];
                            float f8 = fArray[n4];
                            float f9 = fArray[n4 + 68];
                            faceAttributeInfo = this.getCenterPoint(new PointF(f2, f), new PointF(f8, f9));
                        }
                        float f10 = (float)this.getmDistancePoint(pointF, pointF2);
                        f3 = f10 / 180.0f / this.getAdjustWidthScale();
                        f2 = this.getWidth() / 2;
                        f = (float)sticker.getImageWidth() * this.getAdjustWidthScale() / f2;
                        faceAttributeInfo.x += pointF3.x * (f10 / 180.0f) / this.getAdjustWidthScale();
                        faceAttributeInfo.y += pointF3.y * (f10 / 180.0f) / this.getAdjustWidthScale();
                        faceAttributeInfo = new PointF(faceAttributeInfo.x / (float)this.getWidth(), faceAttributeInfo.y / (float)this.getHeight());
                        faceDetectParam.scaleW = f3 *= f;
                        faceDetectParam.scaleH = f3;
                        if (sticker.isComic()) {
                            faceDetectParam.centerPoint = faceAttributeInfo;
                            faceDetectParam.angle = f6 <= 90.0f && f6 >= 0.0f || f6 >= 270.0f && f6 <= 360.0f ? 0.0f : 180.0f;
                        } else {
                            faceDetectParam.centerPoint = faceAttributeInfo;
                            faceDetectParam.angle = f6;
                        }
                        faceDetectParam.points68 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
                        faceDetectParam.points96 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks96();
                        faceDetectParam.points104 = mmcvInfo.getFaceAttributeInfo(0).getLandmarks104();
                        faceDetectParam.warpedPoints104 = mmcvInfo.getFaceAttributeInfo(0).getWarpedLandmarks104();
                        faceDetectParam.filterTrigerManager = this.filterTriggerManager;
                        faceDetectParam.euler_angles = mmcvInfo.getFaceAttributeInfo(0).getEulerAngles();
                        stickerBlendFilter.setDetectParam(faceDetectParam);
                    }
                }
            }
            return;
        }
    }

    private void processDistortionState() {
        if (this.mDistorationMask != null) {
            if (!this.mFaceStateChange && this.mmcvBoxes != null) {
                MMBox[] mMBoxArray = this.mmcvBoxes.getDetectResult();
                int n = mMBoxArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!mMBoxArray[i].class_name_.equals(this.mDistorationMask.getHidingObjectTriggerType())) continue;
                    this.mFaceStateChange = true;
                }
            }
            if (this.mFaceStateChange) {
                if (this.mDistorationMask.getStrengthStep() == 0.0f && this.mDistorationMask.getStrengthStepB() == 0.0f) {
                    this.mFaceBeauty = true;
                } else if (!this.mFaceBeauty) {
                    if (this.mFaceThinValue > 0.0f) {
                        this.mFaceThinValue -= this.mDistorationMask.getStrengthStep();
                    }
                    if (this.mBigEyeValue > 0.0f) {
                        this.mBigEyeValue -= this.mDistorationMask.getStrengthStepB();
                    }
                    if (this.mFaceThinValue <= 0.0f && this.mBigEyeValue <= 0.0f) {
                        this.mFaceBeauty = true;
                    }
                }
                if (this.mFaceBeauty && !this.mFaceBeautyHaveFinish) {
                    this.mFaceThinValue = this.mDistorationMask.getStrengthStep() == 0.0f ? this.mBeautyFace.getThinFaceValue() : (this.mFaceThinValue += this.mDistorationMask.getStrengthStep());
                    this.mBigEyeValue = this.mDistorationMask.getStrengthStepB() == 0.0f ? this.mBeautyFace.getBigEyeValue() : (this.mBigEyeValue += this.mDistorationMask.getStrengthStepB());
                    if (this.mFaceThinValue >= this.mBeautyFace.getThinFaceValue() && this.mBigEyeValue >= this.mBeautyFace.getBigEyeValue()) {
                        this.stickerStateChangeListener.distortionStateChanged(true, this.mBeautyFace.getThinFaceValue(), this.mBeautyFace.getBigEyeValue(), this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                        this.mFaceBeautyHaveFinish = true;
                        return;
                    }
                    this.stickerStateChangeListener.distortionStateChanged(true, this.mFaceThinValue, this.mBigEyeValue, this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                    return;
                }
                this.stickerStateChangeListener.distortionStateChanged(false, this.mFaceThinValue, this.mBigEyeValue, 0.0f, 0.0f);
            }
        }
    }

    public synchronized void destroy() {
        for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
            stickerBlendFilter.cancelDraw();
            stickerBlendFilter.destroy();
        }
        if (this.mEffectGroupFilter != null) {
            this.mEffectGroupFilter.destroy();
        }
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.destroy();
        }
        super.destroy();
        if (this.mNormalFilter != null) {
            this.mNormalFilter.destroy();
        }
        if (this.gestureDetector != null) {
            this.gestureDetector.cancel();
        }
        this.gestureDetectorListener = null;
        this.stopExpressDetect();
        FacerigHelper.release();
        BodyLandHelper.release();
        SegmentHelper.release();
        FacerigHelper.releseFaceRigInfo();
        this.releaseSoundPlayer();
        if (this.mFaceMaskFilter != null) {
            this.mFaceMaskFilter.destroy();
        }
        if (this.mSwapFacialMaskSticker != null) {
            this.mSwapFacialMaskSticker.clear();
            this.mSwapFacialMaskSticker = null;
        }
        if (this.mLookupFilter != null) {
            this.mLookupFilter.destroy();
            this.mLookupFilter = null;
        }
        if (this.filtersToDestroy != null && this.filtersToDestroy.size() > 0) {
            Iterator<StickerBlendFilter> iterator = this.filtersToDestroy.iterator();
            while (iterator.hasNext()) {
                ((GLRenderer)iterator.next()).destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.scaleWidth == 0) {
                this.scaleWidth = this.getWidth();
                this.scaleWidthRatio = 1.0f;
            } else if (this.getWidth() > 0) {
                this.scaleWidthRatio = (float)this.scaleWidth / (float)this.getWidth();
            }
            if (this.scaleHeight == 0) {
                this.scaleHeight = this.getHeight();
                this.scaleHeightRatio = 1.0f;
            } else if (this.getHeight() > 0) {
                this.scaleHeightRatio = (float)this.scaleHeight / (float)this.getHeight();
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.setScaleWidthRatio(this.scaleWidthRatio);
                this.mMultiStickerMaskFilter.setScaleHeightRatio(this.scaleHeightRatio);
            }
            if (this.enableSelfRender) {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                this.setTimeStamp(System.currentTimeMillis() - this.startTime);
            }
            Iterator<GLRenderer> iterator = this.filtersToDestroy.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.filtersToDestroy.clear();
            super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_3, (boolean)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setTimeStamp(ms);
        }
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.setTimeStamp(ms);
        }
        if (this.enableSelfRender) {
            this.setMMCVInfo(new MMCVInfo());
        }
        if (this.mEffectGroupFilter != null) {
            void var1_1;
            if (this.mLastRenderTime == 0L) {
                this.mLastRenderTime = System.currentTimeMillis();
            }
            this.mEffectGroupFilter.setTimeStamp((long)(var1_1 - this.mLastRenderTime));
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeSticker(String stickerType) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                void var1_1;
                this.mMultiStickerMaskFilter.removeSticker((String)var1_1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void clearMaskWithModelType(int modelType) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                if (stickerBlendFilter.sticker.getModelType() != modelType) continue;
                stickerBlendFilter.setFinishListener(null);
                if (stickerBlendFilter == null) {
                    return;
                }
                this.removeStickerBlendFilter(stickerBlendFilter);
                this.filtersToDestroy.add((GLRenderer)stickerBlendFilter);
                if (this.finishListener != null) {
                    int n = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                    Sticker sticker = stickerBlendFilter.sticker;
                    this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n, sticker);
                }
                this.mStickerFilterMap.remove(stickerBlendFilter.sticker.getStickerType());
                if (!(stickerBlendFilter.stickerMaskFilter instanceof Face3DMaskFilter) || this.face3DMaskFilters == null) continue;
                this.face3DMaskFilters.remove((Object)stickerBlendFilter.stickerMaskFilter);
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.clearMaskWithModelType(modelType);
            }
            if (this.mEffectGroupFilter != null) {
                void var1_1;
                this.mEffectGroupFilter.clearWithModelType((int)var1_1);
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskFilters() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (Object object2 : this.mStickerFilterMap.values()) {
                object2.setFinishListener(null);
                if (object2 == null) {
                    return;
                }
                this.removeStickerBlendFilter((StickerBlendFilter)((Object)object2));
                this.filtersToDestroy.add((GLRenderer)object2);
                if (this.finishListener == null) continue;
                int n = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                object2 = object2.sticker;
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n, (Sticker)object2);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                this.face3DMaskFilters.clear();
                this.face3DMaskFilters = null;
            }
            if (BodyLandHelper.isUseBodyLand()) {
                BodyLandHelper.setUseBodyLand((boolean)false);
            }
            if (this.mMultiStickerMaskFilter != null) {
                BasicFilter basicFilter = this.mMultiStickerMaskFilter.parentFilter;
                basicFilter.removeTarget((GLTextureInputRenderer)this.mMultiStickerMaskFilter);
                if (this.mTerminalFilter == this.mMultiStickerMaskFilter) {
                    StickerAdjustFilter stickerAdjustFilter = this;
                    stickerAdjustFilter.removeTerminalFilter(stickerAdjustFilter.mMultiStickerMaskFilter);
                    this.registerTerminalFilter(basicFilter);
                    basicFilter.addTarget((GLTextureInputRenderer)this);
                    this.mTerminalFilter = basicFilter;
                } else {
                    Object object2;
                    StickerAdjustFilter stickerAdjustFilter = this;
                    stickerAdjustFilter.removeFilter(stickerAdjustFilter.mMultiStickerMaskFilter);
                    object2 = (BasicFilter)this.mMultiStickerMaskFilter.getTargets().get(0);
                    ((BasicFilter)this.mMultiStickerMaskFilter.getTargets().get(0)).parentFilter = basicFilter;
                    basicFilter.addTarget((GLTextureInputRenderer)object2);
                }
                this.filtersToDestroy.add((GLRenderer)this.mMultiStickerMaskFilter);
                this.mMultiStickerMaskFilter = null;
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.clearAll();
            }
            if (this.mFaceMaskFilter != null) {
                this.filtersToDestroy.add((GLRenderer)this.mFaceMaskFilter);
                this.mFaceMaskFilter = null;
            }
            if (this.mSwapFacialMaskSticker != null) {
                this.mSwapFacialMaskSticker.clear();
                this.mSwapFacialMaskSticker = null;
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
            this.releaseSoundPlayer();
            SegmentHelper.release();
            FacerigHelper.releseFaceRigInfo();
            this.mStickerFilterMap.clear();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeEffectFilter(BasicFilter filter) {
        void var1_1;
        BasicFilter basicFilter = filter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter(filter);
            this.registerTerminalFilter(basicFilter);
            basicFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = basicFilter;
            return;
        }
        this.removeFilter(filter);
        BasicFilter basicFilter2 = (BasicFilter)filter.getTargets().get(0);
        var1_1.removeTarget((GLTextureInputRenderer)basicFilter2);
        basicFilter2.parentFilter = basicFilter;
        basicFilter.addTarget((GLTextureInputRenderer)basicFilter2);
    }

    public void releaseSoundPlayer() {
        this.clearAllSoundPoolInfo();
        if (this.soundPool != null) {
            if (this.soundIds != null && this.soundIds.size() > 0) {
                for (Integer n : this.soundIds) {
                    this.soundPool.unload(n.intValue());
                }
                this.soundIds.clear();
            }
            this.soundPool.release();
        }
        if (this.soundPlayer != null) {
            this.soundPlayer.release();
            this.soundPlayer = null;
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
    }

    public int getTextOutID() {
        BasicFilter basicFilter = (BasicFilter)this.getTerminalFilters().get(0);
        if (basicFilter != null) {
            return basicFilter.getTextOutID();
        }
        return 0;
    }

    public void lockTexture() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().lockTexture();
        }
    }

    public void unlockTexture() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().unlockTexture();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleWidth(int scaleWidth) {
        void var1_1;
        this.scaleWidth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleHeight(int scaleHeight) {
        void var1_1;
        this.scaleHeight = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setGameScoreListener(GameScoreListener listener) {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            void var1_1;
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).setGameScoreListener((GameScoreListener)var1_1);
        }
    }

    public void startPlayingTailMoving() {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).playingTailMoving();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBitmapValid(Bitmap bitmap) {
        void var1_1;
        return bitmap != null && !var1_1.isRecycled();
    }

    /*
     * WARNING - void declaration
     */
    public void initGameFixSticker(Bitmap scoreBitmap, Bitmap iconBitmap, int width, int height) {
        if (this.isBitmapValid(scoreBitmap) && this.isBitmapValid(iconBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            void var3_3;
            void var2_2;
            void var1_1;
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).initGameFixStickerItem((Bitmap)var1_1, (Bitmap)var2_2, (int)var3_3, height);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateGameFixStickerScore(Bitmap scoreBitmap) {
        if (this.isBitmapValid(scoreBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof MultiStickerGameMaskFilter) {
            void var1_1;
            ((MultiStickerGameMaskFilter)this.mMultiStickerMaskFilter).updateGameFixStickerScore((Bitmap)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setGameStickerDownVelocity(float downVelocity) {
        if (this.mMultiStickerMaskFilter != null) {
            void var1_1;
            this.mMultiStickerMaskFilter.setDownVelocity((float)var1_1);
        }
    }

    public void setIsUseStickerOptimization(boolean isUsePlus) {
    }

    /*
     * WARNING - void declaration
     */
    public void setGestureDetectedListener(GestureDetectedListener listener) {
        void var1_1;
        this.gestureDetectedListener = var1_1;
    }

    public void pauseRender() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().pauseBitmapCache();
        }
    }

    public void resumeRender() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().resumeBitmapCache();
        }
    }

    protected void initFBO() {
        super.initFBO();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            return false;
        }
        return false;
    }

    private int calculateFaceIndex(MMCVInfo mmcvInfo) {
        int n = mmcvInfo.getMaxFaceCnt();
        if (n == 1) {
            return 0;
        }
        boolean bl = false;
        if (mmcvInfo.cameraDegree / 90 % 2 == 0) {
            bl = true;
        }
        if (n >= this.lastFacesCnt) {
            float f = 10000.0f;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                float f2;
                float[] fArray = mmcvInfo.getFaceAttributeInfo(i).getLandmarks68();
                float f3 = (float)PointHelper.a(new PointF(fArray[0], fArray[68]), this.lastFacePosition);
                if (!(f2 < f)) continue;
                f = f3;
                n2 = i;
            }
            return n2;
        }
        float[] fArray = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
        float f = bl ? fArray[68] : fArray[0];
        int n3 = 0;
        float f4 = 10000.0f;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            float f5;
            float[] fArray2 = mmcvInfo.getFaceAttributeInfo(i).getLandmarks68();
            if (!bl && fArray2[0] < f || bl && fArray2[68] < f) {
                f = bl ? fArray2[68] : fArray2[0];
                n3 = i;
            }
            if (!bl && fArray2[0] <= this.lastFacePosition.x || bl && fArray2[68] < this.lastFacePosition.y) continue;
            float f6 = (float)PointHelper.a(new PointF(fArray2[0], fArray2[68]), this.lastFacePosition);
            if (!(f5 < f4)) continue;
            f4 = f6;
            n4 = i;
        }
        if (n4 != -1) {
            return n4;
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    public void setplayStatusListener(MStickerActions.onPlayStatusListener listener) {
        void var1_1;
        this.playStatusListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void updateplayStatus(Sticker sticker, int triggerType, int state) {
        if (this.playStatusListener != null && triggerType == sticker.getTriggerType() && sticker.getTriggerPlayStatus() != -1) {
            void var1_1;
            void var2_2;
            boolean bl = false;
            switch (var2_2) {
                case 1: {
                    void var3_3;
                    if (var3_3 != false) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!this.isplayStatusTriggered && bl) {
                this.isplayStatusTriggered = true;
                this.playStatusListener.onPlayStatusChanged(sticker.getTriggerPlayStatus());
            }
            if (this.isplayStatusTriggered && sticker.curIndex == var1_1.getLoopStart()) {
                this.isplayStatusTriggered = false;
                this.playStatusListener.onPlayStatusChanged(-1);
            }
        }
    }

    public void updateFrameInfo(Frame frame, Session session) {
        Object object;
        Object object2;
        void var4_3 = object2;
        Frame frame2 = frame;
        object2 = ArCoreHelper.a();
        ArCoreHelper.a().a = var4_3;
        ((ArCoreHelper)object2).b = frame2;
        if (this.mArCoreFrameListener != null) {
            this.mArCoreFrameListener.getARCoreFrame((Frame)object);
        }
        object2 = ArCoreHelper.a();
        if (((ArCoreHelper)object2).b == null || ((ArCoreHelper)object2).a == null) {
            return;
        }
        float f = -1.0f;
        float f2 = -1.0f;
        object = ((ArCoreHelper)object2).a.getAllTrackables(Plane.class);
        object2 = new float[24 * object.size()];
        double[] dArray = new double[object.size()];
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Plane plane = (Plane)object.next();
            float[] fArray = new float[3];
            float[] fArray2 = new float[24];
            plane.getCenterPose().toMatrix(fArray2, 0);
            fArray[0] = fArray2[12];
            fArray[1] = fArray2[13];
            fArray[2] = fArray2[14];
            if (plane.getTrackingState() == TrackingState.TRACKING) {
                f = 0.0f;
            } else if (plane.getTrackingState() == TrackingState.PAUSED) {
                f = 1.0f;
            } else if (plane.getTrackingState() == TrackingState.STOPPED) {
                f = 2.0f;
            }
            fArray2[16] = f;
            if (plane.getType() == Plane.Type.HORIZONTAL_UPWARD_FACING) {
                f2 = 0.0f;
            } else if (plane.getType() == Plane.Type.HORIZONTAL_DOWNWARD_FACING) {
                f2 = 1.0f;
            } else if (plane.getType() == Plane.Type.VERTICAL) {
                f2 = 2.0f;
            }
            fArray2[17] = f2;
            fArray2[18] = fArray[0];
            fArray2[19] = fArray[1];
            fArray2[20] = fArray[2];
            fArray2[21] = plane.getExtentX();
            fArray2[22] = 0.0f;
            fArray2[23] = plane.getExtentZ();
            dArray[n] = plane.hashCode();
            for (int i = 0; i < 24; ++i) {
                object2[i + n * 24] = fArray2[i];
            }
            ++n;
        }
        object = XEEngineHelper.get();
        if (object != null) {
            object.getARCore().updateAnchors((float[])object2, dArray);
        }
    }

    public void setCapture3DImageListener(Capture3DImageListener capture3DImageListener) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            Iterator<Face3DMaskFilter> iterator = this.face3DMaskFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next().setCapture3DImageListener(capture3DImageListener);
            }
        }
    }

    public void setCapture3DRenderImage(boolean isCapture, Rect rect) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            Iterator<Face3DMaskFilter> iterator = this.face3DMaskFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next().setCapture(isCapture, rect);
            }
        }
    }

    public List<Size> getViewPortSize() {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (Face3DMaskFilter face3DMaskFilter : this.face3DMaskFilters) {
                arrayList.add(face3DMaskFilter.getViewPortSize());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void setARCoreFrameListener(ARCoreFrameListener arCoreFrameListener) {
        void var1_1;
        this.mArCoreFrameListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setIntensity(float intensity) {
        if (this.mLookupFilter instanceof SingleLineGroupFilter) {
            void var1_1;
            this.mLookupFilter.setIntensity((float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEffectTimeInfoByHaniId(EffectTimeBean time, int haniId) {
        if (this.mMultiStickerMaskFilter != null) {
            void var2_2;
            void var1_1;
            this.mMultiStickerMaskFilter.setEffectTimeInfoByHaniId((EffectTimeBean)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changeDeviceOrientation(int orientation) {
        if (this.mSoundInput != null) {
            this.mSoundInput.resetClockDegrees();
            this.mSoundInput.rotateClockwise90Degrees(orientation / 90);
        }
        if (this.mMultiStickerMaskFilter != null) {
            void var1_1;
            this.mMultiStickerMaskFilter.setDeviceOrientation((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MMCVBoxes access$002(StickerAdjustFilter x0, MMCVBoxes x1) {
        void var1_1;
        x0.mmcvBoxes = var1_1;
        return x0.mmcvBoxes;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(StickerAdjustFilter x0, String x1) {
        void var1_1;
        x0.addGestureMaskModel((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(StickerAdjustFilter x0, SoundPool x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.updateSoundPoolLoadedStatus((SoundPool)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(StickerAdjustFilter x0, BasicFilter x1) {
        void var1_1;
        x0.removeEffectFilter((BasicFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(StickerAdjustFilter x0, Sticker x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.updateplayStatus((Sticker)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(StickerAdjustFilter x0, int x1, Runnable x2) {
        void var2_2;
        void var1_1;
        x0.setRunableCalledWhenLoaded((int)var1_1, (Runnable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1400(StickerAdjustFilter x0, Sticker x1) {
        void var1_1;
        x0.removeStickerFilter((Sticker)var1_1);
    }

    public static interface GestureDetectedListener {
        public void gestureDetected(String var1);

        public void onPreGestureAdded(String var1);
    }

    public static interface StickerMaskFinishListener {
        public void stickerRenderFinished(int var1, Sticker var2);
    }

    class SoundPoolInfo {
        int soundId = 0;
        boolean isLoaded = false;
        Runnable runnable = null;

        SoundPoolInfo() {
        }
    }
}

