/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.MMCVInfo;
import com.cosmos.mdlog.MDLog;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;

public class FaceSkinSmoothFilter
extends FaceDetectFilter {
    private edgePassFilterVersion edgePassFilterType_;
    private boolean bSkinDetect_ = false;
    private int winsize_ = 4;
    private int skinSmoothScaleHanle;
    private float skinSmoothScale = 0.0f;
    private int lowSkinThresholdHandle;
    private int highSkinThresholdHandle;
    private int defaultSkinThresholdHandle;
    private int[] lowSkinThreshold = new int[]{0, 0, 0};
    private int[] highSkinThreshold = new int[]{255, 255, 255};
    private int[] defaultSkinThreshold = new int[]{160, 120, 110};
    protected static final String UNIFORM_TEXELWIDTH = "texelWidthOffset";
    protected static final String UNIFORM_TEXELHEIGHT = "texelHeightOffset";
    protected float texelWidth;
    protected float texelHeight;
    protected int width;
    protected int height;
    private int texelWidthHandle;
    private int texelHeightHandle;

    public FaceSkinSmoothFilter() {
        this.init(edgePassFilterVersion.guidedFilter, 4, true);
    }

    /*
     * WARNING - void declaration
     */
    public FaceSkinSmoothFilter(edgePassFilterVersion skinSmoothType) {
        void var1_1;
        switch (1.$SwitchMap$com$momo$mcamera$mask$FaceSkinSmoothFilter$edgePassFilterVersion[var1_1.ordinal()]) {
            case 1: {
                this.init(edgePassFilterVersion.surfaceFilter, 3, true);
                return;
            }
            case 2: {
                this.init(edgePassFilterVersion.guidedFilter, 4, true);
                return;
            }
            case 3: {
                this.init(edgePassFilterVersion.transitionalGuidedFilter, 4, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void init(edgePassFilterVersion edgePassFilterType, int winsize, boolean bSkinDetect) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.winsize_ = var2_2;
        this.edgePassFilterType_ = var1_1;
        this.bSkinDetect_ = var3_3;
        this.lowSkinThreshold[0] = 0;
        this.lowSkinThreshold[1] = 0;
        this.lowSkinThreshold[2] = 0;
        this.highSkinThreshold[0] = 255;
        this.highSkinThreshold[1] = 255;
        this.highSkinThreshold[2] = 255;
    }

    /*
     * WARNING - void declaration
     */
    private String getSurfaceFilterFragmentShaderString(int winsize, boolean bSkin) {
        void var2_2;
        String string = "";
        for (int i = 0; i < winsize; ++i) {
            for (int j = 0; j < winsize; ++j) {
                string = string + "                tmpVec4 = texture2D(inputImageTexture0, vec2( textureCoordinate.x + (-float(" + Integer.toString(winsize) + ")  * 0.5 * xInc) + float(" + Integer.toString(i) + ") * xInc, textureCoordinate.y + (-float(" + Integer.toString(winsize) + ") * 0.5 * yInc) + float(" + Integer.toString(j) + ") * yInc));\n                w = 1. - abs(tmpVec4.xyz - sourceColorVec4.xyz)/(2.5*threshold);\n                if (w.x < 0.|| w.y < 0. || w.z < 0.) {\n                    w.x = 0.;\n                    w.y = 0.;\n                    w.z = 0.;\n                }\n                sumW = sumW +w;\n                sum = sum + w*tmpVec4.xyz;\n";
            }
        }
        String string2 = var2_2 != false ? "    float m_r = sourceColorVec4.r;\n    float m_g = sourceColorVec4.g;\n    float m_b = sourceColorVec4.b;\n    float m_max = max(m_r, max(m_g, m_b));\n    float m_min = min(m_r, min(m_g, m_b));\n    float r_low = lowSkinThreshold.x;\n    float g_low = lowSkinThreshold.y;\n    float b_low = lowSkinThreshold.z;\n    float r_high = highSkinThreshold.x;\n    float g_high = highSkinThreshold.y;\n    float b_high = highSkinThreshold.z;\n    if(!(r_low<=m_r &&  g_low<=m_g && b_low<=m_b ) ) {\n        gl_FragColor = sourceColorVec4 ;\n        return;\n    }\n" : "";
        return "    precision mediump float;\n    uniform sampler2D inputImageTexture0;\n    varying vec2 textureCoordinate;\n    uniform float parameter;\n    uniform vec3 lowSkinThreshold;\n    uniform vec3 highSkinThreshold;\n    uniform float texelWidthOffset; \n    uniform float texelHeightOffset; \n    vec4 a;\n    vec4 b;\n    void main() {\n        float minstep = 5.0;\n        float xInc = minstep * texelWidthOffset;\n        float yInc = minstep * texelHeightOffset;\n        vec4 tmpVec4;\n        mediump vec4 tmpMediump4;\n        mediump vec4 sourceColorVec4 = texture2D(inputImageTexture0,textureCoordinate);\n        if (parameter <0.001 ) {\n            gl_FragColor = sourceColorVec4;\n            return;\n        }\n        float threshold = parameter*20./255.;\n        vec3 sum = vec3(0.,0.,0.);\n        vec3 sumW = vec3(0.,0.,0.);\n        vec3 w;" + string2 + string + "        if (sumW.x == 0. || sumW.y == 0. || sumW.z == 0.){\n            gl_FragColor = sourceColorVec4;\n        }\n        else {\n            gl_FragColor.xyz = sum/sumW;\n            gl_FragColor.w = sourceColorVec4.w;\n        }\n    }\n";
    }

    /*
     * WARNING - void declaration
     */
    private String getGuidedFilterFragmentShaderString(int winsize, boolean bSkin) {
        void var2_2;
        void var1_1;
        String string = "";
        for (int i = 0; i < winsize; ++i) {
            for (int j = 0; j < winsize; ++j) {
                string = string + "         tmpVec4 = texture2D(inputImageTexture0, vec2( textureCoordinate.x + (-float(" + Integer.toString(winsize) + ") * 0.5 * xInc) + float(" + Integer.toString(i) + ") * xInc, textureCoordinate.y + (-float(" + Integer.toString(winsize) + ") * 0.5 * yInc) + float(" + Integer.toString(j) + ") * yInc));\n        meanI += tmpVec4;\n        meanII += tmpVec4 * tmpVec4;\n";
            }
        }
        string = string + "        meanI /= float(" + Integer.toString(winsize) + " * " + Integer.toString(winsize) + ");\n        meanII /= float(" + Integer.toString(winsize) + " * " + Integer.toString((int)var1_1) + ");\n";
        String string2 = var2_2 != false ? "mediump   float m_r = sourceColorVec4.r;\nmediump   float m_g = sourceColorVec4.g;\nmediump    float m_b = sourceColorVec4.b;\nmediump    float m_max = max(m_r, max(m_g, m_b));\nmediump    float m_min = min(m_r, min(m_g, m_b));\nmediump    float r_low = lowSkinThreshold.x;\nmediump    float g_low = lowSkinThreshold.y;\nmediump    float b_low = lowSkinThreshold.z;\nmediump    float r_high = highSkinThreshold.x;\nmediump    float g_high = highSkinThreshold.y;\nmediump    float b_high = highSkinThreshold.z;\n    if(!(r_low<=m_r  && g_low<=m_g &&  b_low<=m_b)) {\n        gl_FragColor = sourceColorVec4 ;\n        return;\n    }\n" : "";
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform mediump float parameter;\nuniform mediump vec3 lowSkinThreshold;\nuniform mediump vec3 highSkinThreshold;\nuniform float texelWidthOffset; \nuniform float texelHeightOffset; \nmediump float minstep = 3.5;\nvoid main() {\n    float xInc = minstep * texelWidthOffset;\n    float yInc = minstep * texelHeightOffset;\n    float epslone = 0.004*parameter*parameter;\n    vec4 eps = vec4(epslone, epslone, epslone, epslone);\n    vec4 meanI = vec4(0., 0., 0., 0.);\n    vec4 meanII = vec4(0., 0., 0., 0.);\n    vec4 tmpVec4;\n    mediump vec4 sourceColorVec4 = texture2D(inputImageTexture0,textureCoordinate);\n    if (parameter < 0.01 || epslone <=0.){\n         gl_FragColor = sourceColorVec4;\n         return;\n    }\n" + string2 + string + "    tmpVec4 = meanII - meanI * meanI;\n    vec4 temp2 = tmpVec4 + eps;\n    if (temp2.x <= 0. || temp2.y <= 0. || temp2.z <= 0. || temp2.x > 1.0 || temp2.y > 1.0 || temp2.z > 1.0 ){\n            gl_FragColor = sourceColorVec4 ;\n            return;\n    }\n    else {\n        vec4 a = tmpVec4 /temp2;\n        vec4 b = meanI - a * meanI;\n        gl_FragColor = a * sourceColorVec4 + b;\n        gl_FragColor.w = sourceColorVec4.w;\n        return;\n    }\n}\n";
    }

    /*
     * WARNING - void declaration
     */
    private String getTransitionalGuidedFilterFragmentShaderString(int winsize, boolean bSkin) {
        void var2_2;
        void var1_1;
        String string = "";
        for (int i = 0; i < winsize; ++i) {
            for (int j = 0; j < winsize; ++j) {
                string = string + "        tmpVec4 = texture2D(inputImageTexture0, vec2( textureCoordinate.x + (-float(" + Integer.toString(winsize) + ") * 0.5 * xInc) + float(" + Integer.toString(i) + ") * xInc, textureCoordinate.y + (-float(" + Integer.toString(winsize) + ") * 0.5 * yInc) + float(" + Integer.toString(j) + ") * yInc));\n        meanI += tmpVec4;\n        meanII += tmpVec4 * tmpVec4;\n";
            }
        }
        string = string + "        meanI /= float(" + Integer.toString(winsize) + " * " + Integer.toString(winsize) + ");\n        meanII /= float(" + Integer.toString(winsize) + " * " + Integer.toString((int)var1_1) + ");\n";
        String string2 = var2_2 != false ? "vec3 relation = vec3(1.0) + min((sourceColorVec4.xyz - skinDefaultRGB),vec3(0.0));\nrelation = vec3((relation.x+relation.y+relation.z)/3.0);\nrelation = 1./(1. + exp(24. - 30. * relation));\neps = vec4(epslone * relation, epslone);\nif (any(lessThan(eps, vec4(0.000001)))) {\n     gl_FragColor = sourceColorVec4;\n     return;\n}\n" : "";
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform mediump float parameter;\nuniform mediump vec3 lowSkinThreshold;\nuniform mediump vec3 highSkinThreshold;\nuniform float texelWidthOffset; \nuniform float texelHeightOffset; \nmediump float minstep = 3.5;\nuniform vec3 skinDefaultRGB;\nvoid main() {\n    float xInc = minstep * texelWidthOffset;\n    float yInc = minstep * texelHeightOffset;\n    float epslone = 0.004*parameter*parameter;\n    vec4 eps = vec4(epslone, epslone, epslone, epslone);\n    vec4 meanI = vec4(0., 0., 0., 0.);\n    vec4 meanII = vec4(0., 0., 0., 0.);\n    vec4 tmpVec4;\n    mediump vec4 sourceColorVec4 = texture2D(inputImageTexture0,textureCoordinate);\n    if (parameter < 0.01 || epslone <=0.){\n         gl_FragColor = sourceColorVec4;\n         return;\n    }\n" + string2 + string + "    tmpVec4 = meanII - meanI * meanI;\n    vec4 temp2 = tmpVec4 + eps;\n    if (temp2.x <= 0. || temp2.y <= 0. || temp2.z <= 0. || temp2.x > 1.0 || temp2.y > 1.0 || temp2.z > 1.0 ){\n            gl_FragColor = sourceColorVec4 ;\n            return;\n    }\n    else {\n        vec4 a = tmpVec4 /temp2;\n        vec4 b = meanI - a * meanI;\n        gl_FragColor = a * sourceColorVec4 + b;\n        gl_FragColor.w = sourceColorVec4.w;\n        return;\n    }\n}\n";
    }

    protected String getFragmentShader() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        switch (this.edgePassFilterType_) {
            case surfaceFilter: {
                FaceSkinSmoothFilter faceSkinSmoothFilter = this;
                return faceSkinSmoothFilter.getSurfaceFilterFragmentShaderString(faceSkinSmoothFilter.winsize_, this.bSkinDetect_);
            }
            case guidedFilter: {
                FaceSkinSmoothFilter faceSkinSmoothFilter = this;
                return faceSkinSmoothFilter.getGuidedFilterFragmentShaderString(faceSkinSmoothFilter.winsize_, this.bSkinDetect_);
            }
            case transitionalGuidedFilter: {
                FaceSkinSmoothFilter faceSkinSmoothFilter = this;
                return faceSkinSmoothFilter.getTransitionalGuidedFilterFragmentShaderString(faceSkinSmoothFilter.winsize_, this.bSkinDetect_);
            }
        }
        MDLog.e((String)"Beauty log", (String)"Parameters Error: Invalid filter type!");
        return "";
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.skinSmoothScaleHanle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"parameter");
        this.lowSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"lowSkinThreshold");
        this.highSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"highSkinThreshold");
        this.defaultSkinThresholdHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"skinDefaultRGB");
        this.texelWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELWIDTH);
        this.texelHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELHEIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setSkinSmoothScale(float scale) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            this.skinSmoothScale = var1_1;
            return;
        }
    }

    public float getSkinSmoothScale() {
        return this.skinSmoothScale;
    }

    protected void passShaderValues() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.texelWidth = 1.0f / (float)this.width;
        this.texelHeight = 1.0f / (float)this.height;
        super.passShaderValues();
        GLES20.glUniform1f((int)this.skinSmoothScaleHanle, (float)this.skinSmoothScale);
        GLES20.glUniform3f((int)this.lowSkinThresholdHandle, (float)((float)this.lowSkinThreshold[0] / 255.0f), (float)((float)this.lowSkinThreshold[1] / 255.0f), (float)((float)(this.lowSkinThreshold[2] - 10) / 255.0f));
        GLES20.glUniform3f((int)this.highSkinThresholdHandle, (float)((float)this.highSkinThreshold[0] / 255.0f), (float)((float)this.highSkinThreshold[1] / 255.0f), (float)((float)this.highSkinThreshold[2] / 255.0f));
        GLES20.glUniform3f((int)this.defaultSkinThresholdHandle, (float)((float)this.defaultSkinThreshold[0] / 255.0f), (float)((float)this.defaultSkinThreshold[1] / 255.0f), (float)((float)this.defaultSkinThreshold[2] / 255.0f));
        GLES20.glUniform1f((int)this.texelWidthHandle, (float)this.texelWidth);
        GLES20.glUniform1f((int)this.texelHeightHandle, (float)this.texelHeight);
    }

    public void drawSub() {
        super.drawSub();
    }

    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
    }

    protected void handleSizeChange() {
        super.handleSizeChange();
        this.texelWidth = 1.0f / (float)this.getWidth();
        this.texelHeight = 1.0f / (float)this.getHeight();
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = mmcvInfo.getFaceAttributeInfo(0);
        int[] nArray = object == null ? null : object.getSkinThreshold();
        object = nArray;
        if (nArray == null || ((FaceAttributeInfo)object).length < 9) {
            this.lowSkinThreshold[0] = 0;
            this.lowSkinThreshold[1] = 0;
            this.lowSkinThreshold[2] = 0;
            this.highSkinThreshold[0] = 255;
            this.highSkinThreshold[1] = 255;
            this.highSkinThreshold[2] = 255;
            this.defaultSkinThreshold[0] = 160;
            this.defaultSkinThreshold[1] = 120;
            this.defaultSkinThreshold[2] = 110;
            return;
        }
        this.lowSkinThreshold[0] = (int)object[0];
        this.lowSkinThreshold[1] = (int)object[1];
        this.lowSkinThreshold[2] = (int)object[2];
        this.highSkinThreshold[0] = (int)object[3];
        this.highSkinThreshold[1] = (int)object[4];
        this.highSkinThreshold[2] = (int)object[5];
        this.defaultSkinThreshold[0] = (int)object[6];
        this.defaultSkinThreshold[1] = (int)object[7];
        this.defaultSkinThreshold[2] = (int)object[8];
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
    }

    @Override
    public void resetSticker(Sticker sticker) {
    }

    public static enum edgePassFilterVersion {
        surfaceFilter,
        guidedFilter,
        transitionalGuidedFilter;

    }
}

