/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.skin.AIFaceTriangulation;
import com.momocv.mangaface.MangaFace;
import com.momocv.mangaface.MangaFaceInfo;
import com.momocv.mangaface.MangaFaceParams;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class FaceMaskFilter
extends FaceDetectFilter {
    private Sticker sticker;
    private MMFrameInfo curMMCVImage;
    private List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    private List<Map<Float, float[]>> mvpAngle = Collections.synchronizedList(new ArrayList());
    protected Object maskListLock = new Object();
    private boolean mStickerChanged = false;
    private List<Sticker> mStickersList = null;
    private int mCount = 0;
    private boolean mLastHasFace = false;
    protected FloatBuffer vertexBufer;
    protected final int vertexStride = 8;
    protected static final int COORDS_PER_VERTEX = 2;
    private Model model;

    /*
     * WARNING - void declaration
     */
    public FaceMaskFilter(Sticker sticker) {
        void var1_1;
        this.sticker = sticker;
        this.model = new Model();
        this.curMMCVImage = new MMFrameInfo();
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.curMMCVImage, (String)sticker.getMask().getTexturePath());
        this.model.data = this.curMMCVImage.getDataPtr();
        this.model.texCoords = sticker.getMask().landmarks;
        this.model.comic = var1_1.isComic();
    }

    protected String getFragmentShader() {
        return super.getFragmentShader();
    }

    protected String getVertexShader() {
        return super.getVertexShader();
    }

    protected void passShaderValues() {
        super.passShaderValues();
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
    }

    private void drawFace(float[] face_points, float[] angle) {
        Object object;
        float[] fArray;
        int n;
        if (this.model.comic) {
            n = AIFaceTriangulation.CXFaceTriangulationIndexesWithCornerPoint.length;
            MangaFace mangaFace = new MangaFace();
            MangaFaceParams mangaFaceParams = new MangaFaceParams();
            new MangaFaceParams().euler_angles_ = fArray;
            mangaFaceParams.image_height_ = this.getHeight();
            mangaFaceParams.image_width_ = this.getWidth();
            mangaFaceParams.landmarks96_ = (float[])object;
            if (this.sticker.getImageHeight() == 0 || this.sticker.getImageWidth() == 0) {
                mangaFaceParams.manga_height_ = 640;
                mangaFaceParams.manga_width_ = 480;
            } else {
                mangaFaceParams.manga_height_ = this.sticker.getImageHeight();
                mangaFaceParams.manga_width_ = this.sticker.getImageWidth();
            }
            mangaFaceParams.manga_landmarks_ = this.model.texCoords;
            object = new MangaFaceInfo();
            mangaFace.manga_face(mangaFaceParams, (MangaFaceInfo)object);
            object = AIFaceTriangulation.getFaceTriangulationWithCornerPoint(object.landmarks96_plus4_pts_, this.model.texCoords);
            fArray = object[0];
            object = object[2];
        } else {
            n = AIFaceTriangulation.CXFaceTriangulationIndexes.length;
            object = AIFaceTriangulation.getFaceTriangulation((float[])object, this.getWidth(), this.getHeight(), this.model.texCoords);
            fArray = object[0];
            object = object[2];
        }
        this.setRenderVertices(fArray);
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(((float[][])object).length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.vertexBufer.rewind();
        this.vertexBufer.put((float[])object);
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glDrawArrays((int)4, (int)0, (int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            if (this.model.comic) {
                for (int i = 0; i < this.mvpAngle.size(); ++i) {
                    super.passShaderValues();
                    for (float[] fArray : this.mvpAngle.get(i).keySet()) {
                        float[] fArray2 = this.mvpAngle.get(i).get(fArray);
                        this.drawFace(fArray2, fArray);
                    }
                }
            } else {
                for (float[] fArray : this.mvpLists) {
                    super.passShaderValues();
                    this.drawFace(fArray, null);
                }
            }
        }
        this.disableDrawArray();
        this.clearPoints();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        if (this.mvpLists != null && this.mvpAngle != null) {
            void var1_1;
            this.mvpLists.add(detectParam.warpedPoints104 == null ? detectParam.points104 : detectParam.warpedPoints104);
            HashMap<float[], float[]> hashMap = new HashMap<float[], float[]>();
            hashMap.put(detectParam.euler_angles, var1_1.points96);
            this.mvpAngle.add(hashMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        if (mmcvInfo == null || this.texture_in == 0) {
            return;
        }
        if (mmcvInfo.getMaxFaceCnt() <= 0 && this.mLastHasFace && this.mStickersList != null && this.mStickersList.size() > 0) {
            ++this.mCount;
            this.mCount %= this.mStickersList.size();
            FaceMaskFilter faceMaskFilter = this;
            faceMaskFilter.resetSticker(faceMaskFilter.mStickersList.get(this.mCount));
            this.mLastHasFace = false;
        }
        if (var1_1.getMaxFaceCnt() > 0) {
            this.mLastHasFace = true;
        }
    }

    @Override
    public void clearPoints() {
        if (this.mvpLists != null) {
            this.mvpLists.clear();
        }
        if (this.mvpAngle != null) {
            this.mvpAngle.clear();
        }
    }

    @Override
    public void cancelDraw() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void resetSticker(Sticker sticker) {
        void var1_1;
        if (this.model != null || this.curMMCVImage != null) {
            this.model = null;
            this.curMMCVImage = null;
        }
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
        this.sticker = sticker;
        this.model = new Model();
        this.curMMCVImage = new MMFrameInfo();
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.curMMCVImage, (String)sticker.getMask().getTexturePath());
        this.model.data = this.curMMCVImage.getDataPtr();
        this.model.texCoords = sticker.getMask().landmarks;
        this.model.comic = var1_1.isComic();
        this.mStickerChanged = false;
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var2_2;
        if (newData) {
            this.markAsDirty();
        }
        if (this.texture_in == 0 || !this.mStickerChanged) {
            this.texture_in = TextureHelper.bitmapToTexture((MMFrameInfo)this.curMMCVImage);
            this.mStickerChanged = true;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        var2_2.unlockRenderBuffer();
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
        if (this.curMMCVImage != null) {
            this.curMMCVImage = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addStickerList(List<Sticker> stickersList) {
        void var1_1;
        this.mStickersList = var1_1;
    }

    class Model {
        float[] texCoords;
        byte[] data;
        boolean comic;

        private Model() {
        }
    }
}

