/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.facewarp;

import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.FaceDetector;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.facewarp.IFaceWarp;
import com.momocv.SingleFaceInfo;
import com.momocv.beauty.BeautyWarpInfo;
import com.momocv.beauty.BeautyWarpParams;
import com.momocv.videoprocessor.FaceAttribute;
import com.momocv.videoprocessor.VideoInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import project.android.imageprocessing.GLFrameBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public abstract class BaseFaceWarpFilter
extends BasicFilter
implements FaceDetectInterface,
IFaceWarp {
    private FloatBuffer vertexBuffer;
    private FloatBuffer texCoordBuffer;
    private GLFrameBuffer warpFrameBuffer;
    private int maxFaces = Integer.MAX_VALUE;
    protected BeautyWarpParams warpParams = new BeautyWarpParams();
    protected BeautyWarpInfo warpInfo = new BeautyWarpInfo();
    protected MMCVInfo mmcvInfo;
    protected WarpPoint warpPoint = new WarpPoint();
    protected int warpType = this.getDefaultWarpType();

    /*
     * WARNING - void declaration
     */
    public void setMaxFaces(int maxCount) {
        void var1_1;
        this.maxFaces = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWarpType(int warpType) {
        void var1_1;
        this.warpType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleFactor(float scaleFactor) {
        void var1_1;
        this.warpParams.scale_factor_ = var1_1;
    }

    protected void clearPoints() {
        this.warpPoint.srcPoints = null;
        this.warpPoint.dstPoints = null;
    }

    public void destroy() {
        super.destroy();
        FaceDetector.getInstance().releaseBeautyProcessor();
    }

    public void drawSub() {
        if (this.notWarp()) {
            super.drawSub();
            return;
        }
        if (this.maxFaces > 1) {
            this.drawMultiFace();
            return;
        }
        this.drawSingleFace();
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.warpFrameBuffer != null) {
            this.warpFrameBuffer.destoryBuffer();
            this.warpFrameBuffer = null;
        }
    }

    private void drawSingleFace() {
        SingleFaceInfo singleFaceInfo = this.mmcvInfo.getVideoInfo().facesinfo_[0];
        FaceAttribute faceAttribute = this.mmcvInfo.getVideoInfo().faces_attributes_[0];
        WarpPoint warpPoint = this.processSingleWarpPoint(singleFaceInfo);
        if (warpPoint != null && warpPoint.srcPoints != null && warpPoint.dstPoints != null) {
            BaseFaceWarpFilter baseFaceWarpFilter = this;
            baseFaceWarpFilter.drawWarpSub(baseFaceWarpFilter.texture_in, warpPoint);
            this.clearPoints();
            this.setLandmarks(singleFaceInfo, faceAttribute);
            return;
        }
        super.drawSub();
    }

    private void setLandmarks(SingleFaceInfo faceInfo, FaceAttribute faceAttribute) {
        if (this.warpInfo.warped_landmarks68_ != null && this.warpInfo.warped_landmarks96_ != null && this.warpInfo.warped_landmarks104_ != null) {
            faceInfo.landmarks_68_ = this.warpInfo.warped_landmarks68_[0];
            faceInfo.landmarks_96_ = this.warpInfo.warped_landmarks96_[0];
            var1_1.landmarks_104_ = this.warpInfo.warped_landmarks104_[0];
            faceAttribute.warped_landmarks68_ = this.warpInfo.warped_landmarks68_[0];
            faceAttribute.warped_landmarks96_ = this.warpInfo.warped_landmarks96_[0];
            var2_2.warped_landmarks104_ = this.warpInfo.warped_landmarks104_[0];
        }
    }

    private void drawMultiFace() {
        int n = 0;
        int n2 = this.mmcvInfo.getMaxFaceCnt();
        VideoInfo videoInfo = this.mmcvInfo.getVideoInfo();
        for (int i = 0; i < n2; ++i) {
            SingleFaceInfo singleFaceInfo = videoInfo.facesinfo_[i];
            FaceAttribute faceAttribute = videoInfo.faces_attributes_[i];
            WarpPoint warpPoint = this.processSingleWarpPoint(singleFaceInfo);
            if (warpPoint == null || warpPoint.srcPoints == null || warpPoint.dstPoints == null) continue;
            int n3 = n == 0 ? this.texture_in : this.getTextOutID();
            this.drawWarpFrame(n3, warpPoint);
            BaseFaceWarpFilter baseFaceWarpFilter = this;
            baseFaceWarpFilter.copyToFrameBuffer(baseFaceWarpFilter.warpFrameBuffer.getTexture_out()[0]);
            ++n;
            this.clearPoints();
            this.setLandmarks(singleFaceInfo, faceAttribute);
        }
        if (n == 0) {
            super.drawSub();
        }
    }

    private void initWarpFBO() {
        if (this.warpFrameBuffer != null) {
            this.warpFrameBuffer.destoryBuffer();
        }
        this.warpFrameBuffer = new GLFrameBuffer(this.getWidth(), this.getHeight());
        this.warpFrameBuffer.activityFrameBuffer(this.getWidth(), this.getHeight());
        int n = GLES20.glCheckFramebufferStatus((int)36160);
        if (n != 36053) {
            throw new RuntimeException(this.toString() + ": Failed to set up render buffer with status " + n + " and error " + GLES20.glGetError());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawWarpFrame(int textureIn, WarpPoint warpPoint) {
        void var2_2;
        void var1_1;
        if (this.warpFrameBuffer == null || this.warpFrameBuffer.getFrameBuffer() == null) {
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.initWarpFBO();
            } else {
                return;
            }
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.warpFrameBuffer.getFrameBuffer()[0]);
        this.drawWarpSub((int)var1_1, (WarpPoint)var2_2);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private void drawWarpSub(int textureIn, WarpPoint warpPoint) {
        void var1_1;
        float[] fArray;
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glUseProgram((int)this.programHandle);
        float[] fArray2 = warpPoint.srcPoints;
        fArray = fArray.dstPoints;
        int n = fArray.dstPoints.length / 2;
        if (this.vertexBuffer == null || this.vertexBuffer.capacity() != fArray.length << 2) {
            this.vertexBuffer = ByteBuffer.allocateDirect(fArray.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer().put(fArray);
        }
        this.vertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        if (this.texCoordBuffer == null || this.texCoordBuffer.capacity() != fArray2.length << 2) {
            this.texCoordBuffer = ByteBuffer.allocateDirect(fArray2.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer().put(fArray2);
        }
        this.texCoordBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.texCoordBuffer);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)var1_1);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)4, (int)0, (int)n);
        this.disableDrawArray();
    }

    /*
     * WARNING - void declaration
     */
    private void copyToFrameBuffer(int textureIn) {
        void var1_1;
        GLES20.glBindFramebuffer((int)36160, (int)this.glFrameBuffer.getFrameBuffer()[0]);
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        GLES20.glUseProgram((int)this.programHandle);
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)var1_1);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.disableDrawArray();
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    /*
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        this.mmcvInfo = var1_1;
    }

    protected abstract int getDefaultWarpType();

    protected abstract boolean notWarp();

    protected abstract BeautyWarpParams buildParams(MMCVInfo var1, SingleFaceInfo var2);

    protected WarpPoint processSingleWarpPoint(SingleFaceInfo faceInfo) {
        BeautyWarpParams beautyWarpParams;
        BaseFaceWarpFilter baseFaceWarpFilter = this;
        beautyWarpParams = baseFaceWarpFilter.buildParams(baseFaceWarpFilter.mmcvInfo, (SingleFaceInfo)beautyWarpParams);
        if (FaceDetector.getInstance().getWarpKeyPoints(beautyWarpParams, this.warpInfo)) {
            this.warpPoint.srcPoints = this.warpInfo.src_warp_points_;
            this.warpPoint.dstPoints = this.warpInfo.dst_warp_points_;
        }
        return this.warpPoint;
    }

    static class WarpPoint {
        float[] srcPoints;
        float[] dstPoints;

        WarpPoint() {
        }

        public boolean equals(Object o) {
            WarpPoint warpPoint;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            warpPoint = warpPoint;
            return Arrays.equals(this.srcPoints, warpPoint.srcPoints) && Arrays.equals(this.dstPoints, warpPoint.dstPoints);
        }

        public int hashCode() {
            return Arrays.hashCode(this.srcPoints) * 31 + Arrays.hashCode(this.dstPoints);
        }
    }
}

