/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.express;

import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.cv.MMParamsInfo;
import com.core.glcore.util.XEEngineHelper;
import com.immomo.medialog.MediaStatisticModel;
import com.momo.mcamera.mask.detect.IPatternDetect;
import com.momo.xeengine.cv.bean.CVExpressInfo;
import com.momocv.express.Express;
import com.momocv.express.ExpressInfo;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExpressDetector
implements IPatternDetect {
    private String expressModelPath;
    private ByteBuffer curByteBuffer;
    private Object waitSignal;
    private Object startSync;
    private boolean running;
    private AtomicBoolean isDetecting;
    private ExpressThread detectThread;
    private MMFrameInfo mmFrame = new MMFrameInfo();
    private MMParamsInfo paramsInfo = new MMParamsInfo(6);
    private ExpressInfo expressInfo = new ExpressInfo();
    private Express express;

    public ExpressDetector() {
        this.waitSignal = new Object();
        this.startSync = new Object();
        this.isDetecting = new AtomicBoolean(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setModelPath(String path) {
        void var1_1;
        this.expressModelPath = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDetect() {
        Object object = this.startSync;
        synchronized (object) {
            if (this.detectThread == null) {
                this.running = true;
                this.detectThread = new ExpressThread("ExpressDetect");
                this.detectThread.start();
            }
            return;
        }
    }

    @Override
    public void detect() {
        this.isDetecting.set(true);
        long l = SystemClock.elapsedRealtime();
        if (this.express == null && !TextUtils.isEmpty((CharSequence)this.expressModelPath)) {
            this.express = new Express();
            this.express.LoadModel(this.expressModelPath);
        }
        if (this.express != null) {
            Object[] objectArray = this.curByteBuffer.array();
            this.mmFrame.setDataPtr(objectArray);
            this.mmFrame.setDataLen(objectArray.length);
            this.express.ProcessFrame(this.mmFrame.getFrame(), this.paramsInfo.getExpressParams(), this.expressInfo);
            if (this.expressInfo.express_infos_ != null && this.expressInfo.express_infos_.length > 0 && MediaModuleGlobalConfig.hasXE()) {
                ArrayList<CVExpressInfo> arrayList = new ArrayList<CVExpressInfo>();
                objectArray = this.expressInfo.express_infos_;
                int n = this.expressInfo.express_infos_.length;
                for (int i = 0; i < n; ++i) {
                    byte by = objectArray[i];
                    CVExpressInfo cVExpressInfo = new CVExpressInfo();
                    cVExpressInfo.setHead(by.head_);
                    cVExpressInfo.setLeftEye(by.lefteye_);
                    cVExpressInfo.setRightEye(by.righteye_);
                    cVExpressInfo.setMouth(by.mouth_);
                    cVExpressInfo.setNeck(by.neck_);
                    arrayList.add(cVExpressInfo);
                }
                XEEngineHelper.setExpressionInfos(arrayList);
            }
        }
        long l2 = SystemClock.elapsedRealtime() - l;
        MediaStatisticModel.getInstance().setExpressDetect(l2);
        SystemClock.sleep((long)200L);
        this.isDetecting.set(false);
    }

    @Override
    public void stopDetect() {
        this.running = false;
        if (this.curByteBuffer != null) {
            this.curByteBuffer.clear();
        }
        if (this.detectThread != null) {
            try {
                this.detectThread.interrupt();
            }
            catch (Exception exception) {}
            this.detectThread = null;
        }
        if (this.express != null) {
            this.express.Release();
            this.express = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object;
        if (this.isDetecting.get()) {
            return;
        }
        this.mmFrame.setFormat(17);
        this.mmFrame.setWidth(mmcvInfo.width);
        this.mmFrame.setHeight(mmcvInfo.height);
        this.mmFrame.setStep_(mmcvInfo.width);
        this.curByteBuffer = ByteBuffer.wrap(mmcvInfo.frameData);
        this.paramsInfo.setFlipedShow(mmcvInfo.isFrontCamera);
        this.paramsInfo.setRotateDegree(mmcvInfo.cameraDegree);
        this.paramsInfo.setRestoreDegree(mmcvInfo.restoreDegree);
        this.paramsInfo.setOriginFaceRects(mmcvInfo.getOriginFaceRects());
        this.paramsInfo.setOriginLandmarks96(object.getOriginLandmarks96());
        object = this.waitSignal;
        synchronized (object) {
            this.waitSignal.notify();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(ExpressDetector x0, boolean x1) {
        void var1_1;
        x0.running = var1_1;
        return x0.running;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ByteBuffer access$202(ExpressDetector x0, ByteBuffer x1) {
        void var1_1;
        x0.curByteBuffer = var1_1;
        return x0.curByteBuffer;
    }

    class ExpressThread
    extends Thread {
        /*
         * WARNING - void declaration
         */
        public ExpressThread(@NonNull String name) {
            void var2_2;
            super((String)var2_2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            ExpressDetector.access$002(ExpressDetector.this, true);
            try {
                Object object = ExpressDetector.this.waitSignal;
                synchronized (object) {
                    while (ExpressDetector.this.running) {
                        ExpressDetector.this.waitSignal.wait();
                        ExpressDetector.this.detect();
                    }
                }
                ExpressDetector.this.curByteBuffer.clear();
                ExpressDetector.access$202(ExpressDetector.this, null);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }
}

