/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.text.TextUtils;
import com.core.glcore.cv.MMFrameInfo;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.MmcvImageCacheLoader;
import com.momo.mcamera.mask.MmcvImageLoader;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.EffectTimeBean;

public class StickerItem {
    private final int STICKER_MMTIME_PER_FRAME = 50;
    public Sticker sticker;
    public float stickerScale;
    public FloatBuffer vertexBuffer;
    public float[] texData0;
    public final float[] mViewMatrix = new float[16];
    protected float[] mProjectionMatrix;
    protected boolean needUpdateSticker = false;
    public float imageWidth = 0.0f;
    public float imageHeight = 0.0f;
    public long mStickerDuration = -1L;
    public Object maskLock = new Object();
    protected Context context;
    long mRenderTime = -1L;
    public FloatBuffer fvertexBuffer;
    public FloatBuffer vertexBuffer2;
    public Object maskListLock = new Object();
    public List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    public boolean isDraw = false;
    private boolean lastShouldShow = true;
    private boolean hasShowed = false;
    private boolean isPlaying;
    public boolean isTriggered = false;
    private int hiddenFrameCount;
    private boolean isHiddenFrame;
    long startTime = -1L;
    public StickerBlendFilter.StickerMaskFinishListener finishListener;
    StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener;
    public MMFrameInfo mmcvImage;
    protected MmcvImageLoader mmcvImageLoader;
    public int texture_sticker = 0;
    private boolean hasShowedThisTrigger;
    private boolean needPlayLoop = true;
    private EffectTimeBean mEffectTimeBean = null;
    private long lastRenderTime = 0L;

    /*
     * WARNING - void declaration
     */
    public StickerItem(Sticker inSticker, Context context) {
        void var2_2;
        void var1_1;
        this.sticker = var1_1;
        this.context = var2_2;
        this.initCoordinate();
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    public void initCoordinate() {
        this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        float[] fArray = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(fArray);
        this.vertexBuffer.position(0);
        byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer2 = byteBuffer.asFloatBuffer();
        this.vertexBuffer2.put(fArray);
        this.vertexBuffer2.position(0);
        this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
        this.mmcvImageLoader = this.getMMcvImageLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setDetectParam(FaceDetectFilter.FaceDetectParam param) {
        boolean bl = true;
        if (param.filterTrigerManager != null) {
            bl = param.filterTrigerManager.triggerTypeProcess(this.sticker, this.stickerStateChangeListener);
        }
        if (!(!bl || TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType()) && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            bl = param.filterTrigerManager.objectTriggerTypeProcess(this.sticker, param, this.isTriggered);
        }
        boolean bl2 = bl;
        if (!(this.sticker.getMinHiddenFrameCount() <= 0 || this.sticker.getHiddenTriggerType() <= 0 && TextUtils.isEmpty((CharSequence)this.sticker.getHiddenObjectTriggerType()))) {
            if (!bl2 && this.lastShouldShow) {
                this.isHiddenFrame = true;
            }
            if (this.sticker.isNotResetOnHide() && !bl2 && this.hiddenFrameCount > 0) {
                this.hiddenFrameCount = 0;
            }
            if (this.isHiddenFrame) {
                if (this.sticker.getMinHiddenFrameCount() > 0 && this.hiddenFrameCount >= this.sticker.getMinHiddenFrameCount() + 2) {
                    this.hiddenFrameCount = 0;
                    this.isHiddenFrame = false;
                }
                if (this.isHiddenFrame) {
                    bl2 = false;
                    if (this.checkUpdateHidenFrameCnt()) {
                        ++this.hiddenFrameCount;
                    }
                }
            }
        }
        if (this.hasShowedThisTrigger && (this.sticker.isNotHiddenAfterTrigger() || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
            bl2 = true;
        }
        if (this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.getLoopStart() == -1) {
            this.needPlayLoop = false;
        }
        if (bl2) {
            if (bl && this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1) {
                this.sticker.curIndex = 0;
            }
            if (!this.needPlayLoop) {
                return;
            }
            this.startPlay();
            this.hasShowed = true;
            this.lastShouldShow = true;
            this.isHiddenFrame = false;
        } else {
            if (this.sticker.isNotHiddenAfterTrigger()) {
                this.lastShouldShow = bl2;
            }
            if (this.sticker.isNotHiddenAfterTrigger() && this.sticker.curIndex == this.sticker.getFrameNumber() - 1 && this.sticker.curIndex > 0) {
                bl2 = true;
                this.sticker.curIndex = 0;
                this.resumeDisplay();
            } else if (this.sticker.isNoBreakLoop() && this.sticker.curIndex < this.sticker.getFrameNumber() - 1 && this.hasShowed && this.sticker.curIndex > 0 && this.needPlayLoop) {
                bl2 = true;
                this.resumeDisplay();
            } else {
                if (!(this.sticker.curIndex != this.sticker.getFrameNumber() - 1 || this.sticker.getLoopStart() > 0 && this.sticker.isAlwaysShow())) {
                    this.sticker.curIndex = 0;
                }
                this.stopPlay();
            }
        }
        if (bl2) {
            this.hasShowedThisTrigger = true;
        }
        if (this.stickerStateChangeListener != null && !TextUtils.isEmpty((CharSequence)this.sticker.getObjectTriggerType())) {
            this.stickerStateChangeListener.stickerGestureTypeChanged(this.sticker.getObjectTriggerType(), bl2);
        }
        if (this.mStickerDuration > -1L && this.startTime != -1L && System.currentTimeMillis() - this.startTime > this.mStickerDuration) {
            this.clearPoints();
            if (this.finishListener != null) {
                this.finishListener.stickerRenderFinished();
            }
            return;
        }
        Object object = this.maskLock;
        synchronized (object) {
            void var1_1;
            this.setParamForMatrix(param.scaleW, param.scaleH, param.centerPoint, var1_1.angle);
            this.isDraw = bl2;
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public Object getLockObject() {
        return this.maskLock;
    }

    /*
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle) {
        void var2_3;
        void var1_1;
        void var3_4;
        if (centerPoint == null) {
            return;
        }
        float f = -(centerPoint.x * 2.0f - 1.0f);
        float f2 = -var3_4.y * 2.0f + 1.0f;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_3, (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[8];
        float[] fArray4 = fArray3;
        fArray3[0] = fArray2[0];
        fArray4[1] = fArray2[1];
        fArray4[2] = fArray2[4];
        fArray4[3] = fArray2[5];
        fArray4[4] = fArray2[8];
        fArray4[5] = fArray2[9];
        fArray4[6] = fArray2[12];
        fArray4[7] = fArray2[13];
        this.mvpLists.add(fArray4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        Object object = this.maskLock;
        synchronized (object) {
            if (this.mvpLists != null) {
                this.mvpLists.clear();
            }
            return;
        }
    }

    public void startPlay() {
        if (this.sticker.isNotResetOnHide() && this.sticker.curIndex == 0 && this.hasShowed) {
            this.sticker.curIndex = this.sticker.getLoopStart();
        }
        if (!this.isPlaying) {
            if (this.stickerStateChangeListener != null && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), true);
            }
            this.isPlaying = true;
        }
        this.isPlaying = true;
    }

    private void resumeDisplay() {
        this.startPlay();
    }

    public void stopPlay() {
        if (this.isPlaying) {
            if (this.stickerStateChangeListener != null && this.sticker.getSoundId() > 0) {
                this.stickerStateChangeListener.playStateChanged(this.sticker.getSoundId(), false);
            }
            this.isPlaying = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFinishListener(StickerBlendFilter.StickerMaskFinishListener finishListener) {
        void var1_1;
        this.finishListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setProjectionMatrix(float[] matrix) {
        void var1_1;
        this.mProjectionMatrix = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MMFrameInfo getMmcvImage(Context context) {
        void var1_1;
        return this.mmcvImageLoader.getMmcvImage((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setStickerStateChangeListener(StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        void var1_1;
        this.stickerStateChangeListener = var1_1;
    }

    public float getStickerAspectRatio() {
        if (this.sticker != null) {
            return (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        }
        return 1.0f;
    }

    public Bitmap getBitmap() {
        return this.mmcvImageLoader.getDelegateBitmap();
    }

    public long getEscapedTime() {
        if (System.currentTimeMillis() - this.startTime >= this.mStickerDuration) {
            return this.mStickerDuration;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    private boolean checkUpdateHidenFrameCnt() {
        if (this.mRenderTime - this.lastRenderTime > 50L) {
            this.lastRenderTime = this.mRenderTime;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderTime(long mRenderTime) {
        this.mRenderTime = mRenderTime;
        if (this.mmcvImageLoader != null) {
            void var1_1;
            this.mmcvImageLoader.setRenderTime((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentTime(long currentTime) {
        if (this.mmcvImageLoader != null) {
            void var1_1;
            this.mmcvImageLoader.setCurrentTime((long)var1_1);
        }
    }

    protected MmcvImageLoader getMMcvImageLoader() {
        if (this.sticker.isUseImageCache()) {
            return new MmcvImageCacheLoader(this.sticker, this.context);
        }
        return new MmcvImageLoader(this.sticker);
    }

    public void destroy() {
        if (this.texture_sticker != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_sticker;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_sticker = 0;
        }
    }

    public void releaseFrameBuffer() {
        if (this.texture_sticker != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_sticker;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_sticker = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setNeedUpdate(boolean needUpdate) {
        void var1_1;
        this.needUpdateSticker = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEffectTimeInfo(EffectTimeBean time) {
        void var1_1;
        this.mEffectTimeBean = var1_1;
    }

    public EffectTimeBean getEffectTimeBean() {
        return this.mEffectTimeBean;
    }
}

