/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.MultiStickerMaskFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerFixItem;
import com.momo.mcamera.mask.StickerGameEngine;
import com.momo.mcamera.mask.StickerGameItem;
import com.momo.mcamera.mask.StickerItem;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.delegate.GameScoreListener;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class MultiStickerGameMaskFilter
extends MultiStickerMaskFilter {
    StickerGameEngine mStickerGameEngine = new StickerGameEngine();
    public static final int POINTS_LENGTH = 68;
    private static int INDEX_MOUSE_LEFT = 48;
    private static int INDEX_MOUSE_RIGHT = 54;
    private static int INDEX_MOUSE_UPTOP = 51;
    private static int INDEX_MOUSE_DOWNBOTTOM = 57;
    private boolean isMouthOpen;
    private boolean lastOpenState;
    private int triggerRegionOffset = 0;
    private long curTimeStamp = 0L;
    private boolean isGameOver = false;

    /*
     * WARNING - void declaration
     */
    public MultiStickerGameMaskFilter(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addSticker(StickerItem item) {
        super.addSticker(item);
        if (item != null && item instanceof StickerGameItem) {
            void var1_1;
            this.mStickerGameEngine.addSticker((StickerGameItem)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setTimeStamp(long ms) {
        void var1_1;
        super.setTimeStamp(ms);
        this.curTimeStamp = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setGameScoreListener(GameScoreListener listener) {
        void var1_1;
        this.mStickerGameEngine.setGameScoreListener((GameScoreListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        void var1_1;
        super.setMMCVInfo(mmcvInfo);
        this.updateFaceStatus((MMCVInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.mStickerGameEngine != null) {
            this.mStickerGameEngine.setImageHeight(this.getHeight());
            this.mStickerGameEngine.setImageWidth(this.getWidth());
            this.mStickerGameEngine.setSrcImageWidthScaleRatio(this.scaleWidthRatio);
            this.mStickerGameEngine.setSrcImageHeightScaleRatio(this.scaleHeightRatio);
        }
        if (this.mStickerGameEngine != null) {
            this.mStickerGameEngine.setTimeStamp(this.curTimeStamp);
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    private void updateFaceStatus(MMCVInfo info) {
        if (this.filterTriggerManager != null) {
            boolean bl = this.isMouthOpen = this.filterTriggerManager.mouseOpenState == 0;
            if (!this.isMouthOpen && this.lastOpenState && info.getMaxFaceCnt() > 0) {
                float f;
                float[] fArray;
                fArray = fArray.getFaceAttributeInfo(0).getLandmarks68();
                float f2 = fArray[INDEX_MOUSE_UPTOP + 68] - (float)this.triggerRegionOffset;
                float f3 = fArray[INDEX_MOUSE_LEFT] - (float)this.triggerRegionOffset;
                float f4 = fArray[INDEX_MOUSE_RIGHT] + (float)this.triggerRegionOffset;
                float f5 = fArray[INDEX_MOUSE_DOWNBOTTOM + 68] + (float)this.triggerRegionOffset;
                float f6 = Math.abs(f3 - f4);
                float f7 = Math.abs(f2 - f5);
                if (f < f6) {
                    f6 = (f6 - f7) / 2.0f;
                    f2 -= f6;
                    f5 += f6;
                } else {
                    f6 = (f7 - f6) / 2.0f;
                    f3 -= f6;
                    f4 += f6;
                }
                if (this.mStickerGameEngine != null && !this.isGameOver) {
                    this.mStickerGameEngine.updateTriggerStatus(f3, f2, f4, f5);
                }
            }
            this.lastOpenState = this.isMouthOpen;
        }
    }

    public void playingTailMoving() {
        this.isGameOver = true;
        for (StickerItem stickerItem : this.stickerItemList) {
            ((StickerItem)var1_1.next()).isDraw = false;
            stickerItem.isTriggered = true;
            if (stickerItem.sticker.getObjectTriggerType() == null || !stickerItem.sticker.getObjectTriggerType().equals("game_over")) continue;
            stickerItem.startPlay();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initGameFixStickerItem(Bitmap scoreBitmap, Bitmap iconBitmap, int width, int height) {
        void var1_1;
        void var3_5;
        void var2_2;
        int n = scoreBitmap.getWidth() - iconBitmap.getWidth();
        Object object = new Sticker();
        ((Sticker)object).setDuration(99999999999L);
        ((Sticker)object).setFrameRate(20);
        ((Sticker)object).setType(5);
        ((Sticker)object).setStickerType("STICKER_TYPE_GAME_FIX_TYPE");
        ((Sticker)object).setLayerType("default");
        ((Sticker)object).setAlwaysShow(true);
        ((Sticker)object).setObjectTriggerType("");
        ((Sticker)object).setImageWidth(iconBitmap.getWidth());
        ((Sticker)object).setImageHeight(iconBitmap.getHeight());
        AbsolutePosition absolutePosition = new AbsolutePosition();
        ObjectRegion objectRegion = new ObjectRegion();
        iconBitmap.getWidth();
        iconBitmap.getHeight();
        float f = n > 0 ? (float)(iconBitmap.getWidth() / 2 + n) / (float)width : (float)(iconBitmap.getWidth() / 2) / (float)width;
        float f2 = (float)(iconBitmap.getHeight() / 2) / (float)height;
        objectRegion.x = 1.0f - f - 0.05f;
        objectRegion.y = f2 + 0.05f;
        objectRegion.w = width;
        objectRegion.h = height;
        absolutePosition.setCenter(objectRegion);
        ((Sticker)object).setAbsolutePos(absolutePosition);
        object = new StickerFixItem((Sticker)object, null);
        ((StickerFixItem)object).setBitmap(iconBitmap);
        ((StickerFixItem)object).sticker.setImageWidth(iconBitmap.getWidth());
        ((StickerFixItem)object).sticker.setImageHeight(iconBitmap.getHeight());
        ((StickerFixItem)object).fixStickerType = "FIX_STICKER_TYPE_ICON";
        super.addSticker((StickerItem)object);
        object = new Sticker();
        ((Sticker)object).setDuration(99999999999L);
        ((Sticker)object).setFrameRate(20);
        ((Sticker)object).setType(5);
        ((Sticker)object).setStickerType("STICKER_TYPE_GAME_FIX_TYPE");
        ((Sticker)object).setLayerType("default");
        ((Sticker)object).setAlwaysShow(true);
        ((Sticker)object).setObjectTriggerType("");
        ((Sticker)object).setImageWidth(scoreBitmap.getWidth());
        ((Sticker)object).setImageHeight(scoreBitmap.getHeight());
        absolutePosition = new AbsolutePosition();
        objectRegion = new ObjectRegion();
        float f3 = n > 0 ? (float)(scoreBitmap.getWidth() / 2) / (float)width : (float)(scoreBitmap.getWidth() / 2 + n) / (float)width;
        float f4 = (float)(scoreBitmap.getHeight() / 2 + var2_2.getHeight()) / (float)height;
        objectRegion.x = 1.0f - f3 - 0.05f;
        objectRegion.y = f4 + 0.05f + 0.01f;
        objectRegion.w = (float)var3_5;
        objectRegion.h = height;
        absolutePosition.setCenter(objectRegion);
        ((Sticker)object).setAbsolutePos(absolutePosition);
        StickerFixItem stickerFixItem = new StickerFixItem((Sticker)object, null);
        stickerFixItem.setBitmap(scoreBitmap);
        stickerFixItem.sticker.setImageWidth(scoreBitmap.getWidth());
        stickerFixItem.sticker.setImageHeight(var1_1.getHeight());
        stickerFixItem.fixStickerType = "FIX_STICKER_TYPE_SCORE";
        super.addSticker(stickerFixItem);
    }

    public void updateGameFixStickerScore(Bitmap scoreBitmap) {
        for (StickerItem stickerItem : this.stickerItemList) {
            if (!(stickerItem instanceof StickerFixItem)) continue;
            stickerItem = (StickerFixItem)stickerItem;
            if (((StickerFixItem)stickerItem).fixStickerType != "FIX_STICKER_TYPE_SCORE") continue;
            ((StickerFixItem)stickerItem).setBitmap(scoreBitmap);
        }
    }
}

