/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask.gesture;

import android.os.SystemClock;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.cv.HandGestureDetector;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.XEEngineHelper;
import com.momo.mcamera.mask.gesture.CVDetector;
import com.momo.xeengine.cv.bean.XEGestureInfo;
import com.momo.xeengine.cv.bean.XEHandInfo;
import com.momocv.MMBox;
import com.momocv.handgesture.HandGestureInfo;
import java.util.ArrayList;

public class NewHandGestureDetector
extends CVDetector {
    private MMFrameInfo mmFrame = new MMFrameInfo();

    private HandGestureDetector getDetector() {
        return HandGestureDetector.getInstance();
    }

    @Override
    public void startDetect() {
        this.getDetector().create();
    }

    @Override
    public void stopDetect() {
        this.cancel();
        this.getDetector().release();
    }

    @Override
    public void setDetectInterval(int interval) {
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        HandGestureInfo handGestureInfo;
        SystemClock.uptimeMillis();
        MMCVBoxes mMCVBoxes = new MMCVBoxes();
        this.mmFrame.setFormat(17);
        this.mmFrame.setStep_(mmcvInfo.width);
        this.mmFrame.setWidth(mmcvInfo.width);
        this.mmFrame.setHeight(mmcvInfo.height);
        byte[] byArray = mmcvInfo.frameData;
        this.mmFrame.setDataPtr(byArray);
        this.mmFrame.setDataLen(byArray.length);
        this.getDetector().setRestoreRotate(mmcvInfo.restoreDegree);
        this.getDetector().setRotateDegree(mmcvInfo.cameraDegree);
        this.getDetector().setFlip(handGestureInfo.isFrontCamera);
        handGestureInfo = (HandGestureInfo)this.getDetector().objectDetect((Object)this.mmFrame.getFrame());
        if (handGestureInfo != null) {
            if (MediaModuleGlobalConfig.hasXE()) {
                this.processNewGestureData(handGestureInfo.hand_gesture_results_);
            }
            mMCVBoxes.setDetectResult(handGestureInfo.hand_gesture_results_);
            if (this.gestureDetectorListener != null) {
                this.gestureDetectorListener.gestureDetect(mMCVBoxes);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setHandGestureType(int handGestureType) {
        void var1_1;
        this.getDetector().setHandGestureType((int)var1_1);
    }

    private void processNewGestureData(MMBox[] mmBoxes) {
        ArrayList<XEHandInfo> arrayList = new ArrayList<XEHandInfo>();
        if (mmBoxes != null && mmBoxes.length > 0) {
            XEHandInfo xEHandInfo;
            int n = mmBoxes.length;
            ArrayList<XEGestureInfo> arrayList2 = new ArrayList<XEGestureInfo>(n);
            for (void var6_7 : xEHandInfo) {
                if (var6_7 == null) continue;
                XEGestureInfo xEGestureInfo = new XEGestureInfo();
                new XEGestureInfo().type = var6_7.class_name_;
                xEGestureInfo.bounds = new float[]{var6_7.x_, var6_7.y_, var6_7.width_, var6_7.height_};
                xEGestureInfo.score = var6_7.score_;
                arrayList2.add(xEGestureInfo);
            }
            xEHandInfo = new XEHandInfo();
            new XEHandInfo().gestures = arrayList2;
            arrayList.add(xEHandInfo);
        }
        XEEngineHelper.setHandInfos(arrayList);
    }
}

