/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.ImageUtils;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBitmapCache;
import com.momo.mcamera.mask.delegate.ImageDelegateProvider;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class StickerHaniMaskFilter
extends FaceDetectFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    private int stickerIndex = 0;
    private int stickerCount;
    private int frameRate;
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture0;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 color2 = vec4(0.0,1.0,1.0,0.5);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = a;\n   gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    float[] color = new float[]{0.2f, 0.70980394f, 0.8980392f, 1.0f};
    float[] color2 = new float[]{0.0f, 0.20980392f, 0.19803922f, 1.0f};
    int textId;
    float stickerScale;
    MMFrameInfo curMMCVImage;
    float[] mvpMatrix;
    float[] texData0;
    protected Sticker sticker;
    private StickerBitmapCache stickerBitmapCache;
    private Context context;
    private FloatBuffer vertexBuffer;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    private boolean isDraw = true;
    private boolean lockTexture = false;
    private ImageDelegateProvider imageDelegateProvider;
    MMFrameInfo mmcvImage = null;
    FaceDetectFilter.FaceDetectParam currentParam;
    private long startTime = 0L;

    /*
     * WARNING - void declaration
     */
    public StickerHaniMaskFilter(Context context, Sticker sticker, ImageDelegateProvider imageDelegateProvider) {
        void var3_3;
        Object object;
        ByteBuffer byteBuffer;
        this.stickerCount = sticker.getFrameNumber();
        this.frameRate = sticker.getFrameRate();
        this.sticker = byteBuffer;
        this.context = object;
        this.imageDelegateProvider = var3_3;
        this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
        object = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
        byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put((float[])object);
        this.vertexBuffer.position(0);
        this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
        object = byteBuffer2;
        byteBuffer2.order(ByteOrder.nativeOrder());
        this.drawListBuffer = ((ByteBuffer)object).asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void setTextId(int textId) {
        void var1_1;
        this.textId = var1_1;
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture0;varying vec2 textureCoordinate;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\n   vec4 color2 = vec4(0.0,1.0,1.0,0.5);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = a;\n   gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;   vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_POSITION_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void passShaderValues(float[] matrix) {
        void var1_1;
        this.renderVertices.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(matrix.length << 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = byteBuffer.asFloatBuffer();
        this.fvertexBuffer.put((float[])var1_1);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        this.textureVertices[this.curRotation].position(0);
        if (this.texCoordHandle >= 0) {
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        this.setParamForMatrix(this.currentParam.scaleW, this.currentParam.scaleH, new PointF(this.currentParam.cX, this.currentParam.cY), this.currentParam.angle, this.currentParam.points68, this.currentParam.points96, this.currentParam.points104, this.currentParam.filterTrigerManager);
        if (this.mvpMatrix != null && this.mvpMatrix.length == 8) {
            this.passShaderValues(this.mvpMatrix);
            this.draw();
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    /*
     * WARNING - void declaration
     */
    private MMFrameInfo decodeOneFrameByImage(String path) {
        void var1_1;
        if (this.mmcvImage == null) {
            this.mmcvImage = new MMFrameInfo();
            Bitmap bitmap = BitmapFactory.decodeFile((String)path);
            if (this.mmcvImage.getDataPtr() == null) {
                this.mmcvImage.setDataPtr(new byte[bitmap.getHeight() * bitmap.getHeight() << 2]);
            }
            bitmap.recycle();
        }
        ImageUtils.decodeMMCVImage((MMFrameInfo)this.mmcvImage, (String)var1_1);
        return this.mmcvImage;
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var2_4;
        if (newData) {
            this.markAsDirty();
        }
        if (this.mvpMatrix == null) {
            this.setParamForMatrix(this.currentParam.scaleW, this.currentParam.scaleH, new PointF(this.currentParam.cX, this.currentParam.cY), this.currentParam.angle, this.currentParam.points68, this.currentParam.points96, this.currentParam.points104, this.currentParam.filterTrigerManager);
        }
        if (!this.lockTexture || this.texture_in <= 0 || this.mvpMatrix == null) {
            if (this.mvpMatrix != null) {
                boolean bl = false;
                Object object = this.decodeOneFrameByImage(this.sticker.getImagePathByIndex(this.context, this.stickerIndex));
                if (object != null) {
                    bl = true;
                    this.curMMCVImage = object;
                }
                if (this.curMMCVImage != null && this.curMMCVImage != null && this.curMMCVImage.getDataPtr().length > 0) {
                    if (bl) {
                        this.texture_in = this.texture_in == 0 ? TextureHelper.bitmapToTexture((MMFrameInfo)this.curMMCVImage) : TextureHelper.loadDataToTexture((int)this.texture_in, (MMFrameInfo)this.curMMCVImage);
                    }
                } else {
                    if (this.curMMCVImage != null) {
                        this.curMMCVImage = null;
                    }
                    if (object == null && this.imageDelegateProvider != null) {
                        Bitmap bitmap = null;
                        if (this.stickerBitmapCache != null) {
                            bitmap = this.stickerBitmapCache.getRealBitmap();
                        }
                        if (bitmap != null) {
                            if (this.texture_in != 0) {
                                int[] nArray = new int[1];
                                object = nArray;
                                nArray[0] = this.texture_in;
                                GLES20.glDeleteTextures((int)1, (int[])object, (int)0);
                                this.texture_in = 0;
                            }
                            this.texture_in = TextureHelper.bitmapToTexture((Bitmap)bitmap);
                        } else {
                            this.clearPoints();
                        }
                    } else {
                        this.clearPoints();
                    }
                }
            } else {
                this.mvpMatrix = null;
            }
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float f = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        var2_4.unlockRenderBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, float[] points, float[] points96, float[] points104, FilterTriggerManager filterTrigerManager) {
        Object object = this.maskListLock;
        synchronized (object) {
            void var2_4;
            void var1_1;
            if (this.currentParam == null) {
                return;
            }
            float f = -(centerPoint.x * 2.0f - 1.0f);
            float f2 = -centerPoint.y * 2.0f + 1.0f;
            centerPoint.x = f;
            fArray.y = f2;
            float[] fArray = new float[16];
            float[] fArray2 = new float[16];
            Matrix.setIdentityM((float[])fArray2, (int)0);
            Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
            Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_4, (float)1.0f);
            Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
            float[] fArray3 = new float[8];
            float[] fArray4 = fArray3;
            fArray3[0] = fArray2[0];
            fArray4[1] = fArray2[1];
            fArray4[2] = fArray2[4];
            fArray4[3] = fArray2[5];
            fArray4[4] = fArray2[8];
            fArray4[5] = fArray2[9];
            fArray4[6] = fArray2[12];
            fArray4[7] = fArray2[13];
            this.mvpMatrix = fArray4;
            return;
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            FaceDetectFilter.FaceDetectParam faceDetectParam = new FaceDetectFilter.FaceDetectParam();
            new FaceDetectFilter.FaceDetectParam().centerPoint = detectParam.centerPoint;
            faceDetectParam.scaleW = detectParam.scaleW;
            faceDetectParam.scaleH = detectParam.scaleH;
            faceDetectParam.angle = detectParam.angle;
            faceDetectParam.cX = detectParam.centerPoint.x;
            faceDetectParam.cY = var1_1.centerPoint.y;
            this.currentParam = faceDetectParam;
            return;
        }
    }

    @Override
    public void clearPoints() {
    }

    @Override
    public void cancelDraw() {
        if (this.stickerBitmapCache != null) {
            this.stickerBitmapCache.cancel();
            this.stickerBitmapCache = null;
        }
    }

    @Override
    public void lockTexture() {
    }

    @Override
    public void unlockTexture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.stickerBitmapCache != null) {
                this.stickerBitmapCache.pauseCache();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeBitmapCache() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.stickerBitmapCache != null) {
                this.stickerBitmapCache.resumeCache();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            this.sticker = sticker;
            if (this.stickerBitmapCache != null) {
                this.cancelDraw();
            }
            this.stickerScale = (float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth();
            Object object2 = new float[]{-0.5f, 0.5f * this.stickerScale, -0.5f, -0.5f * this.stickerScale, 0.5f, -0.5f * this.stickerScale, 0.5f, 0.5f * this.stickerScale};
            this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
            if (this.vertexBuffer != null) {
                this.vertexBuffer.clear();
                this.drawListBuffer.clear();
            }
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = byteBuffer.asFloatBuffer();
            this.vertexBuffer.put((float[])object2);
            this.vertexBuffer.position(0);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
            object2 = byteBuffer2;
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.drawListBuffer = ((ByteBuffer)object2).asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            this.stickerBitmapCache = new StickerBitmapCache((Sticker)var1_1, this.context, this.imageDelegateProvider);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        void var1_1;
        if (ms < this.startTime) {
            this.startTime = ms;
        }
        if (this.startTime == 0L) {
            this.startTime = ms;
        }
        int n = (int)((var1_1 - this.startTime) / (long)(1000 / this.frameRate));
        this.stickerIndex = n % this.stickerCount;
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
        if (this.mmcvImage != null) {
            this.mmcvImage = null;
        }
    }
}

