/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.ETC1Util;
import android.opengl.GLES20;
import android.opengl.Matrix;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.TextureHelper;
import com.momo.mcamera.mask.Etc1Batch;
import com.momo.mcamera.mask.FaceDetectFilter;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.batchbean.BatchFrame;
import com.momo.mcamera.mask.batchbean.BatchSize;
import com.momocv.MMFrame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class StickerEtc1MaskFilter
extends FaceDetectFilter
implements IVideoTrackTime {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    public static final String ATTRIBUTE_POSITION_3 = "position3";
    static final int COORDS_PER_VERTEX = 2;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  vec2 coord1 = position3.xy;  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n  textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0 - (coord1.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   color1.a = texture2D(inputImageTexture,textureCoordinate1).r;\n   gl_FragColor = color1;\n}";
    protected final float[] mProjectionMatrix = new float[16];
    protected final float[] mViewMatrix = new float[16];
    private final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final int vertexStride = 8;
    protected Object maskListLock = new Object();
    int textId;
    float stickerScale;
    MMFrame curMMCVImage;
    float[] mvpMatrix;
    float[] texData0;
    List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    protected Sticker sticker;
    private FloatBuffer vertexBuffer;
    private FloatBuffer vertexBufferAlpha;
    private FloatBuffer fvertexBuffer;
    private ShortBuffer drawListBuffer;
    private int decorateHandler;
    private int mVPMatrixHandler;
    protected int positionHandle2;
    protected int positionHandle3;
    private boolean isDraw;
    private boolean lockTexture = false;
    private Etc1Batch etc1Batch;
    private String texturePath;
    private ETC1Util.ETC1Texture texture_Etc1;
    private long lastFrameTime = -1L;
    private int curIndex = 0;

    /*
     * WARNING - void declaration
     */
    public StickerEtc1MaskFilter(Context context, Sticker sticker) {
        void var2_2;
        this.sticker = var2_2;
        this.initCoordinate();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
        this.getETC1Texture();
    }

    public void initCoordinate() {
        String string = null;
        String string2 = this.sticker.getETC1JsonPath();
        try {
            string = FileUtil.readString((File)new File(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            return;
        }
        this.etc1Batch = Etc1Batch.getEffectModel(string);
        this.updateETC1Coordinate();
        this.texData0 = new float[]{-0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f, -0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, -0.5f * this.stickerScale, 0.0f, 1.0f, 0.5f, 0.5f * this.stickerScale, 0.0f, 1.0f};
    }

    private void updateETC1Coordinate() {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = System.currentTimeMillis();
            this.curIndex = this.sticker.getETC1ImageIndex();
        }
        if (System.currentTimeMillis() - this.lastFrameTime > 50L) {
            this.curIndex = this.sticker.getETC1ImageIndex();
            this.lastFrameTime = System.currentTimeMillis();
        }
        Object object = this.etc1Batch.getBatchStickers().get(this.curIndex).getFrame();
        BatchSize batchSize = this.etc1Batch.getBatchMeta().getSize();
        float f = (float)((BatchFrame)object).getImageX() / (float)batchSize.getImageBatchWidth();
        float f2 = (float)((BatchFrame)object).getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        float f3 = (float)((BatchFrame)object).getImageX() / (float)batchSize.getImageBatchWidth();
        float f4 = (float)(((BatchFrame)object).getImageY() + ((BatchFrame)object).getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float f5 = (float)(((BatchFrame)object).getImageX() + ((BatchFrame)object).getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float f6 = (float)(((BatchFrame)object).getImageY() + ((BatchFrame)object).getImageHeight()) / (float)(2 * batchSize.getImageBatchHeight());
        float f7 = (float)(((BatchFrame)object).getImageX() + ((BatchFrame)object).getImageWidth()) / (float)batchSize.getImageBatchWidth();
        float f8 = (float)((BatchFrame)object).getImageY() / (float)(2 * batchSize.getImageBatchHeight());
        this.stickerScale = (float)((BatchFrame)object).getImageHeight() / (float)((BatchFrame)object).getImageWidth();
        object = new float[]{f + -0.5f, 0.5f - f2, f3 + -0.5f, 0.5f - f4, f5 + -0.5f, 0.5f - f6, f7 + -0.5f, 0.5f - f8};
        float[] fArray = new float[]{f + -0.5f, -f2, f3 + -0.5f, -f4, f5 + -0.5f, -f6, f7 + -0.5f, -f8};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(32);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put((float[])object);
        this.vertexBuffer.position(0);
        object = ByteBuffer.allocateDirect(32);
        ((ByteBuffer)object).order(ByteOrder.nativeOrder());
        this.vertexBufferAlpha = ((ByteBuffer)object).asFloatBuffer();
        this.vertexBufferAlpha.put(fArray);
        this.vertexBufferAlpha.position(0);
    }

    /*
     * WARNING - void declaration
     */
    public void setTextId(int textId) {
        void var1_1;
        this.textId = var1_1;
    }

    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture,textureCoordinate);\n   color1.a = texture2D(inputImageTexture,textureCoordinate1).r;\n   gl_FragColor = color1;\n}";
    }

    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; attribute vec4   position3 ; attribute vec4 inputTextureCoordinate;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  vec2 coord1 = position3.xy;  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n  textureCoordinate1 = vec2(1.0 - (coord1.x + 0.5),1.0 - (coord1.y + 0.5));\n}";
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.positionHandle3 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_3);
        this.mVPMatrixHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_MVP_MATRIX);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    /*
     * WARNING - void declaration
     */
    protected void passShaderValues(float[] mvpMatrix) {
        void var1_1;
        this.renderVertices.position(0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length << 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.fvertexBuffer = byteBuffer.asFloatBuffer();
        this.fvertexBuffer.put((float[])var1_1);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle3, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufferAlpha);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle3);
        this.textureVertices[this.curRotation].position(0);
        GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureVertices[this.curRotation]);
        GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSub() {
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClear((int)16640);
        GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
        Object object = this.maskListLock;
        synchronized (object) {
            for (float[] fArray : this.mvpLists) {
                this.passShaderValues(fArray);
                this.draw();
            }
            return;
        }
    }

    public void draw() {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)((float)this.sticker.getImageHeight() / (float)this.sticker.getImageWidth()));
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var2_3;
        if (newData) {
            this.markAsDirty();
        }
        if (this.lockTexture && this.texture_in > 0 && this.mvpLists != null && this.mvpLists.size() > 0) {
            this.isDraw = true;
        } else if (this.mvpLists != null && this.mvpLists.size() > 0) {
            if (!this.isDraw) {
                this.clearPoints();
            }
            if (this.texture_Etc1 != null) {
                if (this.texture_in == 0) {
                    this.texture_in = TextureHelper.etc1ToTexture((ETC1Util.ETC1Texture)this.texture_Etc1);
                }
                this.updateETC1Coordinate();
                this.isDraw = true;
            } else {
                this.isDraw = false;
            }
        } else {
            this.isDraw = false;
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        float f = (float)this.getWidth() / (float)this.getHeight();
        Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
        this.onDrawFrame();
        var2_3.unlockRenderBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle, float[] points, float[] points96, float[] points104, FilterTriggerManager filterTrigerManager) {
        Object object = this.maskListLock;
        synchronized (object) {
            void var2_4;
            void var1_1;
            if (centerPoint == null) {
                return;
            }
            float f = -(centerPoint.x * 2.0f - 1.0f);
            float f2 = -centerPoint.y * 2.0f + 1.0f;
            centerPoint.x = f;
            fArray.y = f2;
            float[] fArray = new float[16];
            float[] fArray2 = new float[16];
            Matrix.setIdentityM((float[])fArray2, (int)0);
            Matrix.translateM((float[])fArray2, (int)0, (float)(-f), (float)f2, (float)0.0f);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
            Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
            Matrix.rotateM((float[])fArray, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            Matrix.scaleM((float[])fArray, (int)0, (float)var1_1, (float)var2_4, (float)1.0f);
            Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
            float[] fArray3 = new float[8];
            float[] fArray4 = fArray3;
            fArray3[0] = fArray2[0];
            fArray4[1] = fArray2[1];
            fArray4[2] = fArray2[4];
            fArray4[3] = fArray2[5];
            fArray4[4] = fArray2[8];
            fArray4[5] = fArray2[9];
            fArray4[6] = fArray2[12];
            fArray4[7] = fArray2[13];
            this.mvpLists.add(fArray4);
            return;
        }
    }

    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDetectParam(FaceDetectFilter.FaceDetectParam detectParam) {
        void var1_1;
        this.setParamForMatrix(detectParam.scaleW, detectParam.scaleH, detectParam.centerPoint, detectParam.angle, detectParam.points68, detectParam.points96, detectParam.points104, var1_1.filterTrigerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPoints() {
        Object object = this.maskListLock;
        synchronized (object) {
            this.mvpLists.clear();
            return;
        }
    }

    @Override
    public void cancelDraw() {
        this.isDraw = false;
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockTexture() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.lockTexture = false;
            return;
        }
    }

    @Override
    public void pauseBitmapCache() {
    }

    @Override
    public void resumeBitmapCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2;
            this.sticker = object2;
            if (this.texture_in != 0) {
                int[] nArray = new int[1];
                object2 = nArray;
                nArray[0] = this.texture_in;
                GLES20.glDeleteTextures((int)1, (int[])object2, (int)0);
                this.texture_in = 0;
            }
            if (this.vertexBuffer != null && this.vertexBufferAlpha != null) {
                this.vertexBuffer.clear();
                this.vertexBufferAlpha.clear();
                this.drawListBuffer.clear();
            }
            this.initCoordinate();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.drawOrder.length << 1);
            object2 = byteBuffer;
            byteBuffer.order(ByteOrder.nativeOrder());
            this.drawListBuffer = ((ByteBuffer)object2).asShortBuffer();
            this.drawListBuffer.put(this.drawOrder);
            this.drawListBuffer.position(0);
            return;
        }
    }

    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.texture_in;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
            this.texture_in = 0;
        }
    }

    public void setTimeStamp(long ms) {
    }

    private ETC1Util.ETC1Texture getETC1Texture() {
        if (this.texturePath == null) {
            this.texturePath = this.sticker.getETC1Path();
            this.texture_Etc1 = this.loadPkmFile(this.texturePath);
        }
        return this.texture_Etc1;
    }

    private ETC1Util.ETC1Texture loadPkmFile(String path) {
        ETC1Util.ETC1Texture eTC1Texture = null;
        try {
            File file;
            file = new File((String)((Object)file));
            eTC1Texture = ETC1Util.createTexture((InputStream)new FileInputStream(file));
        }
        catch (Exception exception) {}
        return eTC1Texture;
    }
}

