/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.opengl.GLES20;
import android.text.TextUtils;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.helper.BlendShaderHelper;

public class TriggerBlendFilter
extends MultiInputFilter
implements FaceDetectInterface {
    private static final String UNIFORM_BLEND = "blend";
    protected static final String UNIFORM_TEXTURE_ALPHA = "inputImageTexture2";
    private int blendHandler;
    private int texelWidthHandler;
    private int texelHeightHandler;
    private int strokeRadiusHandler;
    private int strokeColorHandler;
    private int strokeEnabledHandler;
    private boolean isBlend = true;
    protected boolean isSegmentBody = false;
    protected boolean isStroke = false;
    protected float[] strokeRgbaColor;
    protected int strokeRadius = 5;
    private MMCVInfo mmcvInfo;
    private int alphaTexture = 0;
    private String blendType;
    private int strokeEnabled = 1;

    /*
     * WARNING - void declaration
     */
    public void setStrokeEnabled(boolean isStrokeEnalbed) {
        void var1_1;
        this.strokeEnabled = var1_1 != false ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setBlendType(String blendType) {
        void var1_1;
        this.blendType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSegmentBody(boolean segmentBody) {
        void var1_1;
        this.isSegmentBody = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSegmentStrokeColor(float[] strokeRgbaColor) {
        if (strokeRgbaColor != null && strokeRgbaColor.length >= 3) {
            void var1_1;
            this.isStroke = true;
            if (strokeRgbaColor.length == 3) {
                this.strokeRgbaColor = new float[]{strokeRgbaColor[0], strokeRgbaColor[1], strokeRgbaColor[2], 1.0f};
                return;
            }
            this.strokeRgbaColor = var1_1;
            return;
        }
        this.isStroke = false;
    }

    /*
     * WARNING - void declaration
     */
    public void setSegmentStrokeRadius(int strokeRadius) {
        if (strokeRadius > 0) {
            void var1_1;
            this.strokeRadius = var1_1;
        }
    }

    public TriggerBlendFilter() {
        super(2);
    }

    /*
     * WARNING - void declaration
     */
    public TriggerBlendFilter(int numOfInputs) {
        super((int)var1_1);
        void var1_1;
    }

    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        FaceAttributeInfo faceAttributeInfo;
        if (mmcvInfo == null) {
            return;
        }
        this.mmcvInfo = mmcvInfo;
        if ((faceAttributeInfo = faceAttributeInfo.getFaceAttributeInfo(0)) != null && faceAttributeInfo.getModelviewMatrix() != null && faceAttributeInfo.getRotationVector() != null) {
            this.setStrokeEnabled(true);
            return;
        }
        this.setStrokeEnabled(false);
    }

    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blendHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLEND);
        if (this.isSegmentBody && this.isStroke) {
            this.texelWidthHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelWidth");
            this.texelHeightHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"texelHeight");
            this.strokeRadiusHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeRadius");
            this.strokeColorHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeColor");
            this.strokeEnabledHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"strokeEnabled");
        }
    }

    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.blendHandler, (float)(this.isBlend ? 1.0f : 0.0f));
        if (this.isSegmentBody && this.isStroke) {
            GLES20.glUniform1f((int)this.texelWidthHandler, (float)(1.0f / (float)this.getWidth()));
            GLES20.glUniform1f((int)this.texelHeightHandler, (float)(1.0f / (float)this.getHeight()));
            GLES20.glUniform1i((int)this.strokeRadiusHandler, (int)this.strokeRadius);
            GLES20.glUniform4f((int)this.strokeColorHandler, (float)this.strokeRgbaColor[0], (float)this.strokeRgbaColor[1], (float)this.strokeRgbaColor[2], (float)this.strokeRgbaColor[3]);
            GLES20.glUniform1i((int)this.strokeEnabledHandler, (int)this.strokeEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setBlend(boolean blend) {
        Object object = this.listLock;
        synchronized (object) {
            void var1_1;
            this.isBlend = var1_1;
            return;
        }
    }

    protected String getFragmentShader() {
        String string;
        if (this.isSegmentBody) {
            if (this.isStroke) {
                return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nuniform float blend;\nvarying vec2 textureCoordinate;\n\nuniform float texelWidth;\nuniform float texelHeight;\n\nuniform int strokeRadius;\nuniform vec4 strokeColor;\nuniform int strokeEnabled;\nfloat stepWidth = 1.0;\n\nfloat intensityForEdge(vec2 center, vec2 step1) {\n    //bool isIntensity = false;\n    vec4 centerTex = texture2D(inputImageTexture3, center);\n    float intensity = centerTex.r;\n    for (int i = 0; i < strokeRadius; i++) {\n        vec2 left = center + vec2(step1.x * float(i), 0.0);\n        vec2 right = center + vec2(step1.x * -float(i), 0.0);\n        vec2 top = center + vec2(0.0, -step1.y * float(i));\n        vec2 bottom = center + vec2(0.0, +step1.y * float(i));\n        vec4 leftTex = texture2D( inputImageTexture3, left);\n        vec4 rightTex = texture2D( inputImageTexture3, right);\n        vec4 topTex = texture2D( inputImageTexture3, top);\n        vec4 bottomTex = texture2D( inputImageTexture3, bottom);\n        intensity = (intensity+(leftTex.r+rightTex.r+ topTex.r+ bottomTex.r)*(1.0-float(i)/float(strokeRadius)));\n    }\n    return intensity*float(strokeRadius);\n}\n\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {\n   gl_FragColor = color2;\n} else {   \n   vec2 step1 = vec2(stepWidth*texelWidth, stepWidth*texelHeight);\n   vec4 picture = texture2D(inputImageTexture1, textureCoordinate);\n\n   vec4 color1;\n   float intensity = intensityForEdge(textureCoordinate, step1);\n   //if (intensity > 0.0) {\n   //   color1 = strokeColor;\n   //} else {\n   //   color1 = picture;\n   //}\n   color1 = mix(strokeColor, picture , step(0.0, -intensity));\n   color1 = mix(picture, color1, float(strokeEnabled));\n   //vec4 colorSobel = texture2D(inputImageTexture3,textureCoordinate);\n   //float c1AlphaDivisor = color1.a + step(color1.a, 0.0);\n   //color1.rgb = color1.rgb/c1AlphaDivisor;\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   vec4 colorAlpha = texture2D(inputImageTexture2, textureCoordinate);\n   color1 = vec4(color1.rgb, color1.a * (colorAlpha.r > 0.9 ? 0.0 : (1.0 - colorAlpha.r * colorAlpha.r* colorAlpha.r)));\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n   }\n }";
            }
            return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   vec4 colorAlpha = texture2D(inputImageTexture2, textureCoordinate);\n   color1 = vec4(color1.rgb, color1.a * (colorAlpha.r > 0.9 ? 0.0 : (1.0 - colorAlpha.r * colorAlpha.r* colorAlpha.r)));\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
        }
        if (!TextUtils.isEmpty((CharSequence)this.blendType) && !TextUtils.isEmpty((CharSequence)(string = BlendShaderHelper.getBlendShader((String)this.blendType)))) {
            return string;
        }
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
    }

    public void destroy() {
        super.destroy();
        if (this.alphaTexture != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = this.alphaTexture;
            GLES20.glDeleteTextures((int)1, (int[])nArray2, (int)0);
        }
    }
}

