/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.core.glcore.cv.FaceDetectInterface;
import com.core.glcore.cv.MMCVInfo;
import com.momo.mcamera.mask.g.c;
import com.momo.mcamera.mask.z;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class BigEyeFilter
extends BasicFilter
implements FaceDetectInterface {
    public static final String UNIFORM_TEXTURE_SIZE = "textureSize";
    public static final String UNIFORM_CENTER_LEFT = "centerLeft";
    public static final String UNIFORM_CENTER_RIGHT = "centerRight";
    public static final String UNIFORM_RADIUS_LEFT = "radiusLeft";
    public static final String UNIFORM_RADIUS_RIGHT = "radiusRight";
    public static final String UNIFORM_SCALE = "scale";
    public int handleTextureSize = 0;
    public int handleCenterLeft = 0;
    public int handleCenterRight = 0;
    public int handleRadiusLeft = 0;
    public int handleRadiuRight = 0;
    public int handleScale = 0;
    public float[] textureSize = new float[2];
    public float[] centerLeft = new float[2];
    public float[] centerRight = new float[2];
    public float radiusLeft = 0.0f;
    public float radiusRight = 0.0f;
    private float scale = 0.0f;
    private float mEyeScale = 0.0f;
    private a eyesProgram = new a();
    private MMCVInfo mMmcvInfo = null;

    public BigEyeFilter() {
        if (this.eyesProgram != null) {
            this.eyesProgram.a(4);
        }
    }

    public void drawSub() {
        super.drawSub();
        this.drawEyes();
    }

    /*
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.eyesProgram != null) {
            this.eyesProgram.a(source.getWidth(), source.getHeight());
        }
        super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (mmcvInfo == null) {
                return;
            }
            this.mMmcvInfo = var1_1;
            return;
        }
    }

    private void drawEyes() {
        if (this.mMmcvInfo != null && this.mMmcvInfo.getMaxFaceCnt() > 0) {
            for (int i2 = 0; i2 < this.mMmcvInfo.getMaxFaceCnt(); ++i2) {
                if (this.mMmcvInfo.getFaceAttributeInfo(i2) == null || this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104() == null) continue;
                Object object = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[39], this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[143]);
                Object object2 = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[45], this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[149]);
                this.centerLeft[0] = (object.x + object2.x) / 2.0f;
                this.centerLeft[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (object.y + object2.y) / 2.0f;
                PointF pointF = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[51], this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[155]);
                PointF pointF2 = new PointF(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[57], this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104()[161]);
                this.centerRight[0] = (pointF.x + pointF2.x) / 2.0f;
                this.centerRight[1] = 1.0f * (float)this.mMmcvInfo.getWidth() - (pointF.y + pointF2.y) / 2.0f;
                double d2 = Math.sqrt((object.x - object2.x) * (object.x - object2.x) + (object.y - object2.y) * (object.y - object2.y));
                double d3 = (Math.sqrt((pointF.x - pointF2.x) * (pointF.x - pointF2.x) + (pointF.y - pointF2.y) * (pointF.y - pointF2.y)) + d2) / 2.0;
                float f2 = 1.0f - Math.min(Math.abs(this.mMmcvInfo.getFaceAttributeInfo(i2).getEulerAngles()[1]) / 60.0f, 1.0f);
                this.scale = (float)((double)this.mEyeScale * 0.2 * Math.exp((double)f2 - 1.0));
                this.radiusLeft = (float)(d3 * 0.8);
                this.radiusRight = (float)(d3 * 0.8);
                object = new int[]{this.texture_in};
                object2 = c.a(this.mMmcvInfo.getFaceAttributeInfo(i2).getOriglandmarks_104(), this.getWidth(), this.getHeight(), null);
                this.eyesProgram.b((float[][])object2, (int[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEyeScale(float scale) {
        void var1_1;
        this.mEyeScale = var1_1;
    }

    class a
    extends z {
        public a() {
            super(1, 1);
        }

        @Override
        protected final String a() {
            return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate0;\nuniform vec2 textureSize;\nuniform vec2 centerLeft;\nuniform vec2 centerRight;\nuniform float radiusLeft;\nuniform float radiusRight; \nuniform float scale;\nvoid main() {\n    vec2 textureCoordinate = textureCoordinate0  * textureSize;\n    float distanceLeft = distance(centerLeft, textureCoordinate);\n    if (distanceLeft < radiusLeft) {\n        vec2 offset = textureCoordinate - centerLeft;\n        float percent = 1.0 - ((radiusLeft - distanceLeft) / radiusLeft) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerLeft + offset)/textureSize);\n        return;\n    }\n    float distanceRight = distance(centerRight, textureCoordinate);\n    if (distanceRight < radiusRight) {\n        vec2 offset = textureCoordinate - centerRight;\n        float percent = 1.0 - ((radiusRight - distanceRight) / radiusRight) * scale;\n        percent = percent * percent;\n        offset *= percent;\n        gl_FragColor = texture2D(inputImageTexture0, (centerRight + offset)/textureSize);\n        return;\n    }\n    gl_FragColor = texture2D(inputImageTexture0, textureCoordinate0);\n}";
        }

        @Override
        protected final void b() {
            super.b();
            BigEyeFilter.this.handleTextureSize = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_TEXTURE_SIZE);
            BigEyeFilter.this.handleCenterLeft = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_CENTER_LEFT);
            BigEyeFilter.this.handleCenterRight = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_CENTER_RIGHT);
            BigEyeFilter.this.handleRadiusLeft = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_RADIUS_LEFT);
            BigEyeFilter.this.handleRadiuRight = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_RADIUS_RIGHT);
            BigEyeFilter.this.handleScale = GLES20.glGetUniformLocation((int)this.l, (String)BigEyeFilter.UNIFORM_SCALE);
        }

        @Override
        protected final void a(float[][] fArray, int[] nArray) {
            super.a(fArray, nArray);
            BigEyeFilter.this.textureSize[0] = this.p;
            BigEyeFilter.this.textureSize[1] = this.q;
            GLES20.glUniform2f((int)BigEyeFilter.this.handleTextureSize, (float)BigEyeFilter.this.textureSize[0], (float)BigEyeFilter.this.textureSize[1]);
            GLES20.glUniform2f((int)BigEyeFilter.this.handleCenterLeft, (float)BigEyeFilter.this.centerLeft[0], (float)BigEyeFilter.this.centerLeft[1]);
            GLES20.glUniform2f((int)BigEyeFilter.this.handleCenterRight, (float)BigEyeFilter.this.centerRight[0], (float)BigEyeFilter.this.centerRight[1]);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleRadiusLeft, (float)BigEyeFilter.this.radiusLeft);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleRadiuRight, (float)BigEyeFilter.this.radiusRight);
            GLES20.glUniform1f((int)BigEyeFilter.this.handleScale, (float)BigEyeFilter.this.scale);
        }
    }
}

