/*
 * Decompiled with CFR 0.152.
 */
package com.momo.mcamera.mask;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.core.glcore.config.MediaModuleGlobalConfig;
import com.core.glcore.config.Size;
import com.core.glcore.cv.FaceAttributeInfo;
import com.core.glcore.cv.HandGestureDetector;
import com.core.glcore.cv.MMCVBoxes;
import com.core.glcore.cv.MMCVInfo;
import com.core.glcore.util.BodyLandHelper;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.cosmos.mdlog.MDLog;
import com.google.ar.core.Frame;
import com.google.ar.core.Plane;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingState;
import com.immomo.moment.datadot.DataDotUtils;
import com.immomo.moment.datadot.RecoderDotUtil;
import com.momo.mcamera.filtermanager.MMPresetFilterStore;
import com.momo.mcamera.mask.BeautyFace;
import com.momo.mcamera.mask.FilterTriggerManager;
import com.momo.mcamera.mask.LookUpModel;
import com.momo.mcamera.mask.Mask;
import com.momo.mcamera.mask.MaskModel;
import com.momo.mcamera.mask.NormalFilter;
import com.momo.mcamera.mask.Sticker;
import com.momo.mcamera.mask.StickerBlendFilter;
import com.momo.mcamera.mask.aa;
import com.momo.mcamera.mask.ag;
import com.momo.mcamera.mask.ah;
import com.momo.mcamera.mask.ai;
import com.momo.mcamera.mask.aj;
import com.momo.mcamera.mask.ak;
import com.momo.mcamera.mask.al;
import com.momo.mcamera.mask.am;
import com.momo.mcamera.mask.an;
import com.momo.mcamera.mask.ao;
import com.momo.mcamera.mask.aq;
import com.momo.mcamera.mask.ar;
import com.momo.mcamera.mask.aw;
import com.momo.mcamera.mask.ba;
import com.momo.mcamera.mask.bb;
import com.momo.mcamera.mask.bc;
import com.momo.mcamera.mask.bd;
import com.momo.mcamera.mask.bean.AbsolutePosition;
import com.momo.mcamera.mask.bean.EffectFilterItem;
import com.momo.mcamera.mask.bean.ObjectRegion;
import com.momo.mcamera.mask.bean.ViewPortProportion;
import com.momo.mcamera.mask.bf;
import com.momo.mcamera.mask.bg;
import com.momo.mcamera.mask.bi;
import com.momo.mcamera.mask.c.a;
import com.momo.mcamera.mask.d.a;
import com.momo.mcamera.mask.d.b;
import com.momo.mcamera.mask.d.c;
import com.momo.mcamera.mask.e;
import com.momo.mcamera.mask.f;
import com.momo.mcamera.mask.i;
import com.momo.mcamera.mask.l;
import com.momo.mcamera.mask.o;
import com.momo.mcamera.mask.y;
import com.momo.mcamera.mask.z;
import com.momo.render.SharedExecutor;
import com.momo.xeengine.ar.ARCore;
import com.momocv.MMBox;
import com.momocv.MMRect;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import project.android.imageprocessing.EffectTimeBean;
import project.android.imageprocessing.GLRenderer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.SingleLineGroupFilter;
import project.android.imageprocessing.filter.processing.LookUpIntensityInterface;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.ARCoreInterface;
import project.android.imageprocessing.inter.IVideoTrackTime;
import project.android.imageprocessing.inter.MStickerActions;
import project.android.imageprocessing.output.GLTextureInputRenderer;

public class StickerAdjustFilter
extends bd
implements LookUpIntensityInterface,
ARCoreInterface,
IVideoTrackTime {
    public static final int POINTS_LENGTH = 68;
    public static final long DEFAULT_LONG_DURATION = 99999999999L;
    private static final int SOUND_PULL_SIZE = 5;
    private static final long DEFAULT_DURATION = 30000000L;
    private final String TAG = "StickerAdjustFilter";
    public ag mSoundInput;
    public boolean enableSelfRender = false;
    ConcurrentHashMap<String, StickerBlendFilter> mStickerFilterMap;
    ConcurrentHashMap<String, MaskModel> mGestureTriggerModels;
    int lastFacesCnt = 0;
    PointF lastFacePosition = new PointF(0.0f, 0.0f);
    private List<GLRenderer> filtersToDestroy;
    private NormalFilter mNormalFilter;
    private Context mContext;
    private BasicFilter mTerminalFilter;
    private StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener;
    private FilterTriggerManager filterTriggerManager;
    private float mBigEye;
    private float mThinFace;
    private com.momo.mcamera.mask.d.a gestureDetector;
    private MMCVBoxes mmcvBoxes;
    private SoundPool soundPool;
    private MediaPlayer soundPlayer;
    private boolean enableSoundPool;
    private ArrayList<Integer> soundIds = new ArrayList();
    private GestureDetectedListener gestureDetectedListener;
    private StickerMaskFinishListener finishListener;
    private MMRect mmcvRect;
    private bc mGestureTrackingFilter;
    private List<i> face3DMaskFilters;
    private boolean isCameraFront = false;
    private a.a gestureDetectorListener;
    private MMCVInfo mCurCVInfo;
    private long startTime = 0L;
    private long time = System.currentTimeMillis();
    private aa mMultiStickerMaskFilter;
    private int scaleWidth = 0;
    private int scaleHeight = 0;
    private float scaleWidthRatio = 1.0f;
    private float scaleHeightRatio = 1.0f;
    private int groupNumber = 0;
    private boolean useBlendFilter = false;
    private boolean hasExpressionModel = false;
    private boolean isplayStatusTriggered = false;
    private MStickerActions.onPlayStatusListener playStatusListener;
    private boolean multiSwitchEnable = false;
    private com.momo.mcamera.mask.c.a expressDetector;
    private com.momo.mcamera.mask.a mArCoreFrameListener;
    private List<Sticker> mSwapFacialMaskSticker;
    private o mFaceMaskFilter;
    f mEffectGroupFilter;
    private int mCount = 0;
    private Mask mDistorationMask = null;
    private BeautyFace mBeautyFace = null;
    private boolean mFaceBeauty = false;
    private boolean mFaceStateChange = false;
    private float mFaceThinValue = 0.0f;
    private float mBigEyeValue = 0.0f;
    private boolean mFaceBeautyHaveFinish = false;
    private int mPollGroupNum = 0;
    private SingleLineGroupFilter mLookupFilter = null;
    private Map<Integer, a> soundInfoMap = new HashMap<Integer, a>();

    /*
     * WARNING - void declaration
     */
    public StickerAdjustFilter(Context context) {
        void var1_1;
        this.mContext = var1_1;
        this.filterTriggerManager = new FilterTriggerManager();
        this.mNormalFilter = new NormalFilter();
        this.mNormalFilter.addTarget((GLTextureInputRenderer)this);
        this.mStickerFilterMap = new ConcurrentHashMap();
        this.mGestureTriggerModels = new ConcurrentHashMap();
        this.registerInitialFilter(this.mNormalFilter);
        this.registerTerminalFilter(this.mNormalFilter);
        this.mTerminalFilter = this.mNormalFilter;
        this.filtersToDestroy = new ArrayList<GLRenderer>();
        this.soundPool = new SoundPool(5, 3, 5);
    }

    public StickerBlendFilter.StickerStateChangeListener getStickerStateChangeListener() {
        return this.stickerStateChangeListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setStickerStateChangeListener(StickerBlendFilter.StickerStateChangeListener stickerStateChangeListener) {
        void var1_1;
        this.stickerStateChangeListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableSound(boolean enableSound) {
        void var1_1;
        this.enableSoundPool = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceBytes(byte[] bytes) {
        Object object = this.listLock;
        synchronized (object) {
            if (this.mSoundInput != null) {
                ag ag2;
                void var3_4 = ag2;
                ag2 = this.mSoundInput;
                boolean bl = this.mSoundInput.a = var3_4 != null;
                if (ag2.c == null) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(2048).order(ByteOrder.nativeOrder());
                    byteBuffer.position(0);
                    ag2.c = byteBuffer;
                }
                ag2.c.clear();
                if (var3_4 != null) {
                    ag2.c.position(0);
                    ag2.c.put((byte[])var3_4);
                    ag2.c.position(0);
                    ag2.b = true;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExpressDetect(String modelPath) {
        com.momo.mcamera.mask.c.a a2;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter startExpressDetect");
        if (this.expressDetector == null) {
            this.expressDetector = new com.momo.mcamera.mask.c.a();
        }
        this.expressDetector.a = a2;
        a2 = this.expressDetector;
        Object object = a2.d;
        synchronized (object) {
            if (a2.g == null) {
                a2.e = true;
                a2.g = a2.new a.a("ExpressDetect");
                a2.g.start();
            }
            return;
        }
    }

    public void stopExpressDetect() {
        if (this.expressDetector != null) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopExpressDetect");
            com.momo.mcamera.mask.c.a a2 = this.expressDetector;
            this.expressDetector.e = false;
            if (a2.b != null) {
                a2.b.clear();
            }
            if (a2.g != null) {
                try {
                    a2.g.interrupt();
                }
                catch (Exception exception) {}
                a2.g = null;
            }
            if (a2.k != null) {
                a2.k.Release();
                a2.k = null;
            }
        }
    }

    public void startGestureDetect() {
        this.startGestureDetect(false, 0);
    }

    /*
     * WARNING - void declaration
     */
    public void startGestureDetect(boolean useNewVersion, int handGestureType) {
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)("StickerAdjustFilter startGestureDetect useNewVersion " + useNewVersion + " handGestureType = " + handGestureType));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraUseHandGesture(true);
        if (this.gestureDetectorListener == null) {
            this.gestureDetectorListener = new ah(this);
        }
        if (this.gestureDetector == null) {
            if (var1_1 == false) {
                this.gestureDetector = new b(this.gestureDetectorListener);
            } else {
                c c2 = new c();
                c2.a(this.gestureDetectorListener);
                this.gestureDetector = c2;
            }
        } else if (this.gestureDetector instanceof b && var1_1 != false) {
            c c3 = new c();
            c3.a(this.gestureDetectorListener);
            this.gestureDetector = c3;
        } else if (this.gestureDetector instanceof c && var1_1 == false) {
            this.gestureDetector = new b(this.gestureDetectorListener);
        }
        if (this.gestureDetector instanceof c) {
            void var2_4;
            HandGestureDetector.getInstance().setHandGestureType((int)var2_4);
        }
        this.gestureDetector.a(this.gestureDetectorListener);
        this.gestureDetector.a();
    }

    /*
     * WARNING - void declaration
     */
    public void setGestureDetectInterval(int interval) {
        if (this.gestureDetector != null) {
            void var1_1;
            this.gestureDetector.a((int)var1_1);
        }
    }

    public void switchCamera(boolean isFront) {
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter switchCamera ");
        this.isCameraFront = isFront;
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (i i2 : this.face3DMaskFilters) {
                if (i2.f == isFront) continue;
                i2.f = isFront;
                i2.e = 0;
                if (FacerigHelper.isUseFacerig() || FacerigHelper.isSetFacerig()) {
                    i.c.put(((Object)((Object)i2)).hashCode(), false);
                    continue;
                }
                i.c.put(((Object)((Object)i2)).hashCode(), true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultCameraDirection(boolean cameraFront) {
        void var1_1;
        this.isCameraFront = var1_1;
    }

    public void stopGestureDetect() {
        if (this.gestureDetector != null) {
            MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter stopGestureDetect ");
            this.mmcvBoxes = null;
            this.gestureDetector.b();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeGestureModel(String gestureTriggerType) {
        void var1_1;
        this.mGestureTriggerModels.remove(var1_1);
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter removeGestureModel ");
    }

    /*
     * WARNING - void declaration
     */
    public void addGestureModel(String gestureTriggerType, MaskModel maskModel) {
        void var2_2;
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureModel ");
        maskModel.setModelType(4);
        this.mGestureTriggerModels.put((String)var1_1, (MaskModel)var2_2);
        if (this.gestureDetector != null) {
            this.gestureDetector.a(this.gestureDetectorListener);
            this.gestureDetector.a();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addGestureMaskModel(String gestureTriggerType) {
        void var1_1;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addGestureMaskModel ");
        MaskModel maskModel = this.mGestureTriggerModels.get(gestureTriggerType);
        this.addGestureMaskModel((String)var1_1, maskModel);
    }

    /*
     * WARNING - void declaration
     */
    public void addGestureMaskModel(String gestureTriggerType, MaskModel model) {
        MDLog.i((String)"FilterProcess", (String)("StickerAdjustFilter addGestureMaskModel gestureTriggerType = " + gestureTriggerType));
        if (model == null) {
            return;
        }
        if (!FilterTriggerManager.isTriggerRegionMatches(this.mmcvBoxes, gestureTriggerType, model, this.getWidth(), this.getHeight())) {
            return;
        }
        if (this.gestureDetectedListener != null) {
            void var1_1;
            this.gestureDetectedListener.onPreGestureAdded((String)var1_1);
        }
        if (model.addTime == 0L || System.currentTimeMillis() - model.addTime > model.getDuration() + 1000L) {
            model.addTime = System.currentTimeMillis();
            model.setDuration(model.getDuration());
            if (model != null) {
                void var2_2;
                this.addMaskModel((MaskModel)var2_2);
                this.startTime = 0L;
            }
        }
    }

    public void addHaniSticker(MaskModel model, int haniId) {
        if (this.mMultiStickerMaskFilter == null) {
            this.mMultiStickerMaskFilter = new aa(this.mContext);
            this.mMultiStickerMaskFilter.a(model.getPollGroupNum());
            this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
        }
        if (model == null) {
            return;
        }
        for (Sticker sticker : model.getStickers()) {
            String string = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
            sticker.setStickerType(model.getModelType() + "_" + string + haniId);
            sticker.setModelType(haniId);
            sticker.setDuration(99999999999L);
            sticker.setFrameRate(model.getFrameRate());
            sticker.isHaniSticker = true;
            this.addSticker(sticker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeHaniSticker(int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var1_1;
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.b(haniId);
            }
            this.clearMaskWithModelType((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addMaskModel(MaskModel model) {
        Object object;
        MDLog.i((String)"FilterProcess", (String)"StickerAdjustFilter addMaskModel ");
        if (model == null) {
            RecoderDotUtil.getInstance().setUseSticker(false);
            return;
        }
        RecoderDotUtil.getInstance().setUseSticker(true);
        this.useBlendFilter = false;
        if (model.getModelType() == 0 || model.getModelType() == 7) {
            void object5;
            void var4_16;
            if (model.getModelType() == 0) {
                this.clearMaskWithModelType(0);
            }
            if (model.getAdditionalInfo() != null) {
                BodyLandHelper.setUseBodyLand((boolean)model.getAdditionalInfo().isBodyDetectEnable());
            }
            int n2 = 0;
            boolean n3 = false;
            this.mPollGroupNum = model.getPollGroupNum();
            if (model.getModelType() == 0) {
                this.hasExpressionModel = false;
                this.multiSwitchEnable = false;
            } else if (model.getModelType() == 7) {
                if (this.hasExpressionModel) {
                    return;
                }
                this.hasExpressionModel = true;
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isMultiFaceSwitchEnable()) {
                this.multiSwitchEnable = true;
                DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraEnableMultiFaces(this.multiSwitchEnable);
            }
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isAnimojiDetectEnable()) {
                FacerigHelper.setUseAnimojiFaceRig((boolean)true);
            } else {
                FacerigHelper.setUseAnimojiFaceRig((boolean)false);
            }
            boolean bl = false;
            if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                object = model.getStickers();
                ArrayList<Sticker> arrayList = new ArrayList<Sticker>();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    if (!object.get(i2).getStickerType().equals("FACE_MASK_TYPE")) continue;
                    arrayList.add(object.get(i2));
                    object.remove(i2);
                }
                for (Sticker sticker : arrayList) {
                    object.add((Sticker)sticker);
                }
                model.setStickers((List<Sticker>)object);
            }
            for (Sticker sticker : model.getStickers()) {
                if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
                    sticker.setComic(true);
                }
                if (TextUtils.isEmpty((CharSequence)sticker.getStickerType()) || !sticker.getStickerType().equals("STICKER_TYPE_VOICE") && !sticker.getStickerType().equals("FACE_MASK_TYPE") && !sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    int n4 = n2;
                    if (this.mMultiStickerMaskFilter != null) {
                        n4 += this.mMultiStickerMaskFilter.c();
                    }
                    if (this.mStickerFilterMap != null) {
                        n4 += this.mStickerFilterMap.size();
                    }
                    sticker.setStickerType(model.getModelType() + "_" + n4);
                    sticker.setDuration(99999999999L);
                }
                if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    for (LookUpModel lookUpModel : model.getLookUpFilters()) {
                        lookUpModel.setPresetFilter(MMPresetFilterStore.getPresetFilterByFolder(this.mContext, sticker.getImageFolderPath() + "/" + lookUpModel.getFolder()));
                        sticker.setStickerType("FACE_LOOK_UP_TYPE");
                        sticker.setTriggerType(lookUpModel.getTriggerType());
                        sticker.setLookUpModel(lookUpModel);
                        sticker.setHiddenTriggerType(lookUpModel.getHiddenTriggerType());
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d")) {
                    sticker.setXengineEsPath(model.getXengineEsPath());
                    this.useBlendFilter = true;
                }
                if (sticker.isClearsBodyArea()) {
                    this.useBlendFilter = true;
                    this.enableSelfRender = false;
                    ++var4_16;
                }
                if (this.isBlendSticker(sticker)) {
                    this.useBlendFilter = true;
                }
                if (sticker.getAdditionalInfo() != null && sticker.getAdditionalInfo().getFacePositions() != null) {
                    sticker.isCutFaceSticker = true;
                }
                sticker.setModelType(model.getModelType());
                if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                    void var3_8;
                    ++var3_8;
                }
                this.addSticker(sticker);
                ++n2;
            }
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.b = this.mSwapFacialMaskSticker;
            }
            if (var4_16 > 0) {
                SegmentHelper.setSegmentCount((int)var4_16);
            }
            if (!TextUtils.isEmpty((CharSequence)model.getSoundPath())) {
                ++object5;
            }
            if (this.enableSoundPool) {
                if (!TextUtils.isEmpty((CharSequence)model.getSound()) && this.soundPlayer == null) {
                    this.soundPlayer = new MediaPlayer();
                    this.soundPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)new aj(this));
                    this.soundPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)new ak(this));
                    this.soundPlayer.setAudioStreamType(3);
                    try {
                        this.soundPlayer.setDataSource(model.getSoundPath());
                        this.soundPlayer.prepareAsync();
                    }
                    catch (Exception exception) {
                        MDLog.e((String)"FilterProcess", (String)"MediaPlayerDataSourceHelper.setMediaPlayerDataSource Error");
                        this.soundPlayer.release();
                        this.soundPlayer = null;
                    }
                }
                this.tryLoadSound(model, (int)object5);
            }
        } else if (model.getModelType() == 4) {
            if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.b) {
                return;
            }
            this.clearMaskWithModelType(model.getModelType());
            this.mPollGroupNum = model.getPollGroupNum();
            int n6 = 0;
            for (Sticker sticker : model.getStickers()) {
                object = TextUtils.isEmpty((CharSequence)sticker.getObjectTriggerType()) ? "" : sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + object + n6);
                sticker.setTriggerRegion(model.getTriggerRegion());
                sticker.setModelType(model.getModelType());
                sticker.setFrameRate(model.getFrameRate());
                if ("object_follower".equals(sticker.getLayerType()) && !sticker.isDonotTrack()) {
                    sticker.setDuration(99999999999L);
                } else {
                    sticker.setDuration(model.getDuration());
                }
                this.addSticker(sticker);
                ++n6;
            }
        } else if (model.getModelType() == 6) {
            this.mPollGroupNum = model.getPollGroupNum();
            if (this.mMultiStickerMaskFilter == null) {
                this.mMultiStickerMaskFilter = new z(this.mContext);
                this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
            }
            for (Sticker sticker : model.getStickers()) {
                sticker.setDuration(99999999999L);
                sticker.setFrameRate(model.getFrameRate());
                String string = sticker.getObjectTriggerType();
                sticker.setStickerType(model.getModelType() + "_" + string);
                if (string != null && string.equals("game_over")) {
                    sticker.setType(5);
                    sticker.setAlwaysShow(true);
                    object = new AbsolutePosition();
                    ObjectRegion objectRegion = new ObjectRegion();
                    new ObjectRegion().x = 0.5f;
                    objectRegion.y = 0.25f;
                    objectRegion.w = sticker.getImageWidth();
                    objectRegion.h = sticker.getImageHeight();
                    ViewPortProportion viewPortProportion = new ViewPortProportion();
                    new ViewPortProportion().height = 1920;
                    viewPortProportion.width = 1080;
                    ((AbsolutePosition)object).setCenter(objectRegion);
                    ((AbsolutePosition)object).setViewport(viewPortProportion);
                    sticker.setAbsolutePos((AbsolutePosition)object);
                } else {
                    sticker.isGameSticker = true;
                    sticker.setLayerType("face");
                    sticker.setGroupNumber(this.groupNumber);
                    sticker.setAlwaysShow(true);
                }
                this.addSticker(sticker);
            }
            ++this.groupNumber;
            if (this.enableSoundPool) {
                if (this.soundPool == null) {
                    this.soundPool = new SoundPool(5, 3, 5);
                }
                if (this.soundPool != null) {
                    if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
                        model.setSoundId(this.soundPool.load(model.getSoundPath(), 999));
                        this.soundPool.play(model.getSoundId(), 1.0f, 1.0f, 1, 1, 1.0f);
                        this.soundIds.add(model.getSoundId());
                    }
                    this.soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)new al(this));
                    for (Sticker sticker : model.getStickers()) {
                        if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                        sticker.setSoundId(this.soundPool.load(sticker.getSoundPath(), 999));
                        this.soundIds.add(sticker.getSoundId());
                    }
                }
            }
        } else {
            this.addCommonModel(model);
        }
        if (model.getEffectList() != null) {
            this.addEffectProcessFilter(model);
        }
        if (model.getDistortionList() != null) {
            for (Mask mask : model.getDistortionList()) {
                if (mask.getHidingObjectTriggerType() == null) continue;
                this.mDistorationMask = mask;
                this.mFaceThinValue = this.mDistorationMask.getStrength();
                this.mBigEyeValue = this.mDistorationMask.getStrengthB();
                break;
            }
        }
        if (model.getBeautyFace() != null && this.mDistorationMask != null) {
            this.mBeautyFace = model.getBeautyFace();
        }
        if (model.getAdditionalInfo() != null) {
            void var1_1;
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                Iterator<i> iterator = this.face3DMaskFilters.iterator();
                while (iterator.hasNext()) {
                    iterator.next().k = model.getAdditionalInfo();
                }
            }
            if (var1_1.getAdditionalInfo().isObjectDetectEnable()) {
                this.startGestureDetect();
            }
        }
        this.useBlendFilter = false;
    }

    private void addEffectProcessFilter(MaskModel model) {
        if (this.mEffectGroupFilter == null) {
            this.mEffectGroupFilter = new f();
            this.mEffectGroupFilter.a = new am(this);
            this.addTerminalFilter((BasicFilter)this.mEffectGroupFilter);
        }
        for (EffectFilterItem effectFilterItem : model.getEffectList()) {
            effectFilterItem.setModelType(model.getModelType());
            this.mEffectGroupFilter.a(effectFilterItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addCommonModel(MaskModel model) {
        if (model.getAdditionalInfo() != null && model.getAdditionalInfo().isComic()) {
            List<Sticker> list = model.getStickers();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<Sticker> iterator = list.iterator();
            while (iterator.hasNext()) {
                Sticker sticker = iterator.next();
                if (!"FACE_MASK_TYPE".equals(sticker.getStickerType())) continue;
                arrayList.add(sticker);
                iterator.remove();
            }
            list.addAll(arrayList);
            model.setStickers(list);
        }
        this.mPollGroupNum = model.getPollGroupNum();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Sticker sticker : model.getStickers()) {
            if ("audio_visualizer".equals(sticker.getResourceType())) continue;
            if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                sticker.setStickerType("FACE_MASK_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                sticker.setStickerType("FACE_LOOK_UP_TYPE");
            } else if (!TextUtils.isEmpty((CharSequence)sticker.getStickerType()) && sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                sticker.setStickerType("STICKER_TYPE_VOICE");
            } else if (TextUtils.isEmpty((CharSequence)sticker.getStickerType())) {
                sticker.setStickerType(model.getModelType() + "_" + n2);
            }
            sticker.setModelType(model.getModelType());
            sticker.setFrameRate(model.getFrameRate());
            if (sticker.getDuration() == 0L) {
                sticker.setDuration(99999999999L);
            }
            if ("3d".equals(sticker.getLayerType())) {
                this.useBlendFilter = true;
                sticker.setXengineEsPath(model.getXengineEsPath());
            }
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
                ++n3;
            }
            if (this.isBlendSticker(sticker)) {
                this.useBlendFilter = true;
            }
            if (!TextUtils.isEmpty((CharSequence)sticker.getSound())) {
                ++n4;
            }
            this.addSticker(sticker);
            ++n2;
        }
        if (n3 > 0) {
            SegmentHelper.setSegmentCount((int)n3);
        }
        if (!TextUtils.isEmpty((CharSequence)model.getSound())) {
            ++n4;
        }
        if (this.enableSoundPool) {
            void var1_1;
            this.tryLoadSound((MaskModel)var1_1, n4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void updateSoundPoolLoadedStatus(SoundPool pool, int sampleId, int status) {
        void var3_3;
        a a2;
        MDLog.d((String)"media", (String)("update loadedStatus cur id=" + sampleId));
        if (a2 != null && sampleId > 0 && var3_3 == false) {
            void var2_2;
            a2 = this.soundInfoMap.get(sampleId);
            if (a2 == null) {
                a2 = new a();
                new a().a = sampleId;
                a2.b = true;
                this.soundInfoMap.put(sampleId, a2);
                MDLog.d((String)"media", (String)("[SoundPool]sticker is not playing, so put info to map id=" + sampleId));
                return;
            }
            MDLog.d((String)"media", (String)("[SoundPool]sticker is playing now , so execute runable id=" + (int)var2_2));
            a2.b = true;
            if (a2.c != null) {
                a2.c.run();
                a2.c = null;
            }
        }
    }

    private synchronized void clearAllSoundPoolInfo() {
        MDLog.d((String)"media", (String)"[SoundPool]clear all soundInfo ");
        this.soundInfoMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void setRunableCalledWhenLoaded(int sampleId, Runnable runable) {
        MDLog.d((String)"media", (String)("[SoundPool] set runable info id = " + sampleId));
        if (sampleId > 0 && runable != null) {
            void var1_1;
            void var2_2;
            a a2 = this.soundInfoMap.get(sampleId);
            if (a2 != null && a2.b) {
                MDLog.d((String)"media", (String)"[SoundPool] sample is is loaded , execute runable   + sampleid=", (Object[])new Object[]{sampleId});
                runable.run();
                return;
            }
            MDLog.d((String)"media", (String)"[SoundPool] sample is not loaded, just update it ");
            if (a2 == null) {
                a2 = new a();
            }
            a2.a = sampleId;
            a2.c = var2_2;
            this.soundInfoMap.put((int)var1_1, a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryLoadSound(MaskModel model, int soundSize) {
        this.clearAllSoundPoolInfo();
        if (this.soundPool != null) {
            void var1_1;
            void var2_3;
            for (Integer object : this.soundIds) {
                this.soundPool.unload(object.intValue());
            }
            this.soundPool.release();
            this.soundPool = new SoundPool((int)var2_3, 3, 5);
            this.soundPool.setOnLoadCompleteListener((SoundPool.OnLoadCompleteListener)new an(this));
            for (Sticker sticker : var1_1.getStickers()) {
                if (TextUtils.isEmpty((CharSequence)sticker.getSound())) continue;
                int n2 = this.soundPool.load(sticker.getSoundPath(), 999);
                MDLog.e((String)"media", (String)("[SoundPool]load tag is " + n2));
                sticker.setSoundId(n2);
                this.soundIds.add(sticker.getSoundId());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBlendSticker(Sticker sticker) {
        void var1_1;
        return sticker.getBlendMode() != null && !TextUtils.isEmpty((CharSequence)var1_1.getBlendMode().a);
    }

    public float getThinFace() {
        return this.mThinFace;
    }

    /*
     * WARNING - void declaration
     */
    public void setThinFace(float thinFace) {
        void var1_1;
        this.mThinFace = var1_1;
    }

    public float getBigEye() {
        return this.mBigEye;
    }

    /*
     * WARNING - void declaration
     */
    public void setBigEye(float bigEye) {
        void var1_1;
        this.mBigEye = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFaceDetectFilter(l filter) {
        Object object = this.getLockObject();
        synchronized (object) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFinishListener(StickerMaskFinishListener finishListener) {
        void var1_1;
        this.finishListener = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void addSticker(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2;
            sticker.curIndex = 0;
            if (sticker.isClearsBodyArea()) {
                this.useBlendFilter = true;
            }
            if (sticker.getTriggerType() > 0) {
                this.filterTriggerManager.setTriggerType(sticker.getTriggerType());
            }
            if (sticker.getHiddenTriggerType() > 0) {
                this.filterTriggerManager.setHiddenTriggerType(sticker.getHiddenTriggerType());
            }
            if ((object2 = this.mStickerFilterMap.get(sticker.getStickerType())) == null) {
                if (sticker.getStickerType().equals("STICKER_TYPE_VOICE")) {
                    object2 = new ag();
                    this.mSoundInput = (ag)((Object)object2);
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type STICKER_TYPE_VOICE SoundInputFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("object_follower") && !sticker.isHaniSticker) {
                    object2 = new bb(this.mContext, sticker);
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type LAYER_TYPE_GESTURE StickerGestureMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_MASK_TYPE")) {
                    if (this.mSwapFacialMaskSticker == null) {
                        this.mSwapFacialMaskSticker = new ArrayList<Sticker>();
                    }
                    this.mFaceMaskFilter = new o(sticker);
                    object2 = this.mFaceMaskFilter;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_MASK_TYPE FaceMaskFilter !!!");
                } else if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("3d") && MediaModuleGlobalConfig.hasXE()) {
                    if (this.face3DMaskFilters == null) {
                        this.face3DMaskFilters = new ArrayList<i>();
                    }
                    object2 = new i(sticker, this.isCameraFront, this.mContext);
                    this.face3DMaskFilters.add((i)((Object)object2));
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_3D_MASK_TYPE Face3DMaskFilter !!!");
                } else if (sticker.getStickerType().equals("FACE_LOOK_UP_TYPE")) {
                    if (null != sticker.getLookUpModel() && null != sticker.getLookUpModel().getPresetFilter()) {
                        object2 = sticker.getLookUpModel().getPresetFilter().getFilterGroup();
                        this.mLookupFilter = (SingleLineGroupFilter)object2;
                    } else {
                        object2 = new NormalFilter();
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type FACE_LOOK_UP_TYPE !!!");
                } else if (this.useBlendFilter && (sticker.getStickerType() == null || !sticker.getStickerType().startsWith("weex")) || sticker.isComic()) {
                    if (sticker.getEtcTextureBatch() != null) {
                        object2 = new aw(sticker);
                    } else {
                        sticker.getImageProvider();
                        object2 = new bg(this.mContext, sticker);
                    }
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                } else {
                    if (this.mMultiStickerMaskFilter == null) {
                        MDLog.e((String)"FilterProcess", (String)"optimization");
                        this.mMultiStickerMaskFilter = sticker.isCutFaceSticker ? new y(this.mContext) : new aa(this.mContext);
                        this.mMultiStickerMaskFilter.a(this.mPollGroupNum);
                        this.addTerminalMultiStickerFilter(this.mMultiStickerMaskFilter);
                    }
                    if (this.mMultiStickerMaskFilter != null) {
                        if (!TextUtils.isEmpty((CharSequence)sticker.getLayerType()) && sticker.getLayerType().equals("native")) {
                            return;
                        }
                        if (this.mMultiStickerMaskFilter.a(sticker)) {
                            return;
                        }
                        this.mMultiStickerMaskFilter.a(sticker, new ao(this, sticker));
                        this.mMultiStickerMaskFilter.n = new aq(this);
                        object2 = null;
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type MultiStickerMaskFilter !!!");
                    } else if (sticker.getStickerType().startsWith("weex")) {
                        object2 = new bi(sticker);
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type WeexStickerMaskFilter !!!");
                    } else {
                        if (sticker.getEtcTextureBatch() != null) {
                            object2 = new aw(sticker);
                        } else {
                            sticker.getImageProvider();
                            object2 = new bg(this.mContext, sticker);
                        }
                        MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerMaskFilter !!!");
                    }
                }
                if (object2 != null) {
                    MDLog.i((String)"FilterProcess", (String)" Sticker Type StickerBlendFilter !!!");
                    object2 = new StickerBlendFilter((BasicFilter)object2, sticker);
                    ((StickerBlendFilter)((Object)object2)).setSegmentBody(sticker.isClearsBodyArea());
                    ((StickerBlendFilter)((Object)object2)).setSegmentStrokeColor(sticker.getStrokeColor());
                    ((StickerBlendFilter)((Object)object2)).setSegmentStrokeRadius(sticker.getStrokeRadius());
                    ((StickerBlendFilter)((Object)object2)).stickerStateChangeListener = new ar(this, sticker);
                    this.mStickerFilterMap.put(sticker.getStickerType(), (StickerBlendFilter)((Object)object2));
                    this.addTerminalBlendFilter((StickerBlendFilter)((Object)object2));
                    ((StickerBlendFilter)((Object)object2)).sticker = sticker;
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = sticker.getDuration() > 0L ? sticker.getDuration() : 30000000L;
                    ((StickerBlendFilter)((Object)object2)).setFinishListener(new ai(this, sticker));
                }
            } else if (null != sticker.getImageFolderPath() && sticker.getImageFolderPath().equals(((StickerBlendFilter)((Object)object2)).sticker.getImageFolderPath())) {
                if (sticker.getStickerType().equals("FACE_MASK_TYPE") && sticker.getMask().swapFacialMask) {
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = 30000000L;
                    if (sticker.getMask().swapFacialMask) {
                        this.mSwapFacialMaskSticker.add(sticker);
                    }
                } else {
                    ((StickerBlendFilter)((Object)object2)).mStickerDuration = ((StickerBlendFilter)((Object)object2)).mStickerDuration - ((StickerBlendFilter)((Object)object2)).getEscapedTime() + sticker.getDuration();
                }
            } else {
                void var1_1;
                ((StickerBlendFilter)((Object)object2)).sticker = sticker;
                ((StickerBlendFilter)((Object)object2)).resetSticker(sticker);
                ((StickerBlendFilter)((Object)object2)).mStickerDuration = sticker.getDuration() > 0L ? var1_1.getDuration() : 30000000L;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void removeStickerFilter(Sticker sticker) {
        Object object = this.getLockObject();
        synchronized (object) {
            StickerBlendFilter stickerBlendFilter = this.mStickerFilterMap.get(sticker.getStickerType());
            stickerBlendFilter.setFinishListener(null);
            if (stickerBlendFilter == null) {
                return;
            }
            this.removeStickerBlendFilter(stickerBlendFilter);
            this.mStickerFilterMap.remove(sticker.getStickerType());
            this.filtersToDestroy.add((GLRenderer)stickerBlendFilter);
            if (this.finishListener != null) {
                void var1_1;
                int n2 = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n2, (Sticker)var1_1);
            }
            return;
        }
    }

    private void removeStickerBlendFilter(StickerBlendFilter filter) {
        StickerBlendFilter stickerBlendFilter;
        BasicFilter basicFilter = filter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter((BasicFilter)filter);
            this.registerTerminalFilter(basicFilter);
            basicFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = basicFilter;
            return;
        }
        this.removeFilter((BasicFilter)filter);
        if (filter.getTargets().get(0) instanceof StickerBlendFilter) {
            stickerBlendFilter = (StickerBlendFilter)((Object)stickerBlendFilter.getTargets().get(0));
            v0.parentFilter = basicFilter;
            basicFilter.addTarget((GLTextureInputRenderer)stickerBlendFilter);
            return;
        }
        stickerBlendFilter = (BasicFilter)stickerBlendFilter.getTargets().get(0);
        v1.parentFilter = basicFilter;
        basicFilter.addTarget((GLTextureInputRenderer)stickerBlendFilter);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalFilter(BasicFilter filter) {
        void var1_1;
        this.mTerminalFilter.removeTarget((GLTextureInputRenderer)this);
        this.mTerminalFilter.addTarget((GLTextureInputRenderer)filter);
        filter.parentFilter = this.mTerminalFilter;
        this.removeTerminalFilter(this.mTerminalFilter);
        this.registerFilter(this.mTerminalFilter);
        this.mTerminalFilter = filter;
        var1_1.addTarget((GLTextureInputRenderer)this);
        this.registerTerminalFilter(this.mTerminalFilter);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalMultiStickerFilter(BasicFilter filter) {
        void var1_1;
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            this.insertSpecifiedPosition(this.mTerminalFilter, filter);
            return;
        }
        this.addTerminalFilter((BasicFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void insertSpecifiedPosition(BasicFilter destFilter, BasicFilter filter) {
        void var1_1;
        void var2_2;
        BasicFilter basicFilter = destFilter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)destFilter);
        basicFilter.addTarget((GLTextureInputRenderer)filter);
        this.registerFilter(filter);
        filter.parentFilter = basicFilter;
        destFilter.parentFilter = filter;
        var2_2.addTarget((GLTextureInputRenderer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addTerminalBlendFilter(StickerBlendFilter blendFilter) {
        void var1_1;
        if (this.mTerminalFilter == this.mEffectGroupFilter) {
            if (this.mMultiStickerMaskFilter != null) {
                this.insertSpecifiedPosition(this.mMultiStickerMaskFilter, (BasicFilter)blendFilter);
                return;
            }
            this.insertSpecifiedPosition(this.mTerminalFilter, (BasicFilter)blendFilter);
            return;
        }
        if (this.mTerminalFilter == this.mMultiStickerMaskFilter && blendFilter.segmentFilter != null) {
            this.insertSpecifiedPosition(this.mTerminalFilter, (BasicFilter)blendFilter);
            return;
        }
        this.addTerminalFilter((BasicFilter)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void drawTrackerSticker(StickerBlendFilter filter, l.a param) {
        void var2_2;
        filter.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawFixedSticker(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        float f2;
        Sticker sticker = filter.sticker;
        float f3 = (float)this.getWidth() / 2.0f;
        float f4 = sticker.isShowTop() ? (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f : (float)this.getHeight() - (float)sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f3 / (float)this.getWidth(), f4 / (float)this.getHeight());
        param.a = f4 = (f2 = (float)sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f));
        param.b = f2;
        param.l = pointF;
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawFullScreenFixed(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        float f2;
        float f3 = (float)this.getWidth() / 2.0f;
        float f4 = ((float)this.getHeight() - (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale()) / 2.0f + (float)filter.sticker.getImageHeight() * this.getAdjustHeightScale() / 2.0f;
        PointF pointF = new PointF(f3 / (float)this.getWidth(), f4 / (float)this.getHeight());
        if (filter.sticker.getImageWidth() > 360) {
            f4 = 2.0f;
            f2 = 2.0f;
        } else if (this.getWidth() == 720) {
            f4 = 2.0f;
            f2 = 2.0f;
        } else {
            f4 = 1.5f;
            f2 = 1.5f;
        }
        param.a = f4;
        param.b = f2;
        param.l = pointF;
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawPositionSetFixed(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        float f2 = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f);
        param.b = (float)this.getHeight() / (float)filter.sticker.getImageHeight() * f2;
        param.a = (float)this.getWidth() / (float)filter.sticker.getImageWidth() * f2;
        param.l = new PointF(0.5f, 0.5f);
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostion(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        float f2 = (float)filter.sticker.getImageWidth() * this.getAdjustHeightScale() / ((float)this.getWidth() / 2.0f);
        if (absolutePosition != null && absolutePosition.getCenter() != null) {
            float f3 = (float)this.getWidth() * absolutePosition.getCenter().x;
            float f4 = (float)this.getHeight() * absolutePosition.getCenter().y;
            param.l = new PointF(f3 / (float)this.getWidth(), f4 / (float)this.getHeight());
        } else {
            param.l = new PointF(0.5f, 0.5f);
        }
        param.a = f2;
        param.b = f2;
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsolutePostionUseStcikerDim(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        float f2 = (float)filter.sticker.getImageWidth() * ((float)this.getHeight() / (float)filter.sticker.getBaseDemensionHeight()) / ((float)this.getWidth() / 2.0f);
        if (absolutePosition != null && absolutePosition.getCenter() != null) {
            float f3 = (float)this.getWidth() * absolutePosition.getCenter().x;
            float f4 = (float)this.getHeight() * absolutePosition.getCenter().y;
            param.l = new PointF(f3 / (float)this.getWidth(), f4 / (float)this.getHeight());
        } else {
            param.l = new PointF(0.5f, 0.5f);
        }
        param.a = f2;
        param.b = f2;
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawAbsPostionAdjustResolution(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        float f2 = (float)this.getWidth() > 480.0f ? (float)this.getWidth() / 352.0f : 1.0f;
        f2 = (float)filter.sticker.getImageWidth() / ((float)this.getWidth() / 2.0f) * f2;
        AbsolutePosition absolutePosition = filter.sticker.getAbsolutePos();
        param.l = absolutePosition != null && absolutePosition.getCenter() != null ? new PointF(absolutePosition.getCenter().x, absolutePosition.getCenter().y) : new PointF(0.5f, 0.5f);
        param.a = f2;
        param.b = f2;
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawScaleCenterCrop(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        float f2 = filter.sticker.getImageWidth();
        float f3 = filter.sticker.getImageHeight();
        f2 = f2 * (float)this.getHeight() > (float)this.getWidth() * f3 ? (float)this.getHeight() / f3 : (float)this.getWidth() / f2;
        param.a = f2 * 2.0f;
        param.b = f2 * 2.0f;
        param.l = new PointF(0.5f, 0.5f);
        param.h = 0.0f;
        param.n = this.filterTriggerManager;
        var1_1.setDetectParam((l.a)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void drawGestureFilter(StickerBlendFilter filter, l.a param) {
        void var2_2;
        void var1_1;
        if (filter.sticker.isDonotTrack()) {
            this.drawGestureFixedFilter(filter, param);
            return;
        }
        this.drawGestureTrackingFilter((StickerBlendFilter)var1_1, (l.a)var2_2);
    }

    private void drawGestureFixedFilter(StickerBlendFilter filter, l.a param) {
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (this.mmcvBoxes == null || this.mmcvBoxes.getDetectResult() == null || this.mmcvBoxes.getDetectResult().length == 0) {
            param.n = this.filterTriggerManager;
            param.l = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.j = filter.sticker.getObjectTriggerType();
        for (MMBox mMBox : this.mmcvBoxes.getDetectResult()) {
            if (mMBox.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)mMBox.class_name_) || !mMBox.class_name_.equals(param.j)) continue;
            param.k = new RectF((float)mMBox.x_, (float)mMBox.y_, (float)(mMBox.x_ + mMBox.width_), (float)(mMBox.y_ + mMBox.height_));
            param.n = this.filterTriggerManager;
            param.l = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updateRectForTrigger(PointF center, float angle, float scale, boolean forceUpdate, int haniId) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                void var3_4;
                void var1_1;
                void var2_3;
                l.a a2 = new l.a();
                new l.a().h = var2_3;
                a2.l = new PointF(center.x, var1_1.y);
                a2.j = "tracking_rect";
                a2.b = 0.5f * scale;
                a2.a = 0.5f * var3_4;
                this.mMultiStickerMaskFilter.a(a2, haniId);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawGestureTrackingFilter(StickerBlendFilter filter, l.a param) {
        if (this.mGestureTrackingFilter != null && this.mGestureTrackingFilter.b) {
            return;
        }
        if (null == filter.sticker.getObjectTriggerType()) {
            return;
        }
        if (this.mmcvBoxes == null || null == this.mmcvBoxes.getDetectResult() || this.mmcvBoxes.getDetectResult().length == 0) {
            param.n = this.filterTriggerManager;
            param.l = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            return;
        }
        param.j = filter.sticker.getObjectTriggerType();
        for (Object object : this.mmcvBoxes.getDetectResult()) {
            Object object2;
            if (object.class_index_ <= 0 || TextUtils.isEmpty((CharSequence)object.class_name_) || !object.class_name_.equals(param.j)) continue;
            object = new RectF((float)object.x_, (float)object.y_, (float)(object.x_ + object.width_), (float)(object.y_ + object.height_));
            param.k = object;
            this.mmcvRect = new MMRect();
            if (filter.sticker.getTrackingRegion() != null) {
                object2 = filter.sticker.getTrackingRegion();
                object = new RectF((RectF)object);
                this.mmcvRect.x_ = (int)(object.left + object.width() * ((ObjectRegion)object2).x);
                this.mmcvRect.y_ = (int)(object.top + object.height() * ((ObjectRegion)object2).y);
                this.mmcvRect.width_ = (int)((float)this.mmcvRect.x_ + object.width() * ((ObjectRegion)object2).w);
                this.mmcvRect.height_ = (int)((float)this.mmcvRect.y_ + object.height() * ((ObjectRegion)object2).h);
            } else {
                this.mmcvRect.x_ = (int)object.left;
                this.mmcvRect.y_ = (int)object.top;
                this.mmcvRect.width_ = (int)(object.right - object.left);
                this.mmcvRect.height_ = (int)(object.bottom - object.top);
            }
            if (this.mGestureTrackingFilter != null) {
                object2 = this.mmcvRect;
                object = this.mGestureTrackingFilter;
                Object object3 = object.getLockObject();
                synchronized (object3) {
                    object.d = object2;
                }
            }
            param.n = this.filterTriggerManager;
            param.l = new PointF(0.0f, 0.0f);
            filter.setDetectParam(param);
            if (this.mGestureTrackingFilter == null) continue;
            object = this.mGestureTrackingFilter;
            object2 = object.getLockObject();
            synchronized (object2) {
                object.a = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMMCVInfo(MMCVInfo mmcvInfo) {
        if (mmcvInfo == null) {
            return;
        }
        this.mCurCVInfo = mmcvInfo;
        Object object = this.getLockObject();
        synchronized (object) {
            Object object2;
            int n2;
            if (this.mFaceMaskFilter != null) {
                this.mFaceMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.mStickerFilterMap != null && this.mStickerFilterMap.size() > 0) {
                for (StickerBlendFilter object3 : this.mStickerFilterMap.values()) {
                    if (object3.segmentFilter == null) continue;
                    object3.setMMCVInfo(mmcvInfo);
                }
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.expressDetector != null) {
                MMCVInfo n22 = mmcvInfo;
                com.momo.mcamera.mask.c.a a2 = this.expressDetector;
                if (!a2.f.get()) {
                    a2.h.setFormat(17);
                    a2.h.setWidth(n22.width);
                    a2.h.setHeight(n22.height);
                    a2.h.setStep_(n22.width);
                    a2.b = ByteBuffer.wrap(n22.frameData);
                    a2.i.setFlipedShow(n22.isFrontCamera);
                    a2.i.setRotateDegree(n22.cameraDegree);
                    a2.i.setRestoreDegree(n22.restoreDegree);
                    a2.i.setOriginFaceRects(n22.getOriginFaceRects());
                    a2.i.setOriginLandmarks96(n22.getOriginLandmarks96());
                    Object stickerBlendFilter = a2.c;
                    synchronized (stickerBlendFilter) {
                        a2.c.notify();
                    }
                }
            }
            if (this.gestureDetector != null) {
                this.gestureDetector.a(mmcvInfo);
            }
            if (this.mGestureTrackingFilter != null) {
                this.mGestureTrackingFilter.setMMCVInfo(mmcvInfo);
            }
            this.processDistortionState();
            boolean bl = true;
            boolean bl2 = false;
            if (mmcvInfo.getMaxFaceCnt() <= 0) {
                bl = false;
                this.lastFacesCnt = 0;
            } else if (this.multiSwitchEnable) {
                n2 = this.calculateFaceIndex(mmcvInfo);
                object2 = mmcvInfo.getFaceAttributeInfo(n2).getLandmarks68();
                this.lastFacePosition.set(object2[0], object2[68]);
                this.lastFacesCnt = mmcvInfo.getMaxFaceCnt();
            }
            this.filterTriggerManager.setTriggerFaceIndex(n2);
            this.filterTriggerManager.adjustStateBy(mmcvInfo);
            if (this.mMultiStickerMaskFilter != null) {
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(bl);
                }
                this.mMultiStickerMaskFilter.d(n2);
                this.mMultiStickerMaskFilter.k = this.filterTriggerManager;
                this.mMultiStickerMaskFilter.a(this.mmcvBoxes);
                this.mMultiStickerMaskFilter.setMMCVInfo(mmcvInfo);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                object2 = this.face3DMaskFilters.iterator();
                while (object2.hasNext()) {
                    i i2 = (i)((Object)object2.next());
                    if (!i2.a()) continue;
                    i2.setMMCVInfo(mmcvInfo);
                }
            }
            if (mmcvInfo.getMaxFaceCnt() == 0) {
                for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                    l.a a2 = new l.a();
                    if (!TextUtils.isEmpty((CharSequence)stickerBlendFilter.sticker.getLayerType()) && stickerBlendFilter.sticker.getLayerType().equals("object_follower")) {
                        stickerBlendFilter.clearPoints();
                        this.drawGestureFilter(stickerBlendFilter, a2);
                        continue;
                    }
                    if (!stickerBlendFilter.sticker.isAlwaysShow()) {
                        stickerBlendFilter.clearPoints();
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 1) {
                        stickerBlendFilter.clearPoints();
                        this.drawFixedSticker(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 2) {
                        stickerBlendFilter.clearPoints();
                        this.drawFullScreenFixed(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 3) {
                        stickerBlendFilter.clearPoints();
                        this.drawPositionSetFixed(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 99) {
                        stickerBlendFilter.clearPoints();
                        this.drawScaleCenterCrop(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 5) {
                        stickerBlendFilter.clearPoints();
                        this.drawAbsolutePostion(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() == 6) {
                        stickerBlendFilter.clearPoints();
                        this.drawAbsolutePostionUseStcikerDim(stickerBlendFilter, a2);
                        continue;
                    }
                    if (stickerBlendFilter.sticker.getType() != 7) continue;
                    stickerBlendFilter.clearPoints();
                    this.drawAbsPostionAdjustResolution(stickerBlendFilter, a2);
                }
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(false);
                }
            } else {
                if (this.stickerStateChangeListener != null) {
                    this.stickerStateChangeListener.faceDetected(true);
                }
                for (int i2 = mmcvInfo.getMaxFaceCnt() - 1; i2 >= 0; --i2) {
                    for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                        float f2;
                        float f3;
                        float f4;
                        Sticker sticker = stickerBlendFilter.sticker;
                        l.a a3 = new l.a();
                        new l.a().m = this.mmcvBoxes;
                        if (!TextUtils.isEmpty((CharSequence)stickerBlendFilter.sticker.getLayerType()) && stickerBlendFilter.sticker.getLayerType().equals("object_follower")) {
                            stickerBlendFilter.clearPoints();
                            this.drawGestureFilter(stickerBlendFilter, a3);
                            continue;
                        }
                        if (sticker.getType() == 1) {
                            stickerBlendFilter.clearPoints();
                            this.drawFixedSticker(stickerBlendFilter, a3);
                            continue;
                        }
                        if (sticker.getType() == 2) {
                            stickerBlendFilter.clearPoints();
                            this.drawFullScreenFixed(stickerBlendFilter, a3);
                            continue;
                        }
                        if (sticker.getType() == 3) {
                            stickerBlendFilter.clearPoints();
                            this.drawPositionSetFixed(stickerBlendFilter, a3);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 99) {
                            stickerBlendFilter.clearPoints();
                            this.drawScaleCenterCrop(stickerBlendFilter, a3);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 5) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsolutePostion(stickerBlendFilter, a3);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 6) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsolutePostionUseStcikerDim(stickerBlendFilter, a3);
                            continue;
                        }
                        if (stickerBlendFilter.sticker.getType() == 7) {
                            stickerBlendFilter.clearPoints();
                            this.drawAbsPostionAdjustResolution(stickerBlendFilter, a3);
                            continue;
                        }
                        if (sticker.getType() != 0) continue;
                        stickerBlendFilter.clearPoints();
                        FaceAttributeInfo faceAttributeInfo = mmcvInfo.getFaceAttributeInfo(i2);
                        float[] fArray = faceAttributeInfo.getLandmarks68();
                        float f5 = fArray[sticker.getFacePositionLeft()];
                        float f6 = fArray[sticker.getFacePositionLeft() + 68];
                        float f7 = fArray[sticker.getFacePositionRight()];
                        float f8 = fArray[sticker.getFacePositionRight() + 68];
                        PointF pointF = new PointF(f5, f6);
                        PointF pointF2 = new PointF(f7, f8);
                        f7 = faceAttributeInfo.getFaceRotateDegree_2d();
                        PointF pointF3 = new PointF((float)sticker.getOffsetX() * this.getAdjustWidthScale(), (float)sticker.getOffsetY() * this.getAdjustWidthScale());
                        this.rotatePoint(pointF3, f7);
                        if (sticker.hasCenterPoint()) {
                            faceAttributeInfo = new PointF(fArray[sticker.getCenterIndex()], fArray[sticker.getCenterIndex() + 68]);
                        } else if (sticker.getPointIndexes().length == 1) {
                            int n3 = sticker.getPointIndexes()[0];
                            f4 = fArray[n3];
                            f3 = fArray[n3 + 68];
                            faceAttributeInfo = new PointF(f4, f3);
                        } else {
                            int n4 = sticker.getPointIndexes()[0];
                            int n5 = sticker.getPointIndexes()[1];
                            f3 = fArray[n4];
                            f2 = fArray[n4 + 68];
                            float f9 = fArray[n5];
                            float f10 = fArray[n5 + 68];
                            faceAttributeInfo = this.getCenterPoint(new PointF(f3, f2), new PointF(f9, f10));
                        }
                        float f11 = (float)this.getmDistancePoint(pointF, pointF2);
                        f4 = f11 / 180.0f / this.getAdjustWidthScale();
                        f3 = this.getWidth() / 2;
                        f2 = (float)sticker.getImageWidth() * this.getAdjustWidthScale() / f3;
                        faceAttributeInfo.x += pointF3.x * (f11 / 180.0f) / this.getAdjustWidthScale();
                        faceAttributeInfo.y += pointF3.y * (f11 / 180.0f) / this.getAdjustWidthScale();
                        faceAttributeInfo = new PointF(faceAttributeInfo.x / (float)this.getWidth(), faceAttributeInfo.y / (float)this.getHeight());
                        a3.a = f4 *= f2;
                        a3.b = f4;
                        if (sticker.isComic()) {
                            a3.l = faceAttributeInfo;
                            a3.h = f7 <= 90.0f && f7 >= 0.0f || f7 >= 270.0f && f7 <= 360.0f ? 0.0f : 180.0f;
                        } else {
                            a3.l = faceAttributeInfo;
                            a3.h = f7;
                        }
                        a3.c = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
                        a3.d = mmcvInfo.getFaceAttributeInfo(0).getLandmarks96();
                        a3.e = mmcvInfo.getFaceAttributeInfo(0).getLandmarks104();
                        a3.f = mmcvInfo.getFaceAttributeInfo(0).getWarpedLandmarks104();
                        a3.n = this.filterTriggerManager;
                        a3.i = mmcvInfo.getFaceAttributeInfo(0).getEulerAngles();
                        stickerBlendFilter.setDetectParam(a3);
                    }
                }
            }
            return;
        }
    }

    private void processDistortionState() {
        if (this.mDistorationMask != null) {
            if (!this.mFaceStateChange && this.mmcvBoxes != null) {
                MMBox[] mMBoxArray = this.mmcvBoxes.getDetectResult();
                int n2 = mMBoxArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!mMBoxArray[i2].class_name_.equals(this.mDistorationMask.getHidingObjectTriggerType())) continue;
                    this.mFaceStateChange = true;
                }
            }
            if (this.mFaceStateChange) {
                if (this.mDistorationMask.getStrengthStep() == 0.0f && this.mDistorationMask.getStrengthStepB() == 0.0f) {
                    this.mFaceBeauty = true;
                } else if (!this.mFaceBeauty) {
                    if (this.mFaceThinValue > 0.0f) {
                        this.mFaceThinValue -= this.mDistorationMask.getStrengthStep();
                    }
                    if (this.mBigEyeValue > 0.0f) {
                        this.mBigEyeValue -= this.mDistorationMask.getStrengthStepB();
                    }
                    if (this.mFaceThinValue <= 0.0f && this.mBigEyeValue <= 0.0f) {
                        this.mFaceBeauty = true;
                    }
                }
                if (this.mFaceBeauty && !this.mFaceBeautyHaveFinish) {
                    this.mFaceThinValue = this.mDistorationMask.getStrengthStep() == 0.0f ? this.mBeautyFace.getThinFaceValue() : (this.mFaceThinValue += this.mDistorationMask.getStrengthStep());
                    this.mBigEyeValue = this.mDistorationMask.getStrengthStepB() == 0.0f ? this.mBeautyFace.getBigEyeValue() : (this.mBigEyeValue += this.mDistorationMask.getStrengthStepB());
                    if (this.mFaceThinValue >= this.mBeautyFace.getThinFaceValue() && this.mBigEyeValue >= this.mBeautyFace.getBigEyeValue()) {
                        this.stickerStateChangeListener.distortionStateChanged(true, this.mBeautyFace.getThinFaceValue(), this.mBeautyFace.getBigEyeValue(), this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                        this.mFaceBeautyHaveFinish = true;
                        return;
                    }
                    this.stickerStateChangeListener.distortionStateChanged(true, this.mFaceThinValue, this.mBigEyeValue, this.mBeautyFace.getSkinSmoothingValue(), this.mBeautyFace.getSkinWhitenValue());
                    return;
                }
                this.stickerStateChangeListener.distortionStateChanged(false, this.mFaceThinValue, this.mBigEyeValue, 0.0f, 0.0f);
            }
        }
    }

    public synchronized void destroy() {
        for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
            stickerBlendFilter.cancelDraw();
            stickerBlendFilter.destroy();
        }
        if (this.mEffectGroupFilter != null) {
            this.mEffectGroupFilter.destroy();
        }
        if (this.mMultiStickerMaskFilter != null) {
            this.mMultiStickerMaskFilter.destroy();
        }
        super.destroy();
        if (this.mNormalFilter != null) {
            this.mNormalFilter.destroy();
        }
        if (this.gestureDetector != null) {
            this.gestureDetector.c();
        }
        this.gestureDetectorListener = null;
        this.stopExpressDetect();
        FacerigHelper.release();
        BodyLandHelper.release();
        SegmentHelper.release();
        FacerigHelper.releseFaceRigInfo();
        this.releaseSoundPlayer();
        if (this.mFaceMaskFilter != null) {
            this.mFaceMaskFilter.destroy();
        }
        if (this.mSwapFacialMaskSticker != null) {
            this.mSwapFacialMaskSticker.clear();
            this.mSwapFacialMaskSticker = null;
        }
        if (this.mLookupFilter != null) {
            this.mLookupFilter.destroy();
            this.mLookupFilter = null;
        }
        if (this.filtersToDestroy != null && this.filtersToDestroy.size() > 0) {
            Iterator<StickerBlendFilter> iterator = this.filtersToDestroy.iterator();
            while (iterator.hasNext()) {
                ((GLRenderer)iterator.next()).destroy();
            }
        }
        SharedExecutor.getInstance().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        Object object = this.getLockObject();
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            if (this.scaleWidth == 0) {
                this.scaleWidth = this.getWidth();
                this.scaleWidthRatio = 1.0f;
            } else if (this.getWidth() > 0) {
                this.scaleWidthRatio = (float)this.scaleWidth / (float)this.getWidth();
            }
            if (this.scaleHeight == 0) {
                this.scaleHeight = this.getHeight();
                this.scaleHeightRatio = 1.0f;
            } else if (this.getHeight() > 0) {
                this.scaleHeightRatio = (float)this.scaleHeight / (float)this.getHeight();
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.l = this.scaleWidthRatio;
                this.mMultiStickerMaskFilter.m = this.scaleHeightRatio;
            }
            if (this.enableSelfRender) {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                this.setTimeStamp(System.currentTimeMillis() - this.startTime);
            }
            Iterator<GLRenderer> iterator = this.filtersToDestroy.iterator();
            while (iterator.hasNext()) {
                iterator.next().destroy();
            }
            this.filtersToDestroy.clear();
            super.newTextureReady((int)var1_1, (GLTextureOutputRenderer)var2_3, (boolean)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long ms) {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setTimeStamp(ms);
        }
        if (this.mMultiStickerMaskFilter != null) {
            void var1_1;
            this.mMultiStickerMaskFilter.setTimeStamp((long)var1_1);
        }
        if (this.enableSelfRender) {
            this.setMMCVInfo(new MMCVInfo());
        }
    }

    public float getAdjustHeightScale() {
        if ((float)this.getHeight() == 640.0f) {
            return 1.0f;
        }
        return (float)this.getHeight() / 640.0f;
    }

    public float getAdjustWidthScale() {
        if ((float)this.getWidth() == 480.0f) {
            return 1.0f;
        }
        return (float)this.getWidth() / 480.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeSticker(String stickerType) {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.mMultiStickerMaskFilter != null) {
                void var1_1;
                this.mMultiStickerMaskFilter.a((String)var1_1);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void clearMaskWithModelType(int modelType) {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (StickerBlendFilter stickerBlendFilter : this.mStickerFilterMap.values()) {
                if (stickerBlendFilter.sticker.getModelType() != modelType) continue;
                stickerBlendFilter.setFinishListener(null);
                if (stickerBlendFilter == null) {
                    return;
                }
                this.removeStickerBlendFilter(stickerBlendFilter);
                this.filtersToDestroy.add((GLRenderer)stickerBlendFilter);
                if (this.finishListener != null) {
                    int n2 = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                    Sticker sticker = stickerBlendFilter.sticker;
                    this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n2, sticker);
                }
                this.mStickerFilterMap.remove(stickerBlendFilter.sticker.getStickerType());
                if (!(stickerBlendFilter.stickerMaskFilter instanceof i) || this.face3DMaskFilters == null) continue;
                this.face3DMaskFilters.remove((Object)stickerBlendFilter.stickerMaskFilter);
            }
            if (this.mMultiStickerMaskFilter != null) {
                this.mMultiStickerMaskFilter.c(modelType);
            }
            if (this.mEffectGroupFilter != null) {
                void var1_1;
                this.mEffectGroupFilter.a((int)var1_1);
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskFilters() {
        Object object = this.getLockObject();
        synchronized (object) {
            this.mPollGroupNum = 0;
            for (Object object2 : this.mStickerFilterMap.values()) {
                object2.setFinishListener(null);
                if (object2 == null) {
                    return;
                }
                this.removeStickerBlendFilter((StickerBlendFilter)((Object)object2));
                this.filtersToDestroy.add((GLRenderer)object2);
                if (this.finishListener == null) continue;
                int n2 = this.mBigEye > 0.0f ? 1 : (0.0f + this.mThinFace > 0.0f ? 1 : 0);
                object2 = object2.sticker;
                this.finishListener.stickerRenderFinished(this.mStickerFilterMap.size() + n2, (Sticker)object2);
            }
            if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
                this.face3DMaskFilters.clear();
                this.face3DMaskFilters = null;
            }
            if (BodyLandHelper.isUseBodyLand()) {
                BodyLandHelper.setUseBodyLand((boolean)false);
            }
            if (this.mMultiStickerMaskFilter != null) {
                BasicFilter basicFilter = this.mMultiStickerMaskFilter.parentFilter;
                basicFilter.removeTarget((GLTextureInputRenderer)this.mMultiStickerMaskFilter);
                if (this.mTerminalFilter == this.mMultiStickerMaskFilter) {
                    this.removeTerminalFilter(this.mMultiStickerMaskFilter);
                    this.registerTerminalFilter(basicFilter);
                    basicFilter.addTarget((GLTextureInputRenderer)this);
                    this.mTerminalFilter = basicFilter;
                } else {
                    Object object2;
                    this.removeFilter(this.mMultiStickerMaskFilter);
                    object2 = (BasicFilter)this.mMultiStickerMaskFilter.getTargets().get(0);
                    ((BasicFilter)this.mMultiStickerMaskFilter.getTargets().get(0)).parentFilter = basicFilter;
                    basicFilter.addTarget((GLTextureInputRenderer)object2);
                }
                this.filtersToDestroy.add((GLRenderer)this.mMultiStickerMaskFilter);
                this.mMultiStickerMaskFilter = null;
            }
            if (this.mEffectGroupFilter != null) {
                this.mEffectGroupFilter.a();
            }
            if (this.mFaceMaskFilter != null) {
                this.filtersToDestroy.add((GLRenderer)this.mFaceMaskFilter);
                this.mFaceMaskFilter = null;
            }
            if (this.mSwapFacialMaskSticker != null) {
                this.mSwapFacialMaskSticker.clear();
                this.mSwapFacialMaskSticker = null;
            }
            if (this.mDistorationMask != null) {
                this.mDistorationMask = null;
                this.mFaceBeauty = false;
                this.mFaceStateChange = false;
                this.mFaceBeautyHaveFinish = false;
                this.mFaceThinValue = 0.0f;
                this.mBigEyeValue = 0.0f;
            }
            if (this.mBeautyFace != null) {
                this.mBeautyFace = null;
            }
            this.releaseSoundPlayer();
            SegmentHelper.release();
            FacerigHelper.releseFaceRigInfo();
            this.mStickerFilterMap.clear();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeEffectFilter(BasicFilter filter) {
        void var1_1;
        BasicFilter basicFilter = filter.parentFilter;
        basicFilter.removeTarget((GLTextureInputRenderer)filter);
        if (this.mTerminalFilter == filter) {
            this.removeTerminalFilter(filter);
            this.registerTerminalFilter(basicFilter);
            basicFilter.addTarget((GLTextureInputRenderer)this);
            this.mTerminalFilter = basicFilter;
            return;
        }
        this.removeFilter(filter);
        BasicFilter basicFilter2 = (BasicFilter)filter.getTargets().get(0);
        var1_1.removeTarget((GLTextureInputRenderer)basicFilter2);
        basicFilter2.parentFilter = basicFilter;
        basicFilter.addTarget((GLTextureInputRenderer)basicFilter2);
    }

    public void releaseSoundPlayer() {
        this.clearAllSoundPoolInfo();
        if (this.soundPool != null) {
            if (this.soundIds != null && this.soundIds.size() > 0) {
                for (Integer n2 : this.soundIds) {
                    this.soundPool.unload(n2.intValue());
                }
                this.soundIds.clear();
            }
            this.soundPool.release();
        }
        if (this.soundPlayer != null) {
            this.soundPlayer.release();
            this.soundPlayer = null;
        }
    }

    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
    }

    public int getTextOutID() {
        BasicFilter basicFilter = (BasicFilter)this.getTerminalFilters().get(0);
        if (basicFilter != null) {
            return basicFilter.getTextOutID();
        }
        return 0;
    }

    public void lockTexture() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().lockTexture();
        }
    }

    public void unlockTexture() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().unlockTexture();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleWidth(int scaleWidth) {
        void var1_1;
        this.scaleWidth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleHeight(int scaleHeight) {
        void var1_1;
        this.scaleHeight = var1_1;
    }

    public void setGameScoreListener(com.momo.mcamera.mask.b.a listener) {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof z) {
            Iterator<ba> iterator;
            void var2_2 = iterator;
            iterator = ((z)this.mMultiStickerMaskFilter).a.a.iterator();
            while (iterator.hasNext()) {
                ((ba)((bf)iterator.next())).c = var2_2;
            }
        }
    }

    public void startPlayingTailMoving() {
        if (this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof z) {
            ((z)this.mMultiStickerMaskFilter).b();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isBitmapValid(Bitmap bitmap) {
        void var1_1;
        return bitmap != null && !var1_1.isRecycled();
    }

    /*
     * WARNING - void declaration
     */
    public void initGameFixSticker(Bitmap scoreBitmap, Bitmap iconBitmap, int width, int height) {
        if (this.isBitmapValid(scoreBitmap) && this.isBitmapValid(iconBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof z) {
            void var3_3;
            void var2_2;
            void var1_1;
            ((z)this.mMultiStickerMaskFilter).a((Bitmap)var1_1, (Bitmap)var2_2, (int)var3_3, height);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateGameFixStickerScore(Bitmap scoreBitmap) {
        if (this.isBitmapValid(scoreBitmap) && this.mMultiStickerMaskFilter != null && this.mMultiStickerMaskFilter instanceof z) {
            void var1_1;
            ((z)this.mMultiStickerMaskFilter).a((Bitmap)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setGameStickerDownVelocity(float downVelocity) {
        if (this.mMultiStickerMaskFilter != null) {
            void var1_1;
            this.mMultiStickerMaskFilter.b((float)var1_1);
        }
    }

    public void setIsUseStickerOptimization(boolean isUsePlus) {
    }

    /*
     * WARNING - void declaration
     */
    public void setGestureDetectedListener(GestureDetectedListener listener) {
        void var1_1;
        this.gestureDetectedListener = var1_1;
    }

    public void pauseRender() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().pauseBitmapCache();
        }
    }

    public void resumeRender() {
        Iterator<StickerBlendFilter> iterator = this.mStickerFilterMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().resumeBitmapCache();
        }
    }

    protected void initFBO() {
        super.initFBO();
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            return false;
        }
        return false;
    }

    private int calculateFaceIndex(MMCVInfo mmcvInfo) {
        int n2 = mmcvInfo.getMaxFaceCnt();
        if (n2 == 1) {
            return 0;
        }
        boolean bl = false;
        if (mmcvInfo.cameraDegree / 90 % 2 == 0) {
            bl = true;
        }
        if (n2 >= this.lastFacesCnt) {
            float f2 = 10000.0f;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                float f3;
                float[] fArray = mmcvInfo.getFaceAttributeInfo(i2).getLandmarks68();
                float f4 = (float)com.momo.mcamera.a.e.a(new PointF(fArray[0], fArray[68]), this.lastFacePosition);
                if (!(f3 < f2)) continue;
                f2 = f4;
                n3 = i2;
            }
            return n3;
        }
        float[] fArray = mmcvInfo.getFaceAttributeInfo(0).getLandmarks68();
        float f5 = bl ? fArray[68] : fArray[0];
        int n4 = 0;
        float f6 = 10000.0f;
        int n5 = -1;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f7;
            float[] fArray2 = mmcvInfo.getFaceAttributeInfo(i3).getLandmarks68();
            if (!bl && fArray2[0] < f5 || bl && fArray2[68] < f5) {
                f5 = bl ? fArray2[68] : fArray2[0];
                n4 = i3;
            }
            if (!bl && fArray2[0] <= this.lastFacePosition.x || bl && fArray2[68] < this.lastFacePosition.y) continue;
            float f8 = (float)com.momo.mcamera.a.e.a(new PointF(fArray2[0], fArray2[68]), this.lastFacePosition);
            if (!(f7 < f6)) continue;
            f6 = f8;
            n5 = i3;
        }
        if (n5 != -1) {
            return n5;
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     */
    public void setplayStatusListener(MStickerActions.onPlayStatusListener listener) {
        void var1_1;
        this.playStatusListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void updateplayStatus(Sticker sticker, int triggerType, int state) {
        if (this.playStatusListener != null && triggerType == sticker.getTriggerType() && sticker.getTriggerPlayStatus() != -1) {
            void var1_1;
            void var2_2;
            boolean bl = false;
            switch (var2_2) {
                case 1: {
                    void var3_3;
                    if (var3_3 != false) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!this.isplayStatusTriggered && bl) {
                this.isplayStatusTriggered = true;
                this.playStatusListener.onPlayStatusChanged(sticker.getTriggerPlayStatus());
            }
            if (this.isplayStatusTriggered && sticker.curIndex == var1_1.getLoopStart()) {
                this.isplayStatusTriggered = false;
                this.playStatusListener.onPlayStatusChanged(-1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateFrameInfo(Frame frame, Session session) {
        Iterator iterator;
        void var2_2;
        void var3_4 = var2_2;
        var2_2 = iterator;
        iterator = com.momo.mcamera.a.a.a();
        com.momo.mcamera.a.a.a().a = var3_4;
        ((com.momo.mcamera.a.a)((Object)iterator)).b = var2_2;
        iterator = com.momo.mcamera.a.a.a();
        if (((com.momo.mcamera.a.a)((Object)iterator)).b == null || ((com.momo.mcamera.a.a)((Object)iterator)).a == null) {
            return;
        }
        float f2 = -1.0f;
        float f3 = -1.0f;
        iterator = ((com.momo.mcamera.a.a)((Object)iterator)).a.getAllTrackables(Plane.class);
        float[] fArray = new float[24 * iterator.size()];
        double[] dArray = new double[iterator.size()];
        int n2 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Plane plane = (Plane)iterator.next();
            float[] fArray2 = new float[3];
            float[] fArray3 = new float[24];
            plane.getCenterPose().toMatrix(fArray3, 0);
            fArray2[0] = fArray3[12];
            fArray2[1] = fArray3[13];
            fArray2[2] = fArray3[14];
            if (plane.getTrackingState() == TrackingState.TRACKING) {
                f2 = 0.0f;
            } else if (plane.getTrackingState() == TrackingState.PAUSED) {
                f2 = 1.0f;
            } else if (plane.getTrackingState() == TrackingState.STOPPED) {
                f2 = 2.0f;
            }
            fArray3[16] = f2;
            if (plane.getType() == Plane.Type.HORIZONTAL_UPWARD_FACING) {
                f3 = 0.0f;
            } else if (plane.getType() == Plane.Type.HORIZONTAL_DOWNWARD_FACING) {
                f3 = 1.0f;
            } else if (plane.getType() == Plane.Type.VERTICAL) {
                f3 = 2.0f;
            }
            fArray3[17] = f3;
            fArray3[18] = fArray2[0];
            fArray3[19] = fArray2[1];
            fArray3[20] = fArray2[2];
            fArray3[21] = plane.getExtentX();
            fArray3[22] = 0.0f;
            fArray3[23] = plane.getExtentZ();
            dArray[n2] = plane.hashCode();
            for (int i2 = 0; i2 < 24; ++i2) {
                fArray[i2 + n2 * 24] = fArray3[i2];
            }
            ++n2;
        }
        ARCore.updateAnchors((float[])fArray, (double[])dArray);
    }

    public void setCapture3DImageListener(e capture3DImageListener) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            Iterator<i> iterator = this.face3DMaskFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next().i = capture3DImageListener;
            }
        }
    }

    public void setCapture3DRenderImage(boolean isCapture, Rect rect) {
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            Iterator<i> iterator = this.face3DMaskFilters.iterator();
            while (iterator.hasNext()) {
                Rect rect2 = rect;
                i i2 = iterator.next();
                iterator.next().h = isCapture;
                i2.j = rect2;
            }
        }
    }

    public List<Size> getViewPortSize() {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        if (this.face3DMaskFilters != null && this.face3DMaskFilters.size() > 0) {
            for (i i2 : this.face3DMaskFilters) {
                arrayList.add(new Size(i2.getWidth() * i2.d, i2.getHeight() * i2.d));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public void setARCoreFrameListener(com.momo.mcamera.mask.a arCoreFrameListener) {
        void var1_1;
        this.mArCoreFrameListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setIntensity(float intensity) {
        if (this.mLookupFilter instanceof SingleLineGroupFilter) {
            void var1_1;
            this.mLookupFilter.setIntensity((float)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setEffectTimeInfoByHaniId(EffectTimeBean time, int haniId) {
        if (this.mMultiStickerMaskFilter != null) {
            void var2_2;
            void var1_1;
            this.mMultiStickerMaskFilter.a((EffectTimeBean)var1_1, (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MMCVBoxes access$002(StickerAdjustFilter x0, MMCVBoxes x1) {
        void var1_1;
        x0.mmcvBoxes = var1_1;
        return x0.mmcvBoxes;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(StickerAdjustFilter x0, String x1) {
        void var1_1;
        x0.addGestureMaskModel((String)var1_1);
    }

    static /* synthetic */ GestureDetectedListener access$200(StickerAdjustFilter x0) {
        return x0.gestureDetectedListener;
    }

    static /* synthetic */ bc access$300(StickerAdjustFilter x0) {
        return x0.mGestureTrackingFilter;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(StickerAdjustFilter x0, SoundPool x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.updateSoundPoolLoadedStatus((SoundPool)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(StickerAdjustFilter x0, BasicFilter x1) {
        void var1_1;
        x0.removeEffectFilter((BasicFilter)var1_1);
    }

    static /* synthetic */ List access$600(StickerAdjustFilter x0) {
        return x0.filtersToDestroy;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$700(StickerAdjustFilter x0, Sticker x1, int x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.updateplayStatus((Sticker)var1_1, (int)var2_2, (int)var3_3);
    }

    static /* synthetic */ StickerBlendFilter.StickerStateChangeListener access$800(StickerAdjustFilter x0) {
        return x0.stickerStateChangeListener;
    }

    static /* synthetic */ SoundPool access$900(StickerAdjustFilter x0) {
        return x0.soundPool;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(StickerAdjustFilter x0, int x1, Runnable x2) {
        void var2_2;
        void var1_1;
        x0.setRunableCalledWhenLoaded((int)var1_1, (Runnable)var2_2);
    }

    static /* synthetic */ StickerMaskFinishListener access$1100(StickerAdjustFilter x0) {
        return x0.finishListener;
    }

    static /* synthetic */ float access$1200(StickerAdjustFilter x0) {
        return x0.mBigEye;
    }

    static /* synthetic */ float access$1300(StickerAdjustFilter x0) {
        return x0.mThinFace;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1400(StickerAdjustFilter x0, Sticker x1) {
        void var1_1;
        x0.removeStickerFilter((Sticker)var1_1);
    }

    public static interface GestureDetectedListener {
        public void gestureDetected(String var1);

        public void onPreGestureAdded(String var1);
    }

    public static interface StickerMaskFinishListener {
        public void stickerRenderFinished(int var1, Sticker var2);
    }

    private final class a {
        int a = 0;
        boolean b = false;
        Runnable c = null;

        a() {
        }
    }
}

