/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeview;

import android.text.TextUtils;
import com.momo.render.IXeInnerRender;
import com.momo.render.XeEngineRender;
import com.momo.render.XeSharedEngineRender;
import com.momo.test.Logger;
import com.momo.xeengine.XE3DEngine;
import com.momo.xeview.IXeRenderViewController;
import com.momo.xeview.XeRenderView;
import com.momo.xeview.XeViewConfig;

public class XeRenderViewController
implements IXeRenderViewController,
XeRenderView.XeSurfaceCallback {
    private XeRenderView mXeRenderView;
    private XeViewConfig mConfig;
    private long mLastRenderTime;
    private String mSceneId;
    private IXeInnerRender mXeInnerRender;

    @Override
    public void bindView(XeRenderView renderView) {
        this.mXeRenderView = renderView;
        XE3DEngine.getInstance().init(renderView.getContext());
    }

    @Override
    public void config(XeViewConfig config) {
        this.mConfig = config;
        this.mXeRenderView.config(config);
    }

    @Override
    public void prepare(OnPreparedCallback callback) {
        this.mXeInnerRender = this.mConfig.mRenderImpl == 0 ? new XeSharedEngineRender(callback) : new XeEngineRender(callback);
        this.mXeInnerRender.init(this.mXeRenderView.getContext(), this.mConfig.mRootPath);
        this.mXeRenderView.prepare(this);
    }

    @Override
    public void loadScene(final String scenePath) {
        this.mSceneId = scenePath + System.currentTimeMillis();
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XE3DEngine.getInstance().loadSceneWithId(scenePath, XeRenderViewController.this.mSceneId);
            }
        });
    }

    @Override
    public void onResume() {
        this.mXeRenderView.onResume();
    }

    @Override
    public void onPause() {
        Logger.d("onPause .....");
        this.mXeRenderView.onPause();
    }

    @Override
    public void onSurfacePrepared() {
        this.mXeInnerRender.onSurfacePrepared();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        this.mXeInnerRender.onSurfaceChanged(width, height);
        Logger.d("onPrepared");
    }

    @Override
    public void onDrawFrame() {
        long delayMillis;
        long current = System.currentTimeMillis();
        int interval = 1000 / (this.mConfig == null ? 30 : this.mConfig.mFrameRate);
        long delta = current - this.mLastRenderTime;
        long l = delayMillis = delta > (long)interval ? 0L : (long)interval - delta;
        if (delayMillis > 0L) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                Logger.printStakeTrace(e);
            }
        }
        if (this.mXeRenderView != null) {
            this.mLastRenderTime = System.currentTimeMillis();
            if (this.mXeRenderView != null) {
                this.mXeRenderView.requestRender();
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mSceneId)) {
            this.mXeInnerRender.onDrawFrame();
        } else {
            this.mXeInnerRender.onDrawFrame(this.mSceneId);
        }
        Logger.d("onDrawFrame");
    }

    @Override
    public void onDestroyed() {
        this.mXeInnerRender.onDestroyed();
        Logger.d("onDestroyed");
    }

    public static interface OnPreparedCallback {
        public void onPrepared();

        public void onSurfaceChanged(int var1, int var2);

        public void onDestroyed();
    }
}

