/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.xnative;

import com.momo.xeengine.XE3DEngine;

public class XESceneFilterManager {
    public void loadSceneWithId(final String scenePath, final String sceneID) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeLoadSceneWithId(scenePath, sceneID);
            }
        });
    }

    public void setFrontCamera(final boolean frontCamera) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeRotateCamera(frontCamera);
            }
        });
    }

    public void setBeginRecord(final boolean beginRecord) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeEnabledRecoreding(beginRecord);
            }
        });
    }

    public void unloadScene(final String sceneId) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeUnloadScene(sceneId);
            }
        });
    }

    public void updateRelationLocation(final float[] rFrame, final String sceneId) {
        if (rFrame == null || rFrame.length < 4) {
            return;
        }
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeUpdateRelationLocationFrame(rFrame, sceneId);
            }
        });
    }

    public void updateRelationLocationWithTrackId(final int trackid, final float[] rFrame, final String sceneId) {
        if (rFrame == null || rFrame.length < 4) {
            return;
        }
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeUpdateRelationLocationFrameWithTrackId(trackid, rFrame, sceneId);
            }
        });
    }

    public void tickTimeLineAndFrameSequence(final float time, final int frame, final String sceneId) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                XESceneFilterManager.this.nativeTickTimeLineAndFrameSequence(time, frame, sceneId);
            }
        });
    }

    public float[] getActorLocationFrame(String actorName) {
        return this.nativeGetActorLocationFrame(actorName);
    }

    private native void nativeLoadSceneWithId(String var1, String var2);

    private native void nativeUnloadScene(String var1);

    private native void nativeRotateCamera(boolean var1);

    private native void nativeEnabledRecoreding(boolean var1);

    private native void nativeUpdateRelationLocationFrame(float[] var1, String var2);

    private native void nativeUpdateRelationLocationFrameWithTrackId(int var1, float[] var2, String var3);

    private native void nativeTickTimeLineAndFrameSequence(float var1, int var2, String var3);

    private native float[] nativeGetActorLocationFrame(String var1);
}

