/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.xnative;

import com.momo.xeengine.XE3DEngine;
import com.momo.xeengine.bean.XEFaceInfo;
import java.util.List;

public class XEFace {
    private static final int STATE_OPEN = 1;
    private static final int STATE_CLOSE = 2;
    private static int INDEX_FACE_LEFT = 0;
    private static int INDEX_FACE_RIGHT = 16;
    private static int INDEX_MOUSE_UP = 62;
    private static int INDEX_MOUSE_DOWN = 66;
    private static int mouseOpenState = 2;
    private static final int POINTS_LENGTH = 68;
    public static boolean hasFaceLost = false;

    public static void setFaceInfo(List<XEFaceInfo> infos) {
        if (!XE3DEngine.getInstance().isRunning()) {
            return;
        }
        if (infos != null && !infos.isEmpty()) {
            int size = infos.size();
            final long[] pres = new long[size];
            for (int i = 0; i < size; ++i) {
                float[] translationVector;
                float[] rotationVector;
                XEFaceInfo info = infos.get(i);
                long pre = XEFace.nativeSetType(info.meType);
                pre = XEFace.nativeSetTrackId(pre, info.trackId);
                pre = XEFace.nativeSetEuler(pre, info.pitch, info.yaw, info.roll);
                float[] faceBounds = info.faceBounds;
                if (faceBounds != null && faceBounds.length >= 4) {
                    pre = XEFace.nativeBounds(pre, faceBounds[0], faceBounds[1], faceBounds[2], faceBounds[3]);
                }
                if (info.landmarks96 != null && info.landmarks96.length > 0) {
                    pre = XEFace.nativeLandMarks(pre, info.landmarks96);
                }
                info.expression = XEFace.updateMouseState(info.landmarks68);
                pre = XEFace.nativEexpression(pre, info.expression);
                if (info.cameraMatrix != null && info.cameraMatrix.length >= 9) {
                    pre = XEFace.nativeCameraMatrix(pre, info.cameraMatrix);
                }
                if (info.rotationMatrix != null && info.rotationMatrix.length >= 9) {
                    pre = XEFace.nativeRotationMatrix(pre, info.rotationMatrix);
                }
                if ((rotationVector = info.rotationVector) != null) {
                    pre = XEFace.nativeRotationVector(pre, rotationVector[0], rotationVector[1], rotationVector[2]);
                }
                if ((translationVector = info.translationVector) != null) {
                    pre = XEFace.nativeTranslationVector(pre, translationVector[0], translationVector[1], translationVector[2]);
                }
                if (info.projectionMatrix != null && info.projectionMatrix.length >= 16) {
                    pre = XEFace.nativeProjectionMatrix(pre, info.projectionMatrix);
                }
                if (info.modelViewMatrix != null && info.modelViewMatrix.length >= 16) {
                    pre = XEFace.nativeModelViewMatrix(pre, info.modelViewMatrix);
                }
                if (info.facerigStates != null && info.facerigStates.length >= 36) {
                    pre = XEFace.nativeFacerigStates(pre, info.facerigStates);
                }
                pres[i] = pre;
            }
            hasFaceLost = false;
            XE3DEngine.getInstance().queueEvent(new Runnable(){

                @Override
                public void run() {
                    XEFace.nativeSetFaces(pres);
                }
            });
        } else if (!hasFaceLost) {
            hasFaceLost = true;
            XE3DEngine.getInstance().queueEvent(new Runnable(){

                @Override
                public void run() {
                    XEFace.nativeSetFaces(null);
                }
            });
        }
    }

    private static int updateMouseState(float[] points) {
        if (points == null) {
            return mouseOpenState;
        }
        float xUP = points[INDEX_FACE_LEFT];
        float yUP = points[INDEX_FACE_LEFT + 68];
        float xDown = points[INDEX_FACE_RIGHT];
        float yDown = points[INDEX_FACE_RIGHT + 68];
        float xLeft = points[INDEX_MOUSE_DOWN];
        float yLeft = points[INDEX_MOUSE_DOWN + 68];
        float xRight = points[INDEX_MOUSE_UP];
        float yRight = points[INDEX_MOUSE_UP + 68];
        float distance = (float)Math.hypot(xUP - xDown, yUP - yDown);
        float hDistance = (float)Math.hypot(xRight - xLeft, yRight - yLeft);
        if (mouseOpenState == 1) {
            if ((double)hDistance < (double)(distance * 1.0f) / 14.0) {
                mouseOpenState = 2;
            }
        } else {
            mouseOpenState = hDistance > distance * 1.0f / 10.0f ? 1 : 2;
        }
        return mouseOpenState;
    }

    private static native long nativeSetType(int var0);

    private static native long nativeSetTrackId(long var0, int var2);

    private static native long nativeSetEuler(long var0, float var2, float var3, float var4);

    private static native long nativeBounds(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeLandMarks(long var0, float[] var2);

    private static native long nativEexpression(long var0, int var2);

    private static native long nativeCameraMatrix(long var0, float[] var2);

    private static native long nativeRotationMatrix(long var0, float[] var2);

    private static native long nativeRotationVector(long var0, float var2, float var3, float var4);

    private static native long nativeTranslationVector(long var0, float var2, float var3, float var4);

    private static native long nativeProjectionMatrix(long var0, float[] var2);

    private static native long nativeModelViewMatrix(long var0, float[] var2);

    private static native long nativeFacerigStates(long var0, float[] var2);

    private static native void nativeSetFaces(long[] var0);
}

