/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import android.content.Context;
import com.momo.xeengine.sensor.XEAccelerometer;

public class XESensorHelper {
    private static Context sContext;
    private static XEAccelerometer sAccelerometer;
    private static boolean sAccelerometerEnabled;
    private static boolean sCompassEnabled;

    public static void init(Context context) {
        if (context == null) {
            throw new NullPointerException("The Context is null");
        }
        sContext = context.getApplicationContext();
        XESensorHelper.nativeSetContext(sContext);
    }

    public static void onPause() {
        XESensorHelper.getAccelerometer().disable();
    }

    public static void onResume() {
        XESensorHelper.getAccelerometer().enableAccelerometer(sAccelerometerEnabled);
        XESensorHelper.getAccelerometer().enableCompass(sCompassEnabled);
    }

    public static void release() {
        XESensorHelper.getAccelerometer().release();
        sAccelerometer = null;
    }

    public static void enableAccelerometer(boolean accelerometerEnabled) {
        sAccelerometerEnabled = accelerometerEnabled;
        XESensorHelper.getAccelerometer().enableAccelerometer(accelerometerEnabled);
    }

    public static void enebaleCompassEnabled(boolean compassEnabled) {
        sCompassEnabled = compassEnabled;
        XESensorHelper.getAccelerometer().enableCompass(compassEnabled);
    }

    public static void setAccelerometerInterval(float interval) {
        XESensorHelper.getAccelerometer().setAccelerometerInterval(interval);
    }

    public static void setCompassInterval(float interval) {
        XESensorHelper.getAccelerometer().setCompassInterval(interval);
    }

    public static void setContext(Context context) {
        XESensorHelper.nativeSetContext(context);
    }

    public static void Release() {
        sAccelerometer = null;
    }

    private static XEAccelerometer getAccelerometer() {
        if (sAccelerometer == null) {
            if (sContext == null) {
                throw new NullPointerException("The Context is null");
            }
            sAccelerometer = new XEAccelerometer(sContext);
        }
        return sAccelerometer;
    }

    private static native void nativeSetContext(Context var0);
}

