/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.sensor;

import android.hardware.SensorEvent;
import android.hardware.SensorManager;
import android.util.Log;
import com.momo.xeengine.sensor.OrientationProvider;
import com.momo.xeengine.sensor.Quaternion;

public class ImprovedOrientationSensorProvider
extends OrientationProvider {
    private static final float NS2S = 1.0E-9f;
    private final Quaternion deltaQuaternion = new Quaternion();
    private Quaternion quaternionGyroscope = new Quaternion();
    private Quaternion quaternionRotationVector = new Quaternion();
    private long timestamp;
    private static final double EPSILON = (double)0.1f;
    private double gyroscopeRotationVelocity = 0.0;
    private boolean positionInitialised = false;
    private int positionReInitialisedCount = 0;
    private int panicCounter;
    private static final float INDIRECT_INTERPOLATION_WEIGHT = 0.01f;
    private static final float OUTLIER_THRESHOLD = 0.85f;
    private static final float OUTLIER_PANIC_THRESHOLD = 0.75f;
    private static final int PANIC_THRESHOLD = 60;
    private final float[] temporaryQuaternion = new float[4];
    private final Quaternion correctedQuaternion = new Quaternion();
    private final Quaternion interpolatedQuaternion = new Quaternion();

    public ImprovedOrientationSensorProvider(SensorManager sensorManager) {
        super(sensorManager);
        this.sensorList.add(sensorManager.getDefaultSensor(4));
        this.sensorList.add(sensorManager.getDefaultSensor(11));
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 11) {
            SensorManager.getQuaternionFromVector((float[])this.temporaryQuaternion, (float[])event.values);
            this.quaternionRotationVector.setXYZW(this.temporaryQuaternion[1], this.temporaryQuaternion[2], this.temporaryQuaternion[3], -this.temporaryQuaternion[0]);
            if (this.positionReInitialisedCount < 5000) {
                if (this.positionReInitialisedCount <= 90) {
                    this.quaternionGyroscope.set(this.quaternionRotationVector);
                } else if (this.positionReInitialisedCount % 300 == 0) {
                    this.quaternionGyroscope.set(this.quaternionRotationVector);
                }
                ++this.positionReInitialisedCount;
            }
        } else if (event.sensor.getType() == 4) {
            if (this.timestamp != 0L) {
                float dT = (float)(event.timestamp - this.timestamp) * 1.0E-9f;
                float axisX = event.values[0];
                float axisY = event.values[1];
                float axisZ = event.values[2];
                this.gyroscopeRotationVelocity = Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
                if (this.gyroscopeRotationVelocity > (double)0.1f) {
                    axisX = (float)((double)axisX / this.gyroscopeRotationVelocity);
                    axisY = (float)((double)axisY / this.gyroscopeRotationVelocity);
                    axisZ = (float)((double)axisZ / this.gyroscopeRotationVelocity);
                }
                double thetaOverTwo = this.gyroscopeRotationVelocity * (double)dT / 2.0;
                double sinThetaOverTwo = Math.sin(thetaOverTwo);
                double cosThetaOverTwo = Math.cos(thetaOverTwo);
                this.deltaQuaternion.setX((float)(sinThetaOverTwo * (double)axisX));
                this.deltaQuaternion.setY((float)(sinThetaOverTwo * (double)axisY));
                this.deltaQuaternion.setZ((float)(sinThetaOverTwo * (double)axisZ));
                this.deltaQuaternion.setW(-((float)cosThetaOverTwo));
                this.deltaQuaternion.multiplyByQuat(this.quaternionGyroscope, this.quaternionGyroscope);
                float dotProd = this.quaternionGyroscope.dotProduct(this.quaternionRotationVector);
                if (Math.abs(dotProd) < 0.85f) {
                    if (Math.abs(dotProd) < 0.75f) {
                        ++this.panicCounter;
                    }
                    this.setOrientationQuaternionAndMatrix(this.quaternionGyroscope);
                } else {
                    this.quaternionGyroscope.slerp(this.quaternionRotationVector, this.interpolatedQuaternion, (float)((double)0.01f * this.gyroscopeRotationVelocity));
                    this.setOrientationQuaternionAndMatrix(this.interpolatedQuaternion);
                    this.quaternionGyroscope.copyVec4(this.interpolatedQuaternion);
                    this.panicCounter = 0;
                }
                if (this.panicCounter > 60) {
                    Log.d((String)"Rotation Vector", (String)"Panic counter is bigger than threshold; this indicates a Gyroscope failure. Panic reset is imminent.");
                    if (this.gyroscopeRotationVelocity < 3.0) {
                        Log.d((String)"Rotation Vector", (String)"Performing Panic-reset. Resetting orientation to rotation-vector value.");
                        this.setOrientationQuaternionAndMatrix(this.quaternionRotationVector);
                        this.quaternionGyroscope.copyVec4(this.quaternionRotationVector);
                        this.panicCounter = 0;
                    } else {
                        Log.d((String)"Rotation Vector", (String)String.format("Panic reset delayed due to ongoing motion (user is still shaking the device). Gyroscope Velocity: %.2f > 3", this.gyroscopeRotationVelocity));
                    }
                }
            }
            this.timestamp = event.timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOrientationQuaternionAndMatrix(Quaternion quaternion) {
        this.correctedQuaternion.set(quaternion);
        this.correctedQuaternion.w(-this.correctedQuaternion.w());
        Object object = this.synchronizationToken;
        synchronized (object) {
            this.currentOrientationQuaternion.copyVec4(quaternion);
            SensorManager.getRotationMatrixFromVector((float[])this.currentOrientationRotationMatrix.matrix, (float[])this.correctedQuaternion.array());
        }
    }
}

