/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.script;

import com.momo.test.Logger;
import com.momo.xeengine.XE3DEngine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ScriptBridge {
    private static int callNumID;
    private static Map<String, Object> handlers;
    private static Map<String, Callback> callbacks;

    public static String call(final String handler, final String action, final String message) {
        if (XE3DEngine.getInstance().getDirector().isRenderThread()) {
            return ScriptBridge.nativeJavaCallLua(handler, action, message);
        }
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                ScriptBridge.nativeJavaCallLua(handler, action, message);
            }
        });
        return null;
    }

    public static void callAsync(final String handler, final String action, final String message, final Callback callback) {
        XE3DEngine.getInstance().queueEvent(new Runnable(){

            @Override
            public void run() {
                String callID = handler + "." + action + "." + String.valueOf(callNumID++);
                if (callback != null) {
                    callbacks.put(callID, callback);
                }
                ScriptBridge.nativeJavaAsyncCallLua(handler, action, message, callID);
            }
        });
    }

    public static void regist(Object object, String handlerName) {
        handlers.put(handlerName, object);
    }

    public static void unregist(String handlerName) {
        handlers.remove(handlerName);
    }

    public static void unregistAll() {
        handlers.clear();
    }

    public static void luaCallbackForNative(String message, String callID) {
        if (callbacks.get(callID) != null) {
            Callback callback = callbacks.get(callID);
            callback.call(message);
            callbacks.remove(callID);
        }
    }

    public static String luaCallJava(String handler, String action, String message) {
        Object receiveObj;
        Class<?> handlerCalss;
        Object o = handlers.get(handler);
        if (o == null) {
            Logger.e("[ScriptBridge]", handler + "\u672a\u6ce8\u518c");
            return null;
        }
        if (o instanceof Class) {
            handlerCalss = (Class<?>)o;
            receiveObj = null;
        } else {
            handlerCalss = o.getClass();
            receiveObj = o;
        }
        try {
            Method method = handlerCalss.getMethod(action, String.class);
            Object result = method.invoke(receiveObj, message);
            if (result != null) {
                return (String)result;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            Logger.e("[LUA][BRIDGE]", handler + "\u4e2d\u5e76\u6ca1\u6709" + action + "\u8fd9\u4e2a\u65b9\u6cd5");
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void luaCallJavaAsync(String handler, String action, String message, long pCallback) {
        Object receiveObj;
        Class<?> handlerCalss;
        Object o = handlers.get(handler);
        if (o == null) {
            Logger.e("[ScriptBridge]", handler + "\u672a\u6ce8\u518c");
            return;
        }
        if (o instanceof Class) {
            handlerCalss = (Class<?>)o;
            receiveObj = null;
        } else {
            handlerCalss = o.getClass();
            receiveObj = o;
        }
        try {
            Method method = handlerCalss.getMethod(action, String.class, Callback.class);
            method.invoke(receiveObj, message, new JCallback(pCallback));
        }
        catch (NoSuchMethodException e) {
            Logger.e("[ScriptBridge]", handler + "\u4e2d\u5e76\u6ca1\u6709" + action + "\u8fd9\u4e2a\u65b9\u6cd5");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static native void nativeDeleteCallbackFunc(long var0);

    private static native void nativeCallback(long var0, String var2);

    private static native String nativeJavaCallLua(String var0, String var1, String var2);

    private static native void nativeJavaAsyncCallLua(String var0, String var1, String var2, String var3);

    static {
        handlers = new HashMap<String, Object>();
        callbacks = new HashMap<String, Callback>();
    }

    private static class JCallback
    implements Callback {
        private long pCallback;

        private JCallback(long pCallback) {
            this.pCallback = pCallback;
        }

        @Override
        public void call(final String callbackMsg) {
            if (XE3DEngine.getInstance().getDirector().isRenderThread()) {
                ScriptBridge.nativeCallback(this.pCallback, callbackMsg);
            } else {
                XE3DEngine.getInstance().queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        ScriptBridge.nativeCallback(JCallback.this.pCallback, callbackMsg);
                    }
                });
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            ScriptBridge.nativeDeleteCallbackFunc(this.pCallback);
        }
    }

    public static interface Callback {
        public void call(String var1);
    }
}

