/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import com.momo.test.Logger;
import com.momo.xeengine.XE3DEngine;
import java.io.FileInputStream;

public final class XEMusicPlayer {
    private static final String TAG = "[AUDIO][" + XEMusicPlayer.class.getSimpleName() + "]";
    private MediaPlayer mBackgroundMediaPlayer;
    private float mLeftVolume;
    private float mRightVolume;
    private boolean mPaused;
    private boolean mIsLoop = false;
    private boolean mManualPaused = false;
    private boolean mIsAudioFocus = true;
    private String mCurrentPath;

    XEMusicPlayer() {
        this.initData();
    }

    public void preloadBackgroundMusic(String path) {
        if (this.mCurrentPath == null || !this.mCurrentPath.equals(path)) {
            if (this.mBackgroundMediaPlayer != null) {
                this.mBackgroundMediaPlayer.release();
            }
            this.mBackgroundMediaPlayer = this.createMediaPlayer(path);
            this.mCurrentPath = path;
        }
    }

    public void playBackgroundMusic(String path, boolean isLoop) {
        if (this.mCurrentPath == null) {
            this.mBackgroundMediaPlayer = this.createMediaPlayer(path);
            this.mCurrentPath = path;
        } else if (!this.mCurrentPath.equals(path)) {
            if (this.mBackgroundMediaPlayer != null) {
                this.mBackgroundMediaPlayer.release();
            }
            this.mBackgroundMediaPlayer = this.createMediaPlayer(path);
            this.mCurrentPath = path;
        }
        if (this.mBackgroundMediaPlayer == null) {
            Logger.e(TAG, "playBackgroundMusic: background media player is null");
        } else {
            try {
                if (this.mPaused) {
                    this.mBackgroundMediaPlayer.seekTo(0);
                    this.mBackgroundMediaPlayer.start();
                } else if (this.mBackgroundMediaPlayer.isPlaying()) {
                    this.mBackgroundMediaPlayer.seekTo(0);
                } else {
                    this.mBackgroundMediaPlayer.start();
                }
                this.mBackgroundMediaPlayer.setLooping(isLoop);
                this.mPaused = false;
                this.mIsLoop = isLoop;
            }
            catch (Exception e) {
                Logger.e(TAG, "playBackgroundMusic: error state");
            }
        }
    }

    public void stopBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.release();
            this.mBackgroundMediaPlayer = this.createMediaPlayer(this.mCurrentPath);
            this.mPaused = false;
        }
    }

    public void pauseBackgroundMusic() {
        try {
            if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
                this.mBackgroundMediaPlayer.pause();
                this.mPaused = true;
                this.mManualPaused = true;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "pauseBackgroundMusic, IllegalStateException was triggered!");
        }
    }

    public void resumeBackgroundMusic() {
        try {
            if (this.mBackgroundMediaPlayer != null && this.mPaused) {
                this.mBackgroundMediaPlayer.start();
                this.mPaused = false;
                this.mManualPaused = false;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "resumeBackgroundMusic, IllegalStateException was triggered!");
        }
    }

    public void rewindBackgroundMusic() {
        if (this.mBackgroundMediaPlayer != null) {
            this.playBackgroundMusic(this.mCurrentPath, this.mIsLoop);
        }
    }

    public boolean willPlayBackgroundMusic() {
        Context context = XE3DEngine.getInstance().getContext();
        if (context == null) {
            return false;
        }
        AudioManager manager = (AudioManager)context.getSystemService("audio");
        return !manager.isMusicActive();
    }

    public boolean isBackgroundMusicPlaying() {
        boolean ret = false;
        try {
            ret = this.mBackgroundMediaPlayer == null ? false : this.mBackgroundMediaPlayer.isPlaying();
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "isBackgroundMusicPlaying, IllegalStateException was triggered!");
        }
        return ret;
    }

    public void end() {
        if (this.mBackgroundMediaPlayer != null) {
            this.mBackgroundMediaPlayer.release();
        }
        this.initData();
    }

    public float getBackgroundVolume() {
        if (this.mBackgroundMediaPlayer != null) {
            return (this.mLeftVolume + this.mRightVolume) / 2.0f;
        }
        return 0.0f;
    }

    public void setBackgroundVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.mLeftVolume = this.mRightVolume = volume;
        if (this.mBackgroundMediaPlayer != null && this.mIsAudioFocus) {
            this.mBackgroundMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
        }
    }

    public void onEnterBackground() {
        try {
            if (this.mBackgroundMediaPlayer != null && this.mBackgroundMediaPlayer.isPlaying()) {
                this.mBackgroundMediaPlayer.pause();
                this.mPaused = true;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "onEnterBackground, IllegalStateException was triggered!");
        }
    }

    public void onEnterForeground() {
        try {
            if (!this.mManualPaused && this.mBackgroundMediaPlayer != null && this.mPaused) {
                this.mBackgroundMediaPlayer.start();
                this.mPaused = false;
            }
        }
        catch (IllegalStateException e) {
            Logger.e(TAG, "onEnterForeground, IllegalStateException was triggered!");
        }
    }

    private void initData() {
        this.mLeftVolume = 0.5f;
        this.mRightVolume = 0.5f;
        this.mBackgroundMediaPlayer = null;
        this.mPaused = false;
        this.mCurrentPath = null;
    }

    private MediaPlayer createMediaPlayer(String path) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            FileInputStream fis = new FileInputStream(path);
            mediaPlayer.setDataSource(fis.getFD());
            fis.close();
            mediaPlayer.prepare();
            mediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
        }
        catch (Exception e) {
            mediaPlayer = null;
            Logger.e(TAG, "error: " + e.getMessage(), e);
        }
        return mediaPlayer;
    }

    void setAudioFocus(boolean isFocus) {
        this.mIsAudioFocus = isFocus;
        if (this.mBackgroundMediaPlayer != null) {
            float lVolume = this.mIsAudioFocus ? this.mLeftVolume : 0.0f;
            float rVolume = this.mIsAudioFocus ? this.mRightVolume : 0.0f;
            this.mBackgroundMediaPlayer.setVolume(lVolume, rVolume);
        }
    }
}

