/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine.audio;

import com.momo.xeengine.audio.XEEffectPlayer;
import com.momo.xeengine.audio.XEMusicPlayer;

public final class AudioEngine {
    private static XEMusicPlayer musicPlayer = null;
    private static XEEffectPlayer effectPlayer = null;

    private static XEMusicPlayer getMusicPlayer() {
        if (musicPlayer == null) {
            musicPlayer = new XEMusicPlayer();
        }
        return musicPlayer;
    }

    private static XEEffectPlayer getEffectPlayer() {
        if (effectPlayer == null) {
            effectPlayer = new XEEffectPlayer();
        }
        return effectPlayer;
    }

    public static void preloadBackgroundMusic(String pPath) {
        AudioEngine.getMusicPlayer().preloadBackgroundMusic(pPath);
    }

    public static void playBackgroundMusic(String pPath, boolean isLoop) {
        AudioEngine.getMusicPlayer().playBackgroundMusic(pPath, isLoop);
    }

    public static void resumeBackgroundMusic() {
        AudioEngine.getMusicPlayer().resumeBackgroundMusic();
    }

    public static void pauseBackgroundMusic() {
        AudioEngine.getMusicPlayer().pauseBackgroundMusic();
    }

    public static void stopBackgroundMusic() {
        AudioEngine.getMusicPlayer().stopBackgroundMusic();
    }

    public static void rewindBackgroundMusic() {
        AudioEngine.getMusicPlayer().rewindBackgroundMusic();
    }

    public static boolean willPlayBackgroundMusic() {
        return AudioEngine.getMusicPlayer().willPlayBackgroundMusic();
    }

    public static boolean isBackgroundMusicPlaying() {
        return AudioEngine.getMusicPlayer().isBackgroundMusicPlaying();
    }

    public static float getBackgroundMusicVolume() {
        return AudioEngine.getMusicPlayer().getBackgroundVolume();
    }

    public static void setBackgroundMusicVolume(float volume) {
        AudioEngine.getMusicPlayer().setBackgroundVolume(volume);
    }

    public static void preloadEffect(String path) {
        AudioEngine.getEffectPlayer().preloadEffect(path);
    }

    public static int playEffect(String path, boolean isLoop, float pitch, float pan, float gain) {
        return AudioEngine.getEffectPlayer().playEffect(path, isLoop, pitch, pan, gain);
    }

    public static void resumeEffect(int soundId) {
        AudioEngine.getEffectPlayer().resumeEffect(soundId);
    }

    public static void pauseEffect(int soundId) {
        AudioEngine.getEffectPlayer().pauseEffect(soundId);
    }

    public static void stopEffect(int soundId) {
        AudioEngine.getEffectPlayer().stopEffect(soundId);
    }

    public static float getEffectsVolume() {
        return AudioEngine.getEffectPlayer().getEffectsVolume();
    }

    public static void setEffectsVolume(float volume) {
        AudioEngine.getEffectPlayer().setEffectsVolume(volume);
    }

    public static void unloadEffect(String path) {
        AudioEngine.getEffectPlayer().unloadEffect(path);
    }

    public static void pauseAllEffects() {
        AudioEngine.getEffectPlayer().pauseAllEffects();
    }

    public static void resumeAllEffects() {
        AudioEngine.getEffectPlayer().resumeAllEffects();
    }

    public static void stopAllEffects() {
        AudioEngine.getEffectPlayer().stopAllEffects();
    }

    public static void onEnterBackground() {
        AudioEngine.getMusicPlayer().onEnterBackground();
        AudioEngine.getEffectPlayer().onEnterBackground();
    }

    public static void onEnterForeground() {
        AudioEngine.getMusicPlayer().onEnterForeground();
        AudioEngine.getEffectPlayer().onEnterForeground();
    }

    public static void end() {
        if (musicPlayer != null) {
            musicPlayer.end();
            musicPlayer = null;
        }
        if (effectPlayer != null) {
            effectPlayer.end();
            effectPlayer = null;
        }
    }
}

