/*
 * Decompiled with CFR 0.152.
 */
package com.momo.xeengine;

import android.content.Context;
import android.os.Build;
import com.momo.test.Logger;
import com.momo.widget.XUIEditBoxHelper;
import com.momo.xeengine.ar.ARCore;
import com.momo.xeengine.audio.AudioEngine;
import com.momo.xeengine.event.XEvent;
import com.momo.xeengine.lua.XELuaEngine;
import com.momo.xeengine.sensor.XESensorHelper;
import com.momo.xeengine.xnative.XEDirector;
import com.momo.xeengine.xnative.XEFace;
import com.momo.xeengine.xnative.XEMessageManager;
import com.momo.xeengine.xnative.XESceneFilterManager;
import com.momo.xeengine.xnative.XEScriptEngineManager;
import com.momo.xeengine.xnative.XESystemEventDispatcher;
import com.momo.xeengine.xnative.XEWindow;

public class XE3DEngine {
    public static final String XENGINE_TAG = "[XENGINE]";
    private static boolean isAREngineLoeded = false;
    private static boolean isLuaEngineLoeded = false;
    private XEDirector director = new XEDirector();
    private XESceneFilterManager sceneFilterManager = new XESceneFilterManager();
    private Context context;

    public static void loadAREngine() {
        if (isAREngineLoeded) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            System.loadLibrary("arcore_sdk_c");
            System.loadLibrary("arengine");
            XE3DEngine.getInstance().director.registerARModule(ARCore.getInstance());
            isAREngineLoeded = true;
        }
    }

    public static void loadLuaEngine() {
        if (isLuaEngineLoeded) {
            return;
        }
        System.loadLibrary("luaengine");
        isLuaEngineLoeded = true;
    }

    public static XE3DEngine getInstance() {
        return HOLDER.sInstance;
    }

    private XE3DEngine() {
    }

    public XEDirector getDirector() {
        return this.director;
    }

    public void init(Context context) {
        this.context = context.getApplicationContext();
        XESensorHelper.init(context);
    }

    public void setLibraryPath(String libraryPath) {
        this.director.configlibraryPath(libraryPath);
    }

    public synchronized boolean runEngine() {
        return this.runEngine(0, 0);
    }

    public synchronized boolean runEngine(int width, int hight) {
        if (this.isRunning()) {
            return true;
        }
        boolean running = this.director.run(width, hight);
        if (running && isLuaEngineLoeded) {
            XEScriptEngineManager.getInstance().setScriptEngine(XELuaEngine.getInstance());
        }
        return running;
    }

    public boolean isRunning() {
        return this.director.isRunning();
    }

    public void queueEvent(Runnable runnable) {
        this.queueEvent(runnable, 1);
    }

    public void queueEvent(Runnable runnable, int priority) {
        if (runnable == null) {
            return;
        }
        this.director.queueEvent(runnable, priority);
    }

    public void setOnThisFrameFinishCallback(XEDirector.OnThisFrameRenderedCallback callback) {
        if (this.director != null) {
            this.director.setOnThisFrameFinishCallback(callback);
        }
    }

    public void sendEvent(XEvent event) {
        this.director.sendEvent(event);
    }

    public void clearEvent() {
        if (this.director != null) {
            this.director.clearEvent();
        }
    }

    public void clearBackground() {
        if (this.isRunning()) {
            this.director.clearBackground();
        }
    }

    public void enableClearColor(boolean clear) {
        if (this.isRunning()) {
            this.director.enableClearColor(clear);
        }
    }

    public void render() {
        if (this.isRunning()) {
            this.director.render();
        }
    }

    public void render(String sceneId) {
        if (this.isRunning()) {
            this.director.render(sceneId);
        }
    }

    public void resizeWindow(int width, int height) {
        if (this.isRunning()) {
            this.director.resizeWindow(width, height);
        }
    }

    public void endEngine() {
        if (this.isRunning()) {
            XESensorHelper.Release();
            this.director.end();
            if (isLuaEngineLoeded) {
                XEScriptEngineManager.getInstance().removeScriptEngine(XELuaEngine.getInstance());
            }
        }
        XUIEditBoxHelper.release();
    }

    public void loadSceneWithId(String scenePath, String sceneID) {
        if (this.isRunning()) {
            this.sceneFilterManager.loadSceneWithId(scenePath, sceneID);
        }
    }

    public void rorateCamera(boolean frontCamera) {
        if (this.isRunning()) {
            XEFace.hasFaceLost = false;
            this.sceneFilterManager.setFrontCamera(frontCamera);
        }
    }

    public void enableRecording(boolean beginRecord) {
        if (this.isRunning()) {
            this.sceneFilterManager.setBeginRecord(beginRecord);
        }
    }

    public void unloadScene(String sceneId) {
        if (this.isRunning()) {
            this.sceneFilterManager.unloadScene(sceneId);
        }
    }

    public void updateRelationLocation(float[] rFrame, String sceneId) {
        this.sceneFilterManager.updateRelationLocation(rFrame, sceneId);
    }

    public void updateRelationLocationWithTrackId(int trackid, float[] rFrame, String sceneId) {
        this.sceneFilterManager.updateRelationLocationWithTrackId(trackid, rFrame, sceneId);
    }

    public void tickTimeLineAndFrameSequence(float time, int frame, String sceneId) {
        this.sceneFilterManager.tickTimeLineAndFrameSequence(time, frame, sceneId);
    }

    public float[] getActorLocationFrame(String actorName) {
        return this.sceneFilterManager.getActorLocationFrame(actorName);
    }

    public XEWindow getWindow() {
        if (this.isRunning()) {
            return this.director.getWindow();
        }
        return null;
    }

    public boolean touchHitTest(float x, float y) {
        if (!this.isRunning()) {
            return false;
        }
        XEWindow window = this.director.getWindow();
        if (window == null) {
            return false;
        }
        return window.handleTouchHitTest(x, y);
    }

    public void touchesBegin(int num, int[] ids, float[] xs, float[] ys) {
        XEWindow window;
        if (this.isRunning() && (window = this.director.getWindow()) != null) {
            window.handleTouchesBegin(num, ids, xs, ys);
        }
    }

    public void touchesMoved(int num, int[] ids, float[] xs, float[] ys) {
        XEWindow window;
        if (this.isRunning() && (window = this.director.getWindow()) != null) {
            window.handleTouchesMove(num, ids, xs, ys);
        }
    }

    public void touchesEnded(int num, int[] ids, float[] xs, float[] ys) {
        XEWindow window;
        if (this.isRunning() && (window = this.director.getWindow()) != null) {
            window.handleTouchesEnd(num, ids, xs, ys);
        }
    }

    public void touchesCancelled(int num, int[] ids, float[] xs, float[] ys) {
        XEWindow window;
        if (this.isRunning() && (window = this.director.getWindow()) != null) {
            window.handleTouchesCancel(num, ids, xs, ys);
        }
    }

    public void dispatchMessage(String message) {
        this.director.dispatchMessage(message);
    }

    public void registerMessageSendListener(XEMessageManager.IMessageSendListener l) {
        this.director.registerMessageSendListener(l);
    }

    public void unRegisterMessageSendListener(XEMessageManager.IMessageSendListener l) {
        this.director.unRegisterMessageSendListener(l);
    }

    public String getLibraryPath() {
        return this.director.getLibraryPath();
    }

    public boolean arIsActive() {
        return this.director.arIsActive();
    }

    public void activeARSupport(boolean actvie, boolean internal) {
        this.director.activeARSupport(actvie, internal);
    }

    public Context getContext() {
        return this.context;
    }

    public void onResume() {
        AudioEngine.onEnterForeground();
        XESystemEventDispatcher.callResume();
    }

    public void onPause() {
        AudioEngine.onEnterBackground();
        XESystemEventDispatcher.callPause();
    }

    @Deprecated
    public void configResourcePath(String esPath, String libraryPath) {
        this.director.configlibraryPath(libraryPath);
    }

    @Deprecated
    public void configlibraryPath(String libraryPath) {
        this.setLibraryPath(libraryPath);
    }

    @Deprecated
    public static void configEsPath(String arg) {
    }

    @Deprecated
    public void uploadRelationLocation(float[] rFrame, String sceneId) {
        this.updateRelationLocation(rFrame, sceneId);
    }

    static {
        try {
            System.loadLibrary("c++_shared");
            System.loadLibrary("xeengine");
        }
        catch (Exception e) {
            Logger.e("XE3DEngine load xeengine error:", e);
        }
        catch (Error err) {
            Logger.e("XE3DEngine load xeengine error:", err);
        }
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                System.loadLibrary("arcore_sdk_c");
                System.loadLibrary("arengine");
                isAREngineLoeded = true;
                XE3DEngine.getInstance().director.registerARModule(ARCore.getInstance());
            }
        }
        catch (Exception e) {
            Logger.e("XE3DEngine load arengine error:", e);
        }
        catch (Error err) {
            Logger.e("XE3DEngine load arengine error:", err);
        }
        try {
            System.loadLibrary("luaengine");
            isLuaEngineLoeded = true;
        }
        catch (Exception e) {
            Logger.e("XE3DEngine load luaengine error:", e);
        }
        catch (Error err) {
            Logger.e("XE3DEngine load luaengine error:", err);
        }
    }

    private static class HOLDER {
        private static final XE3DEngine sInstance = new XE3DEngine();

        private HOLDER() {
        }
    }
}

