/*
 * Decompiled with CFR 0.152.
 */
package com.momo.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Looper;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.momo.test.Logger;
import com.momo.widget.XUIEditBox;
import com.momo.widget.XUITypefaces;
import com.momo.xeengine.XE3DEngine;

public class XUIEditBoxHelper {
    private static final String TAG = "[JAVA][XUIEditBoxHelper]";
    private static IXUIActivity sActivity;
    private static FrameLayout mFrameLayout;
    private static SparseArray<XUIEditBox> sEditBoxArray;
    private static int sViewTag;
    private static float sPadding;

    public static void __editBoxEditingDidBegin(int index) {
        XUIEditBoxHelper.editBoxEditingDidBegin(index);
    }

    public static void __editBoxEditingChanged(int index, String text) {
        XUIEditBoxHelper.editBoxEditingChanged(index, text);
    }

    public static void __editBoxEditingDidEnd(int index, String text, int action) {
        XUIEditBoxHelper.editBoxEditingDidEnd(index, text, action);
    }

    private static native void editBoxReturnKeyPressed(int var0, String var1, int var2);

    public static void __editBoxReturnKeyPressed(int index, String text, int action) {
        XUIEditBoxHelper.editBoxReturnKeyPressed(index, text, action);
    }

    private static native void editBoxEditingDidSend(int var0, String var1);

    public static void __editBoxEditingDidSend(int index, String text) {
        XUIEditBoxHelper.editBoxEditingDidSend(index, text);
    }

    public static void init(IXUIActivity activity) {
        sActivity = activity;
        sEditBoxArray = new SparseArray();
    }

    public static void release() {
        sActivity = null;
        mFrameLayout = null;
        sEditBoxArray = null;
        sViewTag = 0;
        sPadding = 5.0f;
    }

    public static int getPadding(float scaleX) {
        return (int)(sPadding * scaleX);
    }

    public static int createEditBox(final int left, final int top, final int width, final int height, final float scaleX) {
        final int index = sViewTag;
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sActivity == null) {
                    return;
                }
                ViewGroup rootViewGroup = sActivity.getRootViewGroup();
                final XUIEditBox editBox = new XUIEditBox((Context)sActivity.getActivity());
                editBox.setFocusable(true);
                editBox.setFocusableInTouchMode(true);
                editBox.setInputFlag(5);
                editBox.setInputMode(6);
                editBox.setReturnType(0);
                editBox.setHintTextColor(-7829368);
                editBox.setVisibility(8);
                editBox.setBackgroundColor(0);
                editBox.setTextColor(-1);
                editBox.setSingleLine();
                editBox.setOpenGLViewScaleX(scaleX);
                editBox.setPadding(XUIEditBoxHelper.getPadding(scaleX), 0, 0, 0);
                FrameLayout.LayoutParams lParams = new FrameLayout.LayoutParams(-2, -2);
                lParams.leftMargin = left;
                lParams.topMargin = top;
                lParams.width = width;
                lParams.height = height;
                lParams.gravity = 51;
                Context pContext = rootViewGroup.getContext();
                mFrameLayout = new FrameLayout(pContext);
                mFrameLayout.setBackgroundColor(Color.green((int)128));
                rootViewGroup.addView((View)mFrameLayout);
                mFrameLayout.addView((View)editBox, (ViewGroup.LayoutParams)lParams);
                editBox.setTag(false);
                editBox.addTextChangedListener(new TextWatcher(){

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                        int nReturnKeyType = editBox.GetReturnType();
                        if (count == 1 && s.charAt(s.length() - 1) == '\n') {
                            if (nReturnKeyType == 1) {
                                editBox.setVisibility(8);
                                final String t = new String(s.toString().substring(0, s.length() - 1));
                                editBox.setText(t);
                                XUIEditBoxHelper.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        XUIEditBoxHelper.__editBoxReturnKeyPressed(index, t, 1);
                                    }
                                });
                            } else if (nReturnKeyType == 2) {
                                editBox.setText("");
                                final String text = new String(editBox.getText().toString());
                                XUIEditBoxHelper.runOnGLThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        XUIEditBoxHelper.__editBoxEditingDidSend(index, text);
                                    }
                                });
                            }
                        }
                    }

                    public void afterTextChanged(Editable s) {
                        if (!editBox.getChangedTextProgrammatically().booleanValue() && ((Boolean)editBox.getTag()).booleanValue()) {
                            final String text = s.toString();
                            XUIEditBoxHelper.runOnGLThread(new Runnable(){

                                @Override
                                public void run() {
                                    XUIEditBoxHelper.__editBoxEditingChanged(index, text);
                                }
                            });
                        }
                        editBox.setChangedTextProgrammatically(false);
                    }
                });
                editBox.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                    public void onFocusChange(View v, boolean hasFocus) {
                        editBox.setTag(true);
                        editBox.setChangedTextProgrammatically(false);
                        if (hasFocus) {
                            XUIEditBoxHelper.runOnGLThread(new Runnable(){

                                @Override
                                public void run() {
                                    editBox.endAction = 0;
                                    XUIEditBoxHelper.__editBoxEditingDidBegin(index);
                                }
                            });
                            editBox.setSelection(editBox.getText().length());
                            sActivity.setSoftKeyboardShown(true);
                            Logger.e(XUIEditBoxHelper.TAG, "edit box get focus");
                        } else {
                            editBox.setVisibility(8);
                            final String text = editBox.getText().toString();
                            XUIEditBoxHelper.runOnGLThread(new Runnable(){

                                @Override
                                public void run() {
                                    int action = editBox.endAction;
                                    XUIEditBoxHelper.__editBoxEditingDidEnd(index, text, action);
                                }
                            });
                            Logger.e(XUIEditBoxHelper.TAG, "edit box lose focus");
                        }
                    }
                });
                editBox.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View v, int keyCode, KeyEvent event) {
                        if (event.getAction() == 0 && keyCode == 66 && (editBox.getInputType() & 0x20000) != 131072) {
                            XUIEditBoxHelper.closeKeyboardOnUiThread(index);
                            return true;
                        }
                        return false;
                    }
                });
                editBox.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        if (actionId == 5) {
                            editBox.endAction = 1;
                            XUIEditBoxHelper.closeKeyboardOnUiThread(index);
                            return true;
                        }
                        if (actionId == 6) {
                            XUIEditBoxHelper.closeKeyboardOnUiThread(index);
                        }
                        return false;
                    }
                });
                sEditBoxArray.put(index, (Object)editBox);
            }
        });
        return sViewTag++;
    }

    public static void removeEditBox(final int index) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    sEditBoxArray.remove(index);
                    if (mFrameLayout != null) {
                        mFrameLayout.removeView((View)editBox);
                        mFrameLayout = null;
                    }
                    editBox = null;
                    Logger.e(XUIEditBoxHelper.TAG, "remove EditBox");
                }
            }
        });
    }

    public static void setFont(final int index, final String fontName, final float fontSize) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (sActivity == null) {
                    return;
                }
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    Typeface tf;
                    if (!fontName.isEmpty()) {
                        if (fontName.endsWith(".ttf")) {
                            try {
                                tf = XUITypefaces.get((Context)sActivity.getActivity(), fontName);
                            }
                            catch (Exception e) {
                                tf = Typeface.create((String)fontName, (int)0);
                            }
                        } else {
                            tf = Typeface.create((String)fontName, (int)0);
                        }
                    } else {
                        tf = Typeface.DEFAULT;
                    }
                    if (fontSize >= 0.0f) {
                        editBox.setTextSize(0, fontSize);
                    }
                    editBox.setTypeface(tf);
                }
            }
        });
    }

    public static void setFontColor(final int index, final int red, final int green, final int blue, final int alpha) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setTextColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
                }
            }
        });
    }

    public static void setPlaceHolderText(final int index, final String text) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setHint(text);
                }
            }
        });
    }

    public static void setPlaceHolderTextColor(final int index, final int red, final int green, final int blue, final int alpha) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setHintTextColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
                }
            }
        });
    }

    public static void setMaxLength(final int index, final int maxLength) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setMaxLength(maxLength);
                }
            }
        });
    }

    public static void setVisible(final int index, final boolean visible) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setVisibility(visible ? 0 : 8);
                }
            }
        });
    }

    public static void setText(final int index, final String text) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setChangedTextProgrammatically(true);
                    editBox.setText(text);
                    int position = text.length();
                    editBox.setSelection(position);
                }
            }
        });
    }

    public static void setReturnType(final int index, final int returnType) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setReturnType(returnType);
                }
            }
        });
    }

    public static void setTextHorizontalAlignment(final int index, final int alignment) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setTextHorizontalAlignment(alignment);
                }
            }
        });
    }

    public static void setInputMode(final int index, final int inputMode) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setInputMode(inputMode);
                }
            }
        });
    }

    public static void setInputFlag(final int index, final int inputFlag) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setInputFlag(inputFlag);
                }
            }
        });
    }

    public static void setEditBoxViewRect(final int index, final int left, final int top, final int maxWidth, final int maxHeight) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
                if (editBox != null) {
                    editBox.setEditBoxViewRect(left, top, maxWidth, maxHeight);
                }
            }
        });
    }

    public static void openKeyboard(final int index) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBoxHelper.openKeyboardOnUiThread(index);
            }
        });
    }

    private static void openKeyboardOnUiThread(int index) {
        if (sActivity == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Logger.e(TAG, "openKeyboardOnUiThread doesn't run on UI thread!");
            return;
        }
        InputMethodManager imm = (InputMethodManager)sActivity.getSystemService("input_method");
        XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
        if (null != editBox) {
            editBox.requestFocus();
            sActivity.getRootViewGroup().requestLayout();
            imm.showSoftInput((View)editBox, 0);
            sActivity.setSoftKeyboardShown(true);
        }
    }

    private static void closeKeyboardOnUiThread(int index) {
        if (sActivity == null) {
            return;
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            Logger.e(TAG, "closeKeyboardOnUiThread doesn't run on UI thread!");
            return;
        }
        InputMethodManager imm = (InputMethodManager)sActivity.getSystemService("input_method");
        XUIEditBox editBox = (XUIEditBox)((Object)sEditBoxArray.get(index));
        if (null != editBox) {
            imm.hideSoftInputFromWindow(editBox.getWindowToken(), 0);
            sActivity.setSoftKeyboardShown(false);
            sActivity.getRootViewGroup().requestFocus();
        }
    }

    public static void closeKeyboard(final int index) {
        XUIEditBoxHelper.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                XUIEditBoxHelper.closeKeyboardOnUiThread(index);
            }
        });
    }

    private static void runOnUiThread(Runnable runnable) {
        if (sActivity != null) {
            sActivity.runOnUiThread(runnable);
        }
    }

    private static void runOnGLThread(Runnable runnable) {
        XE3DEngine.getInstance().queueEvent(runnable);
    }

    private static native void editBoxEditingDidBegin(int var0);

    private static native void editBoxEditingChanged(int var0, String var1);

    private static native void editBoxEditingDidEnd(int var0, String var1, int var2);

    static {
        sViewTag = 0;
        sPadding = 5.0f;
    }

    public static interface IXUIActivity {
        public ViewGroup getRootViewGroup();

        public void setSoftKeyboardShown(boolean var1);

        public void runOnUiThread(Runnable var1);

        public Object getSystemService(String var1);

        public Activity getActivity();
    }
}

