/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.util.Log;
import com.momo.gl.EGL14Wrapper;
import com.momo.gl.GLFrameBuffer;
import com.momo.gl.filter.LazyFilter;
import com.momo.test.Logger;
import com.momo.xeengine.XE3DEngine;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class SharedExecutor {
    private static final String TAG = SharedExecutor.class.getName();
    private static final int BLOCING_TIMEOUT = 5000;
    private List<TaskWrapper> mTaskWrappers = new ArrayList<TaskWrapper>();
    private Thread mRenderThread;
    private EGLContext mEGLContext;
    private LazyFilter mLazyFilter;
    private final Object mStartThreadLock = new Object();
    private final Object mTaskListLock = new Object();
    private final Object mStartFlagLock = new Object();
    private BlockingQueue<TaskWrapper> mTaskQueue = new ArrayBlockingQueue<TaskWrapper>(1);
    private BlockingQueue<TaskWrapper> mResultQueue = new ArrayBlockingQueue<TaskWrapper>(1);
    private boolean isStarted;
    private ConcurrentLinkedQueue<Runnable> mRunnables = new ConcurrentLinkedQueue();
    private TaskWrapper mCurrentTask;

    private SharedExecutor() {
    }

    public static SharedExecutor getInstance() {
        return Holder.sInstance;
    }

    public void init(EGLContext context) {
        this.mEGLContext = context;
    }

    public void queue(Runnable runnable) {
        this.mRunnables.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderTask(String name, int width, int height, OnRenderCallback callback) {
        TaskWrapper wrapper = new TaskWrapper();
        wrapper.callback = callback;
        wrapper.name = name;
        wrapper.mSize = new Point(width, height);
        Logger.d(TAG, "\u6dfb\u52a0\u4efb\u52a1: ---\u8fdb\u5165\u9501\u524d " + wrapper.toString());
        Object object = this.mTaskListLock;
        synchronized (object) {
            Logger.d(TAG, "\u6dfb\u52a0\u4efb\u52a1: ---\u8fdb\u5165\u9501\u540e " + wrapper.toString());
            this.mTaskWrappers.add(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRender() {
        Logger.d(TAG, "startRender: ---\u8fdb\u5165\u9501\u524d" + this.hashCode());
        Object object = this.mStartThreadLock;
        synchronized (object) {
            Logger.d(TAG, "startRender: ---\u8fdb\u5165\u9501\u540e");
            if (this.mRenderThread == null) {
                if (this.mEGLContext == null) {
                    this.mEGLContext = EGL14.eglGetCurrentContext();
                }
                Thread thread = new Thread((Runnable)new SharedThread(this.mEGLContext), "XENGINE_RENDER_THREAD");
                Logger.d(TAG, "startRender: -------\u521b\u5efa\u7ebf\u7a0b-- thread:" + thread.hashCode());
                this.mRenderThread = thread;
                thread.start();
            }
            Logger.d(TAG, "startRender: ---\u521b\u5efa\u5b8c\u6bd5 thread:" + this.mRenderThread.hashCode());
        }
    }

    public void removeTask(String name) {
        TaskWrapper taskWrapper = new TaskWrapper();
        taskWrapper.name = name;
        this.remove(taskWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(TaskWrapper taskWrapper) {
        Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u8fdb\u5165\u9501\u524d --- name:" + Thread.currentThread().getName() + "-" + Thread.currentThread().toString() + ",name:" + taskWrapper.name);
        Object object = this.mTaskListLock;
        synchronized (object) {
            Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u8fdb\u5165\u9501\u540e --- name:" + Thread.currentThread().getName() + "-" + Thread.currentThread().toString() + ",name:" + taskWrapper.name);
            if (this.mTaskWrappers.size() == 0) {
                Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u6267\u884c\u7ed3\u675f  ---");
                return;
            }
            int index = this.mTaskWrappers.indexOf(taskWrapper);
            if (index != -1) {
                final TaskWrapper task = this.mTaskWrappers.get(index);
                Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---remove index == " + index + ",name = " + task.name);
                this.mTaskWrappers.remove(index);
                this.queue(new Runnable(){

                    @Override
                    public void run() {
                        Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1 in queue: ---frameBuffer.destroyFrameBuffer  ---name:" + task.name);
                        if (task.frameBuffer != null) {
                            task.frameBuffer.destoryBuffer();
                        }
                    }
                });
            }
            if (this.mTaskWrappers.size() == 0) {
                Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u9000\u51fa\u4e4b\u524d \u5bf9\u521b\u5efa\u7ebf\u7a0b\u8fdb\u884c\u52a0\u9501  ---");
                Object object2 = this.mStartThreadLock;
                synchronized (object2) {
                    Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u4efb\u52a1\u5217\u8868\u7a7a\u4e86\uff0c\u653e\u4e2a\u9000\u51fa\u7684\u6307\u4ee4\u8fc7\u53bb   ---");
                    TaskWrapper task = new TaskWrapper();
                    task.taskFlag = 1;
                    try {
                        if (this.isStarted) {
                            this.mTaskQueue.put(task);
                            Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u9000\u51fa\u7684\u6307\u4ee4\u5df2\u7ecf\u653e\u8fc7\u53bb\uff0c\u5148\u7761\u4e00\u4f1a   ---");
                            TaskWrapper result = this.mResultQueue.poll(5000L, TimeUnit.MILLISECONDS);
                            Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u7761\u9192\u4e86---" + result);
                        }
                    }
                    catch (InterruptedException e) {
                        Logger.printStakeTrace(e);
                    }
                }
            }
            Logger.d(TAG, "----\u79fb\u9664\u4efb\u52a1: ---\u6267\u884c\u7ed3\u675f \u7ebf\u7a0b\u53ef\u4ee5\u91cd\u65b0\u521b\u5efa\u4e86 ---name:" + taskWrapper.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTextureAvailable(int id) {
        if (id == 0) {
            return false;
        }
        Object object = this.mTaskListLock;
        synchronized (object) {
            for (TaskWrapper taskWrapper : this.mTaskWrappers) {
                if (taskWrapper.textureOut != id) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(String name) {
        Logger.d(TAG, "renderTask: \u521a\u8fdb\u6765------------thread:" + Thread.currentThread().getName() + "-" + Thread.currentThread().toString() + ",name:" + name);
        if (!this.isStarted) {
            return;
        }
        Object object = this.mTaskListLock;
        synchronized (object) {
            for (TaskWrapper wrapper : this.mTaskWrappers) {
                if (!wrapper.name.equals(name)) continue;
                try {
                    Logger.d(TAG, "renderTask: ---\u51c6\u5907 put\u4efb\u52a1-- thread:" + (this.mRenderThread == null ? "null" : Integer.valueOf(this.mRenderThread.hashCode())) + "\uff0ctaskQueue\uff1a" + this.mTaskQueue.hashCode());
                    Object object2 = this.mStartFlagLock;
                    synchronized (object2) {
                        if (this.isStarted) {
                            this.mTaskQueue.put(wrapper);
                        }
                    }
                    Logger.d(TAG, "renderTask: --- \u5b8c\u6210 put --");
                }
                catch (InterruptedException e) {
                    Logger.printStakeTrace(e);
                }
                try {
                    Logger.d(TAG, "renderTask: ---\u51c6\u5907 take \u7ed3\u679c-- thread:" + (this.mRenderThread == null ? "null" : Integer.valueOf(this.mRenderThread.hashCode())) + "\uff0cResultQueue\uff1a" + this.mResultQueue.hashCode());
                    Object e = this.mStartFlagLock;
                    synchronized (e) {
                        if (this.isStarted) {
                            TaskWrapper result = this.mResultQueue.poll(5000L, TimeUnit.MILLISECONDS);
                            Logger.d(TAG, "renderTask: --- \u5b8c\u6210 take \u7ed3\u679c-- " + result);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Logger.printStakeTrace(e);
                }
            }
        }
        Logger.d(TAG, "renderTask \u5b8c\u6210\u4e86: ------------" + name);
    }

    @TargetApi(value=17)
    private void glRun(EGLContext eglContext) {
        EGL14Wrapper egl = new EGL14Wrapper();
        egl.createDummyScreenEgl(eglContext);
        this.onGLThreadStart();
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---\u73af\u5883\u521b\u5efa\u5b8c\u6bd5\uff0c\u5373\u5c06\u8fdb\u5165\u5faa\u73af ");
        while (true) {
            egl.makeCurrent();
            try {
                this.isStarted = true;
                Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---\u51c6\u5907take\u4efb\u52a1 thread:" + this.mRenderThread.hashCode() + "\uff0ctaskQueue\uff1a" + this.mTaskQueue.hashCode());
                this.mCurrentTask = this.mTaskQueue.take();
                Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---\u5b8c\u6210take\u4efb\u52a1 name = " + this.mCurrentTask.name);
            }
            catch (InterruptedException e) {
                Logger.printStakeTrace(e);
            }
            if (this.mCurrentTask.taskFlag == 0) {
                Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a --- TYPE_RENDER");
                this.executeRenderTask(this.mCurrentTask);
                Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---  \u5b8c\u6210\u6e32\u67d3  ---");
                this.runTask();
                continue;
            }
            if (this.mCurrentTask.taskFlag == 1) break;
        }
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a --- TYPE_EXIT");
        this.runTask();
        this.isStarted = false;
        this.onGLThreadDestroy();
        egl.releaseEgl();
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---\u7ebf\u7a0b\u5b8c\u5168\u9000\u51fa---");
        this.mRenderThread = null;
        try {
            this.mResultQueue.offer(this.mCurrentTask, 5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"executeRenderTask: mResultQueue.put(currentTask)\u9000\u51fa\u585e\u7ed3\u679c failed");
            Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---mResultQueue.put \u51fa\u73b0\u95ee\u9898 TYPE_EXIT-----------------------  ");
        }
    }

    private void executeRenderTask(TaskWrapper currentTask) {
        int[] bufferArray;
        int width = currentTask.mSize.x;
        int height = currentTask.mSize.y;
        if (currentTask.frameBuffer == null) {
            int id;
            GLFrameBuffer frameBuffer;
            Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---  frameBuffer \u8fdb\u884c\u521b\u5efa  ---");
            currentTask.frameBuffer = frameBuffer = new GLFrameBuffer(width, height);
            frameBuffer.activityFrameBuffer(width, height);
            int status = GLES20.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                throw new RuntimeException(this + ": Failed to set up render buffer with status " + status + " and error " + GLES20.glGetError());
            }
            currentTask.textureOut = id = frameBuffer.getTexture_out()[0];
            currentTask.callback.onTextureCreated(currentTask.name, id);
        }
        if ((bufferArray = currentTask.frameBuffer.getFrameBuffer()) == null) {
            try {
                Log.e((String)TAG, (String)("executeRenderTask: frameBuffer[]==null!!!!!" + currentTask.name));
                this.mResultQueue.offer(currentTask, 5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)"executeRenderTask: mResultQueue.put(currentTask) frameBuffer[]==null!!!!!   put \u7ed3\u679c failed");
            }
            return;
        }
        GLES20.glBindFramebuffer((int)36160, (int)bufferArray[0]);
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        Logger.mark("alllll");
        Logger.mark("drawTexureIn");
        this.drawTextureIn(currentTask.callback.getBgTexture(), currentTask.mSize.x, currentTask.mSize.y);
        Logger.check("drawTexureIn");
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---  onRender \u5f00\u59cb\u4f60\u7684\u6e32\u67d3  ---,name:" + this.mCurrentTask.name);
        Logger.mark("onRender");
        currentTask.callback.onRender(this.mCurrentTask.name);
        Logger.check("onRender");
        Logger.check("alllll");
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---  onRender \u4f60\u7684\u8868\u6f14\u7ed3\u675f 88  ---");
        try {
            Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a --- \u585e\u4e2a\u7ed3\u679c\u56de\u53bb  --- ResultQueue:" + this.mResultQueue.hashCode());
            this.mResultQueue.offer(currentTask, 5000L, TimeUnit.MILLISECONDS);
            Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a --- \u585e\u5b8c\u7ed3\u679c  ---");
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"executeRenderTask: mResultQueue.put(currentTask)\u585e\u4e2a\u7ed3\u679cfailed");
            Logger.printStakeTrace(e);
        }
    }

    private void drawTextureIn(int textureIn, int x, int y) {
        if (textureIn > 0 && this.mTaskWrappers.size() < 2) {
            if (this.mLazyFilter == null) {
                this.mLazyFilter = new LazyFilter();
                this.mLazyFilter.create();
            }
            Logger.d(TAG, "drawTextureIn: ---enableClearColor ---");
            XE3DEngine.getInstance().enableClearColor(false);
            Logger.d(TAG, "drawTextureIn: ---draw ---");
            this.mLazyFilter.draw(textureIn);
            Logger.d(TAG, "drawTextureIn: ---\u80cc\u666f\u7eb9\u7406\u7ed8\u5236---");
        } else {
            Logger.d(TAG, "drawTextureIn: ---\u80cc\u666f\u7eb9\u7406\u4e0d\u7528\u7ed8\u5236---");
            XE3DEngine.getInstance().enableClearColor(true);
        }
    }

    private void runTask() {
        while (!this.mRunnables.isEmpty()) {
            this.mRunnables.poll().run();
        }
    }

    private void onGLThreadStart() {
        this.mTaskQueue.clear();
        this.mResultQueue.clear();
    }

    private void onGLThreadDestroy() {
        XE3DEngine.getInstance().endEngine();
        if (this.mLazyFilter != null) {
            this.mLazyFilter.destroy();
            this.mLazyFilter = null;
        }
        Logger.d(TAG, "\u6e32\u67d3\u7ebf\u7a0b\uff1a ---onGLThreadDestroy---\u6e05\u7a7a\u4e86\u4efb\u52a1queue\u8ddf\u7ed3\u679cqueue");
    }

    public void destroy() {
        this.mEGLContext = null;
    }

    public static void shot(int w, int h) {
        ByteBuffer buf = ByteBuffer.allocateDirect(w * h * 4);
        buf.position(0);
        long start = System.currentTimeMillis();
        GLES20.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)buf);
        Bitmap bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.copyPixelsFromBuffer((Buffer)buf);
        Logger.d("shotScreen time--" + (System.currentTimeMillis() - start));
    }

    private class TaskWrapper {
        public Point mSize;
        public GLFrameBuffer frameBuffer;
        public OnRenderCallback callback;
        public int textureIn;
        public int textureOut;
        public int taskFlag;
        public String name;
        public static final int TYPE_RENDER = 0;
        public static final int TYPE_EXIT = 1;

        private TaskWrapper() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskWrapper that = (TaskWrapper)o;
            if (this.name != null) {
                return this.name.equals(that.name);
            }
            return this.callback != null && this.callback.equals(that.callback);
        }

        public int hashCode() {
            if (this.name != null) {
                return this.name.hashCode();
            }
            if (this.callback != null) {
                return this.callback.hashCode();
            }
            return 0;
        }

        public String toString() {
            return "name:" + this.name + ",type = " + this.taskFlag + "-hashCode:" + this.hashCode();
        }
    }

    public static interface OnRenderCallback {
        public void onTextureCreated(String var1, int var2);

        public int getBgTexture();

        public void onRender(String var1);
    }

    private class SharedThread
    implements Runnable {
        EGLContext mContext;

        public SharedThread(EGLContext eglContext) {
            this.mContext = eglContext;
        }

        @Override
        public void run() {
            SharedExecutor.this.glRun(this.mContext);
        }
    }

    private static class Holder {
        private static SharedExecutor sInstance = new SharedExecutor();

        private Holder() {
        }
    }
}

