/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import com.momo.render.EngineRender;
import com.momo.widget.RenderViewContainer;

public abstract class RenderController {
    private RenderViewContainer container;
    private EngineRender render;

    public RenderController(RenderViewContainer container) {
        this.container = container;
        this.init();
    }

    private void init() {
        this.render = new EngineRender(this.container.getContext(), this.getInternalPath(), this.getLibraryPath(), this.getScenePath());
        this.container.setRender(this.render);
    }

    public void onPause() {
        if (this.container != null) {
            this.container.onPause();
        }
        if (this.render != null) {
            this.render.onPause();
        }
    }

    public void onResume() {
        if (this.container != null) {
            this.container.onResume();
        }
    }

    public void onDestroy() {
        if (this.render != null) {
            this.render.onDestroy();
        }
    }

    public void uploadRelationLocation(float[] frame) {
        if (this.render != null) {
            this.render.uploadRelationLocation(frame);
        }
    }

    public void tickTimeLineAndFrameSequence(long time) {
        if (this.render != null) {
            this.render.tickTimeLineAndFrameSequence(time);
        }
    }

    public void setScenePath(String scenePath) {
        if (this.render != null) {
            this.render.setScenePath(scenePath);
        }
    }

    public abstract String getInternalPath();

    public abstract String getLibraryPath();

    public abstract String getScenePath();
}

