/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import android.text.TextUtils;
import com.momo.listener.ISurfaceListener;
import com.momo.widget.GLTextureView;
import com.momo.widget.GLTextureViewContainer;
import com.momo.xeengine.XE3DEngine;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class GLTextureController {
    private GLTextureViewContainer container;
    private GLTextureView.IGLRender mRender;
    private boolean isCreate;
    private boolean isLoadScene;
    private String sceneId;
    private Map<Integer, float[]> frames = new HashMap<Integer, float[]>();

    public GLTextureController(GLTextureViewContainer container) {
        this.container = container;
    }

    public void remove() {
        if (this.container != null) {
            this.container.remove();
        }
        this.isCreate = false;
        this.isLoadScene = false;
    }

    public boolean isAddedTextureView() {
        return this.container != null && this.container.getChildCount() > 0;
    }

    public void add() {
        XE3DEngine.getInstance().init(this.container.getContext());
        this.mRender = new GLRenderImpl();
        if (this.container != null) {
            this.container.add();
            this.container.setGLRender(this.mRender);
        }
    }

    public void uploadRelationLocation(float[] frame) {
        if (this.isLoadScene) {
            XE3DEngine.getInstance().updateRelationLocation(frame, this.sceneId);
        } else {
            this.frames.put(1, frame);
        }
    }

    public void uploadRelationLocationWithTrackId(int trackid, float[] frame) {
        if (this.isLoadScene) {
            XE3DEngine.getInstance().updateRelationLocationWithTrackId(trackid, frame, this.sceneId);
        } else {
            this.frames.put(trackid, frame);
        }
    }

    public void tickTimeLineAndFrameSequence(long time) {
        if (!TextUtils.isEmpty((CharSequence)this.sceneId)) {
            XE3DEngine.getInstance().tickTimeLineAndFrameSequence(time, 0, this.sceneId);
        }
    }

    public void setScenePath(String scenePath) {
        if (!TextUtils.isEmpty((CharSequence)scenePath) && !TextUtils.equals((CharSequence)scenePath, (CharSequence)this.getScenePath())) {
            this.sceneId = System.currentTimeMillis() + "_" + this.getLibraryPath();
            XE3DEngine.getInstance().loadSceneWithId(scenePath, this.sceneId);
        }
    }

    public abstract String getInternalPath();

    public abstract String getLibraryPath();

    public abstract String getScenePath();

    public void setSurfaceListener(ISurfaceListener l) {
        if (this.container != null) {
            this.container.setSurfaceListener(l);
        }
    }

    private final class GLRenderImpl
    implements GLTextureView.IGLRender {
        private GLRenderImpl() {
        }

        @Override
        public void onStopRender() {
            XE3DEngine.getInstance().endEngine();
        }

        @Override
        public void onSurfaceCreated() {
            if (!GLTextureController.this.isCreate) {
                GLTextureController.this.isCreate = true;
                String libraryPath = GLTextureController.this.getLibraryPath();
                XE3DEngine.getInstance().configResourcePath(GLTextureController.this.getInternalPath(), libraryPath);
                XE3DEngine.getInstance().runEngine();
                XE3DEngine.getInstance().clearBackground();
                if (!TextUtils.isEmpty((CharSequence)GLTextureController.this.getScenePath())) {
                    GLTextureController.this.isLoadScene = true;
                    GLTextureController.this.sceneId = System.currentTimeMillis() + "_" + libraryPath;
                    XE3DEngine.getInstance().loadSceneWithId(GLTextureController.this.getScenePath(), GLTextureController.this.sceneId);
                    if (GLTextureController.this.frames != null && GLTextureController.this.frames.size() > 0) {
                        Iterator iterator = GLTextureController.this.frames.keySet().iterator();
                        while (iterator.hasNext()) {
                            int trackId = (Integer)iterator.next();
                            XE3DEngine.getInstance().updateRelationLocationWithTrackId(trackId, (float[])GLTextureController.this.frames.get(trackId), GLTextureController.this.sceneId);
                        }
                        GLTextureController.this.frames.clear();
                    }
                }
            }
        }

        @Override
        public void onSurfaceChanged(int width, int height) {
            XE3DEngine.getInstance().resizeWindow(width, height);
        }

        @Override
        public void onDrawFrame() {
            GLTextureController.this.container.requestRender();
            if (!TextUtils.isEmpty((CharSequence)GLTextureController.this.sceneId)) {
                XE3DEngine.getInstance().render(GLTextureController.this.sceneId);
            }
        }
    }
}

