/*
 * Decompiled with CFR 0.152.
 */
package com.momo.render;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.text.TextUtils;
import com.momo.xeengine.XE3DEngine;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class EngineRender
implements GLSurfaceView.Renderer {
    private boolean isCreate;
    private boolean isLoadScene;
    private String internalPath;
    private String libraryPath;
    private String scenePath;
    private String sceneId;
    private float[] frame;

    public EngineRender(Context c, String internalPath, String libraryPath, String scenePath) {
        this.internalPath = internalPath;
        this.libraryPath = libraryPath;
        this.scenePath = scenePath;
        XE3DEngine.getInstance().init(c);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        if (!this.isCreate) {
            this.isCreate = true;
            XE3DEngine.getInstance().configResourcePath(this.internalPath, this.libraryPath);
            XE3DEngine.getInstance().runEngine();
            XE3DEngine.getInstance().clearBackground();
            if (!TextUtils.isEmpty((CharSequence)this.scenePath)) {
                this.isLoadScene = true;
                this.sceneId = System.currentTimeMillis() + "_" + this.libraryPath;
                XE3DEngine.getInstance().loadSceneWithId(this.scenePath, this.sceneId);
                if (this.frame != null) {
                    XE3DEngine.getInstance().uploadRelationLocation(this.frame, this.sceneId);
                }
            }
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        XE3DEngine.getInstance().resizeWindow(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (!TextUtils.isEmpty((CharSequence)this.sceneId)) {
            XE3DEngine.getInstance().render(this.sceneId);
        }
    }

    public void onPause() {
        this.isCreate = false;
        XE3DEngine.getInstance().endEngine();
    }

    public void onDestroy() {
        this.isCreate = false;
        XE3DEngine.getInstance().endEngine();
    }

    public void uploadRelationLocation(float[] frame) {
        if (this.isLoadScene) {
            XE3DEngine.getInstance().uploadRelationLocation(frame, this.sceneId);
        } else {
            this.frame = frame;
        }
    }

    public void setScenePath(String scenePath) {
        if (!TextUtils.isEmpty((CharSequence)scenePath) && !TextUtils.equals((CharSequence)scenePath, (CharSequence)this.scenePath)) {
            this.scenePath = scenePath;
            this.sceneId = System.currentTimeMillis() + "_" + this.libraryPath;
            XE3DEngine.getInstance().loadSceneWithId(this.scenePath, this.sceneId);
        }
    }

    public void tickTimeLineAndFrameSequence(long time) {
        if (!TextUtils.isEmpty((CharSequence)this.sceneId)) {
            XE3DEngine.getInstance().tickTimeLineAndFrameSequence(time, 0, this.sceneId);
        }
    }
}

