/*
 * Decompiled with CFR 0.152.
 */
package com.momo.presenter.impl;

import android.content.Context;
import android.graphics.SurfaceTexture;
import com.momo.gl.GLThread;
import com.momo.presenter.IGLPresenter;
import com.momo.widget.GLTextureView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class GLPresenterImpl
implements IGLPresenter {
    private WeakReference<GLTextureView> mView;
    private GLThread mGLThread;
    private List<Runnable> cacheEvents = new ArrayList<Runnable>();
    private GLTextureView.IGLRender renderer;
    private GLThread.EGLContextFactory mContextFactory;

    public GLPresenterImpl(GLTextureView mView) {
        this.mView = new WeakReference<GLTextureView>(mView);
    }

    @Override
    public void init() {
    }

    @Override
    public void queueEvent(Runnable r) {
        if (this.mGLThread != null) {
            this.mGLThread.queueEvent(r);
            return;
        }
        this.cacheEvents.add(r);
    }

    @Override
    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    @Override
    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
    }

    @Override
    public void setGLRender(GLTextureView.IGLRender render) {
        this.renderer = render;
        if (this.mGLThread != null) {
            this.mGLThread.setRenderer(render);
        }
    }

    @Override
    public void setGLContextFactory(GLThread.EGLContextFactory factory) {
        this.mContextFactory = factory;
    }

    @Override
    public GLThread createGLThread(SurfaceTexture surface) {
        if (this.mGLThread != null) {
            return this.mGLThread;
        }
        GLThread.Builder builder = new GLThread.Builder();
        this.mGLThread = builder.setRenderMode(this.getRenderMode()).setSurface(surface).setRenderer(this.renderer).setEglContextFactory(this.mContextFactory).setEGLConfigChooser(true).setEGLConfigChooser(new GLThread.SimpleEGLConfigChooser(true, 2)).createGLThread();
        this.mGLThread.start();
        GLTextureView iView = this.getView();
        if (iView != null) {
            this.updateSurface(iView.getWidth(), iView.getHeight());
        }
        for (Runnable r : this.cacheEvents) {
            this.mGLThread.queueEvent(r);
        }
        return this.mGLThread;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        if (this.mGLThread == null) {
            this.createGLThread(surface);
        } else {
            this.mGLThread.setSurface(surface);
            this.updateSurface(width, height);
        }
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GLThread glThread = this.createGLThread(surface);
        glThread.onWindowResize(width, height);
        glThread.requestRenderAndWait();
    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        if (this.mGLThread != null) {
            this.mGLThread.surfaceDestroyed();
            this.mGLThread.requestExitAndWait();
        }
        return true;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    private void updateSurface(int width, int height) {
        if (this.mGLThread != null) {
            this.mGLThread.surfaceCreated();
            this.mGLThread.onWindowResize(width, height);
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
    }

    int getRenderMode() {
        return 0;
    }

    GLTextureView getView() {
        if (this.mView == null) {
            return null;
        }
        return (GLTextureView)((Object)this.mView.get());
    }

    Context getContext() {
        GLTextureView iView = this.getView();
        if (iView == null) {
            return null;
        }
        return iView.getContext();
    }
}

