/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl;

import android.opengl.GLES20;
import android.os.Build;
import android.util.Log;

public class GLFrameBuffer {
    public boolean isLocked;
    protected int[] frameBuffer;
    protected int[] texture_out;
    protected int[] depthRenderBuffer;
    private Object countLock = new Object();
    private int framebufferReferenceCount = 0;
    private int mWidth;
    private int mHeight;
    private boolean isInited = false;
    static boolean isUsedFloat = false;
    private boolean isFloat = false;

    public GLFrameBuffer(int width, int height) {
        this.frameBuffer = new int[1];
        this.texture_out = new int[1];
        this.depthRenderBuffer = new int[1];
    }

    public boolean cloudRelease() {
        return this.framebufferReferenceCount <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object object = this.countLock;
        synchronized (object) {
            this.isLocked = true;
            ++this.framebufferReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.countLock;
        synchronized (object) {
            --this.framebufferReferenceCount;
            if (this.framebufferReferenceCount < 1) {
                this.isLocked = false;
            }
        }
    }

    public int[] getFrameBuffer() {
        return this.frameBuffer;
    }

    public int[] getTexture_out() {
        return this.texture_out;
    }

    public int[] getDepthRenderBuffer() {
        return this.depthRenderBuffer;
    }

    public void destoryBuffer() {
        if (this.frameBuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
            this.frameBuffer = null;
        }
        if (this.texture_out != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.texture_out, (int)0);
            this.texture_out = null;
        }
        if (this.depthRenderBuffer != null) {
            GLES20.glDeleteRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
            this.depthRenderBuffer = null;
        }
    }

    public int getBufferWidth() {
        return this.mWidth;
    }

    public int getBufferHigh() {
        return this.mHeight;
    }

    public void setFloat(boolean aFloat) {
        String str;
        if (Build.VERSION.SDK_INT >= 21 && (str = GLES20.glGetString((int)7939)).contains("GL_OES_texture_half_float")) {
            this.isFloat = aFloat;
        }
    }

    public void activityFrameBuffer(int width, int height) {
        if (this.isInited) {
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        GLES20.glGenFramebuffers((int)1, (int[])this.frameBuffer, (int)0);
        GLES20.glGenRenderbuffers((int)1, (int[])this.depthRenderBuffer, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.texture_out, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBuffer[0]);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_out[0]);
        if (this.isFloat) {
            int GL_OES_texture_half_float = 36193;
            int GL_RGBA16F_EXT = 34842;
            GLES20.glTexImage2D((int)3553, (int)0, (int)GL_RGBA16F_EXT, (int)width, (int)height, (int)0, (int)6408, (int)GL_OES_texture_half_float, null);
            Log.i((String)"tag", (String)"use half float ");
        } else {
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        }
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.texture_out[0], (int)0);
        GLES20.glBindRenderbuffer((int)36161, (int)this.depthRenderBuffer[0]);
        GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
        GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.depthRenderBuffer[0]);
        this.isInited = true;
    }
}

