/*
 * Decompiled with CFR 0.152.
 */
package com.momo.gl;

import android.opengl.GLES20;

public class FrameBuffer {
    private int[] mFrameTemp;
    private int lastWidth = 0;
    private int lastHeight = 0;

    public int bindFrameBuffer(int width, int height) {
        return this.bindFrameBuffer(width, height, false);
    }

    public int bindFrameBuffer(int width, int height, boolean hasRenderBuffer) {
        if (this.lastWidth != width || this.lastHeight != height) {
            this.destroyFrameBuffer();
            this.lastWidth = width;
            this.lastHeight = height;
        }
        if (this.mFrameTemp == null) {
            return this.createFrameBuffer(hasRenderBuffer, width, height, 3553, 6408, 9729, 9729, 33071, 33071);
        }
        return this.bindFrameBuffer();
    }

    public int createFrameBuffer(boolean hasRenderBuffer, int width, int height, int texType, int texFormat, int minParams, int maxParams, int wrapS, int wrapT) {
        this.mFrameTemp = new int[4];
        GLES20.glGenFramebuffers((int)1, (int[])this.mFrameTemp, (int)0);
        GLES20.glGenTextures((int)1, (int[])this.mFrameTemp, (int)1);
        GLES20.glBindTexture((int)texType, (int)this.mFrameTemp[1]);
        GLES20.glTexImage2D((int)texType, (int)0, (int)texFormat, (int)width, (int)height, (int)0, (int)texFormat, (int)5121, null);
        GLES20.glTexParameteri((int)texType, (int)10241, (int)minParams);
        GLES20.glTexParameteri((int)texType, (int)10240, (int)maxParams);
        GLES20.glTexParameteri((int)texType, (int)10242, (int)wrapS);
        GLES20.glTexParameteri((int)texType, (int)10243, (int)wrapT);
        GLES20.glGetIntegerv((int)36006, (int[])this.mFrameTemp, (int)3);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameTemp[0]);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)texType, (int)this.mFrameTemp[1], (int)0);
        if (hasRenderBuffer) {
            GLES20.glGenRenderbuffers((int)1, (int[])this.mFrameTemp, (int)2);
            GLES20.glBindRenderbuffer((int)36161, (int)this.mFrameTemp[2]);
            GLES20.glRenderbufferStorage((int)36161, (int)33189, (int)width, (int)height);
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.mFrameTemp[2]);
        }
        return GLES20.glGetError();
    }

    public int bindFrameBuffer() {
        if (this.mFrameTemp == null) {
            return -1;
        }
        GLES20.glGetIntegerv((int)36006, (int[])this.mFrameTemp, (int)3);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameTemp[0]);
        return GLES20.glGetError();
    }

    public void unBindFrameBuffer() {
        if (this.mFrameTemp != null) {
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameTemp[3]);
            GLES20.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)0);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameTemp[1], (int)0);
        }
    }

    public int getCacheTextureId() {
        return this.mFrameTemp != null ? this.mFrameTemp[1] : -1;
    }

    public void destroyFrameBuffer() {
        if (this.mFrameTemp != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameTemp, (int)0);
            GLES20.glDeleteTextures((int)1, (int[])this.mFrameTemp, (int)1);
            if (this.mFrameTemp[2] > 0) {
                GLES20.glDeleteRenderbuffers((int)1, (int[])this.mFrameTemp, (int)2);
            }
            this.mFrameTemp = null;
        }
    }
}

