/*
 * Decompiled with CFR 0.152.
 */
package com.momo.egl;

import android.util.Log;
import com.momo.egl.EglContextWrapper;
import com.momo.egl.IEgl;
import com.momo.gl.GLThread;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglImpl
implements IEgl {
    protected GLThread.EGLConfigChooser eglConfigChooser;
    protected GLThread.EGLContextFactory eglContextFactory;
    protected GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    protected EGL10 mEgl;
    protected EGLDisplay mEglDisplay;
    protected EGLSurface mEglSurface;
    protected EGLConfig mEglConfig;
    protected EGLContext mEglContext;

    public EglImpl(GLThread.EGLConfigChooser eglConfigChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = eglConfigChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContextWrapper) {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
        this.mEglContext = this.eglContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig, eglContextWrapper.getEglOldContext());
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            this.mEglContext = null;
        }
        this.mEglSurface = null;
        EglContextWrapper eglContext = new EglContextWrapper();
        eglContext.setEglOldContext(this.mEglContext);
        return eglContext;
    }

    @Override
    public boolean createSurface(Object surface) {
        if (this.mEgl == null) {
            throw new RuntimeException("egl not initialized");
        }
        if (this.mEglDisplay == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.mEglConfig == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        return this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext);
    }

    @Override
    public int swap() {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
            return this.mEgl.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            this.mEgl.eglTerminate(this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentation(long nsecs) {
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }
}

