/*
 * Decompiled with CFR 0.152.
 */
package com.momo.egl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import com.momo.egl.EglContextWrapper;
import com.momo.egl.IEgl;
import com.momo.gl.GLThread;

public class Egl17Impl
implements IEgl {
    protected GLThread.EGLConfigChooser eglConfigChooser;
    protected GLThread.EGLContextFactory eglContextFactory;
    protected GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    protected EGLDisplay mEglDisplay;
    protected EGLSurface mEglSurface;
    protected EGLConfig mEglConfig;
    protected EGLContext mEglContext;

    public Egl17Impl(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = configChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContextWrapper) {
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEglDisplay = null;
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEglDisplay, false);
        this.mEglContext = this.eglContextFactory.createContextAPI17(this.mEglDisplay, this.mEglConfig, eglContextWrapper.getEglContext());
        if (this.mEglContext == null || this.mEglContext == EGL14.EGL_NO_CONTEXT) {
            this.mEglContext = null;
        }
        this.mEglSurface = null;
        EglContextWrapper eglContext = new EglContextWrapper();
        eglContext.setEglContext(this.mEglContext);
        return eglContext;
    }

    @Override
    public boolean createSurface(Object surface) {
        if (this.mEglDisplay == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.mEglConfig == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL14.EGL_NO_SURFACE) {
            int error = EGL14.eglGetError();
            return false;
        }
        return EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext);
    }

    @Override
    public int swap() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
            return EGL14.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentation(long nsecs) {
        if (Build.VERSION.SDK_INT >= 18 && nsecs != 0L) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (long)nsecs);
        }
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }
}

