/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.recorder;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.media.MediaMetadataRetriever;
import android.opengl.EGLContext;
import android.text.TextUtils;
import android.view.SurfaceHolder;
import com.core.glcore.camera.ICamera;
import com.core.glcore.config.MRConfig;
import com.core.glcore.util.BodyLandHelper;
import com.core.glcore.util.ErrorDotStatistics;
import com.core.glcore.util.FileUtil;
import com.core.glcore.util.Log4Cam;
import com.google.ar.core.Session;
import com.immomo.baseutil.TextureRotationUtil;
import com.immomo.moment.config.MRecorderActions;
import com.immomo.moment.datadot.DataDotUtils;
import com.immomo.moment.mediautils.VideoDataRetrieverBySoft;
import com.immomo.moment.mediautils.af;
import com.immomo.moment.mediautils.y;
import com.immomo.moment.model.VideoFragment;
import com.immomo.moment.recorder.MomoRecorder;
import com.immomo.moment.util.c;
import com.mm.mdlog.MDLog;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;

public class MultiRecorder {
    private final MomoRecorder recorder = new MomoRecorder();
    private LinkedList<VideoFragment> videoFragments;
    private String mediaOutPath;
    private boolean isRecording = false;
    private MRecorderActions.OnRecordFinishedListener recordFinishedListener;
    private y splicingThread = null;
    private boolean isDebugDrawPointer = false;
    private String mBgPath;
    private int mBgStartPosition;
    private int mBgEndPosition;
    public af mResolutionSelector = null;
    private boolean mHasBackgroundMusic = false;
    private MRecorderActions.OnErrorDotDataListener mOnErrorDotDataListener = null;
    private int serveCode = 100000;

    public void setDebugDrawPointer(boolean debugDrawPointer) {
        this.isDebugDrawPointer = debugDrawPointer;
        if (this.recorder != null) {
            this.recorder.setDrawPointerDebug(this.isDebugDrawPointer);
        }
    }

    public void setAdjustBrightnessInterval(int frames) {
        if (this.recorder != null) {
            this.recorder.setAdjustBrightnessInterval(frames);
        }
    }

    public LinkedList<VideoFragment> getVideoFragments() {
        return this.videoFragments;
    }

    private void addVideoFragment(VideoFragment videoFragment) {
        if (videoFragment == null) {
            MDLog.e((String)"RecoderUtils", (String)"Don't insert empty object");
            return;
        }
        if (this.videoFragments == null) {
            this.videoFragments = new LinkedList();
        }
        this.videoFragments.addLast(videoFragment);
    }

    private void dump() {
        if (this.videoFragments == null || this.videoFragments.size() == 0) {
            MDLog.e((String)"RecoderUtils", (String)"jarek current content empty");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.videoFragments.size(); ++i2) {
            stringBuilder.append("Frag" + i2 + ":" + this.videoFragments.get(i2).getVideoPath() + "\n");
        }
        MDLog.e((String)"RecoderUtils", (String)("jarek current content:" + stringBuilder));
    }

    private void removeLastFragment() {
        if (this.videoFragments == null || this.videoFragments.size() == 0) {
            return;
        }
        String string = this.videoFragments.getLast().getVideoPath();
        this.videoFragments.removeLast();
        if (string == null) {
            MDLog.e((String)"RecoderUtils", (String)"The video path of videoFragments is null !!!");
            return;
        }
        File file = new File(string);
        FileUtil.deleteFile((File)file);
    }

    public synchronized void setMediaOutPath(String outPath) {
        this.mediaOutPath = outPath;
        MDLog.i((String)"RecoderUtils", (String)("The mediaOutPath is " + this.mediaOutPath));
    }

    public synchronized void setBackGroundMusic(boolean hasBackgroundMusic) {
        this.mHasBackgroundMusic = hasBackgroundMusic;
    }

    public synchronized void startRecording() {
        if (this.isRecording) {
            MDLog.e((String)"RecoderUtils", (String)"recording is true, have you forget to stop?");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mediaOutPath)) {
            MDLog.e((String)"RecoderUtils", (String)"The mediaOutPath is empty, please set outpath first !!!");
            throw new RuntimeException("set outPath first");
        }
        String string = this.generateFragmentPath();
        this.recorder.setBackGroundMusic(this.mHasBackgroundMusic);
        this.recorder.startRecording(string);
        this.isRecording = true;
    }

    public synchronized void stopRecording() {
        if (!this.isRecording) {
            MDLog.e((String)"RecoderUtils", (String)"recording is false, have you forget to start?");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 1001, "recording is false, have you forget to start record !!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1001) + "]" + "recording is false, have you forget to start record !!!");
            return;
        }
        VideoFragment videoFragment = this.recorder.stopRecording();
        if (videoFragment != null) {
            this.addVideoFragment(videoFragment);
        }
        this.isRecording = false;
    }

    private List<String> getFragments() {
        if (this.videoFragments == null) {
            return new LinkedList<String>();
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.videoFragments.size());
        for (int i2 = 0; i2 < this.videoFragments.size(); ++i2) {
            if (!this.isPathExist(this.videoFragments.get(i2).getVideoPath())) continue;
            arrayList.add(this.videoFragments.get(i2).getVideoPath());
        }
        return arrayList;
    }

    public List<String> getFragmentList() {
        return this.getFragments();
    }

    private boolean isPathExist(String path) {
        try {
            return new File(path).exists();
        }
        catch (Throwable throwable) {
            MDLog.printErrStackTrace((String)"RecoderUtils", (Throwable)throwable);
            return false;
        }
    }

    public void finishRecording(List<String> fragmentList, String mediaOutPath, String cfgPath, MRecorderActions.OnRecordFinishedListener listener, Context ctx) {
        MDLog.i((String)"RecoderUtils", (String)"Start calling finishRecording !!!");
        if (fragmentList != null && fragmentList.size() > 0 && cfgPath != null && ctx != null) {
            this.decideResolutionStrategy(fragmentList.get(0), cfgPath, ctx);
        }
        this.startSplicing(fragmentList, mediaOutPath, cfgPath, listener);
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoSegments(fragmentList.size());
    }

    public synchronized void cancelRecording() {
        if (this.videoFragments == null || this.videoFragments.size() < 1) {
            MDLog.e((String)"RecoderUtils", (String)"Start calling cancelRecording !!!");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i2 = 0; i2 < MultiRecorder.this.videoFragments.size(); ++i2) {
                        File file = new File(((VideoFragment)MultiRecorder.this.videoFragments.get(i2)).getVideoPath());
                        if (!file.exists()) continue;
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    MDLog.printErrStackTrace((String)"RecoderUtils", (Throwable)throwable);
                    if (MultiRecorder.this.mOnErrorDotDataListener != null) {
                        MultiRecorder.this.mOnErrorDotDataListener.onError(MultiRecorder.this.serveCode + 1002, "Cancel recording happened file error !!!");
                    }
                    ErrorDotStatistics.getInstance().addErrInfo("[" + (MultiRecorder.this.serveCode + 1002) + "]" + "Cancel recording happened file error !!!");
                }
            }
        }).start();
    }

    public synchronized void removeLast() {
        this.removeLastFragment();
    }

    public synchronized long getTotalLength() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.videoFragments.size(); ++i2) {
            l2 += this.videoFragments.get(i2).getDuration();
        }
        return l2;
    }

    public synchronized int getFragmentCount() {
        if (this.videoFragments == null) {
            return 0;
        }
        return this.videoFragments.size();
    }

    private String generateFragmentPath() {
        if (TextUtils.isEmpty((CharSequence)this.mediaOutPath)) {
            MDLog.e((String)"RecoderUtils", (String)"mediaOutPath is null !!!");
            throw new RuntimeException("mediaOutPath is null");
        }
        String string = this.mediaOutPath.replace(".mp4", System.currentTimeMillis() + ".mp4");
        MDLog.e((String)"RecoderUtils", (String)("jarek fragment path:" + string));
        return string;
    }

    public synchronized boolean isFrontCamera() {
        return this.recorder.isFrontCamera();
    }

    public synchronized void setPreviewDisplay(SurfaceHolder holder) {
        this.recorder.setPreviewDisplay(holder);
    }

    public synchronized void setVisualSize(int w2, int h2) {
        this.recorder.setVisualSize(w2, h2);
    }

    public synchronized void onPause() {
        if (this.isRecording) {
            this.stopRecording();
        }
        this.recorder.release();
    }

    public synchronized void loadFaceModel() {
        this.recorder.loadFaceModel();
    }

    public synchronized void loadGestureModel(String modelPath) {
        boolean bl = this.recorder.loadGestureModel(modelPath);
        if (!bl) {
            MDLog.e((String)"ImageProcess", (String)"Load gesture mode failed !!!");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 1011, "Load Gesture Mode Failed !!!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1011) + "]" + "Load Gesture Mode Failed !!!!");
        }
    }

    public synchronized boolean loadHandGestureModel(String modelPath) {
        boolean bl = this.recorder.loadHandGestureModel(modelPath);
        if (!bl) {
            MDLog.e((String)"ImageProcess", (String)"Load new hand gesture mode failed !!!!");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 1012, "Load New Hand Gesture Mode Failed !!!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1012) + "]" + "Load New Hand Gesture Mode Failed !!!!");
        }
        return bl;
    }

    public synchronized void loadSegmentModel(String modelPath) {
        this.recorder.loadSegmentModel(modelPath);
    }

    public synchronized void setSessionInfo(Session session, boolean isAR) {
        this.recorder.setSessionInfo(session, isAR);
    }

    public synchronized void loadBodyLandModel(boolean isWhiteList, String modelPath) {
        this.recorder.loadBodyLandModel(isWhiteList, modelPath);
    }

    public synchronized void setSharedContext(EGLContext context) {
        this.recorder.setSharedContext(context);
    }

    public synchronized boolean prepare(Activity activity, MRConfig mrConfig) {
        return this.recorder.prepare((Context)activity, TextureRotationUtil.getRotationAngle((Activity)activity), mrConfig);
    }

    public synchronized boolean prepare(Context context, int displayerRotation, MRConfig mrConfig) {
        return this.recorder.prepare(context, displayerRotation, mrConfig);
    }

    public void setOnErrorListener(MRecorderActions.OnErrorListener onErrorListener) {
        this.recorder.setOnErrorListener(onErrorListener);
    }

    public void setOnPreparedListener(MRecorderActions.OnPreparedListener onPreparedListener) {
        this.recorder.setOnPreparedListener(onPreparedListener);
    }

    public void setOnFPSChangeListener(MRecorderActions.OnFpsChangeListener onFpsChangeListener) {
        this.recorder.setOnFPSChangeListener(onFpsChangeListener);
    }

    public void setDoFaceDetect(boolean b2) {
        this.recorder.setDoFaceDetect(b2);
    }

    public void setOnCameraSetListener(ICamera.onCameraSetListener onCameraSetListener2) {
        this.recorder.setOnCameraSetListener(onCameraSetListener2);
    }

    public void setAudioDataCallback(MRecorderActions.AudioDataCallback audioDataCallback) {
        this.recorder.setAudioDataCallback(audioDataCallback);
    }

    public void setOnRecordStoppedListener(MRecorderActions.OnRecordStoppedListener onRecordStoppedListener) {
        this.recorder.setOnRecordStoppedListener(onRecordStoppedListener);
    }

    public void setOnRecordFinishedListener(MRecorderActions.OnRecordFinishedListener onRecordFinishedListener) {
        this.recordFinishedListener = onRecordFinishedListener;
    }

    public void setOnErrorDotDataListener(MRecorderActions.OnErrorDotDataListener onErrorDotDataListener) {
        this.mOnErrorDotDataListener = onErrorDotDataListener;
        this.recorder.setOnErrorDotDataListener(onErrorDotDataListener);
    }

    public void startPreview() {
        this.recorder.startPreview();
    }

    public void addFilterToDestroy(BasicFilter filter) {
        this.recorder.addFilterToDestory(filter);
    }

    public void selectFaceDetectFilter(BasicFilter videoProcessFilter) {
        this.recorder.selectFaceDetectFilter(videoProcessFilter);
    }

    public void setFaceEyeScale(float bigEye) {
        this.recorder.setFaceEyeScale(bigEye);
    }

    public void setFaceThinScale(float thinFace) {
        this.recorder.setFaceThinScale(thinFace);
    }

    public void setAwlFaceType(int type) {
        this.recorder.setAwlFaceType(type);
    }

    public void setFaceWarp(boolean isEnable) {
        if (this.recorder != null) {
            this.recorder.setFaceWarp(isEnable);
        }
    }

    public void setSegmentDetect(boolean isEnable) {
        if (this.recorder != null) {
            this.recorder.setSegmentDetect(isEnable);
        }
    }

    public void setGestureDetector(Boolean isEnable) {
        if (this.recorder != null) {
            this.recorder.setGestureDetector(isEnable);
        }
    }

    public void switchCamera(Activity activity) {
        this.recorder.switchCamera(TextureRotationUtil.getRotationAngle((Activity)activity));
    }

    public void switchCamera(int displayRotation) {
        this.recorder.switchCamera(displayRotation);
    }

    public void focusOnRect(Rect focusRect, Camera.AutoFocusCallback callback) {
        this.recorder.focusOnRect(focusRect, callback);
    }

    public void focusOnTouch(double x2, double y2, int viewWidth, int viewHeight) {
        if (this.recorder != null) {
            this.recorder.focusOnTouch(x2, y2, viewWidth, viewHeight);
        }
    }

    public void startSplicing(List<String> inPath, final String outPath, String cfgPath, final MRecorderActions.OnRecordFinishedListener listener) {
        final long l2 = System.currentTimeMillis();
        MDLog.i((String)"RecoderUtils", (String)" Start splicing videos !!!");
        if (inPath != null && outPath != null && inPath.size() > 0 && inPath.size() == 1) {
            try {
                File file = new File(inPath.get(0));
                File file2 = new File(outPath);
                c.a(file, file2);
                if (listener != null) {
                    listener.onRecordFinished();
                    MultiRecorder.getVideoInfo(outPath);
                }
            }
            catch (IOException iOException) {
                MDLog.e((String)"RecoderUtils", (String)("When splice file copy failed !!! " + iOException.toString()));
                if (listener != null) {
                    listener.onFinishError("\u751f\u6210\u6587\u4ef6\u9519\u8bef\uff01");
                }
                if (this.mOnErrorDotDataListener != null) {
                    this.mOnErrorDotDataListener.onError(this.serveCode + 1003, "When splice file copy failed !!! " + iOException.toString());
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1003) + "]" + "When splice file copy failed !!! " + iOException.toString());
            }
            this.deleteBakFile();
            return;
        }
        y y2 = new y();
        y2.a(new MRecorderActions.onDotErrorListener(){

            @Override
            public void onFail(int errCode, String info) {
                MDLog.e((String)"RecoderUtils", (String)("Splice file is failed because of " + info));
                if (MultiRecorder.this.mOnErrorDotDataListener != null) {
                    MultiRecorder.this.mOnErrorDotDataListener.onError(MultiRecorder.this.serveCode + errCode, "[" + (MultiRecorder.this.serveCode + errCode) + "]" + info);
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (MultiRecorder.this.serveCode + errCode) + "]" + info);
            }
        });
        if (y2.a(inPath, outPath)) {
            y2.a(new MRecorderActions.OnProcessProgressListener(){

                @Override
                public void onProcessProgress(float progress) {
                    MDLog.e((String)"RecoderUtils", (String)("Process " + progress));
                    if (listener != null) {
                        int n2 = (int)(progress * 100.0f);
                        listener.onFinishingProgress(n2 > 100 ? 100 : n2);
                    }
                }

                @Override
                public void onProcessFinished() {
                    MDLog.e((String)"RecoderUtils", (String)"Splicing process finished !");
                    if (listener != null) {
                        listener.onFinishingProgress(100);
                        listener.onRecordFinished();
                        MultiRecorder.getVideoInfo(outPath);
                        long l22 = System.currentTimeMillis();
                        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraEncoderTime(l22 - l2);
                    }
                    MultiRecorder.this.deleteBakFile();
                }
            });
            y2.a();
        } else {
            MDLog.e((String)"RecoderUtils", (String)"When splice files the out path is empty !!!");
            y2 = null;
            if (listener != null) {
                listener.onFinishError("Media Path Empty");
            }
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 1004, " When splice files the out path is empty !!! ");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1004) + "]" + " When splice files the out path is empty !!! ");
        }
    }

    private void deleteBakFile() {
        if (this.mediaOutPath != null) {
            File file = new File(this.mediaOutPath);
            Serializable serializable = new File(file.getParent(), file.getName() + ".bak");
            FileUtil.deleteFile((File)serializable);
        }
        if (this.videoFragments == null || this.videoFragments.size() == 0) {
            return;
        }
        for (Serializable serializable : this.videoFragments) {
            String string = serializable.getVideoPath();
            if (string == null) {
                MDLog.e((String)"RecoderUtils", (String)"The video path of videoFragments is null !!!");
                return;
            }
            File file = new File(string);
            FileUtil.deleteFile((File)file);
        }
        this.videoFragments.clear();
    }

    private static void getVideoInfo(String outPath) {
        long l2 = 0L;
        File file = new File(outPath);
        if (file.exists() && file.isFile()) {
            l2 = file.length();
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(outPath);
        String string = mediaMetadataRetriever.extractMetadata(20);
        String string2 = mediaMetadataRetriever.extractMetadata(18);
        String string3 = mediaMetadataRetriever.extractMetadata(19);
        String string4 = mediaMetadataRetriever.extractMetadata(9);
        mediaMetadataRetriever.release();
        VideoDataRetrieverBySoft videoDataRetrieverBySoft = new VideoDataRetrieverBySoft();
        videoDataRetrieverBySoft.init(outPath);
        int n2 = videoDataRetrieverBySoft.getFrameRate();
        videoDataRetrieverBySoft.release();
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileBitrate(Integer.parseInt(string));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileWidth(Integer.parseInt(string2));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileHeight(Integer.parseInt(string3));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileDuration(Long.parseLong(string4));
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileSize(l2);
        DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraVideoFileFps(n2);
    }

    public void saveFragmentsToStorage() {
        if (!TextUtils.isEmpty((CharSequence)this.mediaOutPath)) {
            File file = new File(this.mediaOutPath);
            File file2 = new File(file.getParent(), file.getName() + ".bak");
            if (this.videoFragments != null && this.videoFragments.size() > 0) {
                ArrayList<VideoFragment> arrayList = new ArrayList<VideoFragment>(this.videoFragments.size());
                for (int i2 = 0; i2 < this.videoFragments.size(); ++i2) {
                    arrayList.add(this.videoFragments.get(i2));
                }
                try {
                    file2.createNewFile();
                    c.a(file2, arrayList);
                }
                catch (IOException iOException) {
                    MDLog.e((String)"RecoderUtils", (String)("Save fragments to storage failed !!!" + iOException.toString()));
                    if (this.mOnErrorDotDataListener != null) {
                        this.mOnErrorDotDataListener.onError(this.serveCode + 1008, " Save fragments to storage failed !!! " + iOException.toString());
                    }
                    ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1008) + "]" + " Save fragments to storage failed !!! " + iOException.toString());
                    Log4Cam.e((String)iOException.getMessage());
                }
            } else {
                try {
                    if (file2.exists()) {
                        file2.delete();
                    }
                }
                catch (Exception exception) {
                    MDLog.e((String)"RecoderUtils", (String)exception.getMessage());
                }
            }
        }
    }

    public void restoreFragmentsFromStorage(String targetMediaPath) {
        try {
            if (TextUtils.isEmpty((CharSequence)targetMediaPath)) {
                return;
            }
            File file = new File(targetMediaPath);
            File file2 = new File(file.getParent(), file.getName() + ".bak");
            if (file2.exists()) {
                ArrayList arrayList = (ArrayList)c.a(file2);
                if (arrayList == null || arrayList.size() < 1) {
                    return;
                }
                if (this.videoFragments == null) {
                    this.videoFragments = new LinkedList();
                }
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    this.videoFragments.add((VideoFragment)arrayList.get(i2));
                }
            }
            this.dump();
        }
        catch (Throwable throwable) {
            MDLog.printErrStackTrace((String)"RecoderUtils", (Throwable)throwable);
        }
    }

    public int getRestoreDegree() {
        return this.recorder == null ? 90 : this.recorder.getRestoreDegree();
    }

    public int getRotateDegree() {
        return this.recorder == null ? 90 : this.recorder.getRotateDegree();
    }

    public int getCameraFPS() {
        if (this.recorder != null) {
            return this.recorder.getCameraFPS();
        }
        return 0;
    }

    public int getRenderFPS() {
        if (this.recorder != null) {
            return this.recorder.getRenderFPS();
        }
        return 0;
    }

    public void initVideoResolutionSelector(String path, Context context) {
        if (this.mResolutionSelector == null) {
            this.mResolutionSelector = new af(path, context);
        }
    }

    public int selectVideoResolution() {
        if (this.mResolutionSelector != null) {
            return this.mResolutionSelector.g();
        }
        return -1;
    }

    public int getResolutionGpu() {
        if (this.mResolutionSelector != null) {
            return this.mResolutionSelector.b();
        }
        return -1;
    }

    public int VideoResolutionForGreaterKitKat() {
        if (this.mResolutionSelector != null) {
            return this.mResolutionSelector.a();
        }
        return 2;
    }

    public boolean isEnableFaceBeauty() {
        if (this.mResolutionSelector != null) {
            return this.mResolutionSelector.f();
        }
        return true;
    }

    public int getFixedResolutionStrategy() {
        if (this.mResolutionSelector != null) {
            return this.mResolutionSelector.d();
        }
        return -1;
    }

    public void decideResolutionStrategy(String path, String cfgPath, Context ctx) {
        af af2 = new af(cfgPath, ctx);
        long l2 = System.currentTimeMillis();
        if (path != null && (af2 == null || af2.d() == -1)) {
            try {
                af2.a(path);
            }
            catch (Exception exception) {
                MDLog.e((String)"RecoderUtils", (String)(" Decide resolution failed !!! " + exception.toString()));
                if (this.mOnErrorDotDataListener != null) {
                    this.mOnErrorDotDataListener.onError(this.serveCode + 1009, " Decide resolution failed !!! " + exception.toString());
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 1009) + "]" + " Decide resolution failed !!! " + exception.toString());
            }
        }
        if (af2 != null) {
            af2.e();
            af2 = null;
        }
    }

    public void takePhoto(String path) {
        if (this.recorder != null) {
            this.recorder.takePhoto(path);
        }
    }

    public void setOnTakePhotoListener(MRecorderActions.OnTakePhotoListener listener) {
        if (this.recorder != null) {
            this.recorder.setOnTakePhotoListener(listener);
        }
    }

    public boolean isSupportFlashOnMode() {
        if (this.recorder != null) {
            return this.recorder.isSupportFlashOnMode();
        }
        return false;
    }

    public boolean isSupportFlashAutoMode() {
        if (this.recorder != null) {
            return this.recorder.isSupportFlashAutoMode();
        }
        return false;
    }

    public void setFlashMode(String mode) {
        if (this.recorder != null) {
            this.recorder.setFlashMode(mode);
        }
    }

    public void resetCamera(int degress) {
        if (this.recorder != null) {
            this.recorder.resetCamera(degress);
        }
    }

    public void setDigimonMode(boolean digimonMode, String modePath, String faModelPath, String fdModelPath) {
        if (this.recorder != null) {
            this.recorder.setDigimonMode(digimonMode, modePath, faModelPath, fdModelPath);
        }
    }

    public void setNeedFeatureData(boolean needFeatureData) {
        if (this.recorder != null) {
            this.recorder.setNeedFeatureData(needFeatureData);
        }
    }

    public void setOnFeatureDetectedListener(MRecorderActions.OnFeatureDetectedListener onFeatureDetectedListener) {
        if (this.recorder != null) {
            this.recorder.setOnFeatureDetectedListener(onFeatureDetectedListener);
        }
    }

    public void setFaceExpressionDetectSwitch(boolean isActiveSwitch) {
        if (this.recorder != null) {
            this.recorder.setFaceExpressionDetectSwitch(isActiveSwitch);
        }
    }

    public void setEncodeSizeChangeListener(MRecorderActions.OnEncodeSizeChangeListener onEncodeSizeChangeListener) {
        if (this.recorder != null) {
            this.recorder.setOnEncodeSizeChangeListener(onEncodeSizeChangeListener);
        }
    }

    public void setPreviewInfoListener(cameraPreviewInfo previewInfoListener) {
        if (this.recorder != null) {
            this.recorder.setPreviewInfoListener(previewInfoListener);
        }
    }

    public void setMmcvModelUploadListener(MRecorderActions.OnMMCVModelUploadListener listener) {
        if (this.recorder != null) {
            this.recorder.setMmcvModelUploadListener(listener);
        }
    }

    public void setOnRenderFrameListener(MRecorderActions.OnRenderFrameListener listener) {
        if (this.recorder != null) {
            this.recorder.setOnRenderFrameListener(listener);
        }
    }

    public void setDataRecycleModel(String modePath, String bitmapPath, int uploadCnt) {
        if (this.recorder != null) {
            this.recorder.setDataRecycleModel(modePath, bitmapPath, uploadCnt);
        }
    }

    public void setBarenessDetectModel(String modePath) {
        if (this.recorder != null) {
            this.recorder.setBarenessDetectModel(modePath);
        }
    }

    public void setBarenessUploadImagePath(String path) {
        if (this.recorder != null) {
            this.recorder.setBarenessUploadImagePath(path);
        }
    }

    public void setOnBarenessCheckListener(MRecorderActions.OnBarenessCheckListener listener) {
        if (this.recorder != null) {
            this.recorder.setOnBarenessCheckListener(listener);
        }
    }

    public void setBarenessUploadListener(MRecorderActions.OnMMCVModelUploadListener listener) {
        if (this.recorder != null) {
            this.recorder.setBarenessUploadListener(listener);
        }
    }

    public void setOnFirstFrameRenderedListener(MRecorderActions.OnFirstFrameRenderedListener listener) {
        if (this.recorder != null) {
            this.recorder.setOnFirstFrameRenderedListener(listener);
        }
    }

    public void setFaceDetectModelPath(List<String> faceDetectModelPath) {
        if (this.recorder != null) {
            this.recorder.setFaceDetectModelPath(faceDetectModelPath);
        }
    }

    public void setEyeClassicSwitch(boolean eyeClassicSwitch) {
        if (this.recorder != null) {
            this.recorder.setEyeClassicSwitch(eyeClassicSwitch);
        }
    }

    public void setOnRecordingListener(MRecorderActions.OnRecordStartListener listener) {
        if (this.recorder != null) {
            this.recorder.setOnRecordStartedListener(listener);
        }
    }

    public void setRecorderSpeed(float speed) {
        if (this.recorder != null) {
            this.recorder.setRecoderSpeed(speed);
        }
    }

    public void setUseAdjustLight(boolean useAdjustLight) {
        if (this.recorder != null) {
            this.recorder.setUseAdjustLight(useAdjustLight);
        }
    }

    public void setUseDokiBeauty(boolean useDoki) {
        if (this.recorder != null) {
            this.recorder.setUseDokiBeauty(useDoki);
        }
    }

    public void setNeedBodyWrap(boolean needBodyWrap) {
        if (this.recorder != null) {
            BodyLandHelper.setUseBodyLand((boolean)needBodyWrap);
            this.recorder.setNeedBodyWrap(needBodyWrap);
        }
    }

    public void setBodyWarpWidth(float bodyWarpWidth) {
        if (this.recorder != null) {
            this.recorder.setBodyWarpWidth(bodyWarpWidth);
        }
    }

    public void setBodyWarpLegsLength(float bodyWarpLegsLength) {
        if (this.recorder != null) {
            this.recorder.setBodyWarpLegsLength(bodyWarpLegsLength);
        }
    }

    public void setBodyWarpScaleFactor(float bodyWarpScaleFactor) {
        if (this.recorder != null) {
            this.recorder.setBodyWarpScaleFactor(bodyWarpScaleFactor);
        }
    }

    public void setScreenWidthAndHeight(int width, int height, int rotate) {
        if (this.recorder != null) {
            this.recorder.setScreenWidthAndHeight(width, height, rotate);
        }
    }

    public void setUseCameraVersion2(boolean useCameraVersion2) {
        if (this.recorder != null) {
            this.recorder.setUseCameraVersion2(useCameraVersion2);
        }
    }

    public boolean isSupportZoom() {
        if (this.recorder != null) {
            return this.recorder.isSupportZoom();
        }
        return false;
    }

    public void setZoomLevel(int level) {
        if (this.recorder != null) {
            this.recorder.setZoomLevel(level);
        }
    }

    public int getCurrentZoomLevel() {
        if (this.recorder != null) {
            return this.recorder.getCurrentZoomLevel();
        }
        return 0;
    }

    public int getMaxZoomLevel() {
        if (this.recorder != null) {
            return this.recorder.getMaxZoomLevel();
        }
        return 0;
    }

    public static class PreviewInfo {
        public int cameraFps;
        public int renderFPS;
        public long toScreenMs;
        public long toCodecMs;
        public int inWidth;
        public int inHeight;
        public int realWidth;
        public int realHeight;
        public int rotation;
        public long aveProcessTime;

        public String toString() {
            return "cameraFps = " + this.cameraFps + "\nrenderFPS = " + this.renderFPS + "\ntoScreenMs = " + this.toScreenMs + "\ntoCodecMs = " + this.toCodecMs + "\ninWidth = " + this.inWidth + "\ninHeight = " + this.inHeight + "\nrealWidth = " + this.realWidth + "\nrealHeight = " + this.realHeight + "\naveTime = " + this.aveProcessTime + "\nscRotation = " + this.rotation;
        }
    }

    public static interface cameraPreviewInfo {
        public void onCameraInfo(PreviewInfo var1);
    }
}

