/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.recorder;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.SurfaceHolder;
import com.core.glcore.camera.ICamera;
import com.core.glcore.config.MRConfig;
import com.core.glcore.config.MRCoreParameters;
import com.core.glcore.config.Size;
import com.core.glcore.cv.HandGestureDetector;
import com.core.glcore.cv.ObjectDetector;
import com.core.glcore.util.BodyLandHelper;
import com.core.glcore.util.FacerigHelper;
import com.core.glcore.util.SegmentHelper;
import com.google.ar.core.Session;
import com.immomo.moment.b;
import com.immomo.moment.c;
import com.immomo.moment.config.MRecorderActions;
import com.immomo.moment.config.VisualSizeChangeListener;
import com.immomo.moment.datadot.DataDotUtils;
import com.immomo.moment.e;
import com.immomo.moment.model.VideoFragment;
import com.immomo.moment.recorder.MultiRecorder;
import com.mm.mdlog.MDLog;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;

public class MomoRecorder
implements VisualSizeChangeListener {
    private final String TAG = "MomoRecorder";
    final Object syncOp = new Object();
    private MRConfig mrConfig;
    private MRCoreParameters mrCoreParameters = new MRCoreParameters();
    b mVideoClient;
    private MRecorderActions.OnRecordStartListener mOnRecordingStartedListener = null;
    private MRecorderActions.OnRecordStoppedListener mOnRecordingStoppedListener = null;
    private MRecorderActions.OnErrorListener mOnErrorListener = null;
    private MRecorderActions.OnFacedetectedListener facedetectedListener = null;
    private MRecorderActions.OnTakePhotoListener takePhotoListener = null;
    private MRecorderActions.OnMMCVModelUploadListener mmcvModelUploadListener = null;
    private MRecorderActions.OnRenderFrameListener mOnRenderFrameListener = null;
    private MRecorderActions.OnBarenessCheckListener barenessCheckListener = null;
    private MRecorderActions.OnMMCVModelUploadListener barenessUploadListener = null;
    private MRecorderActions.OnFirstFrameRenderedListener firstFrameRenderedListener = null;
    private MRecorderActions.OnErrorDotDataListener mOnErrorDotDataListener = null;
    WeakReference<Context> mActivity;
    WeakReference<SurfaceHolder> mHolder;
    private ICamera.onCameraSetListener cameraSetListener;
    private boolean doFaceDetect = false;
    private boolean drawPointerDebug = false;
    private float eyeScale;
    private float faceThinScale = 0.0f;
    private int warpType = 1;
    private int surfaceWidth = 0;
    private int surfaceHeight = 0;
    private Handler handler = new Handler(Looper.getMainLooper());
    private EGLContext mSharedEGLContext;
    private boolean isAR = false;
    private Session mSession = null;
    private MRecorderActions.AudioDataCallback mAudioDataCallback;
    private boolean useCameraVersion2 = false;
    String flashMode = null;
    boolean needFeatureData;
    private MRecorderActions.OnFeatureDetectedListener featureDetectedListener;
    private boolean expressionSwitch = false;
    private MultiRecorder.cameraPreviewInfo cameraPreviewInfo = null;
    private MRecorderActions.OnEncodeSizeChangeListener encodeSizeChangeListener;
    String barenessModelPath;
    String barenessImagePath;
    List<String> faceDetectModePath;
    boolean eyeDetectSwitch;

    public void setDrawPointerDebug(boolean drawPointerDebug) {
        this.drawPointerDebug = drawPointerDebug;
        if (this.mVideoClient != null) {
            this.mVideoClient.b(this.drawPointerDebug);
        }
    }

    public void setAdjustBrightnessInterval(int frames) {
        if (this.mVideoClient != null) {
            this.mVideoClient.b(frames);
        }
    }

    public void setSessionInfo(Session session, boolean isAR) {
        this.mSession = session;
        this.isAR = isAR;
    }

    public void setSharedContext(EGLContext EGL14Wrapper2) {
        this.mSharedEGLContext = EGL14Wrapper2;
    }

    public void initVideoClient(MRCoreParameters parameters) {
        if (this.mVideoClient == null) {
            this.mVideoClient = Build.VERSION.SDK_INT < 19 ? new e(parameters) : new c(parameters, this.isAR, this.mSession, ((Context)this.mActivity.get()).getApplicationContext());
            MDLog.i((String)"RecoderUtils", (String)(parameters.toString() + " isAR = " + this.isAR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare(Context context, int degrees, final MRConfig mrConfig) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mActivity = new WeakReference<Context>(context);
            this.mrConfig = mrConfig;
            this.initCoreParams(mrConfig);
            this.mrCoreParameters.useCameraV2 = this.useCameraVersion2;
            this.initVideoClient(this.mrCoreParameters);
            this.mVideoClient.a(this.mSharedEGLContext);
            this.mVideoClient.a(this);
            this.mVideoClient.a(this.mOnRecordingStartedListener);
            this.mVideoClient.a(this.mOnRecordingStoppedListener);
            this.mVideoClient.a(this.cameraSetListener);
            this.mVideoClient.a(this.mAudioDataCallback);
            this.mVideoClient.a(this.mOnErrorListener);
            this.mVideoClient.a(this.mOnErrorDotDataListener);
            this.mVideoClient.a(this.doFaceDetect);
            this.mVideoClient.a(this.eyeScale);
            this.mVideoClient.b(this.faceThinScale);
            this.mVideoClient.a(this.warpType);
            this.mVideoClient.b(this.drawPointerDebug);
            this.mVideoClient.a(new MRecorderActions.OnParameterChangedListener(){

                @Override
                public void onParameterChanged() {
                    ((MomoRecorder)MomoRecorder.this).mrCoreParameters.videoRotation = mrConfig.getVideoRotation();
                }
            });
            this.mVideoClient.a(this.facedetectedListener);
            this.mVideoClient.a(this.takePhotoListener);
            this.mVideoClient.a(this.mmcvModelUploadListener);
            this.mVideoClient.a(this.mOnRenderFrameListener);
            this.mVideoClient.a(this.barenessCheckListener);
            this.mVideoClient.b(this.barenessUploadListener);
            this.mVideoClient.a(this.firstFrameRenderedListener);
            if (this.flashMode != null) {
                this.mVideoClient.c(this.flashMode);
            }
            this.mVideoClient.c(this.needFeatureData);
            this.mVideoClient.a(this.featureDetectedListener);
            this.mVideoClient.d(this.expressionSwitch);
            this.mVideoClient.a(this.cameraPreviewInfo);
            this.mVideoClient.a(this.encodeSizeChangeListener);
            if (this.barenessModelPath != null) {
                this.mVideoClient.d(this.barenessModelPath);
            }
            if (this.barenessImagePath != null) {
                this.mVideoClient.e(this.barenessImagePath);
            }
            if (this.faceDetectModePath != null) {
                this.mVideoClient.a(this.faceDetectModePath);
            }
            if (this.eyeDetectSwitch) {
                this.mVideoClient.e(this.eyeDetectSwitch);
            }
            this.mVideoClient.a(context);
            if (!this.mVideoClient.a(degrees, mrConfig)) {
                MDLog.i((String)"RecoderUtils", (String)"Recoder prepare failed !!!");
                return false;
            }
            MDLog.i((String)"RecoderUtils", (String)"Recoder prepare success !!!");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreview(Object surfaceTexture) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mVideoClient.a(surfaceTexture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreview(SurfaceHolder holder) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mHolder = new WeakReference<SurfaceHolder>(holder);
            if (this.mVideoClient != null) {
                this.mVideoClient.a(holder.getSurface());
            }
        }
    }

    protected void updateSurfaceSize(int width, int height) {
        if (this.mHolder == null) {
            return;
        }
        final SurfaceHolder surfaceHolder = (SurfaceHolder)this.mHolder.get();
        if (surfaceHolder == null) {
            MDLog.e((String)"RecoderUtils", (String)"UpdateSurfaceSize is failed because of the SurfaceHolder is null !!!");
            return;
        }
        this.surfaceHeight = height;
        this.surfaceWidth = width;
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                surfaceHolder.setFixedSize(MomoRecorder.this.surfaceWidth, MomoRecorder.this.surfaceHeight);
                MDLog.i((String)"RecoderUtils", (String)("The recoder surface width = " + MomoRecorder.this.surfaceWidth + " height = " + MomoRecorder.this.surfaceHeight));
            }
        });
    }

    public int getRestoreDegree() {
        return this.mVideoClient == null ? 90 : this.mVideoClient.g();
    }

    public int getRotateDegree() {
        return this.mVideoClient == null ? 90 : this.mVideoClient.h();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPreview() {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                this.mVideoClient.b();
            }
            SegmentHelper.release();
            FacerigHelper.releseFaceRigInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaOutPath(String targetPath) {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                this.mVideoClient.a(targetPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording(@Nullable String targetPath) {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                this.mrCoreParameters.videoRotation = this.mrConfig.getVideoRotation();
                this.mVideoClient.a(this.mOnRecordingStartedListener);
                this.mVideoClient.a(this.mOnRecordingStoppedListener);
                if (!TextUtils.isEmpty((CharSequence)targetPath)) {
                    this.mVideoClient.a(targetPath);
                } else if (TextUtils.isEmpty((CharSequence)this.mVideoClient.e())) {
                    MDLog.e((String)"RecoderUtils", (String)"Video Output is Null!");
                    throw new RuntimeException("Video Output is Null!");
                }
                this.mVideoClient.c();
            }
        }
    }

    public synchronized void setBackGroundMusicPath(String path, int startPtsMs, int endPtsMS) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoFragment stopRecording() {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                return this.mVideoClient.d();
            }
            SegmentHelper.release();
            FacerigHelper.releseFaceRigInfo();
        }
        return null;
    }

    private void initCoreParams(MRConfig mrConfig) {
        this.mrCoreParameters.visualWidth = mrConfig.getVisualSize().getWidth();
        this.mrCoreParameters.visualHeight = mrConfig.getVisualSize().getHeight();
        this.mrCoreParameters.videoBitrate = mrConfig.getVideoBitRate();
        this.mrCoreParameters.videoFPS = mrConfig.getVideoFPS();
        this.mrCoreParameters.videoRotation = mrConfig.getVideoRotation();
        this.mrCoreParameters.previewBufferCount = mrConfig.getPreviewBufferCount();
        this.mrCoreParameters.threadPauseTimeForData = mrConfig.getThreadPauseForData();
        this.mrCoreParameters.encoderGopMode = mrConfig.getEncoderGopMode();
        this.mrCoreParameters.scaleMode = mrConfig.getScaleMode();
        this.mrCoreParameters.scaleRatio = mrConfig.getScaleRatio();
        this.mrCoreParameters.useDefaultEncodeSize = mrConfig.getUseDefaultEncodeSize();
        this.mrCoreParameters.audioRecoderSampleRate = mrConfig.getAudioSampleRate();
        this.mrCoreParameters.audioRecoderChannelConfig = mrConfig.getAudioChannels();
        this.mrCoreParameters.audioBufferSize = mrConfig.getAudioBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCamera(int degrees) {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                this.mVideoClient.b(degrees, this.mrConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCamera(int degrees) {
        Object object = this.syncOp;
        synchronized (object) {
            if (this.mVideoClient != null) {
                this.mVideoClient.c(degrees, this.mrConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnRecordStartedListener(MRecorderActions.OnRecordStartListener listener) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mOnRecordingStartedListener = listener;
            if (this.mVideoClient != null) {
                this.mVideoClient.a(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnRecordStoppedListener(MRecorderActions.OnRecordStoppedListener listener) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mOnRecordingStoppedListener = listener;
            if (this.mVideoClient != null) {
                this.mVideoClient.a(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDoFaceDetect(boolean dofaceDetect) {
        Object object = this.syncOp;
        synchronized (object) {
            this.doFaceDetect = dofaceDetect;
            if (this.mVideoClient != null) {
                this.mVideoClient.a(dofaceDetect);
            }
        }
    }

    public void focusOnRect(Rect rect, Camera.AutoFocusCallback callback) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(rect, callback);
        }
    }

    public void focusOnTouch(double x2, double y2, int viewWidth, int viewHeight) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(x2, y2, viewWidth, viewHeight);
        }
    }

    public void setFaceEyeScale(float eyeScale) {
        this.eyeScale = eyeScale;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(eyeScale);
        }
    }

    public void setFaceThinScale(float scale) {
        this.faceThinScale = scale;
        if (this.mVideoClient != null) {
            this.mVideoClient.b(scale);
        }
    }

    public void setAwlFaceType(int type) {
        this.warpType = type;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.warpType);
        }
    }

    public void setFaceWarp(boolean isEnable) {
        int n2 = this.warpType = isEnable ? this.warpType : 0;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.warpType);
        }
    }

    public void setSegmentDetect(boolean isEnable) {
        if (this.mVideoClient != null) {
            this.mVideoClient.f(isEnable);
        }
    }

    public void setGestureDetector(Boolean isEnable) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(isEnable);
        }
    }

    @Override
    public void onVisualSizeChanged(int width, int height) {
        this.updateSurfaceSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.syncOp;
        synchronized (object) {
            this.unsetListeners();
            if (this.mVideoClient != null) {
                this.mVideoClient.a((VisualSizeChangeListener)null);
                this.mVideoClient.a();
                this.mVideoClient = null;
            }
            if (this.mHolder != null) {
                this.mHolder.clear();
            }
            if (this.handler != null) {
                this.handler = null;
            }
        }
    }

    private void unsetListeners() {
        this.setOnRecordStartedListener(null);
        this.setOnRecordStoppedListener(null);
        this.setOnErrorListener(null);
        this.setOnPreparedListener(null);
        this.setOnCameraSetListener(null);
        this.setOnFPSChangeListener(null);
        this.setOnFPSChangeListener(null);
        this.setAudioDataCallback(null);
    }

    private boolean isFileExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public boolean loadGestureModel(String modelPath) {
        if (this.isFileExist(modelPath)) {
            return ObjectDetector.getInstance().loadModel(modelPath);
        }
        return false;
    }

    public boolean loadHandGestureModel(String modelPath) {
        if (this.isFileExist(modelPath)) {
            return HandGestureDetector.getInstance().loadModel(modelPath);
        }
        return false;
    }

    public void loadSegmentModel(String modelPath) {
        SegmentHelper.setModelPath((String)modelPath);
    }

    public void loadFaceModel() {
    }

    public void loadBodyLandModel(boolean isBlackList, String modelPath) {
        if (this.isFileExist(modelPath)) {
            BodyLandHelper.setModelTypeAndPath((boolean)isBlackList, (String)modelPath);
        }
    }

    public boolean isFrontCamera() {
        return this.mVideoClient != null && this.mVideoClient.f();
    }

    public void selectFaceDetectFilter(BasicFilter filter) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(filter);
        }
    }

    public void addFilterToDestory(BasicFilter filter) {
        if (this.mVideoClient != null) {
            this.mVideoClient.b(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewDisplay(SurfaceHolder holder) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mHolder = new WeakReference<SurfaceHolder>(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPreview() {
        Object object = this.syncOp;
        synchronized (object) {
            try {
                if (this.mHolder == null || this.mHolder.get() == null) {
                    MDLog.i((String)"RecoderUtils", (String)"Invalid surfaceHolder of recoder !!!");
                    throw new Exception("Invalid surfaceHolder");
                }
                this.mVideoClient.a(((SurfaceHolder)this.mHolder.get()).getSurface());
                this.setVisualSize(((SurfaceHolder)this.mHolder.get()).getSurfaceFrame().width(), ((SurfaceHolder)this.mHolder.get()).getSurfaceFrame().height());
            }
            catch (Throwable throwable) {
                MDLog.printErrStackTrace((String)"RecoderUtils", (Throwable)throwable);
                throw throwable;
            }
        }
    }

    public void setOnErrorListener(MRecorderActions.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.mOnErrorListener);
        }
    }

    public void setOnPreparedListener(MRecorderActions.OnPreparedListener onPreparedListener) {
    }

    public void setOnFPSChangeListener(MRecorderActions.OnFpsChangeListener onFpsChangeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnCameraSetListener(ICamera.onCameraSetListener onCameraSetListener2) {
        Object object = this.syncOp;
        synchronized (object) {
            this.cameraSetListener = onCameraSetListener2;
            if (this.mVideoClient != null) {
                this.mVideoClient.a(onCameraSetListener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAudioDataCallback(MRecorderActions.AudioDataCallback audioDataCallback) {
        Object object = this.syncOp;
        synchronized (object) {
            this.mAudioDataCallback = audioDataCallback;
            if (this.mVideoClient != null) {
                this.mVideoClient.a(this.mAudioDataCallback);
            }
        }
    }

    public Size setVisualSize(int w2, int h2) {
        this.mrCoreParameters.visualWidth = w2;
        this.mrCoreParameters.visualHeight = h2;
        if (this.mVideoClient != null) {
            return this.mVideoClient.i();
        }
        return null;
    }

    public int getCameraFPS() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.j();
        }
        return 0;
    }

    public int getRenderFPS() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.k();
        }
        return 0;
    }

    public void setFacedetectedListener(MRecorderActions.OnFacedetectedListener listener) {
        this.facedetectedListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.facedetectedListener);
        }
    }

    public void takePhoto(String path) {
        if (this.mVideoClient != null) {
            this.mVideoClient.b(path);
        }
    }

    public void setOnTakePhotoListener(MRecorderActions.OnTakePhotoListener listener) {
        this.takePhotoListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(listener);
        }
    }

    public boolean isSupportFlashOnMode() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.l();
        }
        return false;
    }

    public boolean isSupportFlashAutoMode() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.m();
        }
        return false;
    }

    public void setFlashMode(String mode) {
        this.flashMode = mode;
        if (this.mVideoClient != null) {
            this.mVideoClient.c(mode);
        }
    }

    public void setDigimonMode(boolean digimonMode, String modePath, String faModelPath, String fdModelPath) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(digimonMode, modePath, faModelPath, fdModelPath);
        }
    }

    public void setNeedFeatureData(boolean needFeatureData) {
        this.needFeatureData = needFeatureData;
        if (this.mVideoClient != null) {
            this.mVideoClient.c(needFeatureData);
        }
    }

    public void setOnFeatureDetectedListener(MRecorderActions.OnFeatureDetectedListener onFeatureDetectedListener) {
        this.featureDetectedListener = onFeatureDetectedListener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(onFeatureDetectedListener);
        }
    }

    public void setFaceExpressionDetectSwitch(boolean isActiveSwitch) {
        this.expressionSwitch = isActiveSwitch;
        if (this.mVideoClient != null) {
            this.mVideoClient.d(isActiveSwitch);
        }
    }

    public void setPreviewInfoListener(MultiRecorder.cameraPreviewInfo previewInfoListener) {
        this.cameraPreviewInfo = previewInfoListener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(previewInfoListener);
        }
    }

    public void setOnEncodeSizeChangeListener(MRecorderActions.OnEncodeSizeChangeListener onEncodeSizeChangeListener) {
        this.encodeSizeChangeListener = onEncodeSizeChangeListener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(onEncodeSizeChangeListener);
        }
    }

    public void setMmcvModelUploadListener(MRecorderActions.OnMMCVModelUploadListener listener) {
        this.mmcvModelUploadListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.mmcvModelUploadListener);
        }
    }

    public void setOnRenderFrameListener(MRecorderActions.OnRenderFrameListener listener) {
        this.mOnRenderFrameListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.mOnRenderFrameListener);
        }
    }

    public void setOnBarenessCheckListener(MRecorderActions.OnBarenessCheckListener listener) {
        this.barenessCheckListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.barenessCheckListener);
        }
    }

    public void setBarenessUploadListener(MRecorderActions.OnMMCVModelUploadListener listener) {
        this.barenessUploadListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.b(this.barenessUploadListener);
        }
    }

    public void setOnFirstFrameRenderedListener(MRecorderActions.OnFirstFrameRenderedListener listener) {
        this.firstFrameRenderedListener = listener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.firstFrameRenderedListener);
        }
    }

    public void setDataRecycleModel(String modePath, String bitmapPath, int uploadCnt) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(modePath, bitmapPath, uploadCnt);
        }
    }

    public void setBarenessDetectModel(String modePath) {
        this.barenessModelPath = modePath;
        if (this.mVideoClient != null) {
            this.mVideoClient.d(modePath);
        }
    }

    public void setBarenessUploadImagePath(String path) {
        this.barenessImagePath = path;
        if (this.mVideoClient != null) {
            this.mVideoClient.e(path);
        }
    }

    public void setFaceDetectModelPath(List<String> faceDetectModelPath) {
        this.faceDetectModePath = faceDetectModelPath;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(faceDetectModelPath);
        }
    }

    public void setEyeClassicSwitch(boolean eyeClassicSwitch) {
        this.eyeDetectSwitch = eyeClassicSwitch;
        if (this.mVideoClient != null) {
            this.mVideoClient.e(eyeClassicSwitch);
        }
    }

    public void setRecoderSpeed(float speed) {
        if (this.mVideoClient != null) {
            this.mVideoClient.c(speed);
        }
    }

    public void setUseAdjustLight(boolean useAdjustLight) {
        if (this.mVideoClient != null) {
            this.mVideoClient.g(useAdjustLight);
        }
    }

    public void setUseDokiBeauty(boolean useDoki) {
        if (this.mVideoClient != null) {
            this.mVideoClient.h(useDoki);
            DataDotUtils.getInstance().getRecoderDataDotInfo().setCameraBeautyUseDoki(useDoki);
        }
    }

    public void setNeedBodyWrap(boolean needBodyWrap) {
        if (this.mVideoClient != null) {
            this.mVideoClient.i(needBodyWrap);
        }
    }

    public void setBodyWarpWidth(float bodyWarpWidth) {
        if (this.mVideoClient != null) {
            this.mVideoClient.d(bodyWarpWidth);
        }
    }

    public void setBodyWarpScaleFactor(float bodyWarpScaleFactor) {
        if (this.mVideoClient != null) {
            this.mVideoClient.e(bodyWarpScaleFactor);
        }
    }

    public void setBodyWarpLegsLength(float bodyWarpLegsLength) {
        if (this.mVideoClient != null) {
            this.mVideoClient.f(bodyWarpLegsLength);
        }
    }

    public void setScreenWidthAndHeight(int width, int height, int rotate) {
        if (this.mVideoClient != null) {
            this.mVideoClient.a(width, height, rotate);
        }
    }

    public synchronized void setBackGroundMusic(boolean hasBackgroundMusic) {
        if (this.mVideoClient != null) {
            this.mVideoClient.j(hasBackgroundMusic);
        }
    }

    public void setUseCameraVersion2(boolean useCameraVersion2) {
        this.useCameraVersion2 = useCameraVersion2;
    }

    public void setOnErrorDotDataListener(MRecorderActions.OnErrorDotDataListener onErrorDotDataListener) {
        this.mOnErrorDotDataListener = onErrorDotDataListener;
        if (this.mVideoClient != null) {
            this.mVideoClient.a(this.mOnErrorDotDataListener);
        }
    }

    public boolean isSupportZoom() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.n();
        }
        return false;
    }

    public void setZoomLevel(int level) {
        if (this.mVideoClient != null) {
            this.mVideoClient.c(level);
        }
    }

    public int getCurrentZoomLevel() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.o();
        }
        return 0;
    }

    public int getMaxZoomLevel() {
        if (this.mVideoClient != null) {
            return this.mVideoClient.p();
        }
        return 0;
    }
}

