/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.recorder;

import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.view.SurfaceHolder;
import com.core.glcore.config.PacketData;
import com.core.glcore.config.Size;
import com.core.glcore.gl.EGL14Wrapper;
import com.core.glcore.util.ErrorDotStatistics;
import com.core.glcore.util.FileUtil;
import com.immomo.moment.b.a.c;
import com.immomo.moment.b.b.b;
import com.immomo.moment.config.MRecorderActions;
import com.immomo.moment.datadot.DataDotUtils;
import com.immomo.moment.mediautils.VideoDataRetrieverBySoft;
import com.immomo.moment.mediautils.a;
import com.immomo.moment.mediautils.ac;
import com.immomo.moment.mediautils.ad;
import com.immomo.moment.mediautils.ae;
import com.immomo.moment.mediautils.c;
import com.immomo.moment.mediautils.cmds.AudioBackground;
import com.immomo.moment.mediautils.cmds.AudioEffects;
import com.immomo.moment.mediautils.cmds.EffectModel;
import com.immomo.moment.mediautils.cmds.TimeRangeScale;
import com.immomo.moment.mediautils.cmds.VideoCut;
import com.immomo.moment.mediautils.cmds.VideoEffects;
import com.immomo.moment.mediautils.d;
import com.immomo.moment.mediautils.e;
import com.immomo.moment.mediautils.h;
import com.immomo.moment.mediautils.i;
import com.immomo.moment.mediautils.j;
import com.immomo.moment.mediautils.r;
import com.immomo.moment.mediautils.t;
import com.immomo.moment.mediautils.u;
import com.immomo.moment.mediautils.v;
import com.immomo.moment.mediautils.w;
import com.immomo.moment.mediautils.x;
import com.imomo.momo.mediaencoder.FFBgChanger;
import com.mm.mdlog.MDLog;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;

public class MomoProcess
implements a.a,
e.d {
    private String TAG = "MomoProcess";
    public static final int MEDIA_ENCODER_MODE_SOFT = 0;
    public static final int MEDIA_ENCODER_MODE_CODEC = 1;
    private int count = 0;
    static final int MSG_CHANGE_TO_PREVIEW_MODE = 257;
    static final int MSG_PREPARE_ONE_FRAME = 258;
    static final int MSG_START_PREVIEW = 259;
    static final int MSG_SEEK = 260;
    static final int MSG_UPDATE_EFFECT_MODEL = 261;
    static final int MSG_PREPARE = 262;
    static final int MSG_MAKE_VIDEO = 263;
    static final int MSG_CLEAR_CODEC = 264;
    static final int MSG_RELEASE_PROCESS = 265;
    static final int MSG_STOP_PREVIEW = 272;
    x mSourceManager;
    w mSourceConfig;
    e mAudioPlayer;
    h mScaleProcessor;
    c mMixProcessor;
    i mVolumeControlProcessor;
    ad mSpeedControl;
    ae videoControllerPlayer;
    a audioController;
    b renderThread;
    FFBgChanger mBgChanger;
    j encoderWrapper;
    u encoderCodecWrapper;
    t encoderSoftWrapper;
    private BasicFilter mFilterGroup;
    private boolean mInnerMakeVideoStart = false;
    private boolean mSeekAndPlay = true;
    private boolean mIsUpdate = false;
    private boolean mIsNewSource = false;
    private WeakReference<SurfaceHolder> mHolder;
    private Object mScreenSurface;
    private Handler handler;
    private boolean mIsSeeking = false;
    private int mEncodeWidth = 0;
    private int mEncodeHeight = 0;
    private int mOutWidth = 0;
    private int mOutHeight = 0;
    private int mVideoRotation = 0;
    private int mImageWidth = 0;
    private int mImageHeight = 0;
    private int mOutVideoGopSize = 1;
    private int mOutSampleRate = 0;
    private int mOutChannels = 0;
    private int mOutBits = 16;
    private int mOutVideoFps = 20;
    private int mOutVideoBitrate = 3000000;
    private int mOutVideoRotation = 0;
    private int mOutAudioBitrate = 65536;
    private boolean mOutVideoUseCQ = true;
    private boolean mSeekingStatus = false;
    private int mRcMethod = 2;
    private int mCrfConstant = 23;
    private long mTotalDuration = 0L;
    private Object mErrorSync = new Object();
    private boolean mIsLoopbackMode = false;
    private boolean mIsPlaying = false;
    private long mLastPlayingPts = 0L;
    private Object mPlayingObj = new Object();
    private long mSeekTimeUs = 0L;
    private EGL14Wrapper mSharedDumyContex;
    private boolean mUseBgChanger = false;
    private Bundle bound = new Bundle();
    private boolean iFrameOnly = false;
    private int mediaEncoderMode = 1;
    private Object syncFrame = new Object();
    private Object mVideoCodecSurface;
    private MRecorderActions.OnProcessProgressListener mProcessStatusListener;
    private MRecorderActions.OnProcessErrorListener mErrorListener;
    private MRecorderActions.OnProcessErrorListener mInternalErrorListener = new MRecorderActions.OnProcessErrorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onErrorCallback(int what, int errorCode, String msg) {
            Object object = MomoProcess.this.mErrorSync;
            synchronized (object) {
                if (MomoProcess.this.mErrorListener != null) {
                    MomoProcess.this.mErrorListener.onErrorCallback(what, errorCode, msg);
                }
                MDLog.e((String)"EditProcess", (String)("process failed by " + errorCode + msg));
            }
        }
    };
    private final int MODE_UNDEFINE = -1;
    private final int MODE_PROCESS = 0;
    private final int MODE_PREVIEW = 1;
    private int mMode = -1;
    private String mMediaOutPath;
    private EffectModel mInputEffectModel = null;
    private Object mSync = new Object();
    private MRecorderActions.OnPlayingStatusListener mPlayingStatusListener;
    private ac sharedEglContex;
    private String pitchShiftPath = null;
    d pitchShiftProcessor;
    private int pitchMode = 6;
    private long startTime = 0L;
    private int serveCode = 200000;
    private MRecorderActions.OnErrorDotDataListener mOnErrorDotDataListener = null;
    private boolean mIsChangeEffectMode = false;
    c.d surfaceRenderStatusListener = new c.d(){

        @Override
        public void onPause() {
            MomoProcess.this.handlePause();
        }

        @Override
        public void onResume() {
            MomoProcess.this.handleResume();
        }

        @Override
        public void handleProcessCommonCommand(Message msg) {
            switch (msg.what) {
                case 259: {
                    MomoProcess.this.handleStartPreview();
                    break;
                }
                case 260: {
                    MomoProcess.this.handleSeek();
                    break;
                }
                case 261: {
                    MomoProcess.this.handleUpdateEffect((EffectModel)msg.obj);
                    break;
                }
                case 262: {
                    MomoProcess.this.handlePrepare((EffectModel)msg.obj);
                    break;
                }
                case 263: {
                    MomoProcess.this.handleMakeVideo((String)msg.obj);
                    break;
                }
                case 264: {
                    MomoProcess.this.handleClearCodec();
                    break;
                }
                case 258: {
                    MomoProcess.this.handlePrepareOneFrame((Boolean)msg.obj);
                    break;
                }
                case 257: {
                    MomoProcess.this.handleChangeToPreviewMode();
                    break;
                }
                case 265: {
                    MomoProcess.this.handleReleaseProcess();
                    break;
                }
                case 272: {
                    MomoProcess.this.handleStopPreview();
                }
            }
        }
    };
    private x.a mDataOutputCallback = new x.a(){

        @Override
        public void onAudioDataCallback(ByteBuffer buf, int len, long pts) {
            if (MomoProcess.this.audioController != null) {
                MomoProcess.this.audioController.a(buf, len, pts);
            }
        }

        @Override
        public void onAudioDataFormat(MediaFormat fmt) {
            if (MomoProcess.this.audioController != null) {
                MomoProcess.this.audioController.a(fmt);
            }
        }

        @Override
        public void onOutputTextureChanged(int textureId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVideoDataCallback(long pts) {
            if (MomoProcess.this.videoControllerPlayer != null) {
                MomoProcess.this.videoControllerPlayer.b(pts);
            }
            if (pts == -1L) {
                return;
            }
            if (MomoProcess.this.mProcessStatusListener != null && MomoProcess.this.mMode == 0 && MomoProcess.this.mInnerMakeVideoStart) {
                MomoProcess.this.startTime = System.currentTimeMillis();
                if (MomoProcess.this.mTotalDuration != 0L) {
                    if (pts + MomoProcess.this.mSeekTimeUs > MomoProcess.this.mTotalDuration) {
                        MomoProcess.this.mProcessStatusListener.onProcessProgress((float)pts * 1.0f / (float)MomoProcess.this.mTotalDuration);
                    } else {
                        MomoProcess.this.mProcessStatusListener.onProcessProgress((float)(pts + MomoProcess.this.mSeekTimeUs) * 1.0f / (float)MomoProcess.this.mTotalDuration);
                    }
                }
            }
            Object object = MomoProcess.this.mPlayingObj;
            synchronized (object) {
                long l2 = pts + MomoProcess.this.mSeekTimeUs;
                if (MomoProcess.this.mPlayingStatusListener != null && MomoProcess.this.mMode == 1) {
                    MomoProcess.this.mPlayingStatusListener.onPlayingPtsMs(l2 / 1000L);
                }
                MomoProcess.this.mLastPlayingPts = MomoProcess.this.mLastPlayingPts < l2 ? l2 : MomoProcess.this.mLastPlayingPts;
            }
        }

        @Override
        @RequiresApi(api=16)
        public void onVideoDataFormat(MediaFormat fmt) {
            if (fmt == null) {
                return;
            }
            if (MomoProcess.this.mHolder != null) {
                MomoProcess.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (MomoProcess.this.mHolder == null) {
                            return;
                        }
                        SurfaceHolder surfaceHolder = (SurfaceHolder)MomoProcess.this.mHolder.get();
                        if (surfaceHolder != null) {
                            surfaceHolder.setFixedSize(MomoProcess.this.mOutWidth, MomoProcess.this.mOutHeight);
                        }
                    }
                });
            }
            int n2 = 0;
            if (fmt.containsKey("rotation-degrees")) {
                n2 = fmt.getInteger("rotation-degrees");
            }
            boolean bl = false;
            if (n2 != MomoProcess.this.mVideoRotation) {
                if (fmt.containsKey("width")) {
                    MomoProcess.this.mImageWidth = fmt.getInteger("width");
                }
                if (fmt.containsKey("height")) {
                    MomoProcess.this.mImageHeight = fmt.getInteger("height");
                }
                bl = true;
            }
            if (MomoProcess.this.renderThread != null) {
                if (bl) {
                    MomoProcess.this.renderThread.a(MomoProcess.this.mVideoRotation);
                } else {
                    MomoProcess.this.renderThread.a(0);
                }
                MomoProcess.this.renderThread.g(new Size(MomoProcess.this.mImageWidth, MomoProcess.this.mImageHeight));
            }
        }

        @Override
        public void onTextureFrameAvailable(SurfaceTexture texture) {
            MomoProcess.this.setCodecBounds();
            MomoProcess.this.count++;
            if (MomoProcess.this.renderThread != null) {
                MomoProcess.this.renderThread.onFrameAvailable(texture);
            }
            if (MomoProcess.this.mMode == 1 && MomoProcess.this.mIsChangeEffectMode) {
                MomoProcess.this.renderThread.a(MomoProcess.this.mScreenSurface, new Size(MomoProcess.this.mOutWidth, MomoProcess.this.mOutHeight));
                MomoProcess.this.mIsChangeEffectMode = false;
            }
        }

        @Override
        public void onPreviewFinished() {
            MomoProcess.this.mIsPlaying = false;
            if (MomoProcess.this.mPlayingStatusListener != null) {
                MomoProcess.this.mPlayingStatusListener.onPlayingProgress(1.0f);
                MomoProcess.this.mPlayingStatusListener.onPlayingFinished();
                MomoProcess.this.mPlayingStatusListener.onPlayingPaused();
                MomoProcess.this.mPlayingStatusListener.onPlayingPtsMs(MomoProcess.this.mLastPlayingPts / 1000L);
                MomoProcess.this.mLastPlayingPts = 0L;
            }
            MDLog.i((String)"EditProcess", (String)"MomoProcess onPreviewFinished !!!");
        }

        @Override
        public void onFinished() {
            if (MomoProcess.this.mMode == 0) {
                MomoProcess.this.releaseEncoder();
            }
            MDLog.i((String)"EditProcess", (String)"On process Finished");
            MomoProcess.this.mIsPlaying = false;
            if (MomoProcess.this.mMode == 1) {
                if (MomoProcess.this.mPlayingStatusListener != null) {
                    MomoProcess.this.mPlayingStatusListener.onPlayingFinished();
                    MomoProcess.this.mPlayingStatusListener.onPlayingPaused();
                    MomoProcess.this.mPlayingStatusListener.onPlayingProgress(1.0f);
                    MomoProcess.this.mPlayingStatusListener.onPlayingPtsMs(MomoProcess.this.mLastPlayingPts / 1000L);
                    MomoProcess.this.mLastPlayingPts = 0L;
                }
            } else if (MomoProcess.this.mProcessStatusListener != null) {
                MomoProcess.this.mProcessStatusListener.onProcessProgress(1.0f);
                MomoProcess.this.mProcessStatusListener.onProcessFinished();
                MomoProcess.this.dotVideoInfo(MomoProcess.this.startTime);
            }
        }

        @Override
        public void onLoopbackAgain() {
            MDLog.i((String)"EditProcess", (String)"loop back again !!!");
            if (MomoProcess.this.mSpeedControl != null) {
                MomoProcess.this.mSpeedControl.a();
            }
            if (MomoProcess.this.mScaleProcessor != null) {
                MomoProcess.this.mScaleProcessor.b();
            }
            if (MomoProcess.this.mMixProcessor != null) {
                MomoProcess.this.mMixProcessor.b();
            }
            if (MomoProcess.this.pitchShiftProcessor != null) {
                MomoProcess.this.pitchShiftProcessor.b();
            }
            if (MomoProcess.this.mAudioPlayer != null) {
                MomoProcess.this.mAudioPlayer.d();
            }
            MomoProcess.this.mLastPlayingPts = 0L;
            MomoProcess.this.mSeekTimeUs = 0L;
        }
    };
    private ByteBuffer buf;

    public static void InitGloabalEglResource() {
    }

    public static void UinitGloabalEglResource() {
    }

    @Override
    public void onAudioSinkCallback(ByteBuffer data, int len, long pts) {
        PacketData packetData = new PacketData(len);
        data.position(0);
        packetData.getFrameBuffer().position(0);
        data.get(packetData.getFrameBuffer().array());
        packetData.setBuffInfo(len, 0, 0, pts, 0);
        packetData.getFrameBuffer().position(0);
        data.position(0);
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.a(packetData);
        }
        packetData.getFrameBuffer().position(0);
        if (this.encoderWrapper != null) {
            this.encoderWrapper.b(packetData);
        }
    }

    @Override
    public void onAudioPlayingPosition(long pts) {
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.a(pts);
        }
    }

    private void dotVideoInfo(long startTime) {
        long l2 = System.currentTimeMillis();
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoProcessTime(l2 - startTime);
        File file = new File(this.mMediaOutPath);
        if (file.exists() && file.isFile()) {
            DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileSize(file.length());
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(this.mMediaOutPath);
        String string = mediaMetadataRetriever.extractMetadata(20);
        String string2 = mediaMetadataRetriever.extractMetadata(18);
        String string3 = mediaMetadataRetriever.extractMetadata(19);
        String string4 = mediaMetadataRetriever.extractMetadata(9);
        mediaMetadataRetriever.release();
        VideoDataRetrieverBySoft videoDataRetrieverBySoft = new VideoDataRetrieverBySoft();
        videoDataRetrieverBySoft.init(this.mMediaOutPath);
        int n2 = videoDataRetrieverBySoft.getFrameRate();
        videoDataRetrieverBySoft.release();
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileBitrate(Integer.parseInt(string));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileWidth(Integer.parseInt(string2));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileHeight(Integer.parseInt(string3));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileDuration(Long.parseLong(string4));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoFileFps(n2);
    }

    public MomoProcess() {
        this.handler = new Handler(Looper.getMainLooper());
        this.renderThread = new b("textureRenThr");
        this.renderThread.a(this.surfaceRenderStatusListener);
        this.renderThread.a(new c.b(){

            @Override
            public Object beforeOnDrawFrame() {
                return null;
            }

            @Override
            public void afterOnDrawFrame() {
                if (MomoProcess.this.videoControllerPlayer != null) {
                    MomoProcess.this.videoControllerPlayer.e();
                }
            }
        });
        this.renderThread.a(new MRecorderActions.onDotErrorListener(){

            @Override
            public void onFail(int errCode, String info) {
                if (MomoProcess.this.mOnErrorDotDataListener != null) {
                    MomoProcess.this.mOnErrorDotDataListener.onError(MomoProcess.this.serveCode + errCode, info);
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (MomoProcess.this.serveCode + errCode) + "]" + info);
                MDLog.i((String)"EditProcess", (String)("[" + (MomoProcess.this.serveCode + errCode) + "]" + info));
            }
        });
        this.videoControllerPlayer = new ae();
        this.videoControllerPlayer.a(new OnVideoControllerListener(){

            @Override
            public void onPrepareOneFrame(boolean isShow) {
                if (MomoProcess.this.renderThread != null) {
                    MomoProcess.this.renderThread.c(258, isShow);
                }
            }

            @Override
            public void onRequestRender() {
                if (MomoProcess.this.renderThread != null) {
                    MomoProcess.this.setCodecBounds();
                    MomoProcess.this.renderThread.onFrameAvailable(null);
                }
            }

            @Override
            public void onPlayPts(long ptsMs) {
                if (MomoProcess.this.mMode == 1) {
                    float f2 = (float)(ptsMs * 1000L + MomoProcess.this.mSeekTimeUs) * 1.0f / (float)MomoProcess.this.mTotalDuration;
                    if (MomoProcess.this.mPlayingStatusListener != null && MomoProcess.this.mTotalDuration != 0L && ptsMs != 0L && MomoProcess.this.isPlaying()) {
                        MomoProcess.this.mPlayingStatusListener.onPlayingProgress(f2);
                    }
                }
                if (MomoProcess.this.mSeekingStatus) {
                    return;
                }
                if (MomoProcess.this.renderThread != null) {
                    MomoProcess.this.renderThread.a(ptsMs + MomoProcess.this.mSeekTimeUs / 1000L);
                }
            }

            @Override
            public void onVideoCutFinished() {
                if (MomoProcess.this.mSourceManager != null) {
                    MomoProcess.this.mSourceManager.a(16);
                }
                MDLog.i((String)"EditProcess", (String)"MomoProcess video cut finished !!!");
            }
        });
        this.audioController = new a();
        this.audioController.a(this);
    }

    public void setPitchShiftProcessMode(String tmpDataFolder, String videoPath, int pitchMode, MRecorderActions.DataProcessListener listener) {
        this.pitchMode = pitchMode;
        if (this.pitchShiftProcessor == null && this.pitchMode != 0) {
            this.pitchShiftProcessor = new d();
            if (this.mOnErrorDotDataListener != null) {
                this.pitchShiftProcessor.a(new MRecorderActions.onDotErrorListener(){

                    @Override
                    public void onFail(int errCode, String info) {
                        MomoProcess.this.mOnErrorDotDataListener.onError(MomoProcess.this.serveCode + errCode, info);
                        ErrorDotStatistics.getInstance().addErrInfo("[" + (MomoProcess.this.serveCode + errCode) + "]" + info);
                        MDLog.e((String)"EditProcess", (String)("[" + (MomoProcess.this.serveCode + errCode) + "]" + info));
                    }
                });
            }
            this.pitchShiftProcessor.a(tmpDataFolder);
            this.pitchShiftProcessor.a(listener);
            this.pitchShiftPath = videoPath;
            this.pitchShiftProcessor.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels);
            this.pitchShiftProcessor.a(videoPath, pitchMode);
            MDLog.i((String)"EditProcess", (String)("setPitchShiftProcessMode  tmpDataFolder = " + tmpDataFolder + " videoPath = " + videoPath + " pitchMode = " + pitchMode + " mOutSampleRate = " + this.mOutSampleRate + " mOutBits = " + this.mOutBits + " mOutChannels = " + this.mOutChannels));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutMediaVideoInfo(int width, int height, int fps, int bitrate, boolean bUseCQ) {
        Object object = this.mSync;
        synchronized (object) {
            this.mEncodeWidth = width >> 4 << 4;
            this.mEncodeHeight = height >> 4 << 4;
            this.mOutVideoBitrate = bitrate;
            this.mOutVideoFps = fps;
            this.mOutVideoRotation = 0;
            this.mOutVideoUseCQ = bUseCQ;
            MDLog.i((String)"EditProcess", (String)("setOutMediaVideoInfo mEncodeWidth = " + this.mEncodeWidth + " mEncodeHeight = " + this.mEncodeHeight + " mOutVideoBitrate = " + this.mOutVideoBitrate + " mOutVideoFps = " + this.mOutVideoFps + " mOutVideoRotation = " + this.mOutVideoRotation + " mOutVideoUseCQ = " + this.mOutVideoUseCQ));
        }
    }

    public void setLoopBack(boolean isLoopBack) {
        MDLog.i((String)"EditProcess", (String)("setLoopBack()    isLoopBack = " + isLoopBack));
        this.mIsLoopbackMode = isLoopBack;
        if (this.mSourceManager != null) {
            this.mSourceManager.a(isLoopBack);
        }
    }

    public void setPlayingSrcAudioRatio(float ratio) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess setPlayingSrcAudioRatio ratio = " + ratio));
        if (this.mMixProcessor != null) {
            this.mMixProcessor.a(ratio);
        }
        if (this.mVolumeControlProcessor != null) {
            this.mVolumeControlProcessor.a(ratio);
        }
    }

    public void setPlayingMusicAudioRatio(float ratio) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess setPlayingMusicAudioRatio ratio = " + ratio));
        if (this.mMixProcessor != null) {
            this.mMixProcessor.b(ratio);
        }
    }

    public void setSeekStatus(boolean isSeeking) {
        this.mSeekingStatus = isSeeking;
        MDLog.i((String)"EditProcess", (String)("MomoProcess setSeekStatus mSeekingStatus " + this.mSeekingStatus));
    }

    public void setMediaEncoderMode(int mediaEncoderMode) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess setMediaEncoderMode mediaEncoderMode = " + mediaEncoderMode));
        this.mediaEncoderMode = mediaEncoderMode;
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEncodeType(this.mediaEncoderMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncodeParam(int rcMethod, int crfConstant) {
        Object object = this.mSync;
        synchronized (object) {
            MDLog.i((String)"EditProcess", (String)("MomoProcess setEncodeParam mRcMethod = " + this.mRcMethod + " mCrfConstant = " + this.mCrfConstant));
            this.mRcMethod = rcMethod;
            this.mCrfConstant = crfConstant;
            DataDotUtils.getInstance().getEditDataDotInfo().setVideoRateControlMethod(this.mRcMethod);
            DataDotUtils.getInstance().getEditDataDotInfo().setVideoCrfConstant(this.mCrfConstant);
        }
    }

    public void setIFrameOnly(boolean iFrameOnly) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess setIFrameOnly iFrameOnly = " + iFrameOnly));
        this.iFrameOnly = iFrameOnly;
        DataDotUtils.getInstance().getEditDataDotInfo().setiFrameOnly(this.iFrameOnly);
    }

    public synchronized void setUseBgChanger(boolean useBgChanger) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess setUseBgChanger mUseBgChanger = " + useBgChanger));
        this.mUseBgChanger = useBgChanger;
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoBgChanger(this.mUseBgChanger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutAudioInfo(int sampleRate, int channels, int bits, int bitrate) {
        Object object = this.mSync;
        synchronized (object) {
            this.mOutSampleRate = sampleRate;
            this.mOutChannels = channels;
            this.mOutBits = bits;
            this.mOutAudioBitrate = bitrate;
            MDLog.i((String)"EditProcess", (String)("MomoProcess setOutAudioInfo mOutSampleRate = " + this.mOutSampleRate + " mOutChannels = " + this.mOutChannels + " mOutBits = " + this.mOutBits + " mOutAudioBitrate = " + this.mOutAudioBitrate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnProcessErrorListener(MRecorderActions.OnProcessErrorListener listener) {
        Object object = this.mSync;
        synchronized (object) {
            this.mErrorListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayingStatusListener(MRecorderActions.OnPlayingStatusListener listener) {
        Object object = this.mSync;
        synchronized (object) {
            this.mPlayingStatusListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnStatusListener(MRecorderActions.OnProcessProgressListener listener) {
        Object object = this.mSync;
        synchronized (object) {
            this.mProcessStatusListener = listener;
        }
    }

    public synchronized boolean getIsPreviewMode() {
        return this.mMode == 1;
    }

    public boolean isPlaying() {
        if (this.mMode == 1) {
            return this.mIsPlaying;
        }
        return false;
    }

    public synchronized void addScreenSurface(SurfaceHolder holder) {
        MDLog.i((String)"EditProcess", (String)"addScreenSurface() holder ");
        this.mHolder = new WeakReference<SurfaceHolder>(holder);
        this.mScreenSurface = ((SurfaceHolder)this.mHolder.get()).getSurface();
    }

    public synchronized void addSurfaceTexture(SurfaceTexture surfaceTexture) {
        MDLog.i((String)"EditProcess", (String)"addSurfaceTexture() ");
        this.mScreenSurface = surfaceTexture;
    }

    public synchronized boolean prepare(String json) {
        MDLog.i((String)"EditProcess", (String)"prepare()");
        if (json == null) {
            return false;
        }
        if (this.renderThread != null) {
            this.renderThread.c(262, EffectModel.getEffectModel(json));
        }
        return true;
    }

    public void addFilters(BasicFilter filter) {
        MDLog.i((String)"EditProcess", (String)"addFilters()");
        this.mFilterGroup = filter;
    }

    public synchronized void startPreview() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess startPreview !!!");
        if (this.renderThread != null) {
            this.mMode = 1;
            if (this.mScreenSurface == null) {
                if (this.mOnErrorDotDataListener != null) {
                    this.mOnErrorDotDataListener.onError(this.serveCode + 5003, "The Screen surface is invalid !!!");
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5003) + "]" + "The Screen surface is invalid !!!");
                MDLog.e((String)"EditProcess", (String)("[" + (this.serveCode + 5003) + "]" + "The Screen surface is invalid !!!"));
                return;
            }
            this.renderThread.r(this.mScreenSurface);
            this.renderThread.b(259);
            this.renderThread.b();
            this.renderThread.h(this.mFilterGroup);
        }
    }

    public synchronized void updateEffect(String json, long seekTime, boolean isPlay) {
        MDLog.i((String)"EditProcess", (String)"MomoProcess updateEffect!!!");
        if (json == null) {
            return;
        }
        this.mSeekAndPlay = isPlay;
        this.mSeekTimeUs = seekTime * 1000L;
        EffectModel effectModel = EffectModel.getEffectModel(json);
        if (effectModel == null) {
            MDLog.e((String)"EditProcess", (String)"updateEffect model error");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            return;
        }
        if (this.renderThread != null) {
            this.renderThread.d(261, effectModel);
        }
    }

    public synchronized void seek(long ptsMs, boolean isPause) {
        if (ptsMs < 0L) {
            ptsMs = 0L;
        }
        this.mSeekTimeUs = ptsMs * 1000L;
        boolean bl = this.mSeekAndPlay = !isPause;
        if (this.mMode == 1 && isPause && this.mPlayingStatusListener != null) {
            this.mPlayingStatusListener.onPlayingPaused();
        }
        if (this.renderThread != null) {
            this.renderThread.b(260);
        }
    }

    public void pause() {
        MDLog.i((String)"EditProcess", (String)"pause()");
        if (this.mMode == 1 && this.renderThread != null) {
            this.renderThread.h();
        }
    }

    public void resume() {
        MDLog.i((String)"EditProcess", (String)"resume()");
        if (this.renderThread != null) {
            this.renderThread.i();
        }
        if (this.mMode == 1) {
            this.renderThread.a(this.mScreenSurface, new Size(this.mOutWidth, this.mOutHeight));
        }
    }

    public synchronized void removeSurface() {
        MDLog.i((String)"EditProcess", (String)"removeSurface()");
        if (this.videoControllerPlayer != null && this.mMode == 1) {
            this.videoControllerPlayer.b();
        }
        if (this.renderThread != null && this.mMode == 1) {
            this.renderThread.c();
            this.renderThread.c(this.mScreenSurface);
        }
        this.mHolder = null;
        this.mScreenSurface = null;
    }

    public synchronized void stopPreview() {
        MDLog.i((String)"EditProcess", (String)"stopPreview() holder ");
        if (this.renderThread != null && this.mMode == 1) {
            this.renderThread.c();
        }
        this.renderThread.b(272);
    }

    public synchronized void clearAllCodec() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess clearAllCodec !!!");
        if (this.renderThread != null) {
            this.renderThread.b(264);
        }
    }

    public synchronized void makeVideo(String path) {
        MDLog.i((String)"EditProcess", (String)"MomoProcess makeVideo !!!");
        if (path == null) {
            MDLog.e((String)"EditProcess", (String)"make video path error");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 5002, "make video path is empty !!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5002) + "]" + "make video path is empty !!!");
            return;
        }
        this.mIsPlaying = false;
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.b();
        }
        if (this.renderThread != null) {
            if (this.mMode != -1) {
                this.renderThread.c();
                this.renderThread.a();
            }
            this.mMode = 0;
            this.mInnerMakeVideoStart = false;
            this.renderThread.d(263, path);
            if (!this.mUseBgChanger) {
                this.renderThread.b();
                this.renderThread.h(this.mFilterGroup);
                this.renderThread.i();
            }
        }
    }

    public synchronized void changeToPreviewMode() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess changeToPreviewMode");
        if (this.mScreenSurface == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid surface");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-403, 0, null);
            }
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 5003, "The Screen surface is an invalid surface!!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5003) + "]" + "The Screen surface is an invalid surface!!!");
            return;
        }
        if (this.renderThread != null) {
            this.renderThread.b(257);
            if (this.mMode != -1) {
                this.renderThread.c();
                this.renderThread.a();
            }
            this.renderThread.r(this.mScreenSurface);
            this.renderThread.a(this.mScreenSurface, new Size(this.mOutWidth, this.mOutHeight));
            this.renderThread.b();
            this.renderThread.h(this.mFilterGroup);
            this.renderThread.c(261, this.mInputEffectModel);
            this.renderThread.i();
        }
    }

    public synchronized void release() {
        MDLog.i((String)"EditProcess", (String)"Momoprocess release() ");
        if (this.renderThread != null) {
            this.renderThread.d();
        }
    }

    private void handlePrepare(EffectModel model) {
        MDLog.i((String)"EditProcess", (String)"Momoprocess prepare");
        if (model == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid model");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 5001, "Invalid model !!!");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5001) + "]" + "Invalid model !!!");
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        if (this.sharedEglContex == null) {
            this.sharedEglContex = new ac();
        }
        if (this.mSharedDumyContex == null && this.sharedEglContex != null) {
            this.mSharedDumyContex = this.sharedEglContex.a(null);
        }
        this.bound.putInt("request-sync", 1);
        this.mInputEffectModel = model;
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.a();
        }
        this.doUpdateEffectModel();
    }

    private void handleStartPreview() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess startPreview()");
        if (this.mSourceManager == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid mSourceManager");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            return;
        }
        this.renderThread.a(this.mScreenSurface, new Size(this.mOutWidth, this.mOutHeight));
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = new e();
            this.mAudioPlayer.a(this);
            if (this.mOnErrorDotDataListener != null) {
                this.mAudioPlayer.a(new MRecorderActions.onDotErrorListener(){

                    @Override
                    public void onFail(int errCode, String info) {
                        if (MomoProcess.this.mOnErrorDotDataListener != null) {
                            MomoProcess.this.mOnErrorDotDataListener.onError(MomoProcess.this.serveCode + errCode, info);
                        }
                        ErrorDotStatistics.getInstance().addErrInfo("[" + (MomoProcess.this.serveCode + errCode) + "]" + info);
                        MDLog.e((String)"EditProcess", (String)("[" + (MomoProcess.this.serveCode + errCode) + "]" + info));
                    }
                });
            }
            if (!this.mAudioPlayer.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels)) {
                MDLog.e((String)"EditProcess", (String)"mAudioPlayer prepare failed");
                if (this.mErrorListener != null) {
                    this.mErrorListener.onErrorCallback(-401, 0, null);
                }
                return;
            }
        }
        this.resetAudioPlayer();
        this.mSourceManager.a(this.mIsLoopbackMode);
        this.mSourceManager.b(true);
        if (this.mIsNewSource) {
            this.mSourceManager.a();
            this.mIsNewSource = false;
            this.mIsPlaying = true;
            if (this.videoControllerPlayer != null) {
                this.videoControllerPlayer.c();
            }
        } else {
            this.handleSeek();
        }
        if (this.mTotalDuration != 0L && this.mPlayingStatusListener != null) {
            this.mPlayingStatusListener.onPlayingProgress((float)this.mSeekTimeUs * 1.0f / (float)this.mTotalDuration);
        }
    }

    private void handleClearCodec() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess handleClearCodec !!!");
        this.clearPreviousSource();
    }

    private void handleChangeToPreviewMode() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess handleChangeToPreviewMode !!!");
        this.mIsPlaying = false;
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.b();
        }
        if (this.mSourceManager != null) {
            this.mSourceManager.c();
        }
        this.releaseEncoder();
        this.clearPreviousSource();
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = new e();
            this.mAudioPlayer.a(this);
            if (!this.mAudioPlayer.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels)) {
                MDLog.e((String)"EditProcess", (String)"mAudioPlayer prepare failed");
                if (this.mErrorListener != null) {
                    this.mErrorListener.onErrorCallback(-401, 0, null);
                }
                return;
            }
        }
        this.mMode = 1;
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.a(0);
        }
    }

    private void handleMakeVideo(String path) {
        MDLog.i((String)"EditProcess", (String)"makevideo()");
        this.mMediaOutPath = path;
        if (this.mEncodeWidth <= 0) {
            this.mEncodeWidth = this.mOutWidth >> 4 << 4;
        }
        if (this.mEncodeHeight <= 0) {
            this.mEncodeHeight = this.mOutHeight >> 4 << 4;
        }
        this.clearPreviousSource();
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.c();
            this.mAudioPlayer = null;
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.b();
            this.videoControllerPlayer.d();
            this.videoControllerPlayer.a(1);
        }
        this.mInnerMakeVideoStart = true;
        boolean bl = true;
        if (this.mUseBgChanger) {
            MDLog.i((String)"EditProcess", (String)"Momoprocess use bgChanger !!!");
            if (this.mBgChanger != null) {
                this.mBgChanger.release();
                this.mBgChanger = null;
            }
            if (!this.initBgChanger()) {
                bl = this.startEncoder();
            } else {
                this.mUseBgChanger = false;
                this.mBgChanger.startProcess();
            }
        } else {
            bl = this.startEncoder();
        }
        if (!bl) {
            MDLog.e((String)"EditProcess", (String)"startEncoder error");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-402, 0, null);
            }
        }
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoIsEdited(true);
    }

    private void handleUpdateEffect(EffectModel model) {
        MDLog.i((String)"EditProcess", (String)"updateEffect()");
        this.mIsUpdate = true;
        this.mInputEffectModel = model;
        this.doUpdateEffectModel();
        this.handleResume();
    }

    private void handlePause() {
        MDLog.i((String)"EditProcess", (String)"pause preview");
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.a();
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.b();
        }
        if (this.mPlayingStatusListener != null) {
            this.mPlayingStatusListener.onPlayingPaused();
        }
        this.mIsPlaying = false;
    }

    private void handleResume() {
        MDLog.i((String)"EditProcess", (String)("resume mIsUpdate = " + this.mIsUpdate));
        if (this.mSourceManager == null) {
            this.doUpdateEffectModel();
        }
        if (this.mSourceManager == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid SourceManager");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            return;
        }
        if (this.mIsUpdate) {
            if (this.mIsNewSource) {
                this.mSourceManager.b(true);
                this.mSourceManager.a();
                this.mIsNewSource = false;
            } else {
                this.handleSeek();
            }
            this.mIsUpdate = false;
        }
        if (this.mMode == 1) {
            this.mSourceManager.a(this.mIsLoopbackMode);
        } else {
            this.mSourceManager.a(false);
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.b();
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.c();
        }
        this.mIsPlaying = true;
    }

    private void handleSeek() {
        MDLog.i((String)"EditProcess", (String)("seek isPlay = " + this.mSeekAndPlay));
        if (this.mSourceManager != null) {
            this.mSourceManager.c();
            if (this.videoControllerPlayer != null) {
                this.videoControllerPlayer.b();
                this.videoControllerPlayer.d();
            }
            this.mIsSeeking = true;
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.a();
                this.mAudioPlayer.d();
            }
            this.mIsPlaying = this.mSeekAndPlay;
            if (this.mInputEffectModel != null && this.mInputEffectModel.getVideoEffects() != null) {
                List<TimeRangeScale> list = this.adjustTimeRangeScaleList(this.mInputEffectModel.getVideoEffects().getTimeRangeScales(), this.mSeekTimeUs / 1000L);
                if (this.mScaleProcessor != null) {
                    this.mScaleProcessor.a(list);
                }
                if (this.mSpeedControl != null) {
                    this.mSpeedControl.a(list);
                }
            }
            if (this.mSpeedControl != null) {
                this.mSpeedControl.a();
            }
            if (this.mMixProcessor != null) {
                this.mMixProcessor.a(this.mSeekTimeUs / 1000L);
            }
            if (this.mScaleProcessor != null) {
                this.mScaleProcessor.b();
            }
            this.mSourceManager.a(this.mSeekTimeUs);
            if (this.pitchShiftProcessor != null) {
                this.pitchShiftProcessor.a(this.mSeekTimeUs, this.mTotalDuration);
            }
            if (this.mTotalDuration != 0L && this.mPlayingStatusListener != null) {
                this.mPlayingStatusListener.onPlayingProgress((float)this.mSeekTimeUs * 1.0f / (float)this.mTotalDuration);
            }
        }
    }

    private void handlePrepareOneFrame(boolean isDraw) {
        if (this.mSourceManager != null) {
            if (this.mIsPlaying || this.mIsSeeking) {
                this.mSourceManager.d(isDraw);
                this.mIsSeeking = false;
            } else {
                this.mSourceManager.d(false);
            }
        }
    }

    private void handleReleaseProcess() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess release !!!");
        this.releaseEncoder();
        if (this.mSourceManager != null && this.mMode == 1) {
            this.mSourceManager.a(false);
            this.mSourceManager.b(false);
            this.mSourceManager.c();
        }
        if (this.mSourceManager != null) {
            this.mSourceManager.b();
            this.mSourceManager = null;
        }
        if (this.mSourceConfig != null) {
            this.mSourceConfig.d();
            this.mSourceConfig = null;
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.f();
        }
        if (this.mMixProcessor != null) {
            this.mMixProcessor.a();
            this.mMixProcessor = null;
        }
        if (this.mSpeedControl != null) {
            this.mSpeedControl.e();
            this.mSpeedControl = null;
        }
        if (this.mScaleProcessor != null) {
            this.mScaleProcessor.a();
            this.mScaleProcessor = null;
        }
        if (this.pitchShiftProcessor != null) {
            this.pitchShiftProcessor.a();
            this.pitchShiftProcessor = null;
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.c();
            this.mAudioPlayer = null;
        }
        if (this.handler != null) {
            this.handler = null;
        }
        if (this.mBgChanger != null) {
            this.mBgChanger.release();
            this.mBgChanger = null;
        }
        if (this.sharedEglContex != null) {
            this.sharedEglContex.a();
            this.sharedEglContex = null;
            this.mSharedDumyContex = null;
        }
        if (this.mOnErrorDotDataListener != null) {
            this.mOnErrorDotDataListener = null;
        }
        this.mHolder = null;
        this.mMode = -1;
        this.mInputEffectModel = null;
    }

    private void handleStopPreview() {
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.c();
            this.mAudioPlayer = null;
        }
    }

    private v createNewMediaSource(String mediaPath) {
        int n2;
        MDLog.i((String)"EditProcess", (String)"MomoProcess createNewMediaSource !!!");
        if (mediaPath == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid mediaPath");
            return null;
        }
        r r2 = new r();
        r2.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels);
        r2.a(this.mSharedDumyContex);
        r2.a(this.mInternalErrorListener);
        r2.a(new MRecorderActions.onDotErrorListener(){

            @Override
            public void onFail(int errCode, String info) {
                if (MomoProcess.this.mOnErrorDotDataListener != null) {
                    MomoProcess.this.mOnErrorDotDataListener.onError(MomoProcess.this.serveCode + errCode, info);
                    ErrorDotStatistics.getInstance().addErrInfo("[" + (MomoProcess.this.serveCode + errCode) + "]" + info);
                }
                MDLog.e((String)"EditProcess", (String)("[" + (MomoProcess.this.serveCode + errCode) + "]" + info));
            }
        });
        if (this.renderThread != null) {
            if (this.renderThread.z() == null) {
                this.renderThread.B();
            }
            r2.a(this.renderThread.z(), this.renderThread.F(), this.renderThread.A());
        }
        if (!r2.a(mediaPath, 17)) {
            MDLog.e((String)"EditProcess", (String)"init Source Error");
            return null;
        }
        r2.a(false);
        if (this.mMode == 1 || this.mOutChannels <= 0) {
            this.mOutChannels = r2.l();
            int n3 = this.mOutChannels = this.mOutChannels <= 0 ? 1 : this.mOutChannels;
        }
        if (this.mMode == 1 || this.mOutSampleRate <= 0) {
            this.mOutSampleRate = r2.k();
            int n4 = this.mOutSampleRate = this.mOutSampleRate <= 0 ? 44100 : this.mOutSampleRate;
        }
        if ((n2 = r2.i()) == 90 || n2 == 270) {
            this.mOutWidth = r2.h();
            this.mOutHeight = r2.g();
        } else {
            this.mOutWidth = r2.g();
            this.mOutHeight = r2.h();
        }
        if (this.mOutWidth <= 0 || this.mOutHeight <= 0) {
            MDLog.e((String)"EditProcess", (String)"Analyse souce error");
            return null;
        }
        this.mImageWidth = this.mOutWidth;
        this.mImageHeight = this.mOutHeight;
        this.mVideoRotation = n2;
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(mediaPath);
        String string = mediaMetadataRetriever.extractMetadata(20);
        String string2 = mediaMetadataRetriever.extractMetadata(18);
        String string3 = mediaMetadataRetriever.extractMetadata(19);
        mediaMetadataRetriever.release();
        VideoDataRetrieverBySoft videoDataRetrieverBySoft = new VideoDataRetrieverBySoft();
        videoDataRetrieverBySoft.init(mediaPath);
        int n5 = videoDataRetrieverBySoft.getFrameRate();
        videoDataRetrieverBySoft.release();
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginalNaturalWidth(Integer.parseInt(string2));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginalNaturalHeight(Integer.parseInt(string3));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginBitrate(Integer.parseInt(string));
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginVideoFps(n5);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginAudioSamplerate(this.mOutSampleRate);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginAudioChannels(this.mOutChannels);
        return r2;
    }

    private boolean initEncoder(String outPath) {
        MDLog.i((String)"EditProcess", (String)("MomoProcess initEncoder !!!  mediaEncoderMode = " + this.mediaEncoderMode));
        if (this.mediaEncoderMode == 0) {
            this.encoderSoftWrapper = new t();
            this.encoderSoftWrapper.c(0);
            this.encoderSoftWrapper.a(this.mTotalDuration - this.mSeekTimeUs);
            this.encoderSoftWrapper.a(new j.b(){

                public void onUpdateProgress(int percent) {
                    if (MomoProcess.this.mProcessStatusListener != null && MomoProcess.this.mTotalDuration != 0L) {
                        MomoProcess.this.mProcessStatusListener.onProcessProgress((float)((double)percent / 100.0));
                    }
                }
            });
            this.encoderSoftWrapper.a(new j.a(){

                public void onError(int arg1, int arg2, String msg) {
                    if (MomoProcess.this.mErrorListener != null) {
                        MomoProcess.this.mErrorListener.onErrorCallback(-402, 0, "soft encoder error ");
                    }
                    MDLog.e((String)"EditProcess", (String)"soft encoder error ");
                }
            });
            this.encoderSoftWrapper.d(this.mCrfConstant);
            this.encoderSoftWrapper.e(this.mRcMethod);
            this.encoderSoftWrapper.a(this.mOutVideoGopSize);
            this.encoderSoftWrapper.b(this.mOutVideoRotation);
            this.encoderSoftWrapper.a(this.mEncodeWidth, this.mEncodeHeight, this.mOutVideoFps, this.mOutVideoBitrate);
            this.encoderSoftWrapper.a(this.mOutSampleRate, this.mOutChannels, this.mOutAudioBitrate);
            this.encoderWrapper = this.encoderSoftWrapper;
            this.setEncodeDotInfo();
        } else {
            this.encoderCodecWrapper = new u();
            this.encoderCodecWrapper.a(this.mInternalErrorListener);
            this.encoderCodecWrapper.a(this.mEncodeWidth, this.mEncodeHeight, this.mOutVideoFps, this.mOutVideoBitrate, this.mOutVideoGopSize, this.mOutVideoRotation, u.o);
            this.encoderCodecWrapper.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels, this.mOutAudioBitrate, 8192);
            this.setEncodeDotInfo();
            if (this.mOutVideoUseCQ) {
                this.encoderCodecWrapper.c();
            }
            if (this.mSpeedControl != null) {
                this.encoderCodecWrapper.a(new u.c(){

                    @Override
                    public long getCurVideoFramePts() {
                        long l2 = MomoProcess.this.getHeaderFramePts();
                        return l2;
                    }
                });
            }
            this.encoderWrapper = this.encoderCodecWrapper;
        }
        this.encoderWrapper.a(outPath);
        if (!this.encoderWrapper.a()) {
            this.encoderWrapper = null;
            MDLog.e((String)"EditProcess", (String)"startEncoding error");
            return false;
        }
        if (this.mediaEncoderMode == 1) {
            this.mVideoCodecSurface = this.encoderCodecWrapper.d();
        }
        return true;
    }

    private void setEncodeDotInfo() {
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditAudioSampleRate(this.mOutSampleRate);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditAudioChannels(this.mOutChannels);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditAudioBitrate(this.mOutAudioBitrate);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditAudioEncode("audio/mp4a-latm");
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditCq(this.mOutVideoUseCQ);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoEncode("video/avc");
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoExtension("mp4");
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoWidth(this.mEncodeWidth);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoHeight(this.mEncodeHeight);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoBitrate(this.mOutVideoBitrate);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoRotation(this.mOutVideoRotation);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoFrameRate(this.mOutVideoFps);
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoEditVideoGopSize(this.mOutVideoGopSize);
    }

    private boolean initBgChanger() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess initBgChanger !!!");
        final long l2 = System.currentTimeMillis();
        if (this.mInputEffectModel == null) {
            MDLog.e((String)"EditProcess", (String)"no EffectModel");
            return false;
        }
        String string = this.mInputEffectModel.getMediaPath();
        String string2 = "";
        boolean bl = false;
        float f2 = 0.0f;
        long l3 = 0L;
        long l4 = 0L;
        if (!FileUtil.exist((String)string)) {
            return false;
        }
        AudioEffects audioEffects = this.mInputEffectModel.getAudioEffects();
        if (audioEffects == null) {
            MDLog.e((String)"EditProcess", (String)"no Audio Effects");
            return false;
        }
        List<AudioBackground> list = audioEffects.getAudioBackgrounds();
        if (list != null && list.size() > 0) {
            bl = true;
            AudioBackground audioBackground = list.get(0);
            string2 = audioBackground.getBgPath();
            l3 = audioBackground.getStart();
            l4 = audioBackground.getEnd();
            f2 = audioBackground.getRatio();
        } else {
            bl = false;
            f2 = audioEffects.getAudioSource() != null ? audioEffects.getAudioSource().getRatio() : 1.0f;
        }
        this.mBgChanger = new FFBgChanger();
        if (!this.mBgChanger.initBgChanger()) {
            MDLog.e((String)"EditProcess", (String)"initBgChanger error");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 8001, "initBgChanger error");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 8001) + "]" + "initBgChanger error");
            return false;
        }
        if (!this.mBgChanger.setOutputFileName(this.mMediaOutPath)) {
            MDLog.e((String)"EditProcess", (String)"setOutputFileName error");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 8002, "setOutputFileName error");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 8002) + "]" + "setOutputFileName error");
            return false;
        }
        this.mBgChanger.setMixModeAndRatio(Boolean.valueOf(bl), f2);
        if (!this.mBgChanger.initVideoSource(string)) {
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 8003, "bgChange init video source error");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 8003) + "]" + "bgChange init video source error");
            MDLog.e((String)"EditProcess", (String)"bgChange init video source error");
            return false;
        }
        if (bl && !this.mBgChanger.initAudioSource(string2, l3, l4)) {
            MDLog.e((String)"EditProcess", (String)"bgChange init audio source error");
            if (this.mOnErrorDotDataListener != null) {
                this.mOnErrorDotDataListener.onError(this.serveCode + 8004, "bgChange init audio source error");
            }
            ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 8004) + "]" + "bgChange init audio source error");
            return false;
        }
        this.mBgChanger.setBgChangerListener(new FFBgChanger.OnBgChangerListener(){

            public void onProgress(int progress) {
                if (MomoProcess.this.mProcessStatusListener != null) {
                    MomoProcess.this.mProcessStatusListener.onProcessProgress(progress);
                }
                if (progress == 100 && MomoProcess.this.mProcessStatusListener != null && MomoProcess.this.mProcessStatusListener != null) {
                    MomoProcess.this.dotVideoInfo(l2);
                    MomoProcess.this.mProcessStatusListener.onProcessFinished();
                }
            }

            public void onError(int err) {
                if (MomoProcess.this.mErrorListener != null) {
                    MomoProcess.this.mErrorListener.onErrorCallback(-402, 0, "BgChanger error ");
                }
                if (MomoProcess.this.mOnErrorDotDataListener != null) {
                    MomoProcess.this.mOnErrorDotDataListener.onError(MomoProcess.this.serveCode + 8005, "BgChanger running error");
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (MomoProcess.this.serveCode + 8005) + "]" + err + "BgChanger running error");
                MDLog.e((String)"EditProcess", (String)"BgChanger running error");
            }
        });
        return true;
    }

    private boolean startEncoder() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess startEncoder !!!");
        if (this.mSourceManager == null) {
            this.doUpdateEffectModel();
        }
        if (this.mSourceManager == null) {
            MDLog.e((String)"EditProcess", (String)"source error");
            return false;
        }
        this.mSourceManager.b(false);
        this.mSourceManager.a(false);
        this.mSourceManager.b(1);
        if (this.pitchShiftProcessor != null) {
            this.pitchShiftProcessor.b();
            this.audioController.a(this.pitchShiftProcessor);
            DataDotUtils.getInstance().getEditDataDotInfo().setVideoSourcePitchShift(true);
        }
        if (this.mScaleProcessor != null) {
            this.mScaleProcessor.b();
            this.audioController.a(this.mScaleProcessor);
        }
        if (this.mMixProcessor != null) {
            this.mMixProcessor.b();
            this.audioController.a(this.mMixProcessor);
        } else if (this.mVolumeControlProcessor != null) {
            this.audioController.a(this.mVolumeControlProcessor);
        }
        if (this.mIsNewSource) {
            if (!this.mSourceManager.a()) {
                MDLog.e((String)"EditProcess", (String)"mSourceManager start failed");
                return false;
            }
            this.mIsNewSource = false;
        } else if (!this.mSourceManager.a(0L)) {
            MDLog.e((String)"EditProcess", (String)"mSourceManager seek failed");
            return false;
        }
        if (!this.initEncoder(this.mMediaOutPath)) {
            MDLog.e((String)"EditProcess", (String)"initEncoder failed");
            return false;
        }
        if (this.mediaEncoderMode == 0) {
            this.renderThread.a(new c.a(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onVideoBufferListener(ByteBuffer data, int len, long pts) {
                    Object object = MomoProcess.this.syncFrame;
                    synchronized (object) {
                        PacketData packetData = new PacketData(data);
                        packetData.setBuffInfo(len, 0, 0, pts, 0);
                        if (MomoProcess.this.encoderWrapper != null) {
                            MomoProcess.this.encoderWrapper.a(packetData);
                        }
                    }
                }
            });
            this.renderThread.C();
            this.renderThread.a(null, new Size(this.mEncodeWidth, this.mEncodeHeight));
        } else if (this.encoderWrapper instanceof u && this.mVideoCodecSurface != null) {
            this.renderThread.s(this.mVideoCodecSurface);
            this.renderThread.a(this.mVideoCodecSurface, new Size(this.mEncodeWidth, this.mEncodeHeight));
        }
        return true;
    }

    private boolean initSource() {
        ArrayList<Float> arrayList;
        Object object;
        MDLog.i((String)"EditProcess", (String)"MomoProcess initSource !!!");
        if (this.mInputEffectModel == null) {
            MDLog.e((String)"EditProcess", (String)"Invalid model");
            return false;
        }
        if (this.mSourceManager != null) {
            this.mSourceManager.c();
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.d();
        }
        if (this.mSourceConfig != null) {
            this.mSourceConfig.c();
        }
        this.mTotalDuration = 0L;
        v v2 = null;
        List<VideoCut> list = null;
        if (this.mInputEffectModel.getVideoEffects() != null) {
            list = this.mInputEffectModel.getVideoEffects().getVideoCuts();
        }
        if (list != null && list.size() > 0) {
            if (list.size() > 1) {
                String string = null;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string2 = list.get(i2).getMedia();
                    if (string2 == null) continue;
                    if (string == null) {
                        string = string2;
                    }
                    if (string2.equals(string)) continue;
                    MDLog.e((String)"EditProcess", (String)" Surface Texture does not support switching between two different video sources!!!");
                    if (this.mOnErrorDotDataListener != null) {
                        this.mOnErrorDotDataListener.onError(this.serveCode + 5001, " Surface Texture does not support switching between two different video sources!!!");
                    }
                    ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5001) + "]" + " Surface Texture does not support switching between two different video sources!!!");
                    return false;
                }
            }
            long l2 = 0L;
            long l3 = 0L;
            object = list.iterator();
            while (object.hasNext()) {
                VideoCut videoCut = object.next();
                if (videoCut.getMedia() == null) continue;
                if (this.mSourceConfig != null && this.mSourceConfig.a() != null) {
                    v2 = this.mSourceConfig.a().get(videoCut.getMedia());
                }
                if (v2 == null) {
                    if (this.mSourceManager != null) {
                        this.count = 0;
                        this.mSourceManager.b();
                        this.mSourceManager = null;
                        this.mSourceConfig = null;
                    }
                    if ((v2 = this.createNewMediaSource(videoCut.getMedia())) == null) continue;
                    if (this.mSourceConfig == null) {
                        this.mSourceConfig = new w();
                    }
                    this.mSourceConfig.a(videoCut.getMedia(), v2);
                    File serializable = new File(videoCut.getMedia());
                    if (serializable.exists() && serializable.isFile()) {
                        l3 += serializable.length();
                    }
                }
                this.mSourceConfig.a(videoCut.getMedia(), videoCut.getStart() * 1000L, videoCut.getEnd() * 1000L, videoCut.isReverse());
                l2 = v2.j();
                if (videoCut.getEnd() * 1000L > l2) {
                    this.mTotalDuration += l2 - videoCut.getStart() * 1000L;
                    continue;
                }
                this.mTotalDuration += (videoCut.getEnd() - videoCut.getStart()) * 1000L;
            }
            DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginSize(l3);
        } else {
            String string = this.mInputEffectModel.getMediaPath();
            if (string != null) {
                if (this.mSourceConfig != null && this.mSourceConfig.a() != null) {
                    v2 = this.mSourceConfig.a().get(this.mInputEffectModel.getMediaPath());
                }
                if (v2 == null) {
                    this.clearPreviousSource();
                    v2 = this.createNewMediaSource(this.mInputEffectModel.getMediaPath());
                    if (v2 == null) {
                        MDLog.e((String)"EditProcess", (String)"Fail to create new source");
                        if (this.mOnErrorDotDataListener != null) {
                            this.mOnErrorDotDataListener.onError(this.serveCode + 5001, " Fail to create new source!!!");
                        }
                        ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5001) + "]" + " Fail to create new source!!!");
                        return false;
                    }
                    if (this.mSourceConfig == null) {
                        this.mSourceConfig = new w();
                    }
                    this.mSourceConfig.a(this.mInputEffectModel.getMediaPath(), v2);
                }
                this.mSourceConfig.a(this.mInputEffectModel.getMediaPath(), 0L, -1L);
                this.mTotalDuration = v2.j();
                long l4 = 0L;
                arrayList = new File(string);
                if (((File)((Object)arrayList)).exists() && ((File)((Object)arrayList)).isFile()) {
                    l4 = ((File)((Object)arrayList)).length();
                }
                DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginSize(l4);
            } else {
                MDLog.e((String)"EditProcess", (String)"No source");
                if (this.mOnErrorDotDataListener != null) {
                    this.mOnErrorDotDataListener.onError(this.serveCode + 5001, " The media source is empty !!!");
                }
                ErrorDotStatistics.getInstance().addErrInfo("[" + (this.serveCode + 5001) + "]" + " The media source is empty !!!");
                return false;
            }
        }
        DataDotUtils.getInstance().getEditDataDotInfo().setVideoOriginDuration(this.mTotalDuration);
        VideoEffects videoEffects = this.mInputEffectModel.getVideoEffects();
        AudioEffects audioEffects = this.mInputEffectModel.getAudioEffects();
        if (this.mSpeedControl != null) {
            this.mSpeedControl.a();
            this.mSpeedControl.a(null);
        }
        if (this.mScaleProcessor != null) {
            this.mScaleProcessor.b();
            this.mScaleProcessor.a(null);
        }
        if (this.mMixProcessor != null) {
            this.mMixProcessor.a();
            this.mMixProcessor = null;
        }
        if (this.mVolumeControlProcessor != null) {
            this.mVolumeControlProcessor.a();
            this.mVolumeControlProcessor = null;
        }
        if (videoEffects != null) {
            List<TimeRangeScale> list2 = this.adjustTimeRangeScaleList(videoEffects.getTimeRangeScales(), this.mSeekTimeUs / 1000L);
            this.mTotalDuration = this.calculateRealDuration(this.mTotalDuration, list2);
            if (this.mSpeedControl == null) {
                this.mSpeedControl = new ad();
            }
            this.mSpeedControl.a(list2);
            if (list2 != null) {
                DataDotUtils.getInstance().getEditDataDotInfo().setVideoUseSpeedvary(true);
                arrayList = new ArrayList<Float>();
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    arrayList.add(Float.valueOf(list2.get(i3).getSpeed()));
                }
                object = new Float[arrayList.size()];
                DataDotUtils.getInstance().getEditDataDotInfo().setVideoSpeedvaryValue((Float[])arrayList.toArray((T[])object));
                MDLog.i((String)"EditProcess", (String)("The speed value is " + arrayList.toArray().toString()));
            }
            boolean bl = false;
            if (list2 != null && list2.size() > 0) {
                bl = true;
                if (list2.size() == 1 && ((TimeRangeScale)(object = list2.get(0))).getEnd() - ((TimeRangeScale)object).getStart() < 1000L) {
                    bl = false;
                }
            }
            if (bl) {
                if (this.mScaleProcessor == null) {
                    this.mScaleProcessor = new h();
                    this.mScaleProcessor.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels);
                    this.mScaleProcessor.c();
                }
                this.mScaleProcessor.a(list2);
            }
        }
        if (audioEffects != null) {
            List<AudioBackground> list3 = audioEffects.getAudioBackgrounds();
            arrayList = audioEffects.getAudioSource();
            if (list3 != null) {
                DataDotUtils.getInstance().getEditDataDotInfo().setVideoUseBgMusic(true);
                float f2 = arrayList == null ? 1.0f : ((AudioEffects.AudioSource)((Object)arrayList)).getRatio();
                for (AudioBackground audioBackground : list3) {
                    if (audioBackground.getBgPath() == null) continue;
                    this.mMixProcessor = new c();
                    this.mMixProcessor.a(this.mOutSampleRate, this.mOutBits, this.mOutChannels);
                    if (!this.mMixProcessor.a(audioBackground.getBgPath(), audioBackground.getStart(), audioBackground.getEnd())) {
                        MDLog.e((String)"EditProcess", (String)("Init Audio Mixer error !! Audio File [" + audioBackground.getBgPath() + "] maybe not exist !!"));
                        if (this.mOnErrorDotDataListener != null) {
                            this.mOnErrorDotDataListener.onError(this.serveCode + 5004, "Init Audio Mixer error !! Audio File [" + audioBackground.getBgPath() + "] maybe not exist !!");
                        }
                        ErrorDotStatistics.getInstance().addErrInfo("[" + this.serveCode + 5004 + "]" + "Init Audio Mixer error !! Audio File [" + audioBackground.getBgPath() + "] maybe not exist !!");
                        return false;
                    }
                    this.mMixProcessor.a(f2, audioBackground.getRatio());
                    break;
                }
            } else {
                this.mVolumeControlProcessor = new i();
                if (arrayList != null) {
                    this.mVolumeControlProcessor.a(((AudioEffects.AudioSource)((Object)arrayList)).getRatio());
                }
            }
        }
        if (this.mMixProcessor != null) {
            this.mMixProcessor.a(this.mSeekTimeUs / 1000L);
        }
        this.resetAudioPlayer();
        if (this.mSourceManager == null) {
            this.mIsNewSource = true;
            this.mSourceManager = new x();
            this.mSourceManager.a(this.mIsLoopbackMode);
            this.mSourceManager.a(this.mDataOutputCallback);
            this.mSourceManager.a(new x.c(){

                @Override
                public void onPauseComplete() {
                    if (MomoProcess.this.mPlayingStatusListener != null) {
                        MomoProcess.this.mPlayingStatusListener.onPlayingPaused();
                    }
                    MDLog.i((String)"EditProcess", (String)"MediaSourceManager onPauseComplete !!!");
                }

                public void onResumeComplete() {
                    MDLog.i((String)"EditProcess", (String)"MediaSourceManager onResumeComplete !!!");
                }

                @Override
                public void onSeekComplete() {
                    if (MomoProcess.this.mAudioPlayer != null && MomoProcess.this.mSeekAndPlay) {
                        MomoProcess.this.mAudioPlayer.b();
                    }
                    if (MomoProcess.this.videoControllerPlayer != null) {
                        MomoProcess.this.videoControllerPlayer.a(MomoProcess.this.mSeekAndPlay);
                    }
                    MDLog.i((String)"EditProcess", (String)"MediaSourceManager onSeekComplete !!!");
                }
            });
        }
        this.mSourceManager.a(this.mSourceConfig);
        return true;
    }

    private void resetAudioPlayer() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess resetAudioPlayer !!!");
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.d();
            if (this.pitchShiftProcessor != null) {
                this.pitchShiftProcessor.b();
                this.mAudioPlayer.a(this.pitchShiftProcessor);
            }
            if (this.mScaleProcessor != null) {
                this.mScaleProcessor.b();
                this.mAudioPlayer.a(this.mScaleProcessor);
            }
            if (this.mMixProcessor != null) {
                this.mMixProcessor.b();
                this.mAudioPlayer.a(this.mMixProcessor);
            } else if (this.mVolumeControlProcessor != null) {
                this.mAudioPlayer.a(this.mVolumeControlProcessor);
            }
        }
    }

    private long getHeaderFramePts() {
        if (this.mSpeedControl != null) {
            return this.mSpeedControl.d();
        }
        return -1L;
    }

    private void clearPreviousSource() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess clearPreviousSource !!!");
        this.mIsPlaying = false;
        if (this.mSourceManager != null) {
            this.mSourceManager.b();
            this.mSourceManager = null;
        }
        if (this.mSourceConfig != null) {
            this.mSourceConfig.d();
            this.mSourceConfig = null;
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.d();
        }
        if (this.audioController != null) {
            this.audioController.a();
        }
        if (this.mSpeedControl != null) {
            this.mSpeedControl.e();
            this.mSpeedControl = null;
        }
        if (this.renderThread != null) {
            this.renderThread.y();
        }
    }

    private List<TimeRangeScale> adjustTimeRangeScaleList(List<TimeRangeScale> timeRangeScales, long startTime) {
        MDLog.i((String)"EditProcess", (String)"Adjust time range scale !!!");
        if (timeRangeScales == null || timeRangeScales.size() <= 0) {
            return null;
        }
        ArrayList<TimeRangeScale> arrayList = new ArrayList<TimeRangeScale>();
        for (TimeRangeScale timeRangeScale : timeRangeScales) {
            long l2 = timeRangeScale.getStart() - startTime;
            long l3 = timeRangeScale.getEnd() - startTime;
            l2 = l2 >= 0L ? l2 : 0L;
            l3 = l3 >= 0L ? l3 : 0L;
            TimeRangeScale timeRangeScale2 = new TimeRangeScale(l2, l3, timeRangeScale.getSpeed());
            arrayList.add(timeRangeScale2);
        }
        return arrayList;
    }

    private long calculateRealDuration(long originDuration, List<TimeRangeScale> timeRangeScales) {
        MDLog.i((String)"EditProcess", (String)"MomoProcess calculateRealDuration !!!");
        if (timeRangeScales == null || timeRangeScales.size() <= 0) {
            return originDuration;
        }
        for (TimeRangeScale timeRangeScale : timeRangeScales) {
            float f2 = timeRangeScale.getSpeed();
            long l2 = timeRangeScale.getEnd() - timeRangeScale.getStart();
            long l3 = (long)((float)l2 * f2);
            long l4 = l3 - l2;
            originDuration += l4 * 1000L;
        }
        return originDuration;
    }

    private void setCodecBounds() {
        if (this.iFrameOnly && this.mMode == 0 && this.encoderWrapper != null && this.encoderWrapper instanceof u) {
            ((u)this.encoderWrapper).a(this.bound);
        }
    }

    private void releaseEncoder() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess releaseEncoder !!!");
        if (this.encoderWrapper != null) {
            this.encoderWrapper.a(true);
            this.encoderWrapper.b();
            this.encoderWrapper = null;
        }
    }

    private void doUpdateEffectModel() {
        MDLog.i((String)"EditProcess", (String)"MomoProcess doUpdateEffectModel !!!");
        this.mIsChangeEffectMode = true;
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.b();
            this.videoControllerPlayer.d();
        }
        if (this.mAudioPlayer != null) {
            this.mAudioPlayer.a();
            this.mAudioPlayer.e();
        }
        if (!this.initSource()) {
            MDLog.e((String)"EditProcess", (String)"init Source Error");
            if (this.mErrorListener != null) {
                this.mErrorListener.onErrorCallback(-401, 0, null);
            }
            return;
        }
        if (this.mSpeedControl != null) {
            this.mSpeedControl.a();
        }
        if (this.videoControllerPlayer != null) {
            this.videoControllerPlayer.a(this.mSpeedControl);
        }
    }

    public void setOnErrorDotDataListener(MRecorderActions.OnErrorDotDataListener onErrorDotDataListener) {
        this.mOnErrorDotDataListener = onErrorDotDataListener;
    }

    public long getTotalTime() {
        return this.mTotalDuration;
    }

    public static interface OnVideoControllerListener {
        public void onPrepareOneFrame(boolean var1);

        public void onRequestRender();

        public void onPlayPts(long var1);

        public void onVideoCutFinished();
    }
}

