/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.mediautils;

import android.graphics.Bitmap;
import com.core.glcore.cv.MMFrameInfo;
import com.core.glcore.util.Log4Cam;
import com.immomo.moment.mediautils.z;
import com.immomo.moment.util.d;
import com.momocv.pickercover.PickerCover;
import com.momocv.pickercover.PickerCoverInfo;
import com.momocv.videoprocessor.VideoParams;
import java.util.List;

public class VideoDataRetrieverBySoft
extends z {
    private String TAG = "VideoDataRetriever";
    private long mHandler = 0L;
    private Object mSync = new Object();
    private int[] mARGBData = null;
    private int[] mDstIntData = null;
    private byte[] mDstByteData = null;
    Bitmap mCurBmp = null;
    List<Node> mThumbnailList;
    private int mIndex = 0;
    public static final int AV_PIX_FMT_YUV420P = 0;
    public static final int AV_PIX_FMT_NV12 = 25;
    public static final int AV_PIX_FMT_BGRA = 30;
    public static final int AV_PIX_FMT_RGBA = 28;
    public static final int BITMAP_IMAGE = 1;
    public static final int INTRAW_IMAGE = 2;
    public static final int BYTERAW_IMAGE = 3;
    public static final int BYTERAW_DATA = 4;
    public static final int INTRAW_DATA = 5;
    private int mWidth;
    private int mHeight;
    private long mDuration;
    private int mType;
    private final int ONE_MINIS_DURATION = 60000000;
    private final int THREE_MINIS_DURATION = 180000000;
    public static final int GET_FRAME_TYPE_BY_BEST = 1;
    private final int GET_FRAME_TYPE_NORMAL = 0;
    private final int BEST_FRAME_NEED_CNT_FOR_ONE_MINS = 10;
    private final int BEST_FRAME_NEED_CNT_FOR_THREE_MINS = 20;
    private final int BEST_FRAME_NEED_CNT_FOR_FIVE_MINS = 30;
    private OnThumbnailListComplete mCompleteListener;
    private BestFrameFilter mFrameFilter;
    private boolean mExit = false;
    private PickerCover mCoverPicker = null;
    private List<String> mFaceModeList = null;
    private long WAIT_TIME_US = 10000L;
    private ImageFrameFilterListener mImageFrameFilterListener;

    private static native long nativeCreateVideoDataRetriver();

    private static native int nativeInitVideoDataRetriver(long var0, String var2);

    private static native int nativeDecodeOneFrame(long var0, long var2);

    private static native int nativeMediaRetrieverSeek(long var0, long var2);

    private static native int nativeMediaRetrieverGetRGBImageData(long var0, int[] var2);

    private static native int nativeMediaRetrieverRelease(long var0);

    private static native int nativeMediaRetrieverGetWidth(long var0);

    private static native int nativeMediaRetrieverGetHeight(long var0);

    private static native int nativeMediaRetrieverGetRotation(long var0);

    private static native long nativeMediaRetrieverGetDuration(long var0);

    private static native int nativeMediaRetrieverGetFrameRate(long var0);

    private static native int nativeMediaRetrieverGetRGBByteImageData(long var0, byte[] var2);

    private static native int nativeMediaRetrieverGetYUVImageData(long var0, byte[] var2);

    private static native int nativeMediaRetrieverGetDstFmtData(long var0, byte[] var2);

    private static native int nativeMediaRetrieverGetDstFmtDataIntArray(long var0, int[] var2);

    private static native void nativeMediaRetrieverSetYuvAndRgbOut(long var0, int var2);

    private static native void nativeMediaRetrieverSetDstPixFmt(long var0, int var2);

    private static native void nativeSetDstPixSize(long var0, int var2, int var3);

    public VideoDataRetrieverBySoft() {
        this.mHandler = VideoDataRetrieverBySoft.nativeCreateVideoDataRetriver();
    }

    private int initNativeRetriever(String path) {
        if (this.mHandler == 0L || path == null || path.length() == 0) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeInitVideoDataRetriver(this.mHandler, path);
    }

    private int nativeDecodeOneFrame(long pts) {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeDecodeOneFrame(this.mHandler, pts);
    }

    private void nativeSetYuvAndRgbOutFlag(boolean isOpen) {
        if (this.mHandler != 0L) {
            VideoDataRetrieverBySoft.nativeMediaRetrieverSetYuvAndRgbOut(this.mHandler, isOpen ? 1 : 0);
        }
    }

    private void nativeSetDstPixFmt(int pix) {
        if (this.mHandler != 0L) {
            VideoDataRetrieverBySoft.nativeMediaRetrieverSetDstPixFmt(this.mHandler, pix);
        }
    }

    private void setDstImageSize(int width, int height) {
        if (this.mHandler != 0L) {
            VideoDataRetrieverBySoft.nativeSetDstPixSize(this.mHandler, width, height);
        }
    }

    private int nativeSeek(long pts) {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverSeek(this.mHandler, pts);
    }

    private int nativeGetRGBImage(int[] data) {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetRGBImageData(this.mHandler, data);
    }

    private int nativeGetDstImage(byte[] data) {
        if (this.mHandler != 0L) {
            return VideoDataRetrieverBySoft.nativeMediaRetrieverGetDstFmtData(this.mHandler, data);
        }
        return -1;
    }

    private int nativeGetDstImage(int[] data) {
        if (this.mHandler != 0L) {
            return VideoDataRetrieverBySoft.nativeMediaRetrieverGetDstFmtDataIntArray(this.mHandler, data);
        }
        return -1;
    }

    private int nativeRelease() {
        if (this.mHandler == 0L) {
            return -1;
        }
        VideoDataRetrieverBySoft.nativeMediaRetrieverRelease(this.mHandler);
        this.mHandler = 0L;
        return 0;
    }

    private int nativeGetWidth() {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetWidth(this.mHandler);
    }

    private int nativeGetHeight() {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetHeight(this.mHandler);
    }

    private int nativeGetRotation() {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetRotation(this.mHandler);
    }

    private long nativeGetDuration() {
        if (this.mHandler == 0L) {
            return -1L;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetDuration(this.mHandler);
    }

    private int nativeGetFps() {
        if (this.mHandler == 0L) {
            return 0;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetFrameRate(this.mHandler);
    }

    private int nativeGetYuvImage(byte[] image) {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetYUVImageData(this.mHandler, image);
    }

    private int nativeGetRGBImage(byte[] image) {
        if (this.mHandler == 0L) {
            return -1;
        }
        return VideoDataRetrieverBySoft.nativeMediaRetrieverGetRGBByteImageData(this.mHandler, image);
    }

    public void setOnCompleteListener(OnThumbnailListComplete listener) {
        this.mCompleteListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getFrameAtTime(long ptsUs) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.nativeSeek(ptsUs) < 0) {
                return null;
            }
            return this.decodecOneFrameToBmp(ptsUs, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getFrameAbsTime(long ptsMs) {
        Object object = this.mSync;
        synchronized (object) {
            return this.decodecOneFrameToBmp(ptsMs * 1000L, 0, 0);
        }
    }

    public int getImageRotation() {
        return 0;
    }

    public boolean init(String path) {
        int n2 = 0;
        if (this.mHandler == 0L || path == null || path.length() == 0) {
            return false;
        }
        n2 = VideoDataRetrieverBySoft.nativeInitVideoDataRetriver(this.mHandler, path);
        if (n2 < 0) {
            this.release();
            this.mHandler = 0L;
            return false;
        }
        this.mWidth = this.nativeGetWidth();
        this.mHeight = this.nativeGetHeight();
        this.mDuration = this.nativeGetDuration();
        this.mARGBData = new int[this.mWidth * this.mHeight];
        return true;
    }

    public void setBestFrameCnt(int cnt, int interval) {
        if (this.mFrameFilter != null) {
            this.mFrameFilter.setFrameCnt(cnt, interval);
        }
    }

    private boolean allocImagebuffer(int pixFmt) {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int n2 = this.getWidth() * this.getHeight();
            switch (pixFmt) {
                case 28: 
                case 30: {
                    if (this.mDstByteData == null || this.mDstByteData.length != n2 * 4) {
                        this.mDstByteData = new byte[this.getHeight() * this.getWidth() * 4];
                    }
                    if (this.mDstIntData != null && this.mDstIntData.length == n2) break;
                    this.mDstIntData = new int[this.getWidth() * this.getHeight()];
                    break;
                }
                case 0: 
                case 25: {
                    if (this.mDstByteData == null || this.mDstByteData.length != n2 * 3 / 2) {
                        this.mDstByteData = new byte[this.getWidth() * this.getHeight() * 3 / 2];
                    }
                    if (this.mDstIntData != null && this.mDstIntData.length == n2) break;
                    this.mDstIntData = new int[this.getWidth() * this.getHeight()];
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private Object decoderOneFrame(long needPts, int imgType, int pixFmt) {
        this.nativeSetYuvAndRgbOutFlag(false);
        this.nativeSetDstPixFmt(pixFmt);
        int n2 = 0;
        Object[] objectArray = null;
        n2 = this.nativeDecodeOneFrame(needPts);
        if (n2 > 0 && this.allocImagebuffer(pixFmt)) {
            if (imgType == 5) {
                n2 = this.nativeGetDstImage(this.mDstIntData);
                if (n2 == 0) {
                    objectArray = this.mDstIntData;
                }
            } else if (imgType == 4 && (n2 = this.nativeGetDstImage(this.mDstByteData)) == 0) {
                objectArray = this.mDstByteData;
            }
        }
        return objectArray;
    }

    private Bitmap decodecOneFrameToBmp(long needPts, int dstWidth, int dstHeight) {
        int[] nArray;
        this.nativeSetYuvAndRgbOutFlag(false);
        this.nativeSetDstPixFmt(30);
        if (dstHeight > 0 && dstHeight > 0) {
            this.setDstImageSize(dstWidth, dstHeight);
        }
        if ((nArray = (int[])this.decoderOneFrame(needPts, 5, 30)) != null) {
            dstWidth = dstWidth <= 0 ? this.mWidth : dstWidth;
            dstHeight = dstHeight <= 0 ? this.mHeight : dstHeight;
            return Bitmap.createBitmap((int[])nArray, (int)0, (int)dstWidth, (int)dstWidth, (int)dstHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        return null;
    }

    private void seek(long ptsUs) {
        this.nativeSeek(ptsUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImageByList(List<Node> list, int imageType, int pixFmt) {
        if (this.mType == 1) {
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            Node node;
            long l2 = System.currentTimeMillis();
            this.mThumbnailList = list;
            if (list.size() > 0) {
                node = list.get(0);
                this.seek(node.pts);
            }
            this.mIndex = 0;
            while (this.mIndex < list.size()) {
                node = list.get(this.mIndex);
                if (imageType == 1) {
                    Bitmap bitmap = null;
                    bitmap = this.decodecOneFrameToBmp(node.pts, node.dstWidth, node.dstHeight);
                    if (bitmap != null) {
                        node.bmp = bitmap;
                        Log4Cam.e((String)this.TAG, (String)("get cur frame cost " + (System.currentTimeMillis() - l2)));
                        l2 = System.currentTimeMillis();
                    }
                } else if (imageType == 2) {
                    node.intBuffer = (int[])this.decoderOneFrame(node.pts, 5, pixFmt);
                } else if (imageType == 3) {
                    node.byteBuffer = (byte[])this.decoderOneFrame(node.pts, 4, pixFmt);
                }
                ++this.mIndex;
                if (this.mIndex >= list.size() || list.get((int)this.mIndex).pts >= node.pts && list.get((int)this.mIndex).pts - node.pts < 1000000L) continue;
                Log4Cam.e((String)this.TAG, (String)("seek to new pos " + list.get((int)this.mIndex).pts));
                this.seek(list.get((int)this.mIndex).pts);
            }
        }
    }

    public void getImageByList(List<Node> list) {
        this.getImageByList(list, 1, 30);
        Log4Cam.e((String)this.TAG, (String)"\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.mExit = true;
        Object object = this.mSync;
        synchronized (object) {
            this.nativeRelease();
            this.mExit = false;
        }
    }

    public int getWidth() {
        return this.nativeGetWidth();
    }

    public int getHeight() {
        return this.nativeGetHeight();
    }

    public int getRotation() {
        return this.nativeGetRotation();
    }

    public long getDuration() {
        return this.nativeGetDuration();
    }

    public int getFrameRate() {
        return this.nativeGetFps();
    }

    public Bitmap getBestImage() {
        return null;
    }

    public boolean initWithType(String path, int type, int cnt) {
        return this.initWithType(path, type, cnt, 0);
    }

    public boolean initWithType(String path, int type, int cnt, int interval) {
        if (!this.init(path)) {
            return false;
        }
        this.mType = type;
        if (type == 1) {
            this.mFrameFilter = new BestFrameFilter();
        }
        if (this.mFrameFilter != null) {
            this.mFrameFilter.setFrameCnt(cnt, interval);
        }
        return true;
    }

    public void setImageFrameFilterListener(ImageFrameFilterListener mImageFrameFilterListener) {
        this.mImageFrameFilterListener = mImageFrameFilterListener;
    }

    public void setmFaceModeList(List<String> mFaceModeList) {
        this.mFaceModeList = mFaceModeList;
    }

    public void executeFrameFilter() {
        if (this.mFrameFilter != null) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block8: {
                        Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"executeFrameFilter is called\uff0cthread will run!");
                        if (VideoDataRetrieverBySoft.this.mCoverPicker == null) {
                            VideoDataRetrieverBySoft.this.mCoverPicker = new PickerCover();
                            if (VideoDataRetrieverBySoft.this.mFaceModeList != null && VideoDataRetrieverBySoft.this.mFaceModeList.size() >= 2) {
                                VideoDataRetrieverBySoft.this.mCoverPicker.LoadModel((String)VideoDataRetrieverBySoft.this.mFaceModeList.get(0), (String)VideoDataRetrieverBySoft.this.mFaceModeList.get(1));
                            }
                        }
                        try {
                            VideoDataRetrieverBySoft.this.mFrameFilter.setYuv(new byte[VideoDataRetrieverBySoft.this.mWidth * VideoDataRetrieverBySoft.this.mHeight * 3 / 2]);
                            Object object = VideoDataRetrieverBySoft.this.mSync;
                            synchronized (object) {
                                VideoDataRetrieverBySoft.this.mFrameFilter.doFrameFilter();
                            }
                        }
                        catch (Exception exception) {
                            Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"executeFrameFilter thread is exception, will release!");
                            exception.printStackTrace();
                            VideoDataRetrieverBySoft.this.release();
                            if (VideoDataRetrieverBySoft.this.mImageFrameFilterListener == null) break block8;
                            VideoDataRetrieverBySoft.this.mImageFrameFilterListener.doFilterError(exception);
                        }
                    }
                    if (VideoDataRetrieverBySoft.this.mCoverPicker != null) {
                        VideoDataRetrieverBySoft.this.mCoverPicker.Release();
                        VideoDataRetrieverBySoft.this.mCoverPicker = null;
                    }
                }
            }, "DataRetriverBySoft" + d.a()).start();
        }
    }

    private long getAutoStep() {
        return 300000L;
    }

    private long getAutoMaxLength(long step) {
        long l2 = 2000000L;
        long l3 = l2 % step;
        if (l3 != 0L) {
            l2 += step - l3;
        }
        return l2;
    }

    class BestFrameFilter {
        private int mInterval;
        private int mMaxCnt = 0;
        private int mNeedFrameCnt;
        private long mPtsStep = 0L;
        private MMFrameInfo frame = new MMFrameInfo();
        private byte[] yuv;

        BestFrameFilter() {
        }

        private void setYuv(byte[] yuv) {
            this.yuv = yuv;
        }

        private void setFrameCnt(int needFrameCnt, int interval) {
            this.mNeedFrameCnt = needFrameCnt;
            this.mInterval = interval == 0 ? (this.mNeedFrameCnt <= 10 ? 3 : (this.mNeedFrameCnt <= 20 ? 2 : (this.mNeedFrameCnt <= 30 ? 2 : 1))) : (this.mInterval > 0 ? interval : 1);
            if (this.mInterval == 1) {
                this.mPtsStep = 40000L;
            } else {
                this.mMaxCnt = this.mNeedFrameCnt * this.mInterval;
                this.mPtsStep = VideoDataRetrieverBySoft.this.mDuration / (long)this.mMaxCnt;
                Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)("  setFrameCnt method,  mNeedFrameCnt:" + this.mNeedFrameCnt + ", mInterval:" + this.mInterval + ", mMaxCnt:" + this.mMaxCnt + ", mDuration:" + VideoDataRetrieverBySoft.this.mDuration + ",mPtsStep:" + this.mPtsStep));
            }
        }

        public float doMMCVFilter(byte[] data) {
            this.frame.setFormat(17);
            this.frame.setDataPtr(data);
            this.frame.setDataLen(data.length);
            this.frame.setWidth(VideoDataRetrieverBySoft.this.mWidth);
            this.frame.setHeight(VideoDataRetrieverBySoft.this.mHeight);
            this.frame.setStep_(VideoDataRetrieverBySoft.this.mWidth);
            PickerCoverInfo pickerCoverInfo = new PickerCoverInfo();
            VideoParams videoParams = new VideoParams();
            videoParams.eye_classify_switch_ = true;
            VideoDataRetrieverBySoft.this.mCoverPicker.ProcessFrame(this.frame.getFrame(), videoParams, pickerCoverInfo);
            return pickerCoverInfo.ret_state_;
        }

        public void resetMMCV() {
        }

        public void doFrameFilter() {
            Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter is called");
            int n2 = 0;
            long l2 = 0L;
            int n3 = 0;
            int n4 = -1;
            float f2 = -1.0f;
            VideoDataRetrieverBySoft.this.nativeSetYuvAndRgbOutFlag(true);
            if (this.mInterval != 1) {
                Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter:mInterval != 1");
                for (int i2 = 0; i2 < this.mMaxCnt; ++i2) {
                    Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)("  doFrameFilter:needPts " + l2));
                    if (VideoDataRetrieverBySoft.this.mExit) break;
                    n2 = VideoDataRetrieverBySoft.this.nativeDecodeOneFrame(l2);
                    if (n2 >= 0 && VideoDataRetrieverBySoft.this.mHandler != 0L) {
                        VideoDataRetrieverBySoft.this.nativeGetYuvImage(this.yuv);
                        if (n2 >= 0) {
                            float f3 = this.doMMCVFilter(this.yuv);
                            if (f3 > f2) {
                                f2 = f3;
                                VideoDataRetrieverBySoft.this.nativeGetRGBImage(VideoDataRetrieverBySoft.this.mARGBData);
                            }
                            if ((n3 = (n3 + 1) % this.mInterval) == 0) {
                                VideoDataRetrieverBySoft.this.mCurBmp = Bitmap.createBitmap((int[])VideoDataRetrieverBySoft.this.mARGBData, (int)0, (int)VideoDataRetrieverBySoft.this.mWidth, (int)VideoDataRetrieverBySoft.this.mWidth, (int)VideoDataRetrieverBySoft.this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                if (VideoDataRetrieverBySoft.this.mImageFrameFilterListener != null) {
                                    VideoDataRetrieverBySoft.this.mImageFrameFilterListener.doFilterFrame(VideoDataRetrieverBySoft.this.mCurBmp);
                                }
                                f2 = -1.0f;
                            }
                        }
                    } else {
                        Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter nativeDecodeOneFrame or mHandler is error!");
                        Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)("            mHandler:" + VideoDataRetrieverBySoft.this.mHandler));
                    }
                    l2 += this.mPtsStep;
                }
            } else {
                Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter:mInterval == 1");
                this.mPtsStep = VideoDataRetrieverBySoft.this.getAutoStep();
                long l3 = VideoDataRetrieverBySoft.this.getAutoMaxLength(this.mPtsStep);
                for (l2 = 0L; l2 <= l3 && !VideoDataRetrieverBySoft.this.mExit; l2 += this.mPtsStep) {
                    Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)("  doFrameFilter:needPts " + l2));
                    n2 = VideoDataRetrieverBySoft.this.nativeDecodeOneFrame(l2);
                    if (n2 <= 0 || VideoDataRetrieverBySoft.this.mHandler == 0L) continue;
                    VideoDataRetrieverBySoft.this.nativeGetYuvImage(this.yuv);
                    if (n2 >= 0) {
                        float f4 = this.doMMCVFilter(this.yuv);
                        if (!(f4 > f2)) continue;
                        f2 = f4;
                        VideoDataRetrieverBySoft.this.nativeGetRGBImage(VideoDataRetrieverBySoft.this.mARGBData);
                        continue;
                    }
                    Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter nativeDecodeOneFrame or mHandler is error!");
                    Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)("            mHandler:" + VideoDataRetrieverBySoft.this.mHandler));
                }
                VideoDataRetrieverBySoft.this.mCurBmp = Bitmap.createBitmap((int[])VideoDataRetrieverBySoft.this.mARGBData, (int)0, (int)VideoDataRetrieverBySoft.this.mWidth, (int)VideoDataRetrieverBySoft.this.mWidth, (int)VideoDataRetrieverBySoft.this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (VideoDataRetrieverBySoft.this.mImageFrameFilterListener != null) {
                    VideoDataRetrieverBySoft.this.mImageFrameFilterListener.doFilterFrame(VideoDataRetrieverBySoft.this.mCurBmp);
                }
            }
            if (VideoDataRetrieverBySoft.this.mImageFrameFilterListener != null) {
                VideoDataRetrieverBySoft.this.mImageFrameFilterListener.doFilterComplete();
            }
            Log4Cam.e((String)VideoDataRetrieverBySoft.this.TAG, (String)"doFrameFilter is complete, VideoDataRetrieverBySoft will be release!");
        }
    }

    public static interface ImageFrameFilterListener {
        public void doFilterFrame(Bitmap var1);

        public void doFilterComplete();

        public void doFilterError(Exception var1);
    }

    public static interface OnThumbnailListComplete {
        public void onComplete();
    }

    public static class Node {
        public long pts;
        public Bitmap bmp;
        public byte[] byteBuffer;
        public int[] intBuffer;
        public int seqNum;
        public int dstWidth;
        public int dstHeight;

        public Node(long pts, int seqNum) {
            this.pts = pts;
            this.seqNum = seqNum;
            this.dstWidth = 0;
            this.dstHeight = 0;
        }

        public Node(long pts, int seqNum, int width, int height) {
            this.pts = pts;
            this.seqNum = seqNum;
            this.dstWidth = width;
            this.dstHeight = height;
        }
    }
}

