/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.moment.mediautils;

import android.media.MediaCodec;
import android.os.Handler;
import android.text.TextUtils;
import com.core.glcore.config.PacketData;
import com.core.glcore.util.Log4Cam;
import com.immomo.moment.mediautils.b;
import com.immomo.moment.mediautils.cmds.TimeRangeScale;
import com.immomo.moment.mediautils.e;
import com.immomo.moment.mediautils.h;
import com.immomo.moment.mediautils.i;
import com.mm.mmutil.task.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class AudioSpeedControlPlayer
implements e.a,
e.b,
e.d {
    public static final int DECODER_ERROR = 0;
    public static final int PROCESSOR_ERROR = 1;
    public static final int PLAYER_ERROR = 2;
    public static final int AUDIO_NOT_FOUND = 3;
    private final String TAG = "AudioSpeedControlPlayer";
    private final int state_uninitialized = 0;
    private final int state_prepared = 1;
    private final int state_paused = 2;
    private final int state_playing = 3;
    private int mPlayerState = 0;
    private e mAudioPlayer;
    private b mAudioDecoder;
    private h mScaleProcessor;
    private i mVolumeProcessor;
    private int mSampleRate = 44100;
    private int mSampleBits = 16;
    private int mSampleChannels = 2;
    private int mStart = 0;
    private int mEnd = 0;
    private int mDuration = 0;
    private float mSpeed = 1.0f;
    private float mVolume = 1.0f;
    private int mSeekTime = -1;
    private String mPath;
    private boolean mIsLooping = true;
    private boolean mNeedSeekRange = false;
    private volatile boolean mDecoderPaused = false;
    private volatile boolean mIgnoreCount = false;
    private boolean decodeFinished = false;
    private Object mSync = new Object();
    private Object mDecodeSync = new Object();
    private OnErrorListener mOnErrorListener;
    private OnPreparedListener mOnPreparedListener;
    private OnPlayPositionListener mOnPlayPositionListener;
    private Handler mHandler = new Handler();
    private boolean disableCodec = false;

    @Override
    public void onAudioPlayingPosition(long pts) {
    }

    @Override
    public void onAudioOriginPosition(long pts) {
        if (this.mOnPlayPositionListener != null) {
            this.mOnPlayPositionListener.onPlayPositionListener(this, (int)pts / 1000);
        }
        if (this.mIsLooping && (pts >= (long)(this.mEnd * 1000) && this.mEnd != 0 || this.decodeFinished)) {
            Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("seek start " + this.mStart + " mEnd = " + this.mEnd + "  decodeFinished = " + this.decodeFinished + " pts = " + pts));
            this.decodeFinished = false;
            this.seekWithOutReset(this.mStart);
        }
    }

    @Override
    public void onAudioAvailableBufferCount(int count) {
        if (this.mIgnoreCount) {
            return;
        }
        if (count > 1500) {
            this.mDecoderPaused = true;
        } else if (count < 500) {
            this.mDecoderPaused = false;
        } else if (count > 2000 || count < 50) {
            Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("!!!!!!!!! count  = " + count));
        }
    }

    public AudioSpeedControlPlayer() {
        this(false);
    }

    public AudioSpeedControlPlayer(boolean disableCodec) {
        this.disableCodec = disableCodec;
    }

    public boolean setDataSource(String path) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("setDataSource " + path));
        if (this.mPlayerState == 0) {
            this.mPath = path;
            return true;
        }
        return false;
    }

    public void prepare() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"prepare");
        if (this.disableCodec) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            if (this.mOnErrorListener != null) {
                this.mOnErrorListener.onError(this, 3);
            }
            return;
        }
        ThreadUtils.execute((int)2, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AudioSpeedControlPlayer.this.mSync;
                synchronized (object) {
                    if (!AudioSpeedControlPlayer.this.initAudioDecoder() && AudioSpeedControlPlayer.this.mOnErrorListener != null) {
                        AudioSpeedControlPlayer.this.mOnErrorListener.onError(AudioSpeedControlPlayer.this, 0);
                    }
                    AudioSpeedControlPlayer.this.mAudioDecoder.a(new b.a(){

                        @Override
                        public void a(int n2, int n3, int n4) {
                            if (AudioSpeedControlPlayer.this.mPlayerState != 0) {
                                return;
                            }
                            AudioSpeedControlPlayer.this.mSampleBits = n4;
                            AudioSpeedControlPlayer.this.mSampleChannels = n3;
                            AudioSpeedControlPlayer.this.mSampleRate = n2;
                            if (!AudioSpeedControlPlayer.this.initAudioPlayer() && AudioSpeedControlPlayer.this.mOnErrorListener != null) {
                                AudioSpeedControlPlayer.this.mOnErrorListener.onError(AudioSpeedControlPlayer.this, 2);
                            }
                            AudioSpeedControlPlayer.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    AudioSpeedControlPlayer.this.mPlayerState = 1;
                                    Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"on prepared");
                                    if (AudioSpeedControlPlayer.this.mOnPreparedListener != null) {
                                        AudioSpeedControlPlayer.this.mOnPreparedListener.onPrepared(AudioSpeedControlPlayer.this);
                                    }
                                }
                            });
                        }
                    });
                    if (AudioSpeedControlPlayer.this.mAudioDecoder != null) {
                        AudioSpeedControlPlayer.this.mAudioDecoder.b();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"start  play");
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAudioDecoder != null) {
                if (this.mNeedSeekRange) {
                    this.setPlayTimeRange(this.mStart, this.mEnd);
                    this.mNeedSeekRange = false;
                }
                if (this.mPlayerState == 1 || this.mPlayerState == 2) {
                    this.resume();
                }
                this.mPlayerState = 3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seekPlayTime(int seekTime) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("seekPlayTime = " + seekTime));
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPlayerState == 0) {
                return false;
            }
            if (seekTime < this.mStart || seekTime > this.mEnd) {
                return false;
            }
            this.seek(seekTime);
            this.mSeekTime = seekTime;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPlayTimeRange(int startPtsMs, int endPtsMs) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("setPlayTimeRange  start = " + startPtsMs + "  end = " + endPtsMs));
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPlayerState == 0) {
                this.mStart = startPtsMs;
                this.mEnd = endPtsMs;
                this.mNeedSeekRange = true;
            } else if (this.mPlayerState == 2 || this.mPlayerState == 1) {
                this.mStart = startPtsMs;
                this.mEnd = endPtsMs;
                if (this.mNeedSeekRange) {
                    this.mNeedSeekRange = false;
                    if (this.mSeekTime > this.mStart && this.mSeekTime < this.mEnd) {
                        this.seek(this.mSeekTime);
                    } else if (this.mStart != 0) {
                        this.seek(this.mStart);
                    }
                } else {
                    this.seek(this.mStart);
                }
            } else if (this.mPlayerState == 3) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaySpeed(float speed) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("setPlaySpeed = " + speed));
        Object object = this.mSync;
        synchronized (object) {
            if (speed != this.mSpeed) {
                this.mSpeed = speed;
                if (this.mScaleProcessor != null) {
                    this.mScaleProcessor.a(this.mSpeed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(float volume) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"setVolume");
        Object object = this.mSync;
        synchronized (object) {
            if (volume != this.mVolume) {
                this.mVolume = volume;
                if (this.mVolumeProcessor != null) {
                    this.mVolumeProcessor.a(this.mVolume);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"release");
        Object object = this.mSync;
        synchronized (object) {
            this.mDecoderPaused = false;
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mAudioDecoder != null) {
                this.mIgnoreCount = true;
                this.mDecoderPaused = false;
                try {
                    this.mSync.wait(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAudioDecoder.a();
                this.mAudioDecoder = null;
            }
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.c();
                this.mAudioPlayer = null;
            }
            if (this.mScaleProcessor != null) {
                this.mScaleProcessor.a();
                this.mScaleProcessor = null;
            }
            if (this.mVolumeProcessor != null) {
                this.mVolumeProcessor.a();
                this.mVolumeProcessor = null;
            }
            this.resetState();
            this.mPlayerState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"pause");
        long l2 = System.currentTimeMillis();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPlayerState == 0) {
                return;
            }
            this.mDecoderPaused = false;
            if (this.mAudioDecoder != null) {
                this.mDecoderPaused = true;
            }
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.a();
            }
            this.mDecoderPaused = true;
            this.mPlayerState = 2;
        }
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("pause time = " + (System.currentTimeMillis() - l2)));
    }

    public int getDuration() {
        return this.mDuration;
    }

    public boolean isPlaying() {
        return this.mPlayerState == 3;
    }

    public void isLooping(boolean isLoop) {
        this.mIsLooping = isLoop;
    }

    public void setOnPreparedListener(OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.mOnErrorListener = listener;
    }

    public void setOnPlayPositionListener(OnPlayPositionListener listener) {
        this.mOnPlayPositionListener = listener;
    }

    public void reset() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"reset");
        if (this.mPlayerState == 0) {
            return;
        }
        this.release();
    }

    private boolean initAudioDecoder() {
        Boolean bl = false;
        if (this.mAudioDecoder == null) {
            this.mAudioDecoder = new b();
        }
        this.mAudioDecoder.b(false);
        if (this.mAudioDecoder != null) {
            if (!this.mAudioDecoder.a(this.mPath)) {
                return bl;
            }
            this.mDuration = (int)this.mAudioDecoder.e() / 1000;
            this.mAudioDecoder.a(0L, (long)this.mDuration);
        }
        this.mAudioDecoder.a(new b.b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void a(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
                Object object;
                if (bufferInfo.presentationTimeUs < (long)(AudioSpeedControlPlayer.this.mStart * 1000) || bufferInfo.size <= 0 || bufferInfo.presentationTimeUs > (long)((AudioSpeedControlPlayer.this.mEnd + 100) * 1000)) {
                    return;
                }
                try {
                    while (AudioSpeedControlPlayer.this.mDecoderPaused) {
                        object = AudioSpeedControlPlayer.this.mDecodeSync;
                        synchronized (object) {
                            AudioSpeedControlPlayer.this.mDecodeSync.wait(5L);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = new PacketData(bufferInfo.size);
                byteBuffer.position(0);
                object.getFrameBuffer().position(0);
                byteBuffer.get(object.getFrameBuffer().array());
                object.setBuffInfo(bufferInfo.size, 0, 0, bufferInfo.presentationTimeUs, 0);
                object.getFrameBuffer().position(0);
                byteBuffer.position(0);
                if (AudioSpeedControlPlayer.this.mAudioPlayer != null) {
                    AudioSpeedControlPlayer.this.mAudioPlayer.a((PacketData)object);
                }
            }

            @Override
            public void a() {
                AudioSpeedControlPlayer.this.decodeFinished = true;
            }
        });
        return true;
    }

    private boolean initAudioPlayer() {
        boolean bl = false;
        if (this.mScaleProcessor == null) {
            this.mScaleProcessor = new h();
        }
        if (this.mVolumeProcessor == null) {
            this.mVolumeProcessor = new i();
        }
        this.mScaleProcessor.a(this.mSampleRate, this.mSampleBits, this.mSampleChannels);
        this.mVolumeProcessor.a(this.mSampleRate, this.mSampleBits, this.mSampleChannels);
        ArrayList<TimeRangeScale> arrayList = new ArrayList<TimeRangeScale>();
        arrayList.add(new TimeRangeScale(0L, this.mDuration, this.mSpeed));
        this.mScaleProcessor.a(arrayList);
        this.mScaleProcessor.c();
        this.mVolumeProcessor.a(this.mVolume);
        this.mVolumeProcessor.c();
        if (this.mAudioPlayer == null) {
            this.mAudioPlayer = new e();
        }
        this.mAudioPlayer.a(this);
        this.mAudioPlayer.a(this);
        this.mAudioPlayer.a(this);
        if (!this.mAudioPlayer.a(this.mSampleRate, this.mSampleBits, this.mSampleChannels)) {
            return bl;
        }
        this.mAudioPlayer.a(this.mScaleProcessor);
        this.mAudioPlayer.a(this.mVolumeProcessor);
        this.mAudioPlayer.a();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seek(int ptsMs) {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("seek   =  " + ptsMs));
        Object object = this.mSync;
        synchronized (object) {
            this.seekWithOutReset(ptsMs);
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.d();
            }
            if (this.mScaleProcessor != null) {
                this.mScaleProcessor.b();
            }
            if (this.mVolumeProcessor != null) {
                this.mVolumeProcessor.b();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekWithOutReset(int ptsMs) {
        long l2 = System.currentTimeMillis();
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("seekWithoutReset   =  " + ptsMs));
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAudioDecoder != null) {
                this.mIgnoreCount = true;
                this.mDecoderPaused = false;
                this.mAudioDecoder.a(ptsMs * 1000);
                this.mIgnoreCount = false;
            }
        }
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)("seekWithoutReset  time cost =   " + (System.currentTimeMillis() - l2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Log4Cam.d((String)"AudioSpeedControlPlayer", (String)"resume");
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAudioPlayer != null) {
                this.mAudioPlayer.b();
            }
            if (this.mAudioDecoder != null) {
                this.mDecoderPaused = false;
            }
            this.mDecoderPaused = false;
        }
    }

    private void resetState() {
        this.mSpeed = 1.0f;
        this.mStart = 0;
        this.mEnd = 0;
        this.mDuration = 0;
        this.mPath = "";
        this.mIsLooping = true;
        this.mDecoderPaused = false;
        this.mNeedSeekRange = false;
        this.mSeekTime = -1;
        this.mIgnoreCount = false;
    }

    public static interface OnPlayPositionListener {
        public void onPlayPositionListener(AudioSpeedControlPlayer var1, int var2);
    }

    public static interface OnErrorListener {
        public void onError(AudioSpeedControlPlayer var1, int var2);
    }

    public static interface OnSeekCompleteListener {
        public void onSeekComplete(AudioSpeedControlPlayer var1);
    }

    public static interface OnPreparedListener {
        public void onPrepared(AudioSpeedControlPlayer var1);
    }
}

