/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.app.Activity;
import com.immomo.baseutil.Rotation;

public class TextureRotationUtil {
    public static final float[] TEXTURE_NO_ROTATION = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_90 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_180 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    public static final float[] TEXTURE_ROTATED_270 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    private TextureRotationUtil() {
    }

    public static float[] getRotation(Rotation rotation, boolean bl, boolean bl2) {
        float[] fArray;
        switch (rotation) {
            case ROTATION_90: {
                fArray = TEXTURE_ROTATED_90;
                break;
            }
            case ROTATION_180: {
                fArray = TEXTURE_ROTATED_180;
                break;
            }
            case ROTATION_270: {
                fArray = TEXTURE_ROTATED_270;
                break;
            }
            default: {
                fArray = TEXTURE_NO_ROTATION;
            }
        }
        if (bl) {
            fArray = new float[]{TextureRotationUtil.flip(fArray[0]), fArray[1], TextureRotationUtil.flip(fArray[2]), fArray[3], TextureRotationUtil.flip(fArray[4]), fArray[5], TextureRotationUtil.flip(fArray[6]), fArray[7]};
        }
        if (bl2) {
            fArray = new float[]{fArray[0], TextureRotationUtil.flip(fArray[1]), fArray[2], TextureRotationUtil.flip(fArray[3]), fArray[4], TextureRotationUtil.flip(fArray[5]), fArray[6], TextureRotationUtil.flip(fArray[7])};
        }
        return fArray;
    }

    private static float flip(float f) {
        if (f == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    public static int getRotationAngle(Activity activity) {
        int n = activity.getWindowManager().getDefaultDisplay().getRotation();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
            }
        }
        return n2;
    }
}

