/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.content.Context;
import android.os.SystemClock;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.immomo.baseutil.DebugLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public final class DebugInfos {
    public static final String TAG = "DebugInfos";
    public static final int PULL = 1;
    public static final int PUSH = 2;
    private String url;
    private int mode = 0;
    private int enable = -1;
    private int baseMark = -1;
    private int speedupMark = -1;
    private int dropMark = -1;
    private float speedRate = -1.0f;
    private int videoFirstRender = -1;
    private int audioFistRender = -1;
    private int fps;
    private int videoBuffer;
    private int audioBuffer;
    private int delay;
    private String cpuAndMem;
    private String pullDetects;
    private boolean droping = false;
    private int dropingCount = 0;
    private long mShowupDebugInfoIndex = 0L;
    private TextView mDebugInfoView;
    private String dns = "";
    private int mTransferType = 0;
    private List<String> mTargets;
    private String mUserPeer = null;
    private long currentTimeMs = -1L;
    private long pre_VideoOutputFrames = 0L;
    private long pre_AudioSize = 0L;
    private long pre_VideoSize = 0L;
    private long audioBitRate;
    private long videoBitRate;
    private int width = 0;
    private int height = 0;

    public DebugInfos(Context context, int n) {
        this.mode = n;
        DebugLog.d(TAG, "DebugInfos mode" + this.mode + " " + (null == this.mDebugInfoView));
        if (null == this.mDebugInfoView) {
            this.mDebugInfoView = new TextView(context);
            this.mDebugInfoView.setTextColor(-65536);
            this.mDebugInfoView.setGravity(5);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(11, -1);
            layoutParams.addRule(15, -1);
            this.mDebugInfoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.dns = this.getLocalDNS();
        }
    }

    public DebugInfos(TextView textView, int n) {
        this.mode = n;
        this.mDebugInfoView = textView;
        DebugLog.d(TAG, "DebugInfos mode" + this.mode);
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public TextView getTextView() {
        return this.mDebugInfoView;
    }

    public void showInfos() {
        DebugLog.d(TAG, "showInfos mode" + this.mode);
        if (this.mode == 1) {
            this.showPullInfos();
        } else {
            this.showPushInfos();
        }
    }

    public void setSpeedupParms(int n, int n2, int n3, int n4, float f) {
        this.enable = n;
        this.baseMark = n2;
        this.speedupMark = n3;
        this.dropMark = n4;
        this.speedRate = f;
    }

    public void setPullDebugInfoWH(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setP2PInfo(int n, List<String> list, String string) {
        this.mTransferType = n;
        this.mTargets = list;
        this.mUserPeer = string;
    }

    public void setPullDebugInfoParms(long l, long l2, long l3, int n, int n2, int n3, int n4, int n5, String string, String string2) {
        if (this.currentTimeMs == -1L) {
            this.fps = 0;
            this.audioBitRate = 0L;
            this.videoBitRate = 0L;
        } else {
            long l4 = (SystemClock.elapsedRealtime() - this.currentTimeMs) / 1000L;
            if (l4 != 0L) {
                this.fps = (int)((l3 - this.pre_VideoOutputFrames) / l4);
                this.audioBitRate = (l - this.pre_AudioSize) * 8L / (l4 * 1024L);
                this.videoBitRate = (l2 - this.pre_VideoSize) * 8L / (l4 * 1024L);
                DebugLog.d(TAG, "fps " + (l3 - this.pre_VideoOutputFrames) + "   " + this.fps);
                DebugLog.d(TAG, "audioBitRate " + (l - this.pre_AudioSize) + "   " + this.audioBitRate);
                DebugLog.d(TAG, "videoBitRate " + (l2 - this.pre_VideoSize) + "   " + this.videoBitRate);
            } else {
                this.fps = 0;
                this.audioBitRate = 0L;
                this.videoBitRate = 0L;
            }
        }
        this.pre_AudioSize = l;
        this.pre_VideoSize = l2;
        this.pre_VideoOutputFrames = l3;
        this.currentTimeMs = SystemClock.elapsedRealtime();
        this.videoBuffer = n3;
        this.audioBuffer = n4;
        this.delay = n5;
        this.cpuAndMem = string;
        this.pullDetects = string2;
        this.videoFirstRender = n2;
        this.audioFistRender = n;
    }

    public void dropFrameMessage(boolean bl) {
        this.droping = bl;
        if (this.droping) {
            ++this.dropingCount;
        }
    }

    private void showPullInfos() {
        if (this.mDebugInfoView != null) {
            StringBuilder stringBuilder = new StringBuilder();
            ++this.mShowupDebugInfoIndex;
            stringBuilder.append("i: " + this.mShowupDebugInfoIndex + "\n");
            stringBuilder.append("fps: " + this.fps + "/" + this.width + "/" + this.height + "\n");
            stringBuilder.append("delay: " + this.delay + "\n");
            stringBuilder.append("dns: " + this.dns + "\n");
            stringBuilder.append("droping: " + this.droping + "/" + this.dropingCount + "\n");
            stringBuilder.append("v buffer: " + this.videoBuffer + " Ms\n");
            stringBuilder.append("a buffer: " + this.audioBuffer + " Ms\n");
            stringBuilder.append("bitrate/v/a: " + this.videoBitRate + "/" + this.audioBitRate + " kbps\n");
            stringBuilder.append("cpu/mem : " + this.cpuAndMem + " MB\n");
            stringBuilder.append("pullDetect:" + this.pullDetects + "\n");
            stringBuilder.append("firstRender v/a: " + this.videoFirstRender + "/" + this.audioFistRender + " Ms\n");
            stringBuilder.append("speedUp: " + this.enable + "," + this.baseMark + "," + this.speedupMark + "," + this.dropMark + "," + this.speedRate + "\n");
            stringBuilder.append(this.url + "\n");
            stringBuilder.append("proxy mode :" + (this.mTransferType == 0 ? "TRANSFER_TYPE_P2P" : "TRANSFER_TYPE_HTTP") + "\n");
            if (this.mTargets != null) {
                for (String string : this.mTargets) {
                    stringBuilder.append("TargetId :" + string + "\n");
                }
            }
            if (this.mUserPeer != null) {
                stringBuilder.append("CurrentId :" + this.mUserPeer + "\n");
            }
            this.mDebugInfoView.setText((CharSequence)stringBuilder.toString());
        }
    }

    private void showPushInfos() {
    }

    public void reset() {
        DebugLog.d(TAG, "reset");
        this.mShowupDebugInfoIndex = 0L;
        this.enable = -1;
        this.baseMark = -1;
        this.speedupMark = -1;
        this.dropMark = -1;
        this.speedRate = -1.0f;
        this.droping = false;
        this.dropingCount = 0;
        this.pullDetects = "";
        this.url = "";
        this.cpuAndMem = "";
        this.fps = 0;
        this.videoBuffer = 0;
        this.audioBuffer = 0;
        this.delay = 0;
        this.videoFirstRender = 0;
        this.audioFistRender = 0;
        this.currentTimeMs = -1L;
        this.audioBitRate = 0L;
        this.videoBitRate = 0L;
        this.pre_VideoOutputFrames = 0L;
        this.pre_AudioSize = 0L;
        this.pre_VideoSize = 0L;
        this.width = 0;
        this.height = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalDNS() {
        Process process = null;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            process = Runtime.getRuntime().exec("getprop net.dns1");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = string = bufferedReader.readLine();
            return string2;
        }
        catch (IOException iOException) {
            String string3 = null;
            return string3;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            process.destroy();
        }
    }
}

