/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.baseutil;

import android.os.Build;
import com.immomo.baseutil.CPUManager;
import com.immomo.baseutil.CpuBenchmark;
import com.immomo.baseutil.CpuBenchmarkCallBack;
import com.immomo.baseutil.CpuBenchmarkListener;
import com.immomo.baseutil.CpuModelInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class CpuBenchmarkUtils {
    private static final int NO_SUPPORT = 0;
    private static final int SUPER_CPU_LEVEL = 4;
    private static final int HIGH_CPU_LEVEL = 1;
    private static final int MEDIUM_CPU_LEVEL = 2;
    private static final int LOWER_CPU_LEVEL = 3;
    private static final int NO_KNOWN = -1;
    private CpuBenchmarkCallBack cpuBenchmarkCallBack;
    private double mFlops;
    private double mIops;
    private int mSupportH265CpuLevel;
    private int i = 0;

    public void setCpuBenchmarkCallBack(CpuBenchmarkCallBack cpuBenchmarkCallBack) {
        this.cpuBenchmarkCallBack = cpuBenchmarkCallBack;
    }

    public void calculateCpuPerformance() {
        this.calculateCpuPerformance(false);
    }

    public void calculateCpuPerformance(boolean bl) {
        this.i = 0;
        while (this.i <= 5) {
            CpuBenchmark cpuBenchmark = new CpuBenchmark();
            cpuBenchmark.setCpuBenchmarkListener(new CpuBenchmarkListener(){

                @Override
                public void getCpuFLOPS(double d) {
                    if (CpuBenchmarkUtils.this.i > 2) {
                        CpuBenchmarkUtils.this.mFlops = CpuBenchmarkUtils.this.mFlops + d * 1000.0 / 3.0;
                    }
                }

                @Override
                public void getCpuIOPS(double d) {
                    if (CpuBenchmarkUtils.this.i > 2) {
                        CpuBenchmarkUtils.this.mIops = CpuBenchmarkUtils.this.mIops + d * 1000.0 / 3.0;
                    }
                }
            });
            cpuBenchmark.FLOPSBenchmark(CPUManager.getNumCores(), 5000L);
            cpuBenchmark.IOPSBenchmark(CPUManager.getNumCores(), 5000L);
            ++this.i;
        }
        this.mSupportH265CpuLevel = this.supportHEVCLevel(this.mFlops, this.mIops);
        boolean bl2 = this.isSupportHEVC(this.mFlops, this.mIops, 5.0, bl);
        this.cpuBenchmarkCallBack.isSupportHEVC(bl2);
        this.cpuBenchmarkCallBack.supportHEVCLevel(this.mSupportH265CpuLevel);
    }

    private boolean isSupportHEVC(double d, double d2, double d3, boolean bl) {
        String string = CPUManager.getCpuModel();
        if (string != null && this.isContainsCpuModelInfo()) {
            if (this.getCpuLevelBasedModel() == 1) {
                return true;
            }
            if (this.getCpuLevelBasedModel() != -1) {
                return false;
            }
        }
        int n = 0;
        n = bl ? this.getCpuLevel() : this.getCpuLevelOldLogic();
        double d4 = d + d2;
        return d4 >= d3 && (n == 2 || n == 1);
    }

    private int supportHEVCLevel(double d, double d2) {
        int n;
        String string = CPUManager.getCpuModel();
        if (string != null && this.isContainsCpuModelInfo() && (n = this.getCpuLevelBasedModel()) != -1) {
            return n;
        }
        n = this.getCpuLevel();
        double d3 = d + d2;
        if (d3 >= 5.0 && n == 1) {
            return 1;
        }
        if (d3 >= 4.0 && n == 2) {
            return 2;
        }
        if (d3 >= 3.0 && n == 3) {
            return 3;
        }
        return 0;
    }

    private int getCpuLevelOldLogic() {
        int n = CPUManager.getNumCores();
        float f = CPUManager.getMaxCpuFrequence();
        boolean bl = this.judgeMtkCpuMode();
        if (bl) {
            if ((double)f >= 2.3 && n >= 8 && Build.VERSION.SDK_INT >= 23 || (double)f > 2.3 && 4 <= n && n < 8 && Build.VERSION.SDK_INT >= 24 || 10 <= n && Build.VERSION.SDK_INT >= 23) {
                return 1;
            }
            if (n >= 8 && (double)f > 2.2 && Build.VERSION.SDK_INT >= 23) {
                return 2;
            }
            return 0;
        }
        if ((double)f >= 2.2 && n >= 8 && Build.VERSION.SDK_INT >= 21) {
            return 1;
        }
        if (4 <= n && n < 8 && (double)f >= 2.0 && Build.VERSION.SDK_INT >= 21 || n >= 8 && (double)f >= 1.8 && Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 3;
    }

    private int getCpuLevel() {
        int n = CPUManager.getNumCores();
        float f = CPUManager.getMaxCpuFrequence();
        float f2 = CPUManager.getTotalMemory() / 1024.0f;
        boolean bl = this.judgeMtkCpuMode();
        if (bl) {
            if (((double)f >= 2.3 && n >= 8 && Build.VERSION.SDK_INT >= 23 || (double)f > 2.3 && 4 <= n && n < 8 && Build.VERSION.SDK_INT >= 24) && f2 >= 2.0f) {
                return 1;
            }
            if (n >= 8 && (double)f >= 2.2 && Build.VERSION.SDK_INT >= 23 && f2 > 2.0f) {
                return 2;
            }
            return 0;
        }
        if (((double)f >= 1.8 && n >= 8 && Build.VERSION.SDK_INT >= 19 || (double)f >= 2.2 && 4 <= n && n < 8 && Build.VERSION.SDK_INT >= 21) && f2 > 2.0f) {
            return 1;
        }
        if ((4 <= n && n < 8 && (double)f >= 1.8 && Build.VERSION.SDK_INT >= 21 || n >= 8 && (double)f >= 1.7 && Build.VERSION.SDK_INT >= 19) && f2 > 2.0f) {
            return 2;
        }
        if ((4 <= n && n < 8 && (double)f >= 1.5 && Build.VERSION.SDK_INT >= 19 || n >= 8 && (double)f >= 1.4 && Build.VERSION.SDK_INT >= 16) && f2 > 1.0f) {
            return 3;
        }
        return 0;
    }

    private boolean isContainsCpuModelInfo() {
        String string = CPUManager.getCpuModel();
        List<String> list = Arrays.asList(CpuModelInfo.IsSupport720p);
        List<String> list2 = Arrays.asList(CpuModelInfo.IsSupport540p);
        List<String> list3 = Arrays.asList(CpuModelInfo.IsSupport360p);
        List<String> list4 = Arrays.asList(CpuModelInfo.IsNoSupport);
        return list.toString().toUpperCase().contains(string.toUpperCase(Locale.US)) || list2.toString().contains(string.toUpperCase(Locale.US)) || list3.toString().contains(string.toUpperCase(Locale.US)) || list4.toString().contains(string.toUpperCase(Locale.US));
    }

    private int getCpuLevelBasedModel() {
        String string = CPUManager.getCpuModel();
        List<String> list = Arrays.asList(CpuModelInfo.IsSupport720p);
        List<String> list2 = Arrays.asList(CpuModelInfo.IsSupport540p);
        List<String> list3 = Arrays.asList(CpuModelInfo.IsSupport360p);
        List<String> list4 = Arrays.asList(CpuModelInfo.IsNoSupport);
        if (list.toString().toUpperCase().contains(string.toUpperCase())) {
            return 1;
        }
        if (list2.toString().contains(string.toUpperCase())) {
            return 2;
        }
        if (list3.toString().contains(string.toUpperCase())) {
            return 3;
        }
        if (list4.toString().contains(string.toUpperCase())) {
            return 0;
        }
        return -1;
    }

    private boolean judgeMtkCpuMode() {
        String string = CPUManager.getCpuModel();
        return string.contains("MT") || string.contains("mt") || string.contains("Helio");
    }
}

